/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import com.intellij.vfs.AsyncVfsEventsPostProcessorImpl;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class VcsDirtyScopeVfsListener
implements AsyncVfsEventsListener,
Disposable {
    @NotNull
    private final Project myProject;
    private boolean myForbid;

    public VcsDirtyScopeVfsListener(@NotNull Project project2) {
        if (project2 == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        AsyncVfsEventsPostProcessor.getInstance().addListener(this, this);
    }

    public static VcsDirtyScopeVfsListener getInstance(@NotNull Project project2) {
        if (project2 == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(1);
        }
        return (VcsDirtyScopeVfsListener)project2.getService(VcsDirtyScopeVfsListener.class);
    }

    public static void install(@NotNull Project project2) {
        if (project2 == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(2);
        }
        VcsDirtyScopeVfsListener.getInstance(project2);
    }

    @TestOnly
    public void setForbid(boolean forbid) {
        this.myForbid = forbid;
    }

    public void dispose() {
    }

    @TestOnly
    public void waitForAsyncTaskCompletion() {
        AsyncVfsEventsPostProcessorImpl.waitEventsProcessed();
    }

    @Override
    public void filesChanged(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(3);
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(this.myProject);
        if (this.myForbid || !vcsManager2.hasActiveVcss()) {
            return;
        }
        FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            boolean isDirectory;
            ProgressManager.checkCanceled();
            if (vFileEvent instanceof VFileCreateEvent) {
                if (!((VFileCreateEvent)vFileEvent).getParent().isInLocalFileSystem()) continue;
                isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
            } else {
                VirtualFile file = Objects.requireNonNull(vFileEvent.getFile(), "All events but VFileCreateEvent have @NotNull getFile()");
                if (!file.isInLocalFileSystem()) continue;
                isDirectory = file.isDirectory();
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                VcsDirtyScopeVfsListener.add(vcsManager2, dirtyFilesAndDirs, VcsUtil.getFilePath(((VFileMoveEvent)vFileEvent).getOldPath(), isDirectory));
                VcsDirtyScopeVfsListener.add(vcsManager2, dirtyFilesAndDirs, VcsUtil.getFilePath(((VFileMoveEvent)vFileEvent).getNewPath(), isDirectory));
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                FilePath oldPath = VcsUtil.getFilePath(((VFilePropertyChangeEvent)vFileEvent).getOldPath(), isDirectory);
                FilePath newPath = VcsUtil.getFilePath(((VFilePropertyChangeEvent)vFileEvent).getNewPath(), isDirectory);
                VcsDirtyScopeVfsListener.addWithParentDirectory(vcsManager2, dirtyFilesAndDirs, oldPath);
                VcsDirtyScopeVfsListener.add(vcsManager2, dirtyFilesAndDirs, newPath);
                continue;
            }
            VcsDirtyScopeVfsListener.add(vcsManager2, dirtyFilesAndDirs, VcsUtil.getFilePath(vFileEvent.getPath(), isDirectory));
        }
        VcsDirtyScopeManagerImpl dirtyScopeManager = VcsDirtyScopeManagerImpl.getInstanceImpl(this.myProject);
        dirtyScopeManager.fileVcsPathsDirty(dirtyFilesAndDirs.files.asMap(), dirtyFilesAndDirs.dirs.asMap());
    }

    private static void add(@NotNull ProjectLevelVcsManager vcsManager2, @NotNull FilesAndDirs filesAndDirs, @NotNull FilePath filePath, boolean withParentDirectory) {
        FilePath parentPath;
        VcsRoot vcsRoot;
        AbstractVcs vcs;
        if (vcsManager2 == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(4);
        }
        if (filesAndDirs == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(5);
        }
        if (filePath == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(6);
        }
        AbstractVcs abstractVcs = vcs = (vcsRoot = vcsManager2.getVcsRootObjectFor(filePath)) != null ? vcsRoot.getVcs() : null;
        if (vcsRoot == null || vcs == null) {
            return;
        }
        if (filePath.isDirectory()) {
            filesAndDirs.dirs.add(vcsRoot, filePath);
        } else {
            filesAndDirs.files.add(vcsRoot, filePath);
        }
        if (withParentDirectory && vcs.areDirectoriesVersionedItems() && (parentPath = filePath.getParentPath()) != null && vcsManager2.getVcsFor(parentPath) == vcs) {
            filesAndDirs.files.add(vcsRoot, parentPath);
        }
    }

    private static void add(@NotNull ProjectLevelVcsManager vcsManager2, @NotNull FilesAndDirs filesAndDirs, @NotNull FilePath filePath) {
        if (vcsManager2 == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(7);
        }
        if (filesAndDirs == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(8);
        }
        if (filePath == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(9);
        }
        VcsDirtyScopeVfsListener.add(vcsManager2, filesAndDirs, filePath, false);
    }

    private static void addWithParentDirectory(@NotNull ProjectLevelVcsManager vcsManager2, @NotNull FilesAndDirs filesAndDirs, @NotNull FilePath filePath) {
        if (vcsManager2 == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(10);
        }
        if (filesAndDirs == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(11);
        }
        if (filePath == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(12);
        }
        VcsDirtyScopeVfsListener.add(vcsManager2, filesAndDirs, filePath, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesAndDirs";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filesChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addWithParentDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FilesAndDirs {
        @NotNull
        VcsDirtyScopeMap files = new VcsDirtyScopeMap();
        @NotNull
        VcsDirtyScopeMap dirs = new VcsDirtyScopeMap();

        private FilesAndDirs() {
        }
    }
}

