/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.history.ActivityId;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcs.VcsActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RevertCommittedStuffAbstractAction
extends AnAction
implements DumbAware {
    private final boolean myReverse;

    protected RevertCommittedStuffAbstractAction(boolean reverse) {
        this.myReverse = reverse;
    }

    protected abstract Change @Nullable [] getChanges(@NotNull AnActionEvent var1, boolean var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        LocalChangeList targetList;
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(0);
        }
        final Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final VirtualFile baseDir2 = project2.getBaseDir();
        assert (baseDir2 != null);
        Change[] changes2 = this.getChanges(e, false);
        if (changes2 == null || changes2.length == 0) {
            return;
        }
        final ArrayList changesList = new ArrayList();
        Collections.addAll(changesList, changes2);
        FileDocumentManager.getInstance().saveAllDocuments();
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        final String title2 = VcsBundle.message("changes.progress.title.choice.revert.apply.changes", this.myReverse ? 0 : 1);
        final String errorPrefix = VcsBundle.message("changes.dialog.message.failed.to.revert.apply.changes", this.myReverse ? 0 : 1);
        if (ChangeListManager.getInstance(project2).areChangeListsEnabled()) {
            ChangeListChooser chooser = new ChangeListChooser(project2, VcsBundle.message("revert.changes.changelist.chooser.title", new Object[0]));
            if (changeLists != null && changeLists.length > 0) {
                String defaultName = VcsBundle.message("changes.revert.apply.change.list.name", this.myReverse ? 0 : 1, changeLists[0].getName());
                chooser.setSuggestedName(defaultName);
            }
            if (!chooser.showAndGet()) {
                return;
            }
            targetList = chooser.getSelectedList();
        } else {
            targetList = null;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, title2, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    List<Change> preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(changesList);
                    List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(project2, preprocessed, baseDir2.toNioPath(), RevertCommittedStuffAbstractAction.this.myReverse, false);
                    String activityName = RevertCommittedStuffAbstractAction.this.myReverse ? VcsBundle.message("activity.name.rollback", new Object[0]) : VcsBundle.message("activity.name.apply.patch", new Object[0]);
                    ActivityId activityId = RevertCommittedStuffAbstractAction.this.myReverse ? VcsActivity.Rollback : VcsActivity.ApplyPatch;
                    new PatchApplier(project2, baseDir2, new ArrayList<FilePatch>(patches), targetList, null, false, null, null, activityName, activityId).execute();
                }
                catch (VcsException ex) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project2, (String)(errorPrefix + ex.getMessage()), (String)title2), null, (Project)project2);
                    indicator.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction$1", "run"));
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(3);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes2 = this.getChanges(e, true);
        return project2 != null && changes2 != null && changes2.length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

