/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.BrowseCommittedChangesActionKt;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesViewManagerKt;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/BrowseCommittedChangesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        AbstractVcs abstractVcs = ChangesUtil.getVcsForFile(file, project3);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        if (!CommittedChangesViewManagerKt.isCommittedChangesAvailable(vcs)) {
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(vcs.allowsRemoteCalls(file) && AbstractVcs.fileInVcsByFileStatus(vcs.getProject(), file));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        Object object = e.getData(CommonDataKeys.VIRTUAL_FILE);
        Intrinsics.checkNotNull((Object)object);
        VirtualFile file = (VirtualFile)object;
        AbstractVcs abstractVcs = ChangesUtil.getVcsForFile(file, project3);
        Intrinsics.checkNotNull((Object)abstractVcs);
        AbstractVcs vcs = abstractVcs;
        ChangeBrowserSettings settings = BrowseCommittedChangesActionKt.access$getChangeBrowserSettings(vcs);
        CommittedChangesProvider<CommittedChangeList, ?> committedChangesProvider = vcs.getCommittedChangesProvider();
        Intrinsics.checkNotNull(committedChangesProvider);
        if (new CommittedChangesFilterDialog(project3, committedChangesProvider.createFilterUI(true), settings).showAndGet()) {
            BrowseCommittedChangesActionKt.access$showCommittedChanges(vcs, file, settings);
        }
    }
}

