/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import java.util.List;

public class RemoveList
implements ChangeListCommand {
    private final String myName;
    private LocalChangeList myListCopy;
    private LocalChangeList myDefaultListCopy;
    private List<Change> myMovedChanges;

    public RemoveList(String name) {
        this.myName = name;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        this.myListCopy = worker.getChangeListByName(this.myName);
        this.myMovedChanges = worker.removeChangeList(this.myName);
        this.myDefaultListCopy = worker.getDefaultList();
    }

    @Override
    public void doNotify(ChangeListListener listener2) {
        if (this.myListCopy != null && this.myMovedChanges != null) {
            if (!this.myMovedChanges.isEmpty()) {
                listener2.changesMoved(this.myMovedChanges, this.myListCopy, this.myDefaultListCopy);
            }
            listener2.changeListRemoved(this.myListCopy);
        }
    }
}

