/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsCatchingRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportToShelfExecutor
implements ApplyPatchExecutor<TextFilePatchInProgress> {
    private static final Logger LOG = Logger.getInstance(ImportToShelfExecutor.class);
    private final Project myProject;

    public ImportToShelfExecutor(Project project2) {
        this.myProject = project2;
    }

    @Override
    public String getName() {
        return VcsBundle.message("action.import.to.shelf", new Object[0]);
    }

    @Override
    public void apply(@NotNull List<? extends FilePatch> remaining, final @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, final @Nullable String fileName, final @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            ImportToShelfExecutor.$$$reportNull$$$0(0);
        }
        if (patchGroupsToApply == null) {
            ImportToShelfExecutor.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            LOG.error("Patch file name shouldn't be null");
            return;
        }
        VcsCatchingRunnable vcsCatchingRunnable = new VcsCatchingRunnable(){

            @Override
            public void runImpl() throws VcsException {
                VirtualFile baseDir2 = ImportToShelfExecutor.this.myProject.getBaseDir();
                File ioBase = new File(baseDir2.getPath());
                ArrayList allPatches = new ArrayList();
                for (VirtualFile virtualFile : patchGroupsToApply.keySet()) {
                    File ioCurrentBase = new File(virtualFile.getPath());
                    allPatches.addAll(ContainerUtil.map((Collection)patchGroupsToApply.get((Object)virtualFile), patchInProgress -> {
                        TextFilePatch was = (TextFilePatch)patchInProgress.getPatch();
                        was.setBeforeName(PathUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)ioBase, (File)new File(ioCurrentBase, was.getBeforeName()))));
                        was.setAfterName(PathUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)ioBase, (File)new File(ioCurrentBase, was.getAfterName()))));
                        return was;
                    }));
                }
                if (!allPatches.isEmpty()) {
                    ArrayList patchTransitExtensions = null;
                    if (additionalInfo != null) {
                        try {
                            HashMap<String, TransitExtension> extensions2 = new HashMap<String, TransitExtension>();
                            for (Map.Entry entry2 : ((Map)additionalInfo.compute()).entrySet()) {
                                String filePath = (String)entry2.getKey();
                                Map extToValue = (Map)entry2.getValue();
                                for (Map.Entry innerEntry : extToValue.entrySet()) {
                                    TransitExtension patchEP = (TransitExtension)extensions2.get(innerEntry.getKey());
                                    if (patchEP == null) {
                                        patchEP = new TransitExtension((String)innerEntry.getKey());
                                        extensions2.put((String)innerEntry.getKey(), patchEP);
                                    }
                                    patchEP.put(filePath, (CharSequence)innerEntry.getValue());
                                }
                            }
                            patchTransitExtensions = new ArrayList(extensions2.values());
                        }
                        catch (PatchSyntaxException e) {
                            VcsBalloonProblemNotifier.showOverChangesView(ImportToShelfExecutor.this.myProject, VcsBundle.message("patch.import.additional.info.error", e.getMessage()), MessageType.ERROR, new NamedRunnable[0]);
                        }
                    }
                    try {
                        ShelvedChangeList shelvedChangeList = ShelveChangesManager.getInstance(ImportToShelfExecutor.this.myProject).importFilePatches(fileName, allPatches, patchTransitExtensions);
                        ShelvedChangesViewManager.getInstance(ImportToShelfExecutor.this.myProject).activateView(shelvedChangeList);
                    }
                    catch (IOException e) {
                        throw new VcsException(e);
                    }
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)vcsCatchingRunnable, VcsBundle.message("patch.import.to.shelf.progress.title", new Object[0]), true, this.myProject);
        if (!vcsCatchingRunnable.get().isEmpty()) {
            AbstractVcsHelper.getInstance(this.myProject).showErrors((List<? extends VcsException>)vcsCatchingRunnable.get(), VcsBundle.message("action.import.to.shelf", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "remaining";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "patchGroupsToApply";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TransitExtension
    implements PatchEP {
        private final String myName;
        private final Map<String, CharSequence> myMap;

        private TransitExtension(String name) {
            this.myName = name;
            this.myMap = new HashMap<String, CharSequence>();
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = this.myName;
            if (string2 == null) {
                TransitExtension.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        public CharSequence provideContent(@NotNull Project project2, @NotNull String path2, CommitContext commitContext) {
            if (project2 == null) {
                TransitExtension.$$$reportNull$$$0(1);
            }
            if (path2 == null) {
                TransitExtension.$$$reportNull$$$0(2);
            }
            return this.myMap.get(path2);
        }

        @Override
        public void consumeContentBeforePatchApplied(@NotNull Project project2, @NotNull String path2, @NotNull CharSequence content, CommitContext commitContext) {
            if (project2 == null) {
                TransitExtension.$$$reportNull$$$0(3);
            }
            if (path2 == null) {
                TransitExtension.$$$reportNull$$$0(4);
            }
            if (content == null) {
                TransitExtension.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException();
        }

        public void put(String fileName, CharSequence value2) {
            this.myMap.put(fileName, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "provideContent";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "consumeContentBeforePatchApplied";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
            };
        }
    }
}

