/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class VcsHandleType
extends HandleType {
    private static final Function<LocalChangeList, String> FUNCTION = list2 -> list2.getName();
    private final AbstractVcs myVcs;
    private final ChangeListManager myChangeListManager;
    private final Function<VirtualFile, Change> myChangeFunction;

    public VcsHandleType(AbstractVcs vcs) {
        super(VcsBundle.message("handle.ro.file.status.type.using.vcs", vcs.getDisplayName()), true);
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance(this.myVcs.getProject());
        this.myChangeFunction = file -> this.myChangeListManager.getChange((VirtualFile)file);
    }

    public void processFiles(Collection<? extends VirtualFile> files2, @Nullable String changelist) {
        try {
            EditFileProvider provider2 = this.myVcs.getEditFileProvider();
            assert (provider2 != null);
            provider2.editFiles(VfsUtilCore.toVirtualFileArray(files2));
        }
        catch (VcsException e) {
            Messages.showErrorDialog((String)VcsBundle.message("message.text.cannot.edit.file", e.getLocalizedMessage()), (String)VcsBundle.message("message.title.edit.files", new Object[0]));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file : files2) {
                file.refresh(false, false);
            }
        });
        if (changelist != null) {
            this.myChangeListManager.invokeAfterUpdate(true, () -> {
                LocalChangeList list2 = this.myChangeListManager.findChangeList(changelist);
                if (list2 != null) {
                    List changes2 = ContainerUtil.mapNotNull((Collection)files2, this.myChangeFunction);
                    this.myChangeListManager.moveChangesTo(list2, changes2.toArray(Change.EMPTY_CHANGE_ARRAY));
                }
            });
        }
    }

    public List<String> getChangelists() {
        return ContainerUtil.map(this.myChangeListManager.getChangeLists(), FUNCTION);
    }

    public String getDefaultChangelist() {
        return this.myChangeListManager.getDefaultListName();
    }
}

