/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.logger;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.platform.ml.impl.apiPlatform.MLApiPlatform;
import com.intellij.platform.ml.impl.apiPlatform.ReplaceableIJPlatform;
import com.intellij.platform.ml.impl.logger.MLApiPlatformStartupLogger;
import com.intellij.platform.ml.impl.logger.MLEvent;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "InitializationContext", "Initializer", "Manager", "State", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMLEventsLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLEventsLogger.kt\ncom/intellij/platform/ml/impl/logger/MLEventsLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class MLEventsLogger
extends CounterUsagesCollector {
    @NotNull
    public EventLogGroup getGroup() {
        EventLogGroup eventLogGroup;
        EventLogGroup it = eventLogGroup = Initializer.INSTANCE.getGROUP();
        boolean bl = false;
        Manager.ensureInitialized$intellij_platform_ml_impl$default(Manager.INSTANCE, false, null, 2, null);
        return eventLogGroup;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$InitializationContext;", "", "apiPlatform", "Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;", "staticState", "Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform$StaticState;", "(Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform$StaticState;)V", "getApiPlatform", "()Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;", "getStaticState", "()Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform$StaticState;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
    public static final class InitializationContext {
        @NotNull
        private final MLApiPlatform apiPlatform;
        @NotNull
        private final MLApiPlatform.StaticState staticState;

        public InitializationContext(@NotNull MLApiPlatform apiPlatform, @NotNull MLApiPlatform.StaticState staticState) {
            Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
            Intrinsics.checkNotNullParameter((Object)staticState, (String)"staticState");
            this.apiPlatform = apiPlatform;
            this.staticState = staticState;
        }

        @NotNull
        public final MLApiPlatform getApiPlatform() {
            return this.apiPlatform;
        }

        @NotNull
        public final MLApiPlatform.StaticState getStaticState() {
            return this.staticState;
        }

        @NotNull
        public final MLApiPlatform component1() {
            return this.apiPlatform;
        }

        @NotNull
        public final MLApiPlatform.StaticState component2() {
            return this.staticState;
        }

        @NotNull
        public final InitializationContext copy(@NotNull MLApiPlatform apiPlatform, @NotNull MLApiPlatform.StaticState staticState) {
            Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
            Intrinsics.checkNotNullParameter((Object)staticState, (String)"staticState");
            return new InitializationContext(apiPlatform, staticState);
        }

        public static /* synthetic */ InitializationContext copy$default(InitializationContext initializationContext, MLApiPlatform mLApiPlatform, MLApiPlatform.StaticState staticState, int n, Object object) {
            if ((n & 1) != 0) {
                mLApiPlatform = initializationContext.apiPlatform;
            }
            if ((n & 2) != 0) {
                staticState = initializationContext.staticState;
            }
            return initializationContext.copy(mLApiPlatform, staticState);
        }

        @NotNull
        public String toString() {
            return "InitializationContext(apiPlatform=" + this.apiPlatform + ", staticState=" + this.staticState + ")";
        }

        public int hashCode() {
            int result2 = this.apiPlatform.hashCode();
            result2 = result2 * 31 + this.staticState.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InitializationContext)) {
                return false;
            }
            InitializationContext initializationContext = (InitializationContext)other;
            if (!Intrinsics.areEqual((Object)this.apiPlatform, (Object)initializationContext.apiPlatform)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.staticState, (Object)initializationContext.staticState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$Initializer;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "state", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "getState", "()Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "setState", "(Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;)V", "initializeGroup", "", "apiPlatform", "Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;", "addDefaultEventsAndListeners", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nMLEventsLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLEventsLogger.kt\ncom/intellij/platform/ml/impl/logger/MLEventsLogger$Initializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1855#2,2:123\n*S KotlinDebug\n*F\n+ 1 MLEventsLogger.kt\ncom/intellij/platform/ml/impl/logger/MLEventsLogger$Initializer\n*L\n101#1:123,2\n*E\n"})
    public static final class Initializer {
        @NotNull
        public static final Initializer INSTANCE = new Initializer();
        @NotNull
        private static final EventLogGroup GROUP = new EventLogGroup("ml", 1, null, null, 12, null);
        @NotNull
        private static State state = State.NonInitialized.INSTANCE;

        private Initializer() {
        }

        @NotNull
        public final EventLogGroup getGROUP() {
            return GROUP;
        }

        @NotNull
        public final State getState() {
            return state;
        }

        public final void setState(@NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"<set-?>");
            Initializer.state = state;
        }

        public final void initializeGroup(@NotNull MLApiPlatform apiPlatform) {
            State.FailedToInitialize failedToInitialize;
            Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
            if (!Intrinsics.areEqual((Object)state, (Object)State.NonInitialized.INSTANCE)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            state = State.Initializing.INSTANCE;
            try {
                MLApiPlatform.Companion.ensureApproachesInitialized(apiPlatform);
                MLApiPlatform.StaticState apiPlatformState = apiPlatform.getStaticState();
                this.addDefaultEventsAndListeners(apiPlatform);
                Iterable $this$forEach$iv = apiPlatform.getEvents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MLEvent event = (MLEvent)element$iv;
                    boolean bl = false;
                    EventField<?>[] eventFieldArray = event.getDeclaration();
                    VarargEventId eventId = GROUP.registerVarargEvent(event.getEventName(), Arrays.copyOf(eventFieldArray, eventFieldArray.length));
                    event.onEventGroupInitialized(eventId);
                }
                state = new State.Initialized(new InitializationContext(apiPlatform, apiPlatformState));
            }
            catch (Throwable e) {
                state = new State.FailedToInitialize(e);
            }
            State state = Initializer.state;
            State.FailedToInitialize failedToInitialize2 = failedToInitialize = state instanceof State.FailedToInitialize ? (State.FailedToInitialize)state : null;
            if (failedToInitialize != null) {
                State.FailedToInitialize it = failedToInitialize;
                boolean bl = false;
                throw new Exception("Failed to initialize FUS ML Logger", it.getException());
            }
        }

        private final void addDefaultEventsAndListeners(MLApiPlatform $this$addDefaultEventsAndListeners) {
            MLApiPlatformStartupLogger startupLogger = new MLApiPlatformStartupLogger();
            $this$addDefaultEventsAndListeners.addEvent$intellij_platform_ml_impl(startupLogger);
            $this$addDefaultEventsAndListeners.addStartupListener(startupLogger);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$Manager;", "", "()V", "defaultPlatform", "Lcom/intellij/platform/ml/impl/apiPlatform/ReplaceableIJPlatform;", "ensureInitialized", "", "okIfInitializing", "", "apiPlatform", "Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;", "ensureInitialized$intellij_platform_ml_impl", "intellij.platform.ml.impl"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();
        @NotNull
        private static final ReplaceableIJPlatform defaultPlatform = ReplaceableIJPlatform.INSTANCE;

        private Manager() {
        }

        public final void ensureInitialized$intellij_platform_ml_impl(boolean okIfInitializing, @NotNull MLApiPlatform apiPlatform) {
            MLApiPlatform.StaticState currentApiPlatformState;
            Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
            State state = Initializer.INSTANCE.getState();
            if (state instanceof State.FailedToInitialize) {
                throw new Exception("ML Event Log already has failed to initialize", ((State.FailedToInitialize)state).getException());
            }
            if (Intrinsics.areEqual((Object)state, (Object)State.Initializing.INSTANCE)) {
                if (okIfInitializing) {
                    return;
                }
                throw new IllegalStateException("Initialization recursion");
            }
            if (Intrinsics.areEqual((Object)state, (Object)State.NonInitialized.INSTANCE)) {
                Initializer.INSTANCE.initializeGroup(apiPlatform);
            } else if (state instanceof State.Initialized && !Intrinsics.areEqual((Object)(currentApiPlatformState = apiPlatform.getStaticState()), (Object)((State.Initialized)state).getContext().getStaticState())) {
                boolean bl = false;
                String string2 = StringsKt.trimIndent((String)("\n            FUS ML Logger was initialized from " + ((State.Initialized)state).getContext().getApiPlatform() + " with presumably immutable state " + ((State.Initialized)state).getContext().getStaticState() + ",\n            but it is used from " + apiPlatform + " with state " + currentApiPlatformState + ", which differs from the initial state.\n            Hence, something that was expected to be logged will not be.\n            "));
                throw new IllegalArgumentException(string2.toString());
            }
        }

        public static /* synthetic */ void ensureInitialized$intellij_platform_ml_impl$default(Manager manager, boolean bl, MLApiPlatform mLApiPlatform, int n, Object object) {
            if ((n & 2) != 0) {
                mLApiPlatform = defaultPlatform;
            }
            manager.ensureInitialized$intellij_platform_ml_impl(bl, mLApiPlatform);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "", "FailedToInitialize", "Initialized", "Initializing", "NonInitialized", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$FailedToInitialize;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$Initialized;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$Initializing;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$NonInitialized;", "intellij.platform.ml.impl"})
    public static interface State {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$FailedToInitialize;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "exception", "", "(Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "intellij.platform.ml.impl"})
        public static final class FailedToInitialize
        implements State {
            @NotNull
            private final Throwable exception;

            public FailedToInitialize(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$Initialized;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "context", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$InitializationContext;", "(Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$InitializationContext;)V", "getContext", "()Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$InitializationContext;", "intellij.platform.ml.impl"})
        public static final class Initialized
        implements State {
            @NotNull
            private final InitializationContext context;

            public Initialized(@NotNull InitializationContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.context = context;
            }

            @NotNull
            public final InitializationContext getContext() {
                return this.context;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$Initializing;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
        public static final class Initializing
        implements State {
            @NotNull
            public static final Initializing INSTANCE = new Initializing();

            private Initializing() {
            }

            @NotNull
            public String toString() {
                return "Initializing";
            }

            public int hashCode() {
                return 1707338434;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Initializing)) {
                    return false;
                }
                Initializing cfr_ignored_0 = (Initializing)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State$NonInitialized;", "Lcom/intellij/platform/ml/impl/logger/MLEventsLogger$State;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
        public static final class NonInitialized
        implements State {
            @NotNull
            public static final NonInitialized INSTANCE = new NonInitialized();

            private NonInitialized() {
            }

            @NotNull
            public String toString() {
                return "NonInitialized";
            }

            public int hashCode() {
                return -59396356;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NonInitialized)) {
                    return false;
                }
                NonInitialized cfr_ignored_0 = (NonInitialized)other;
                return true;
            }
        }
    }
}

