/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.ide.DataManager;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.DictionaryLevel;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.components.JBList;
import icons.SpellcheckerIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public final class SaveTo
implements SpellCheckerQuickFix,
LowPriorityAction {
    private static final SaveTo SAVE_TO_APP_FIX = new SaveTo(DictionaryLevel.APP);
    private static final SaveTo SAVE_TO_PROJECT_FIX = new SaveTo(DictionaryLevel.PROJECT);
    private static final String DICTIONARY = " dictionary";
    private static final String DOTS = "...";
    private DictionaryLevel myLevel;
    private String myWord;

    private SaveTo(@NotNull DictionaryLevel level) {
        if (level == null) {
            SaveTo.$$$reportNull$$$0(0);
        }
        this.myLevel = DictionaryLevel.NOT_SPECIFIED;
        this.myLevel = level;
    }

    public SaveTo(String word) {
        this.myLevel = DictionaryLevel.NOT_SPECIFIED;
        this.myWord = word;
    }

    public SaveTo(String word, @NotNull DictionaryLevel level) {
        if (level == null) {
            SaveTo.$$$reportNull$$$0(1);
        }
        this.myLevel = DictionaryLevel.NOT_SPECIFIED;
        this.myWord = word;
        this.myLevel = level;
    }

    @NotNull
    public String getName() {
        String string2 = SpellCheckerBundle.message("save.0.to.1", this.myWord != null ? SpellCheckerBundle.message("0.in.quotes", this.myWord) : "");
        if (string2 == null) {
            SaveTo.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String dictionary = this.myLevel != DictionaryLevel.NOT_SPECIFIED ? this.myLevel.getName() + DICTIONARY : DOTS;
        String string2 = SpellCheckerBundle.message("save.0.to.1", "", dictionary);
        if (string2 == null) {
            SaveTo.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            SaveTo.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            SaveTo.$$$reportNull$$$0(5);
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            String wordToSave = this.myWord != null ? this.myWord : ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement());
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            if (this.myLevel == DictionaryLevel.NOT_SPECIFIED) {
                List<String> dictionaryList = Arrays.asList(DictionaryLevel.PROJECT.getName(), DictionaryLevel.APP.getName());
                JBList dictList = new JBList(dictionaryList);
                JBPopupFactory.getInstance().createListPopupBuilder((JList)dictList).setTitle(SpellCheckerBundle.message("select.dictionary.title", new Object[0])).setItemChosenCallback(() -> CommandProcessor.getInstance().executeCommand(project2, () -> SaveTo.acceptWord(wordToSave, DictionaryLevel.getLevelByName((String)dictList.getSelectedValue()), descriptor), this.getName(), null)).createPopup().showInBestPositionFor(context);
            } else {
                SaveTo.acceptWord(wordToSave, this.myLevel, descriptor);
            }
        });
    }

    private static void acceptWord(String word, DictionaryLevel level, ProblemDescriptor descriptor) {
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
        PsiElement psi = descriptor.getPsiElement();
        PsiFile file = psi.getContainingFile();
        Project project2 = file.getProject();
        SpellCheckerManager.getInstance(project2).acceptWordAsCorrect$intellij_spellchecker(word, file.getViewProvider().getVirtualFile(), project2, level);
        TextRange range = descriptor.getTextRangeInElement().shiftRight(psi.getTextRange().getStartOffset());
        UpdateHighlightersUtil.removeHighlightersWithExactRange((Document)file.getViewProvider().getDocument(), (Project)project2, (Segment)range);
    }

    public static SaveTo getSaveToLevelFix(DictionaryLevel level) {
        return DictionaryLevel.PROJECT == level ? SAVE_TO_PROJECT_FIX : SAVE_TO_APP_FIX;
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    public static String getFixName() {
        return SpellCheckerBundle.message("save.0.to.1", "", DOTS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

