/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExistingTemplatesComponent {
    private static final Pattern SPLIT = Pattern.compile("(?<!/)/(?!/)");
    private final Tree patternTree;
    private final JBScrollPane myScrollPane;
    private final DefaultTreeModel patternTreeModel;
    private final JComponent panel;
    private Supplier<? extends Configuration> myConfigurationProducer;
    private final DefaultMutableTreeNode myDraftTemplateNode;
    private final DefaultMutableTreeNode myRecentNode;
    private final DefaultMutableTreeNode myUserTemplatesNode;
    private final DefaultMutableTreeNode myProjectTemplatesNode;
    private boolean myTemplateChanged = false;
    private boolean myDraftTemplateAutoselect = false;

    ExistingTemplatesComponent(final Project project2, JComponent keyboardShortcutRoot, AnAction importAction, AnAction exportAction) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.myDraftTemplateNode = new DefaultMutableTreeNode(SSRBundle.message("draft.template.node", new Object[0]));
        this.myRecentNode = new DefaultMutableTreeNode(SSRBundle.message("recent.category", new Object[0]));
        this.myUserTemplatesNode = new DefaultMutableTreeNode(SSRBundle.message("user.defined.category", new Object[0]));
        this.myProjectTemplatesNode = new DefaultMutableTreeNode(SSRBundle.message("project.templates.category", new Object[0]));
        root.add(this.myDraftTemplateNode);
        root.add(this.myRecentNode);
        root.add(this.myUserTemplatesNode);
        this.patternTreeModel = new DefaultTreeModel(root);
        this.patternTree = this.createTree(this.patternTreeModel);
        final ConfigurationManager configurationManager = ConfigurationManager.getInstance(project2);
        for (Configuration config : configurationManager.getHistoryConfigurations()) {
            this.myRecentNode.add(new DefaultMutableTreeNode(config));
        }
        this.patternTree.expandPath(new TreePath(new Object[]{this.patternTreeModel.getRoot(), this.myRecentNode}));
        this.reloadUserTemplates(configurationManager);
        for (Configuration info : StructuralSearchUtil.getPredefinedTemplates()) {
            ExistingTemplatesComponent.getOrCreateCategoryNode(root, SPLIT.split(info.getCategory())).add(new DefaultMutableTreeNode(info, false));
        }
        this.patternTreeModel.reload();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.patternTree);
        DumbAwareAction saveTemplateAction = new DumbAwareAction(SSRBundle.message("save.template.action.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Configuration configuration = ExistingTemplatesComponent.this.myConfigurationProducer.get();
                if (ConfigurationManager.getInstance(project2).showSaveTemplateAsDialog(configuration)) {
                    ExistingTemplatesComponent.this.reloadUserTemplates(configurationManager);
                    DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)ExistingTemplatesComponent.this.myUserTemplatesNode, (Object)configuration);
                    if (node != null) {
                        TreeUtil.selectNode((JTree)ExistingTemplatesComponent.this.patternTree, (TreeNode)node);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$1", "actionPerformed"));
            }
        };
        DumbAwareAction saveInspectionAction = new DumbAwareAction(SSRBundle.message("save.inspection.action.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                StructuralSearchProfileActionProvider.createNewInspection(ExistingTemplatesComponent.this.myConfigurationProducer.get(), project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$2", "actionPerformed"));
            }
        };
        DefaultActionGroup saveGroup = new DefaultActionGroup(SSRBundle.messagePointer("save.template", new Object[0]), SSRBundle.messagePointer("save.template.description.button", new Object[0]), AllIcons.Actions.MenuSaveall);
        saveGroup.addAll(new AnAction[]{saveTemplateAction, saveInspectionAction});
        saveGroup.setPopup(true);
        DumbAwareAction removeAction = new DumbAwareAction(SSRBundle.messagePointer("remove.template", new Object[0]), AllIcons.General.Remove){

            public void update(@NotNull AnActionEvent e) {
                DefaultMutableTreeNode selectedNode;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean enabled = (selectedNode = ExistingTemplatesComponent.this.getSelectedNode()) != null && selectedNode.getUserObject() instanceof Configuration && selectedNode.isNodeAncestor(ExistingTemplatesComponent.this.myUserTemplatesNode);
                e.getPresentation().setEnabled(enabled);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                ExistingTemplatesComponent.this.removeTemplate(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        actionGroup.addAll(new AnAction[]{saveGroup, removeAction, Separator.getInstance(), commonActionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree), commonActionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree), Separator.getInstance(), exportAction, importAction});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbarImpl toolbar2 = (ActionToolbarImpl)actionManager.createActionToolbar("ExistingTemplatesComponent", (ActionGroup)actionGroup, true);
        toolbar2.setTargetComponent((JComponent)this.patternTree);
        toolbar2.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        toolbar2.setForceMinimumSize(true);
        toolbar2.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        this.panel = new JPanel(new GridBagLayout());
        GridBag constraints = new GridBag().setDefaultWeightX(1.0);
        this.panel.add((Component)toolbar2, constraints.nextLine().fillCellHorizontally().insets((Insets)JBInsets.create((int)0, (int)10)));
        this.myScrollPane = new JBScrollPane((Component)this.patternTree);
        this.panel.add((Component)this.myScrollPane, constraints.nextLine().weighty(1.0).fillCell());
        this.panel.setBorder((Border)JBUI.Borders.empty());
        saveGroup.registerCustomShortcutSet(actionManager.getAction("SaveAll").getShortcutSet(), keyboardShortcutRoot);
        removeAction.registerCustomShortcutSet(actionManager.getAction("$Delete").getShortcutSet(), this.panel);
        importAction.registerCustomShortcutSet(actionManager.getAction("$Paste").getShortcutSet(), this.panel);
        exportAction.registerCustomShortcutSet(actionManager.getAction("$Copy").getShortcutSet(), this.panel);
    }

    public TreeState getTreeState() {
        return TreeState.createOn((JTree)this.patternTree, (boolean)true, (boolean)true);
    }

    public void setTreeState(TreeState treeState) {
        if (treeState == null) {
            TreeUtil.expandAll((JTree)this.patternTree);
        } else {
            treeState.applyTo((JTree)this.patternTree);
        }
    }

    private void reloadUserTemplates(ConfigurationManager configurationManager) {
        this.myProjectTemplatesNode.removeAllChildren();
        this.myUserTemplatesNode.removeAllChildren();
        for (Configuration config : configurationManager.getIdeConfigurations()) {
            this.myUserTemplatesNode.add(new DefaultMutableTreeNode(config));
        }
        List<Configuration> projectConfigurations = configurationManager.getProjectConfigurations();
        if (!projectConfigurations.isEmpty()) {
            this.myUserTemplatesNode.insert(this.myProjectTemplatesNode, 0);
            for (Configuration config : projectConfigurations) {
                this.myProjectTemplatesNode.add(new DefaultMutableTreeNode(config));
            }
        }
        this.patternTreeModel.reload(this.myUserTemplatesNode);
    }

    private void removeTemplate(Project project2) {
        DefaultMutableTreeNode sibling;
        Object selection = this.patternTree.getLastSelectedPathComponent();
        if (!(selection instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
        Object object = node.getUserObject();
        if (!(object instanceof Configuration)) {
            return;
        }
        Configuration configuration = (Configuration)object;
        if (configuration.isPredefined()) {
            return;
        }
        if (((DefaultMutableTreeNode)selection).isNodeAncestor(this.myRecentNode)) {
            return;
        }
        String configurationName = configuration.getName();
        block0: for (Configuration otherConfiguration : ConfigurationManager.getInstance(project2).getAllConfigurations()) {
            MatchOptions matchOptions = otherConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
                if (constraint == null || !configurationName.equals(constraint.getWithinConstraint()) && !configurationName.equals(constraint.getContainsConstraint()) && !configurationName.equals(constraint.getReferenceConstraint())) continue;
                if (2 != Messages.showOkCancelDialog((Project)project2, (String)SSRBundle.message("template.in.use.message", configurationName, otherConfiguration.getName()), (String)SSRBundle.message("template.in.use.title", configurationName), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)AllIcons.General.WarningDialog)) break block0;
                return;
            }
        }
        if ((sibling = node.getNextSibling()) == null) {
            sibling = node.getPreviousSibling();
        }
        if (sibling == null) {
            sibling = this.myUserTemplatesNode;
        }
        TreeUtil.selectNode((JTree)this.patternTree, (TreeNode)sibling);
        TreeNode parent = node.getParent();
        this.patternTreeModel.removeNodeFromParent(node);
        if (parent == this.myProjectTemplatesNode && parent.getChildCount() == 0) {
            this.patternTreeModel.removeNodeFromParent((MutableTreeNode)parent);
        }
        ConfigurationManager.getInstance(project2).removeConfiguration(configuration, parent == this.myUserTemplatesNode);
    }

    public void selectFileType(LanguageFileType fileType) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.patternTreeModel.getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            for (String lang : node.toString().split("/")) {
                if (!lang.equalsIgnoreCase(fileType.getName())) continue;
                TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)false, (JTree)this.patternTree, (boolean)true);
                return;
            }
        }
    }

    public void templateChanged() {
        if (!this.myTemplateChanged) {
            this.myTemplateChanged = true;
            if (!this.myDraftTemplateNode.equals(this.getSelectedNode())) {
                this.myDraftTemplateAutoselect = true;
                TreeUtil.selectInTree((DefaultMutableTreeNode)this.myDraftTemplateNode, (boolean)false, (JTree)this.patternTree, (boolean)true);
                this.myDraftTemplateAutoselect = false;
            }
        }
    }

    @NotNull
    private static DefaultMutableTreeNode getOrCreateCategoryNode(@NotNull DefaultMutableTreeNode root, String[] path2) {
        if (root == null) {
            ExistingTemplatesComponent.$$$reportNull$$$0(0);
        }
        DefaultMutableTreeNode result2 = root;
        block0: for (String step2 : path2) {
            DefaultMutableTreeNode child;
            step2 = StringUtil.replace((String)step2, (String)"//", (String)"/");
            DefaultMutableTreeNode defaultMutableTreeNode = child = result2.getChildCount() == 0 ? null : (DefaultMutableTreeNode)result2.getLastChild();
            while (child != null) {
                if (step2.equals(child.getUserObject())) {
                    result2 = child;
                    continue block0;
                }
                child = child.getPreviousSibling();
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(step2);
            result2.add(newNode);
            result2 = newNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = result2;
        if (defaultMutableTreeNode == null) {
            ExistingTemplatesComponent.$$$reportNull$$$0(1);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        Object selection = this.patternTree.getLastSelectedPathComponent();
        if (!(selection instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)selection;
    }

    private Tree createTree(TreeModel treeModel) {
        final Tree tree2 = new Tree(treeModel);
        tree2.setRootVisible(false);
        tree2.setShowsRootHandles(true);
        tree2.setDragEnabled(false);
        tree2.setEditable(false);
        tree2.getSelectionModel().setSelectionMode(1);
        tree2.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                Object selection = tree2.getLastSelectedPathComponent();
                if (!(selection instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
                if (!(node.getUserObject() instanceof Configuration)) {
                    return null;
                }
                return new TextTransferable(ConfigurationUtil.toXml((Configuration)node.getUserObject()));
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        TreeSpeedSearch speedSearch = TreeSpeedSearch.installOn((JTree)tree2, (boolean)false, treePath -> {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (treeNode == this.myDraftTemplateNode) {
                return SSRBundle.message("draft.template.node", new Object[0]);
            }
            Object userObject = treeNode.getUserObject();
            return userObject instanceof Configuration ? ((Configuration)userObject).getName() : userObject.toString();
        });
        tree2.setCellRenderer((TreeCellRenderer)((Object)new ExistingTemplatesTreeCellRenderer(speedSearch, this.myDraftTemplateNode)));
        return tree2;
    }

    public JComponent getTemplatesPanel() {
        return this.panel;
    }

    public void onConfigurationSelected(Consumer<? super Configuration> consumer) {
        this.patternTree.addTreeSelectionListener(event -> {
            Object configuration;
            Object selection = this.patternTree.getLastSelectedPathComponent();
            if (!(selection instanceof DefaultMutableTreeNode) || this.myDraftTemplateAutoselect) {
                return;
            }
            if (this.myTemplateChanged) {
                this.myDraftTemplateNode.setUserObject(this.myConfigurationProducer.get());
                this.myTemplateChanged = false;
            }
            if ((configuration = ((DefaultMutableTreeNode)selection).getUserObject()) instanceof Configuration) {
                consumer.accept((Configuration)configuration);
            }
        });
    }

    public void setConfigurationProducer(Supplier<? extends Configuration> configurationProducer) {
        this.myConfigurationProducer = configurationProducer;
    }

    public void updateColors() {
        this.myScrollPane.setBorder(JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCategoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCategoryNode";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static class ExistingTemplatesTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;
        private final TreeNode myDraftNode;

        ExistingTemplatesTreeCellRenderer(@NotNull TreeSpeedSearch speedSearch, @NotNull TreeNode draftNode) {
            if (speedSearch == null) {
                ExistingTemplatesTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (draftNode == null) {
                ExistingTemplatesTreeCellRenderer.$$$reportNull$$$0(1);
            }
            this.mySpeedSearch = speedSearch;
            this.myDraftNode = draftNode;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            int style;
            String text2;
            DefaultMutableTreeNode treeNode;
            Object userObject;
            if (tree2 == null) {
                ExistingTemplatesTreeCellRenderer.$$$reportNull$$$0(2);
            }
            if ((userObject = (treeNode = (DefaultMutableTreeNode)value2).getUserObject()) == null && treeNode != this.myDraftNode) {
                return;
            }
            Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
            Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            if (treeNode == this.myDraftNode) {
                text2 = SSRBundle.message("draft.template.node", new Object[0]);
                style = 1;
            } else if (userObject instanceof Configuration) {
                text2 = ((Configuration)userObject).getName();
                style = 0;
            } else {
                text2 = userObject.toString();
                style = 1;
            }
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)text2, (int)style, (Color)foreground, (Color)background, (SimpleColoredComponent)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "draftNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$ExistingTemplatesTreeCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

