/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeChooser
extends ComboBoxAction
implements DumbAware {
    private final List<FileTypeInfo> myFileTypeInfos = FileTypeChooser.createFileTypeInfos();
    private FileTypeInfo mySelectedItem = this.myFileTypeInfos.get(0);
    private Consumer<? super FileTypeInfo> myConsumer;
    private Consumer<? super FileTypeInfo> myUserActionConsumer;

    FileTypeChooser() {
        this.setSmallVariant(true);
    }

    public void setFileTypeInfoConsumer(@Nullable Consumer<? super FileTypeInfo> consumer) {
        this.myConsumer = consumer;
    }

    public void setUserActionFileTypeInfoConsumer(@Nullable Consumer<? super FileTypeInfo> consumer) {
        this.myUserActionConsumer = consumer;
    }

    private static List<FileTypeInfo> createFileTypeInfos() {
        ArrayList<LanguageFileType> types = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        types.sort((o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (LanguageFileType fileType : types) {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile != null);
            Language language = fileType.getLanguage();
            ArrayList<PatternContext> patternContexts = new ArrayList<PatternContext>(profile.getPatternContexts());
            if (!patternContexts.isEmpty()) {
                infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(0), false));
                for (int i = 1; i < patternContexts.size(); ++i) {
                    infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(i), true));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, language, null, false));
            ArrayList<Language> dialects = new ArrayList<Language>(language.getDialects());
            dialects.sort(Comparator.comparing(Language::getDisplayName));
            for (Language dialect : dialects) {
                if (!profile.isMyLanguage(dialect)) continue;
                infos.add(new FileTypeInfo(fileType, dialect, null, true));
            }
        }
        return infos;
    }

    public void setSelectedItem(@Nullable LanguageFileType type2, @Nullable Language dialect, @Nullable PatternContext context) {
        if (type2 == null) {
            this.setSelectedItem(null);
        } else {
            for (FileTypeInfo info : this.myFileTypeInfos) {
                if (!info.isEqualTo(type2, dialect, context)) continue;
                this.setSelectedItem(info);
                return;
            }
        }
    }

    private void setSelectedItem(FileTypeInfo info) {
        this.mySelectedItem = info;
        if (this.myConsumer != null && info != null) {
            this.myConsumer.accept(info);
        }
    }

    public FileTypeInfo getSelectedItem() {
        return this.mySelectedItem;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FileTypeChooser.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        if (this.mySelectedItem == null) {
            presentation2.setIcon(AllIcons.FileTypes.Unknown);
            presentation2.setText(CoreBundle.message((String)"filetype.unknown.description", (Object[])new Object[0]));
        } else {
            presentation2.setIcon(this.mySelectedItem.getFileType().getIcon());
            presentation2.setText(this.mySelectedItem.getText());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            FileTypeChooser.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            FileTypeChooser.$$$reportNull$$$0(2);
        }
        if (place == null) {
            FileTypeChooser.$$$reportNull$$$0(3);
        }
        JPanel panel2 = new JPanel(new BorderLayout(1, 0));
        ComboBoxAction.ComboBoxButton button = this.createComboBoxButton(presentation2);
        String text2 = SSRBundle.message("search.dialog.file.type.label", new Object[0]);
        JBLabel label2 = new JBLabel(text2);
        button.setLabel((JLabel)label2);
        panel2.add((Component)label2, "West");
        panel2.add((Component)button, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            FileTypeChooser.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
        if (button == null) {
            FileTypeChooser.$$$reportNull$$$0(5);
        }
        if (context == null) {
            FileTypeChooser.$$$reportNull$$$0(6);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (FileTypeInfo fileTypeInfo : this.myFileTypeInfos) {
            group2.add((AnAction)new FileTypeInfoAction(fileTypeInfo));
        }
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            FileTypeChooser.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return action2 -> ((FileTypeInfoAction)((Object)action2)).getFileTypeInfo() == this.mySelectedItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 7 -> new IllegalStateException(string2);
        };
    }

    private class FileTypeInfoAction
    extends DumbAwareAction {
        @NotNull
        private final FileTypeInfo myFileTypeInfo;

        FileTypeInfoAction(FileTypeInfo fileTypeInfo) {
            this.myFileTypeInfo = fileTypeInfo;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setIcon(fileTypeInfo.isNested() ? null : fileTypeInfo.getFileType().getIcon());
            presentation2.setText((String)(fileTypeInfo.isNested() ? "    " + fileTypeInfo.getText() : fileTypeInfo.getText()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FileTypeInfoAction.$$$reportNull$$$0(0);
            }
            FileTypeChooser.this.setSelectedItem(this.myFileTypeInfo);
            if (FileTypeChooser.this.myUserActionConsumer != null) {
                FileTypeChooser.this.myUserActionConsumer.accept(this.myFileTypeInfo);
            }
        }

        @NotNull
        FileTypeInfo getFileTypeInfo() {
            FileTypeInfo fileTypeInfo = this.myFileTypeInfo;
            if (fileTypeInfo == null) {
                FileTypeInfoAction.$$$reportNull$$$0(1);
            }
            return fileTypeInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser$FileTypeInfoAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser$FileTypeInfoAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

