/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Predicates;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.vcs.log.VcsLogBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterComponent
extends JBPanel<FilterComponent> {
    private static final int GAP_BEFORE_ARROW = 3;
    protected static final int BORDER_SIZE = 2;
    protected static final int ARC_SIZE = 10;
    @NotNull
    private final @NotNull Supplier<@NlsContexts.Label @NotNull String> myDisplayName;
    @Nullable
    private JLabel myNameLabel;
    @NotNull
    private JLabel myValueLabel;
    @NotNull
    private InlineIconButton myFilterActionButton;
    @Nullable
    private Runnable myShowPopupAction;

    protected FilterComponent(@NotNull @NotNull Supplier<@NlsContexts.Label @NotNull String> displayName) {
        if (displayName == null) {
            FilterComponent.$$$reportNull$$$0(0);
        }
        super(null);
        this.myDisplayName = displayName;
        this.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
    }

    public JComponent initUi() {
        DrawLabelMode drawLabelMode = this.shouldDrawLabel();
        switch (drawLabelMode) {
            case ALWAYS: {
                this.myNameLabel = new DynamicLabel(() -> this.myDisplayName.get() + (this.isValueSelected() ? ": " : ""));
                break;
            }
            case NEVER: {
                this.myNameLabel = null;
                break;
            }
            case WHEN_VALUE_NOT_SET: {
                this.myNameLabel = new DynamicLabel(() -> this.isValueSelected() ? "" : this.myDisplayName.get());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + drawLabelMode);
            }
        }
        this.myValueLabel = new DynamicLabel(this::getCurrentText);
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(FilterComponent.wrapBorder(this.createUnfocusedBorder()));
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.myFilterActionButton = new InlineIconButton(AllIcons.Actions.Close);
        if (this.myNameLabel != null) {
            this.add(this.myNameLabel);
        }
        this.add(this.myValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.myFilterActionButton);
        this.myFilterActionButton.setActionListener(e -> {
            if (this.isValueSelected()) {
                this.resetFilter();
            } else {
                this.showPopup();
            }
        });
        this.updateFilterButton();
        this.installChangeListener(() -> {
            this.setDefaultForeground();
            this.updateFilterButton();
            this.myValueLabel.revalidate();
            this.myValueLabel.repaint();
        });
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        if (this.shouldIndicateHovering()) {
            Stream.of(new JComponent[]{this, this.myFilterActionButton, this.myNameLabel, this.myValueLabel}).filter(Predicates.nonNull()).forEach(this::indicateHovering);
        }
        this.indicateFocusing();
        this.setCursor(Cursor.getPredefinedCursor(12));
        return this;
    }

    private void updateFilterButton() {
        boolean selected = this.isValueSelected();
        this.myFilterActionButton.setIcon(selected ? AllIcons.Actions.Close : AllIcons.General.ArrowDown);
        this.myFilterActionButton.setHoveredIcon(selected ? AllIcons.Actions.CloseHovered : AllIcons.General.ArrowDown);
        this.myFilterActionButton.setFocusable(selected);
    }

    @NotNull
    @Nls
    public abstract String getCurrentText();

    @NotNull
    @Nls
    public abstract String getEmptyFilterValue();

    protected abstract boolean isValueSelected();

    public abstract void installChangeListener(@NotNull Runnable var1);

    protected boolean shouldIndicateHovering() {
        return true;
    }

    @NotNull
    protected DrawLabelMode shouldDrawLabel() {
        DrawLabelMode drawLabelMode = DrawLabelMode.ALWAYS;
        if (drawLabelMode == null) {
            FilterComponent.$$$reportNull$$$0(1);
        }
        return drawLabelMode;
    }

    protected abstract Runnable createResetAction();

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FilterComponent.this.setBorder(FilterComponent.wrapBorder(FilterComponent.this.createFocusedBorder()));
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                FilterComponent.this.setBorder(FilterComponent.wrapBorder(FilterComponent.this.createUnfocusedBorder()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/util/ui/FilterComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    FilterComponent.this.showPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/FilterComponent$2", "keyPressed"));
            }
        });
    }

    private void showPopupMenuOnClick() {
        ClickListener clickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (UIUtil.isCloseClick((MouseEvent)event, (int)502)) {
                    FilterComponent.this.resetFilter();
                } else {
                    FilterComponent.this.showPopup();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/FilterComponent$3", "onClick"));
            }
        };
        clickListener.installOn((Component)((Object)this));
        clickListener.installOn((Component)this.myValueLabel);
        if (this.myNameLabel != null) {
            clickListener.installOn((Component)this.myNameLabel);
        }
    }

    private void indicateHovering(@NotNull JComponent component2) {
        if (component2 == null) {
            FilterComponent.$$$reportNull$$$0(2);
        }
        component2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                FilterComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                FilterComponent.this.setDefaultForeground();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/util/ui/FilterComponent$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setDefaultForeground() {
        if (this.myNameLabel != null) {
            this.myNameLabel.setForeground(UIUtil.getLabelInfoForeground());
        }
        this.myValueLabel.setForeground(UIUtil.getLabelForeground());
    }

    private void setOnHoverForeground() {
        if (this.myNameLabel != null) {
            this.myNameLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        }
        this.myValueLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private void resetFilter() {
        Runnable resetAction = this.createResetAction();
        if (resetAction != null) {
            resetAction.run();
        }
    }

    private void showPopup() {
        if (this.myShowPopupAction != null) {
            this.myShowPopupAction.run();
        }
    }

    protected Border createFocusedBorder() {
        return new FilledRoundedBorder(UIUtil.getFocusedBorderColor(), 10, 2, false);
    }

    protected Border createUnfocusedBorder() {
        return JBUI.Borders.empty((int)2);
    }

    public void setShowPopupAction(@NotNull Runnable showPopupAction) {
        if (showPopupAction == null) {
            FilterComponent.$$$reportNull$$$0(3);
        }
        this.myShowPopupAction = showPopupAction;
    }

    private static Border wrapBorder(Border outerBorder) {
        return BorderFactory.createCompoundBorder(outerBorder, JBUI.Borders.empty((int)2));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleVcsLogPopupComponent(super.getAccessibleContext());
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/FilterComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showPopupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/FilterComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldDrawLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indicateHovering";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setShowPopupAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    public static enum DrawLabelMode {
        ALWAYS,
        NEVER,
        WHEN_VALUE_NOT_SET;

    }

    private static final class DynamicLabel
    extends JLabel {
        private final @NotNull Supplier<@NlsContexts.Label String> myText;

        private DynamicLabel(@NotNull Supplier<@NlsContexts.Label String> text2) {
            if (text2 == null) {
                DynamicLabel.$$$reportNull$$$0(0);
            }
            this.myText = text2;
        }

        @Override
        @NlsContexts.Label
        public String getText() {
            if (this.myText == null) {
                return "";
            }
            return this.myText.get();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.width = Math.min(size.width, JBUI.scale((int)70));
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/FilterComponent$DynamicLabel", "<init>"));
        }
    }

    public static class FilledRoundedBorder
    implements Border {
        private final Color myColor;
        private final int myThickness;
        private final int myArcSize;
        private final boolean myThinBorder;

        public FilledRoundedBorder(@NotNull Color color2, int arcSize, int thickness, boolean thinBorder) {
            if (color2 == null) {
                FilledRoundedBorder.$$$reportNull$$$0(0);
            }
            this.myColor = color2;
            this.myThickness = thickness;
            this.myArcSize = arcSize;
            this.myThinBorder = thinBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.myColor);
            int thickness = JBUI.scale((int)(this.myThinBorder ? 1 : this.myThickness));
            int arcSize = JBUI.scale((int)this.myArcSize);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, arcSize, arcSize));
            int innerArc = Math.max(arcSize - thickness, 0);
            area.subtract(new Area(new RoundRectangle2D.Double(x + thickness, y + thickness, width - 2 * thickness, height - 2 * thickness, innerArc, innerArc)));
            ((Graphics2D)g).fill(area);
            config.restore();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBUI.insets((int)this.myThickness);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/ui/FilterComponent$FilledRoundedBorder", "<init>"));
        }
    }

    private class AccessibleVcsLogPopupComponent
    extends AccessibleContextDelegate {
        AccessibleVcsLogPopupComponent(AccessibleContext context) {
            super(context);
        }

        protected Container getDelegateParent() {
            return null;
        }

        public String getAccessibleName() {
            return VcsLogBundle.message("vcs.log.filter.accessible.name", FilterComponent.this.myDisplayName.get(), FilterComponent.this.getCurrentText());
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }
}

