/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.CollectionDataExternalizer;
import com.intellij.vcs.log.data.index.IntListDataExternalizer;
import com.intellij.vcs.log.data.index.IntPairKeyDescriptor;
import com.intellij.vcs.log.data.index.LongPairDataExternalizer;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.data.index.VcsLogWriter;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0001`BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,H\u0082\bJ\r\u0010-\u001a\u00020*H\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016J\u0010\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u0014H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020*H\u0016J:\u00107\u001a\f\u0012\u0006\u0012\u0004\u0018\u000109\u0018\u0001082\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u0002092\u0006\u0010>\u001a\u00020\u000fH\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u00103\u001a\u00020\u0014H\u0016J8\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\u001b2\b\u0010C\u001a\u0004\u0018\u0001002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001b0E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J\u0016\u0010J\u001a\u0002002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020@0\bH\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010@2\u0006\u00103\u001a\u00020\u0014H\u0016J\u0012\u0010L\u001a\u0004\u0018\u00010\u001b2\u0006\u00103\u001a\u00020\u0014H\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010\u001d2\u0006\u00103\u001a\u00020\u0014H\u0016J(\u0010M\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020P0O0N2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140QH\u0016J\b\u0010R\u001a\u00020SH\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010$2\u0006\u00103\u001a\u00020\u0014H\u0016J,\u0010U\u001a\u00020*2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u0002092\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020W0O0VH\u0016J\u001e\u0010X\u001a\u00020*2\u0006\u0010Y\u001a\u00020\u00142\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000f0[H\u0016J\b\u0010\\\u001a\u00020*H\u0016J\"\u0010]\u001a\u00020*2\u0018\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000f0^H\u0016J\b\u0010_\u001a\u00020*H\u0002R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0016\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001d0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020$0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend;", "Lcom/intellij/vcs/log/data/index/VcsLogStorageBackend;", "Lcom/intellij/openapi/Disposable;", "storageId", "Lcom/intellij/vcs/log/util/StorageId$Directory;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "useDurableEnumerator", "", "disposable", "(Lcom/intellij/vcs/log/util/StorageId$Directory;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Set;Lcom/intellij/vcs/log/VcsUserRegistry;Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;ZLcom/intellij/openapi/Disposable;)V", "committers", "Lcom/intellij/util/io/PersistentHashMap;", "", "isEmpty", "()Z", "isFresh", "setFresh", "(Z)V", "messages", "", "parents", "", "paths", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex;", "renames", "getStorageId", "()Lcom/intellij/vcs/log/util/StorageId$Directory;", "timestamps", "", "trigrams", "Lcom/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex;", "users", "Lcom/intellij/vcs/log/data/index/VcsLogUserIndex;", "catchAndWarn", "", "runnable", "Lkotlin/Function0;", "clearCaches", "clearCaches$intellij_platform_vcs_log_impl", "collectMissingCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "commitIds", "containsCommit", "commitId", "createWriter", "Lcom/intellij/vcs/log/data/index/VcsLogWriter;", "dispose", "findRename", "Lcom/intellij/vcs/log/history/EdgeData;", "Lcom/intellij/openapi/vcs/FilePath;", "parent", "child", "root", "path", "isChildPath", "getAuthorForCommit", "Lcom/intellij/vcs/log/VcsUser;", "getCommitsForSubstring", "string", "candidates", "noTrigramSources", "", "consumer", "Ljava/util/function/IntConsumer;", "filter", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "getCommitsForUsers", "getCommitterForCommit", "getMessage", "getParents", "", "", "Lcom/intellij/vcs/log/Hash;", "", "getPathsEncoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "getTimestamp", "iterateChangesInCommits", "Ljava/util/function/ObjIntConsumer;", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind;", "iterateIndexedCommits", "limit", "processor", "Ljava/util/function/IntFunction;", "markCorrupted", "processMessages", "Lkotlin/Function2;", "reportEmpty", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nPhmVcsLogStorageBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhmVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,413:1\n324#1,7:427\n324#1,7:434\n324#1,7:441\n324#1,7:448\n324#1,7:455\n1603#2,9:414\n1855#2:423\n1856#2:425\n1612#2:426\n1#3:424\n*S KotlinDebug\n*F\n+ 1 PhmVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend\n*L\n79#1:427,7\n90#1:434,7\n101#1:441,7\n112#1:448,7\n121#1:455,7\n228#1:414,9\n228#1:423\n228#1:425\n228#1:426\n228#1:424\n*E\n"})
public final class PhmVcsLogStorageBackend
implements VcsLogStorageBackend,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageId.Directory storageId;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsLogErrorHandler errorHandler;
    @NotNull
    private final PersistentHashMap<Integer, String> messages;
    @NotNull
    private final PersistentHashMap<Integer, int[]> parents;
    @NotNull
    private final PersistentHashMap<Integer, Integer> committers;
    @NotNull
    private final PersistentHashMap<Integer, long[]> timestamps;
    @NotNull
    private final PersistentHashMap<int[], int[]> renames;
    @NotNull
    private final VcsLogMessagesTrigramIndex trigrams;
    @NotNull
    private final VcsLogPathsIndex paths;
    @NotNull
    private final VcsLogUserIndex users;
    private volatile boolean isFresh;
    @NotNull
    private static final Logger LOG;
    @NonNls
    @NotNull
    private static final String INDEX = "index";
    private static final int VERSION = 3;

    public PhmVcsLogStorageBackend(@NotNull StorageId.Directory storageId, @NotNull VcsLogStorage storage, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsUserRegistry userRegistry, @NotNull VcsLogErrorHandler errorHandler2, boolean useDurableEnumerator, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)userRegistry, (String)"userRegistry");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.storageId = storageId;
        this.storage = storage;
        this.errorHandler = errorHandler2;
        Disposer.register((Disposable)disposable, (Disposable)this);
        try {
            StorageLockContext storageLockContext = new StorageLockContext();
            Path messagesStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "messages", false, 2, null);
            this.setFresh(!Files.exists(messagesStorage, new LinkOption[0]));
            this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$0(this));
            Path parentsStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "parents", false, 2, null);
            this.parents = new PersistentHashMap(parentsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntListDataExternalizer(), AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$2(this));
            Path committerStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "committers", false, 2, null);
            this.committers = new PersistentHashMap(committerStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$4(this));
            Path timestampsStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "timestamps", false, 2, null);
            this.timestamps = new PersistentHashMap(timestampsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new LongPairDataExternalizer(), AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$6(this));
            Path storageFile = StorageId.Directory.getStorageFile$default(this.getStorageId(), "renames-map", false, 2, null);
            this.renames = new PersistentHashMap(storageFile, (KeyDescriptor)IntPairKeyDescriptor.INSTANCE, (DataExternalizer)CollectionDataExternalizer.INSTANCE, AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$8(this));
            this.paths = new VcsLogPathsIndex(this.getStorageId(), this.storage, roots, storageLockContext, this.errorHandler, this.renames, useDurableEnumerator, this);
            this.users = new VcsLogUserIndex(this.getStorageId(), storageLockContext, userRegistry, this.errorHandler, this);
            this.trigrams = new VcsLogMessagesTrigramIndex(this.getStorageId(), storageLockContext, this.errorHandler, this);
            this.reportEmpty();
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)this);
            throw t;
        }
    }

    @Override
    @NotNull
    public StorageId.Directory getStorageId() {
        return this.storageId;
    }

    @Override
    public boolean isFresh() {
        return this.isFresh;
    }

    @Override
    public void setFresh(boolean bl) {
        this.isFresh = bl;
    }

    @Override
    public boolean isEmpty() {
        return this.messages.keysCountApproximately() == 0;
    }

    private final void reportEmpty() throws IOException {
        if (this.messages.keysCountApproximately() == 0) {
            return;
        }
        boolean trigramsEmpty = this.trigrams.isEmpty();
        boolean usersEmpty = this.users.isEmpty();
        boolean pathsEmpty = this.paths.isEmpty();
        if (trigramsEmpty || usersEmpty || pathsEmpty) {
            VcsLogPersistentIndex.LOG.warn("Some of the index maps empty:\ntrigrams empty " + trigramsEmpty + "\nusers empty " + usersEmpty + "\npaths empty " + pathsEmpty);
        }
    }

    @Override
    @NotNull
    public VcsLogWriter createWriter() {
        return new VcsLogWriter(this){
            final /* synthetic */ PhmVcsLogStorageBackend this$0;
            {
                this.this$0 = $receiver;
            }

            public void putCommit(int commitId2, @NotNull VcsLogIndexer.CompressedDetails details) {
                Intrinsics.checkNotNullParameter((Object)details, (String)"details");
                PhmVcsLogStorageBackend.access$getUsers$p(this.this$0).update(commitId2, details);
                PhmVcsLogStorageBackend.access$getPaths$p(this.this$0).update(commitId2, details);
                PhmVcsLogStorageBackend.access$getTrigrams$p(this.this$0).update(commitId2, details);
                int n = 0;
                int n2 = details.getParents().size();
                int[] nArray = new int[n2];
                Integer n3 = commitId2;
                PersistentHashMap persistentHashMap = PhmVcsLogStorageBackend.access$getParents$p(this.this$0);
                while (n < n2) {
                    int n4 = n++;
                    VcsLogStorage vcsLogStorage = PhmVcsLogStorageBackend.access$getStorage$p(this.this$0);
                    Id Id = details.getParents().get(n4);
                    Intrinsics.checkNotNullExpressionValue(Id, (String)"get(...)");
                    Hash hash2 = (Hash)Id;
                    VirtualFile virtualFile = details.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    nArray[n4] = vcsLogStorage.getCommitIndex(hash2, virtualFile);
                }
                persistentHashMap.put((Object)n3, (Object)nArray);
                long[] lArray = new long[]{details.getAuthorTime(), details.getCommitTime()};
                PhmVcsLogStorageBackend.access$getTimestamps$p(this.this$0).put((Object)commitId2, (Object)lArray);
                if (!Intrinsics.areEqual((Object)details.getAuthor(), (Object)details.getCommitter())) {
                    PhmVcsLogStorageBackend.access$getCommitters$p(this.this$0).put((Object)commitId2, (Object)PhmVcsLogStorageBackend.access$getUsers$p(this.this$0).getUserId(details.getCommitter()));
                }
                PhmVcsLogStorageBackend.access$getMessages$p(this.this$0).put((Object)commitId2, (Object)details.getFullMessage());
            }

            private final void force() {
                try {
                    PhmVcsLogStorageBackend.access$getParents$p(this.this$0).force();
                    PhmVcsLogStorageBackend.access$getCommitters$p(this.this$0).force();
                    PhmVcsLogStorageBackend.access$getTimestamps$p(this.this$0).force();
                    PhmVcsLogStorageBackend.access$getTrigrams$p(this.this$0).flush();
                    PhmVcsLogStorageBackend.access$getUsers$p(this.this$0).flush();
                    PhmVcsLogStorageBackend.access$getPaths$p(this.this$0).flush();
                    PhmVcsLogStorageBackend.access$getMessages$p(this.this$0).force();
                }
                catch (IOException e) {
                    PhmVcsLogStorageBackend.access$getErrorHandler$p(this.this$0).handleError(VcsLogErrorHandler.Source.Index, e);
                }
                catch (StorageException s) {
                    PhmVcsLogStorageBackend.access$getErrorHandler$p(this.this$0).handleError(VcsLogErrorHandler.Source.Index, s);
                }
            }

            public void flush() {
                this.force();
            }

            public void close(boolean performCommit) {
                this.force();
            }

            public void interrupt() {
                this.force();
            }
        };
    }

    @Override
    public void markCorrupted() {
        try {
            this.messages.markCorrupted();
            this.messages.force();
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    @Override
    public boolean containsCommit(int commitId2) {
        return this.messages.containsMapping((Object)commitId2);
    }

    @Override
    @NotNull
    public IntSet collectMissingCommits(@NotNull IntSet commitIds) {
        Intrinsics.checkNotNullParameter((Object)commitIds, (String)"commitIds");
        IntOpenHashSet missing = new IntOpenHashSet();
        commitIds.forEach(arg_0 -> PhmVcsLogStorageBackend.collectMissingCommits$lambda$9(this, missing, arg_0));
        return (IntSet)missing;
    }

    @Override
    public void iterateIndexedCommits(int limit, @NotNull IntFunction<Boolean> processor2) throws IOException {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Ref.IntRef iterationCount = new Ref.IntRef();
        this.messages.processKeysWithExistingMapping(arg_0 -> PhmVcsLogStorageBackend.iterateIndexedCommits$lambda$10((Function1)new Function1<Integer, Boolean>(iterationCount, limit, processor2){
            final /* synthetic */ Ref.IntRef $iterationCount;
            final /* synthetic */ int $limit;
            final /* synthetic */ IntFunction<Boolean> $processor;
            {
                this.$iterationCount = $iterationCount;
                this.$limit = $limit;
                this.$processor = $processor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Integer it) {
                if (this.$iterationCount.element >= this.$limit) {
                    return false;
                }
                int n = this.$iterationCount.element;
                this.$iterationCount.element = n + 1;
                Intrinsics.checkNotNull((Object)it);
                Boolean bl = this.$processor.apply(it);
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"apply(...)");
                return bl;
            }
        }, arg_0));
    }

    @Override
    @Nullable
    public long[] getTimestamp(int commitId2) {
        return (long[])this.timestamps.get((Object)commitId2);
    }

    @Override
    @Nullable
    public int[] getParents(int commitId2) {
        return (int[])this.parents.get((Object)commitId2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, List<Hash>> getParents(@NotNull Collection<Integer> commitIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        Iterable $this$mapNotNull$iv = commitIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            List<Hash> parentHashes;
            int[] parents;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int commitId2 = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ((this.getParents(commitId2) == null ? null : (PhmVcsLogStorageBackendKt.getHashes(this.storage, parents) == null ? null : TuplesKt.to((Object)commitId2, parentHashes))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    @Nullable
    public String getMessage(int commitId2) {
        return (String)this.messages.get((Object)commitId2);
    }

    @Override
    public void processMessages(@NotNull Function2<? super Integer, ? super String, Boolean> processor2) throws IOException {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.messages.processKeysWithExistingMapping(arg_0 -> PhmVcsLogStorageBackend.processMessages$lambda$12(processor2, this, arg_0));
    }

    @Override
    public void getCommitsForSubstring(@NotNull String string2, @Nullable IntSet candidates, @NotNull List<String> noTrigramSources, @NotNull IntConsumer consumer, @NotNull VcsLogTextFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Intrinsics.checkNotNullParameter(noTrigramSources, (String)"noTrigramSources");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        IntSet commits2 = this.trigrams.getCommitsForSubstring(string2);
        if (commits2 == null) {
            noTrigramSources.add(string2);
            return;
        }
        IntIterator intIterator = commits2.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            String message2;
            int commit2 = iterator.nextInt();
            if (candidates != null && !candidates.contains(commit2) || !filter2.matches(message2 = (String)this.messages.get((Object)commit2))) continue;
            consumer.accept(commit2);
        }
    }

    @Override
    @Nullable
    public VcsUser getAuthorForCommit(int commitId2) {
        return this.users.getAuthorForCommit(commitId2);
    }

    @Override
    @Nullable
    public VcsUser getCommitterForCommit(int commitId2) {
        Integer committer = (Integer)this.committers.get((Object)commitId2);
        if (committer != null) {
            return this.users.getUserById(committer);
        }
        return this.messages.containsMapping((Object)commitId2) ? this.getAuthorForCommit(commitId2) : null;
    }

    @Override
    @NotNull
    public IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        IntSet intSet = this.users.getCommitsForUsers(users);
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"getCommitsForUsers(...)");
        return intSet;
    }

    @Override
    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child, @NotNull VirtualFile root, @NotNull FilePath path2, boolean isChildPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        int[] nArray = new int[]{parent, child};
        int[] renames2 = (int[])this.renames.get((Object)nArray);
        if (renames2 == null || renames2.length == 0) {
            return null;
        }
        int pathId = this.paths.getPathId(new VcsLogPathsIndex.LightFilePath(root, path2));
        for (int i = 0; i < renames2.length; i += 2) {
            int first = renames2[i];
            int second = renames2[i + 1];
            if ((!isChildPath || second != pathId) && (isChildPath || first != pathId)) continue;
            FilePath path1 = this.paths.getPath(first, path2.isDirectory());
            FilePath path22 = this.paths.getPath(second, path2.isDirectory());
            return new EdgeData<FilePath>(path1, path22);
        }
        return null;
    }

    @Override
    public void iterateChangesInCommits(@NotNull VirtualFile root, @NotNull FilePath path2, @NotNull ObjIntConsumer<List<VcsLogPathsIndex.ChangeKind>> consumer) throws IOException, StorageException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        int pathId = this.paths.getPathId(new VcsLogPathsIndex.LightFilePath(root, path2));
        this.paths.iterateCommitIdsAndValues(pathId, consumer);
    }

    @Override
    @NotNull
    public VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return (arg_0, arg_1, arg_2) -> PhmVcsLogStorageBackend.getPathsEncoder$lambda$13(this, arg_0, arg_1, arg_2);
    }

    private final void catchAndWarn(Function0<Unit> runnable) {
        boolean $i$f$catchAndWarn = false;
        try {
            runnable.invoke();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public final void clearCaches$intellij_platform_vcs_log_impl() {
        Object[] objectArray = new VcsLogFullDetailsIndex[]{this.trigrams, this.paths, this.users};
        for (VcsLogFullDetailsIndex index : CollectionsKt.listOf((Object[])objectArray)) {
            index.clearCaches();
        }
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(PhmVcsLogStorageBackend this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PhmVcsLogStorageBackend phmVcsLogStorageBackend = this$0;
        PersistentHashMap<Integer, String> persistentHashMap = this$0.messages;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            persistentHashMap.close();
        }
        catch (IOException e$iv) {
            LOG.warn((Throwable)e$iv);
        }
    }

    private static final void _init_$lambda$2(PhmVcsLogStorageBackend this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PhmVcsLogStorageBackend phmVcsLogStorageBackend = this$0;
        PersistentHashMap<Integer, int[]> persistentHashMap = this$0.parents;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            persistentHashMap.close();
        }
        catch (IOException e$iv) {
            LOG.warn((Throwable)e$iv);
        }
    }

    private static final void _init_$lambda$4(PhmVcsLogStorageBackend this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PhmVcsLogStorageBackend phmVcsLogStorageBackend = this$0;
        PersistentHashMap<Integer, Integer> persistentHashMap = this$0.committers;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            persistentHashMap.close();
        }
        catch (IOException e$iv) {
            LOG.warn((Throwable)e$iv);
        }
    }

    private static final void _init_$lambda$6(PhmVcsLogStorageBackend this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PhmVcsLogStorageBackend phmVcsLogStorageBackend = this$0;
        PersistentHashMap<Integer, long[]> persistentHashMap = this$0.timestamps;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            persistentHashMap.close();
        }
        catch (IOException e$iv) {
            LOG.warn((Throwable)e$iv);
        }
    }

    private static final void _init_$lambda$8(PhmVcsLogStorageBackend this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PhmVcsLogStorageBackend phmVcsLogStorageBackend = this$0;
        PersistentHashMap<int[], int[]> persistentHashMap = this$0.renames;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            persistentHashMap.close();
        }
        catch (IOException e$iv) {
            LOG.warn((Throwable)e$iv);
        }
    }

    private static final void collectMissingCommits$lambda$9(PhmVcsLogStorageBackend this$0, IntOpenHashSet $missing, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$missing, (String)"$missing");
        if (!this$0.messages.containsMapping((Object)it)) {
            $missing.add(it);
        }
    }

    private static final boolean iterateIndexedCommits$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processMessages$lambda$12(Function2 $processor, PhmVcsLogStorageBackend this$0, Integer commit2) {
        Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)commit2);
        String string2 = (String)this$0.messages.get((Object)commit2);
        if (string2 == null) {
            return true;
        }
        return (Boolean)$processor.invoke((Object)commit2, (Object)string2);
    }

    private static final int getPathsEncoder$lambda$13(PhmVcsLogStorageBackend this$0, VirtualFile root, String relativePath, boolean bl) {
        int n;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            n = this$0.paths.getPathId(new VcsLogPathsIndex.LightFilePath(root, relativePath));
        }
        catch (IOException e) {
            this$0.errorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
            return 0;
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final PhmVcsLogStorageBackend create(@NotNull Project project2, @NotNull VcsLogStorage storage, @NotNull StorageId.Directory indexStorageId, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable parent) throws IOException {
        return Companion.create(project2, storage, indexStorageId, roots, errorHandler2, parent);
    }

    @JvmStatic
    @NotNull
    public static final StorageId.Directory getIndexStorageId(@NotNull Project project2, @NotNull String logId) {
        return Companion.getIndexStorageId(project2, logId);
    }

    public static final /* synthetic */ VcsLogUserIndex access$getUsers$p(PhmVcsLogStorageBackend $this) {
        return $this.users;
    }

    public static final /* synthetic */ VcsLogPathsIndex access$getPaths$p(PhmVcsLogStorageBackend $this) {
        return $this.paths;
    }

    public static final /* synthetic */ VcsLogMessagesTrigramIndex access$getTrigrams$p(PhmVcsLogStorageBackend $this) {
        return $this.trigrams;
    }

    public static final /* synthetic */ PersistentHashMap access$getParents$p(PhmVcsLogStorageBackend $this) {
        return $this.parents;
    }

    public static final /* synthetic */ VcsLogStorage access$getStorage$p(PhmVcsLogStorageBackend $this) {
        return $this.storage;
    }

    public static final /* synthetic */ PersistentHashMap access$getTimestamps$p(PhmVcsLogStorageBackend $this) {
        return $this.timestamps;
    }

    public static final /* synthetic */ PersistentHashMap access$getCommitters$p(PhmVcsLogStorageBackend $this) {
        return $this.committers;
    }

    public static final /* synthetic */ PersistentHashMap access$getMessages$p(PhmVcsLogStorageBackend $this) {
        return $this.messages;
    }

    public static final /* synthetic */ VcsLogErrorHandler access$getErrorHandler$p(PhmVcsLogStorageBackend $this) {
        return $this.errorHandler;
    }

    static {
        Logger logger = Logger.getInstance(PhmVcsLogStorageBackend.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend$Companion;", "", "()V", "INDEX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "VERSION", "", "durableEnumeratorRegistryProperty", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getDurableEnumeratorRegistryProperty$intellij_platform_vcs_log_impl", "()Lcom/intellij/openapi/util/registry/RegistryValue;", "create", "Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "indexStorageId", "Lcom/intellij/vcs/log/util/StorageId$Directory;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "parent", "Lcom/intellij/openapi/Disposable;", "getIndexStorageId", "logId", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RegistryValue getDurableEnumeratorRegistryProperty$intellij_platform_vcs_log_impl() {
            RegistryValue registryValue = Registry.get((String)"vcs.log.index.durable.enumerator");
            Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
            return registryValue;
        }

        @JvmStatic
        @NotNull
        public final PhmVcsLogStorageBackend create(@NotNull Project project2, @NotNull VcsLogStorage storage, @NotNull StorageId.Directory indexStorageId, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable parent) throws IOException {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)indexStorageId, (String)"indexStorageId");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            VcsUserRegistry userRegistry = (VcsUserRegistry)project2.getService(VcsUserRegistry.class);
            boolean useDurableEnumerator = this.getDurableEnumeratorRegistryProperty$intellij_platform_vcs_log_impl().asBoolean();
            Object object = IOUtil.openCleanOrResetBroken(() -> Companion.create$lambda$0(indexStorageId, storage, roots, userRegistry, errorHandler2, useDurableEnumerator, parent), () -> Companion.create$lambda$1(indexStorageId));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"openCleanOrResetBroken(...)");
            return (PhmVcsLogStorageBackend)object;
        }

        @JvmStatic
        @NotNull
        public final StorageId.Directory getIndexStorageId(@NotNull Project project2, @NotNull String logId) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            String string2 = project2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return new StorageId.Directory(string2, PhmVcsLogStorageBackend.INDEX, logId, 29);
        }

        private static final PhmVcsLogStorageBackend create$lambda$0(StorageId.Directory $indexStorageId, VcsLogStorage $storage, Set $roots, VcsUserRegistry $userRegistry, VcsLogErrorHandler $errorHandler, boolean $useDurableEnumerator, Disposable $parent) {
            Intrinsics.checkNotNullParameter((Object)$indexStorageId, (String)"$indexStorageId");
            Intrinsics.checkNotNullParameter((Object)$storage, (String)"$storage");
            Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
            Intrinsics.checkNotNullParameter((Object)$errorHandler, (String)"$errorHandler");
            Intrinsics.checkNotNullParameter((Object)$parent, (String)"$parent");
            Intrinsics.checkNotNull((Object)$userRegistry);
            return new PhmVcsLogStorageBackend($indexStorageId, $storage, $roots, $userRegistry, $errorHandler, $useDurableEnumerator, $parent);
        }

        private static final void create$lambda$1(StorageId.Directory $indexStorageId) {
            Intrinsics.checkNotNullParameter((Object)$indexStorageId, (String)"$indexStorageId");
            if (!$indexStorageId.cleanupAllStorageFiles()) {
                LOG.error("Could not clean up storage files in " + $indexStorageId.getStoragePath());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

