/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collection;
import java.util.function.IntConsumer;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFullDetailsIndex<T, D>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogFullDetailsIndex.class);
    @NotNull
    private final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    protected final StorageId.Directory myStorageId;
    @NotNull
    protected final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, D> myIndexer;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    private volatile boolean myDisposed;

    public VcsLogFullDetailsIndex(@NotNull StorageId.Directory storageId, @NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, @Nullable StorageLockContext storageLockContext, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(0);
        }
        if (name == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(1);
        }
        if (indexer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(2);
        }
        if (externalizer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(3);
        }
        if (errorHandler2 == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(5);
        }
        this.myDisposed = false;
        this.myName = name;
        this.myStorageId = storageId;
        this.myIndexer = indexer;
        this.myErrorHandler = errorHandler2;
        this.myMapReduceIndex = this.createMapReduceIndex(externalizer, storageLockContext);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private MyMapReduceIndex createMapReduceIndex(@NotNull DataExternalizer<T> dataExternalizer, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (dataExternalizer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(6);
        }
        MyIndexExtension<T, D> extension = new MyIndexExtension<T, D>(this.myName, this.myIndexer, dataExternalizer, this.myStorageId.getVersion());
        Pair<ForwardIndex, ForwardIndexAccessor<Integer, T>> pair = this.createdForwardIndex(storageLockContext);
        ForwardIndex forwardIndex = pair != null ? (ForwardIndex)pair.getFirst() : null;
        ForwardIndexAccessor forwardIndexAccessor = pair != null ? (ForwardIndexAccessor)pair.getSecond() : null;
        PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(storageLockContext);
        MyMapReduceIndex myMapReduceIndex = new MyMapReduceIndex(extension, new MyMapIndexStorage<T>(this.myName, this.myStorageId, dataExternalizer), forwardIndex, forwardIndexAccessor);
        MyMapReduceIndex myMapReduceIndex2 = myMapReduceIndex;
        if (myMapReduceIndex2 == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(7);
        }
        return myMapReduceIndex2;
        finally {
            PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
        }
    }

    @Nullable
    protected Pair<ForwardIndex, ForwardIndexAccessor<Integer, T>> createdForwardIndex(@Nullable StorageLockContext storageLockContext) throws IOException {
        return null;
    }

    public boolean isEmpty() throws IOException {
        return ((MyMapIndexStorage)this.myMapReduceIndex.getStorage()).isEmpty();
    }

    @NotNull
    public IntSet getCommitsWithAnyKey(@NotNull IntSet keys) throws StorageException {
        if (keys == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(8);
        }
        this.checkDisposed();
        IntOpenHashSet result2 = new IntOpenHashSet();
        IntIterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key2 = iterator.nextInt();
            this.iterateCommitIds(key2, arg_0 -> ((IntSet)result2).add(arg_0));
        }
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(9);
        }
        return intOpenHashSet;
    }

    @NotNull
    public IntSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        if (keys == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(10);
        }
        this.checkDisposed();
        IntSet intSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, null, null);
        if (intSet == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(11);
        }
        return intSet;
    }

    private void iterateCommitIds(int key2, @NotNull IntConsumer consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(12);
        }
        ValueContainer data2 = this.myMapReduceIndex.getData(key2);
        data2.forEach((id, value2) -> {
            consumer.accept(id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key2, @NotNull ObjIntConsumer<? super T> consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(13);
        }
        this.myMapReduceIndex.getData(key2).forEach((id, value2) -> {
            consumer.accept(value2, id);
            return true;
        });
    }

    @Nullable
    protected Collection<Integer> getKeysForCommit(int commit2) throws IOException {
        ForwardIndex forwardIndex = this.myMapReduceIndex.getForwardIndex();
        KeyCollectionForwardIndexAccessor forwardIndexAccessor = (KeyCollectionForwardIndexAccessor)this.myMapReduceIndex.getForwardIndexAccessor();
        if (forwardIndex == null || forwardIndexAccessor == null) {
            return null;
        }
        return (Collection)forwardIndexAccessor.deserializeData(forwardIndex.get(Integer.valueOf(commit2)));
    }

    public void update(int commitId2, @NotNull D details) {
        if (details == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(14);
        }
        this.checkDisposed();
        this.myMapReduceIndex.mapInputAndPrepareUpdate(commitId2, details).compute();
    }

    public void clearCaches() {
        this.myMapReduceIndex.clearCaches();
    }

    public void flush() throws StorageException, IOException {
        this.checkDisposed();
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myMapReduceIndex.dispose();
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExternalizer";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapReduceIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsWithAnyKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsWithAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMapReduceIndex";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsWithAnyKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsWithAllKeys";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommitIds";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommitIdsAndValues";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 9, 11 -> new IllegalStateException(string2);
        };
    }

    private final class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, D> {
        private MyMapReduceIndex(@NotNull MyIndexExtension<T, D> extension, @Nullable IndexStorage<Integer, T> storage, @Nullable ForwardIndex forwardIndex, ForwardIndexAccessor<Integer, T> forwardIndexAccessor) throws IOException {
            if (extension == null) {
                MyMapReduceIndex.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                MyMapReduceIndex.$$$reportNull$$$0(1);
            }
            super(extension, storage, forwardIndex, forwardIndexAccessor);
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Throwable ex) {
            if (ex == null) {
                MyMapReduceIndex.$$$reportNull$$$0(2);
            }
            VcsLogFullDetailsIndex.this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, ex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestRebuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyIndexExtension<T, D>
    extends IndexExtension<Integer, T, D> {
        @NotNull
        private final IndexId<Integer, T> myID;
        @NotNull
        private final DataIndexer<Integer, T, D> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        MyIndexExtension(@NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, int version) {
            if (name == null) {
                MyIndexExtension.$$$reportNull$$$0(0);
            }
            if (indexer == null) {
                MyIndexExtension.$$$reportNull$$$0(1);
            }
            if (externalizer == null) {
                MyIndexExtension.$$$reportNull$$$0(2);
            }
            this.myID = IndexId.create((String)name);
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public IndexId<Integer, T> getName() {
            IndexId<Integer, T> indexId = this.myID;
            if (indexId == null) {
                MyIndexExtension.$$$reportNull$$$0(3);
            }
            return indexId;
        }

        @NotNull
        public DataIndexer<Integer, T, D> getIndexer() {
            DataIndexer<Integer, T, D> dataIndexer = this.myIndexer;
            if (dataIndexer == null) {
                MyIndexExtension.$$$reportNull$$$0(4);
            }
            return dataIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
            if (enumeratorIntegerDescriptor == null) {
                MyIndexExtension.$$$reportNull$$$0(5);
            }
            return enumeratorIntegerDescriptor;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            DataExternalizer<T> dataExternalizer = this.myExternalizer;
            if (dataExternalizer == null) {
                MyIndexExtension.$$$reportNull$$$0(6);
            }
            return dataExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalizer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyDescriptor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        @NotNull
        private final String myName;

        MyMapIndexStorage(@NotNull String name, @NotNull StorageId.Directory storageId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            if (name == null) {
                MyMapIndexStorage.$$$reportNull$$$0(0);
            }
            if (storageId == null) {
                MyMapIndexStorage.$$$reportNull$$$0(1);
            }
            if (externalizer == null) {
                MyMapIndexStorage.$$$reportNull$$$0(2);
            }
            super(storageId.getStorageFile(name, true), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 500, false);
            this.myName = name;
        }

        boolean isEmpty() throws IOException {
            Ref isEmpty = new Ref((Object)true);
            this.doProcessKeys(key2 -> {
                isEmpty.set((Object)false);
                return false;
            });
            return (Boolean)isEmpty.get();
        }

        public void clear() throws StorageException {
            LOG.warn("Clearing '" + this.myName + "' map index storage", (Throwable)new RuntimeException());
            super.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storageId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "externalizer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapIndexStorage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

