/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void, VcsShortCommitDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    @NonNls
    private static final String USERS = "users";
    @NonNls
    private static final String USERS_IDS = "users-ids";
    @NotNull
    private final UserIndexer myUserIndexer;

    VcsLogUserIndex(@NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsUserRegistry userRegistry, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(0);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(1);
        }
        if (errorHandler2 == null) {
            VcsLogUserIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogUserIndex.$$$reportNull$$$0(3);
        }
        super(storageId, USERS, new UserIndexer(VcsLogUserIndex.createUserEnumerator(storageId, storageLockContext, userRegistry)), VoidDataExternalizer.INSTANCE, storageLockContext, errorHandler2, disposableParent);
        this.myUserIndexer = (UserIndexer)this.myIndexer;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer(e -> errorHandler2.handleError(VcsLogErrorHandler.Source.Index, (Throwable)e));
    }

    @Override
    @NotNull
    protected Pair<ForwardIndex, ForwardIndexAccessor<Integer, Void>> createdForwardIndex(@Nullable StorageLockContext storageLockContext) throws IOException {
        return new Pair((Object)new PersistentMapBasedForwardIndex(this.myStorageId.getStorageFile(this.myName + ".idx"), true, false, storageLockContext), (Object)new KeyCollectionForwardIndexAccessor((DataExternalizer)new IntCollectionDataExternalizer()));
    }

    @NotNull
    private static PersistentEnumerator<VcsUser> createUserEnumerator(@NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsUserRegistry userRegistry) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(4);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(5);
        }
        Path storageFile = storageId.getStorageFile(USERS_IDS);
        return new PersistentEnumerator(storageFile, (KeyDescriptor)new VcsUserKeyDescriptor(userRegistry), AbstractStorage.PAGE_SIZE, storageLockContext, storageId.getVersion());
    }

    @NotNull
    IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) throws IOException, StorageException {
        if (users == null) {
            VcsLogUserIndex.$$$reportNull$$$0(6);
        }
        IntOpenHashSet ids2 = new IntOpenHashSet();
        for (VcsUser vcsUser : users) {
            ids2.add(this.myUserIndexer.getUserId(vcsUser));
        }
        IntSet intSet = this.getCommitsWithAnyKey((IntSet)ids2);
        if (intSet == null) {
            VcsLogUserIndex.$$$reportNull$$$0(7);
        }
        return intSet;
    }

    @Nullable
    VcsUser getAuthorForCommit(int commitId2) {
        try {
            Collection<Integer> userIds = this.getKeysForCommit(commitId2);
            if (userIds == null || userIds.isEmpty()) {
                return null;
            }
            LOG.assertTrue(userIds.size() == 1);
            return this.myUserIndexer.getUserById(Objects.requireNonNull((Integer)ContainerUtil.getFirstItem(userIds)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    int getUserId(@NotNull VcsUser user) {
        if (user == null) {
            VcsLogUserIndex.$$$reportNull$$$0(8);
        }
        try {
            return this.myUserIndexer.getUserId(user);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    VcsUser getUserById(int id) {
        try {
            return this.myUserIndexer.getUserById(id);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flush() throws StorageException, IOException {
        super.flush();
        this.myUserIndexer.flush();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myUserIndexer.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = USERS;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsForUsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUserEnumerator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsForUsers";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserId";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    private static final class UserIndexer
    implements DataIndexer<Integer, Void, VcsShortCommitDetails> {
        @NotNull
        private final PersistentEnumerator<VcsUser> myUserEnumerator;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer;

        UserIndexer(@NotNull PersistentEnumerator<VcsUser> userEnumerator) {
            if (userEnumerator == null) {
                UserIndexer.$$$reportNull$$$0(0);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myUserEnumerator = userEnumerator;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsShortCommitDetails inputData) {
            if (inputData == null) {
                UserIndexer.$$$reportNull$$$0(1);
            }
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
            try {
                result2.put(this.myUserEnumerator.enumerate((Object)inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.accept(e);
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = result2;
            if (int2ObjectOpenHashMap == null) {
                UserIndexer.$$$reportNull$$$0(2);
            }
            return int2ObjectOpenHashMap;
        }

        @Nullable
        public VcsUser getUserById(int id) throws IOException {
            return (VcsUser)this.myUserEnumerator.valueOf(id);
        }

        public int getUserId(@NotNull VcsUser user) throws IOException {
            if (user == null) {
                UserIndexer.$$$reportNull$$$0(3);
            }
            return this.myUserEnumerator.enumerate((Object)user);
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                UserIndexer.$$$reportNull$$$0(4);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        public void flush() {
            this.myUserEnumerator.force();
        }

        public void close() throws IOException {
            this.myUserEnumerator.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userEnumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserId";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

