/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChainBackedDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.actions.history.CompareRevisionsFromFileHistoryActionProvider;
import com.intellij.vcs.log.ui.frame.EditorDiffPreview;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryEditorDiffPreview;", "Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChainBackedDiffPreviewProvider;", "project", "Lcom/intellij/openapi/project/Project;", "fileHistoryPanel", "Lcom/intellij/vcs/log/history/FileHistoryPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/history/FileHistoryPanel;)V", "createDiffRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "getOwnerComponent", "Ljavax/swing/JComponent;", "performDiffAction", "", "updateDiffAction", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryDiffPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryDiffPreview.kt\ncom/intellij/vcs/log/history/FileHistoryEditorDiffPreview\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class FileHistoryEditorDiffPreview
extends EditorDiffPreview
implements ChainBackedDiffPreviewProvider {
    @NotNull
    private final FileHistoryPanel fileHistoryPanel;

    public FileHistoryEditorDiffPreview(@NotNull Project project2, @NotNull FileHistoryPanel fileHistoryPanel) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileHistoryPanel, (String)"fileHistoryPanel");
        super(project2, fileHistoryPanel);
        this.fileHistoryPanel = fileHistoryPanel;
    }

    @Override
    @NotNull
    public JComponent getOwnerComponent() {
        VcsLogGraphTable vcsLogGraphTable = this.fileHistoryPanel.getGraphTable();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"getGraphTable(...)");
        return (JComponent)((Object)vcsLogGraphTable);
    }

    @Override
    @NotNull
    public String getEditorTabName(@Nullable DiffRequestProcessor processor2) {
        Object[] objectArray = new Object[]{this.fileHistoryPanel.getFilePath().getName()};
        String string2 = VcsLogBundle.message("file.history.diff.preview.editor.tab.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @Override
    @NotNull
    public DiffRequestProcessor createDiffRequestProcessor() {
        FileHistoryDiffProcessor fileHistoryDiffProcessor = this.fileHistoryPanel.createDiffPreview(true);
        Intrinsics.checkNotNullExpressionValue((Object)fileHistoryDiffProcessor, (String)"createDiffPreview(...)");
        FileHistoryDiffProcessor preview = fileHistoryDiffProcessor;
        preview.updatePreview(true);
        return (DiffRequestProcessor)preview;
    }

    @Override
    @Nullable
    public DiffRequestChain createDiffRequestChain() {
        Change change = this.fileHistoryPanel.getSelectedChange();
        if (change == null) {
            return null;
        }
        Change change2 = change;
        ChangeDiffRequestProducer changeDiffRequestProducer = ChangeDiffRequestProducer.create(this.getProject(), change2);
        if (changeDiffRequestProducer == null) {
            return null;
        }
        ChangeDiffRequestProducer producer = changeDiffRequestProducer;
        return (DiffRequestChain)SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer);
    }

    @Override
    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)event.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (vcsLogCommitSelection == null) {
            return;
        }
        VcsLogCommitSelection selection = vcsLogCommitSelection;
        CompareRevisionsFromFileHistoryActionProvider.setTextAndDescription(event, selection);
    }

    @Override
    public boolean performDiffAction() {
        Change change;
        if (ExternalDiffTool.isEnabled() && (change = this.fileHistoryPanel.getSelectedChange()) != null) {
            ListSelection diffProducers;
            ChangeDiffRequestProducer changeDiffRequestProducer = ChangeDiffRequestProducer.create(this.getProject(), change);
            if (changeDiffRequestProducer != null) {
                ChangeDiffRequestProducer it = changeDiffRequestProducer;
                boolean bl = false;
                v0 = ListSelection.createSingleton((Object)it);
            } else {
                v0 = diffProducers = null;
            }
            if (EditorTabPreviewBase.Companion.showExternalToolIfNeeded(this.getProject(), (ListSelection<? extends DiffRequestProducer>)diffProducers)) {
                return true;
            }
        }
        return super.performDiffAction();
    }
}

