/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpanAttribute;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogCommitDataCache;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.CommitMetadataWithPath;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryFiltererKt;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.history.FileHistorySpeedSearch;
import com.intellij.vcs.log.history.FileHistoryTask;
import com.intellij.vcs.log.history.Rename;
import com.intellij.vcs.log.history.VcsLogFileHistoryFilter;
import com.intellij.vcs.log.statistics.VcsLogRepoSizeCollector;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.SemanticAttributes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0002;<B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eH\u0002J2\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\"H\u0016J<\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u0002082\u0006\u0010\u001f\u001a\u00020 2\u0006\u00109\u001a\u000203H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010+2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\r\u001aJ\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u0011 \u0010*#\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u0012\u00a2\u0006\u0002\b\f0\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006="}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logId", "", "(Lcom/intellij/vcs/log/data/VcsLogData;Ljava/lang/String;)V", "fileHistoryTask", "Lcom/intellij/vcs/log/history/FileHistoryTask;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "Lorg/jetbrains/annotations/NotNull;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/vcs/log/VcsLogProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "vcsLogFilterer", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "vcsLogObjectsFactory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getVcsLogObjectsFactory", "()Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "canFilterEmptyPack", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "cancelLastTask", "", "wait", "createFileHistoryTask", "historyHandler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "root", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "isInitial", "createProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "getHash", "Companion", "MyWorker", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,410:1\n31#2,2:411\n1#3:413\n11#4:414\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer\n*L\n51#1:411,2\n311#1:414\n*E\n"})
public final class FileHistoryFilterer
implements VcsLogFilterer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final String logId;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsLogIndex index;
    @NotNull
    private final VcsLogFiltererImpl vcsLogFilterer;
    @Nullable
    private FileHistoryTask fileHistoryTask;
    @NotNull
    private static final Logger LOG;

    public FileHistoryFilterer(@NotNull VcsLogData logData, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        this.logData = logData;
        this.logId = logId;
        Project project2 = this.logData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
        Map<VirtualFile, VcsLogProvider> map2 = this.logData.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getLogProviders(...)");
        this.logProviders = map2;
        VcsLogStorage vcsLogStorage = this.logData.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
        this.storage = vcsLogStorage;
        VcsLogIndex vcsLogIndex = this.logData.getIndex();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"getIndex(...)");
        this.index = vcsLogIndex;
        TopCommitsCache topCommitsCache = this.logData.getTopCommitsCache();
        Intrinsics.checkNotNullExpressionValue((Object)topCommitsCache, (String)"getTopCommitsCache(...)");
        VcsLogCommitDataCache<VcsFullCommitDetails> vcsLogCommitDataCache = this.logData.getFullCommitDetailsCache();
        Intrinsics.checkNotNullExpressionValue(vcsLogCommitDataCache, (String)"<get-fullCommitDetailsCache>(...)");
        this.vcsLogFilterer = new VcsLogFiltererImpl(this.logProviders, this.storage, topCommitsCache, vcsLogCommitDataCache, this.index);
    }

    private final VcsLogObjectsFactory getVcsLogObjectsFactory() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsLogObjectsFactory> serviceClass$iv = VcsLogObjectsFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VcsLogObjectsFactory)object;
    }

    @Override
    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        VcsLogFileHistoryHandler fileHistoryHandler;
        VcsLogProvider logProvider;
        VirtualFile virtualFile;
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
        Intrinsics.checkNotNullParameter((Object)((Object)sortType), (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
        FilePath filePath2 = filePath = Companion.getFilePath(filters);
        if (filePath2 != null) {
            FilePath it = filePath2;
            boolean bl = false;
            virtualFile = VcsLogUtil.getActualRoot(this.project, filePath);
        } else {
            virtualFile = null;
        }
        VirtualFile root = virtualFile;
        Hash hash2 = this.getHash(filters);
        VcsLogProvider vcsLogProvider = logProvider = this.logProviders.get(root);
        VcsLogFileHistoryHandler vcsLogFileHistoryHandler = fileHistoryHandler = vcsLogProvider != null ? vcsLogProvider.getFileHistoryHandler(this.project) : null;
        if (root != null && !filePath.isDirectory() && fileHistoryHandler != null) {
            VcsKey vcsKey = logProvider.getSupportedVcs();
            Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getSupportedVcs(...)");
            return new MyWorker(vcsKey, fileHistoryHandler, root, filePath, hash2).filter(dataPack, oldVisiblePack, sortType, filters, commitCount);
        }
        return this.vcsLogFilterer.filter(dataPack, oldVisiblePack, sortType, filters, commitCount);
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return true;
    }

    private final void cancelLastTask(boolean wait) {
        FileHistoryTask fileHistoryTask = this.fileHistoryTask;
        if (fileHistoryTask != null) {
            fileHistoryTask.cancel(wait);
        }
        this.fileHistoryTask = null;
    }

    private final FileHistoryTask createFileHistoryTask(VcsLogFileHistoryHandler historyHandler, VirtualFile root, FilePath filePath, Hash hash2, boolean isInitial) {
        FileHistoryTask newHistoryTask;
        FileHistoryTask oldHistoryTask = this.fileHistoryTask;
        if (oldHistoryTask != null && !oldHistoryTask.isCancelled() && !isInitial && Intrinsics.areEqual((Object)oldHistoryTask.getFilePath(), (Object)filePath) && Intrinsics.areEqual((Object)oldHistoryTask.getHash(), (Object)hash2)) {
            return oldHistoryTask;
        }
        this.cancelLastTask(false);
        this.fileHistoryTask = newHistoryTask = new FileHistoryTask(this.project, historyHandler, this.storage, this.getVcsLogObjectsFactory(), root, filePath, hash2, this.createProgressIndicator());
        return newHistoryTask;
    }

    private final ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = this.logData.getProgress().createProgressIndicator(new VcsLogProgress.ProgressKey("file history task for " + this.logId));
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"createProgressIndicator(...)");
        return progressIndicator;
    }

    public void dispose() {
        this.cancelLastTask(true);
    }

    private final Hash getHash(VcsLogFilterCollection filters) {
        VcsLogFileHistoryFilter fileHistoryFilter;
        VcsLogStructureFilter vcsLogStructureFilter = FileHistoryFilterer.Companion.getStructureFilter(filters);
        VcsLogFileHistoryFilter vcsLogFileHistoryFilter = fileHistoryFilter = vcsLogStructureFilter instanceof VcsLogFileHistoryFilter ? (VcsLogFileHistoryFilter)vcsLogStructureFilter : null;
        if (fileHistoryFilter != null) {
            return fileHistoryFilter.getHash();
        }
        VcsLogRevisionFilter revisionFilter = filters.get(VcsLogFilterCollection.REVISION_FILTER);
        Object object = revisionFilter;
        return object != null && (object = object.getHeads()) != null && (object = (CommitId)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? ((CommitId)object).getHash() : null;
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection createFilters(@NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
        return Companion.createFilters(path2, revision, root, showAllBranches);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileHistoryFilterer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J>\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0017H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0006J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "revision", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showAllBranches", "", "createVisibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "matchingHeads", "", "matchingCommits", "getFilePath", "filters", "getStructureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final VcsLogStructureFilter getStructureFilter(VcsLogFilterCollection filters) {
            List<VcsLogDetailsFilter> list2 = filters.getDetailsFilters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getDetailsFilters(...)");
            Object object = CollectionsKt.singleOrNull(list2);
            return object instanceof VcsLogStructureFilter ? (VcsLogStructureFilter)object : null;
        }

        @Nullable
        public final FilePath getFilePath(@NotNull VcsLogFilterCollection filters) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            VcsLogStructureFilter vcsLogStructureFilter = this.getStructureFilter(filters);
            if (vcsLogStructureFilter == null) {
                return null;
            }
            VcsLogStructureFilter filter2 = vcsLogStructureFilter;
            Collection<FilePath> collection = filter2.getFiles();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getFiles(...)");
            return (FilePath)CollectionsKt.singleOrNull((Iterable)collection);
        }

        @JvmStatic
        @NotNull
        public final VcsLogFilterCollection createFilters(@NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            VcsLogFileHistoryFilter fileFilter = new VcsLogFileHistoryFilter(path2, revision);
            VcsLogBranchLikeFilter revisionFilter = showAllBranches ? null : (revision != null ? (VcsLogBranchLikeFilter)VcsLogFilterObject.fromCommit(new CommitId(revision, root)) : (VcsLogBranchLikeFilter)VcsLogFilterObject.fromBranch("HEAD"));
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{fileFilter, revisionFilter};
            return VcsLogFilterObject.collection(vcsLogFilterArray);
        }

        private final VisibleGraph<Integer> createVisibleGraph(DataPack dataPack, PermanentGraph.SortType sortType, Set<Integer> matchingHeads, Set<Integer> matchingCommits) {
            if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || VcsLogFiltererImplKt.matchesNothing((Collection)matchingCommits)) {
                VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
                Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"getInstance(...)");
                return visibleGraph;
            }
            VisibleGraph<Integer> visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, matchingCommits);
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"createVisibleGraph(...)");
            return visibleGraph;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\"\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J:\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dJJ\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010(\u001a\u00020\u001aH\u0002J8\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u000eH\u0002J(\u0010*\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020-0,2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010/\u001a\u00020\u0010H\u0002J\u001c\u00100\u001a\b\u0012\u0004\u0012\u000202012\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker;", "", "vcsKey", "Lcom/intellij/openapi/vcs/VcsKey;", "fileHistoryHandler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/history/FileHistoryFilterer;Lcom/intellij/openapi/vcs/VcsKey;Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;)V", "checkNotEmpty", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "withIndex", "collectRenamesFromProvider", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "", "Lcom/intellij/vcs/log/history/Rename;", "fileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "commitCount", "filterWithIndex", "indexDataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "oldRenames", "oldFileHistory", "isInitial", "filterWithVcs", "getFilteredRefs", "", "Lcom/intellij/vcs/log/data/CompressedRefs;", "getHead", "pack", "toCommitMetadata", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "revisions", "", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nFileHistoryFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,410:1\n30#2:411\n129#2,2:412\n31#2,2:414\n146#2:416\n132#2,12:417\n30#2:450\n129#2,2:451\n31#2,2:453\n146#2:474\n132#2,12:475\n1549#3:429\n1620#3,3:430\n1179#3,2:433\n1253#3,4:435\n1549#3:439\n1620#3,3:440\n1179#3,2:443\n1253#3,4:445\n1603#3,9:455\n1855#3:464\n1856#3:466\n1612#3:467\n1549#3:468\n1620#3,3:469\n1855#3,2:472\n1#4:449\n1#4:465\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker\n*L\n114#1:411\n114#1:412,2\n114#1:414,2\n114#1:416\n114#1:417,12\n275#1:450\n275#1:451,2\n275#1:453,2\n275#1:474\n275#1:475,12\n174#1:429\n174#1:430,3\n186#1:433,2\n186#1:435,4\n195#1:439\n195#1:440,3\n202#1:443,2\n202#1:445,4\n276#1:455,9\n276#1:464\n276#1:466\n276#1:467\n281#1:468\n281#1:469,3\n290#1:472,2\n276#1:465\n*E\n"})
    private final class MyWorker {
        @NotNull
        private final VcsKey vcsKey;
        @NotNull
        private final VcsLogFileHistoryHandler fileHistoryHandler;
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final FilePath filePath;
        @Nullable
        private final Hash hash;

        public MyWorker(@NotNull VcsKey vcsKey, @NotNull VcsLogFileHistoryHandler fileHistoryHandler, @NotNull VirtualFile root, @Nullable FilePath filePath, Hash hash2) {
            Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
            Intrinsics.checkNotNullParameter((Object)fileHistoryHandler, (String)"fileHistoryHandler");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.vcsKey = vcsKey;
            this.fileHistoryHandler = fileHistoryHandler;
            this.root = root;
            this.filePath = filePath;
            this.hash = hash2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
            void $this$use$iv;
            Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
            Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
            Intrinsics.checkNotNullParameter((Object)((Object)sortType), (String)"sortType");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
            long start2 = System.currentTimeMillis();
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogHistory.Computing.getName());
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder spanBuilder2 = spanBuilder;
            FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
            boolean $i$f$use = false;
            Span span = $this$use$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan()");
            Span $this$useWithoutActiveScope$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                Pair pair;
                VisiblePack visiblePack;
                Span scope2;
                Throwable throwable;
                AutoCloseable autoCloseable;
                block17: {
                    Span span$iv = $this$useWithoutActiveScope$iv$iv;
                    boolean bl = false;
                    autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                    throwable = null;
                    Scope it$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    scope2 = span$iv;
                    boolean bl3 = false;
                    boolean isInitial = Intrinsics.areEqual((Object)commitCount, (Object)CommitCountStage.INITIAL);
                    scope2.setAttribute("filePath", this.filePath.toString());
                    scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getFILE_HISTORY_IS_INITIAL().getKey(), isInitial);
                    scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getVCS_NAME().getKey(), VcsLogRepoSizeCollector.getVcsKeySafe(this.vcsKey));
                    IndexDataGetter indexDataGetter = fileHistoryFilterer.index.getDataGetter();
                    if (indexDataGetter == null || !fileHistoryFilterer.index.isIndexed(this.root) || !dataPack.isFull() || !Registry.is((String)"vcs.history.use.index")) break block17;
                    fileHistoryFilterer.cancelLastTask(false);
                    visiblePack = this.filterWithIndex(indexDataGetter, dataPack, oldVisiblePack, sortType, filters, isInitial);
                    LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with index");
                    scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getFILE_HISTORY_TYPE().getKey(), "index");
                    scope2.setAttribute("commitCount", String.valueOf(visiblePack.getVisibleGraph().getVisibleCommitCount()));
                    if (!this.checkNotEmpty(dataPack, visiblePack, true)) break block17;
                    Pair pair2 = new Pair((Object)visiblePack, (Object)commitCount);
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    Pair pair3 = pair2;
                    return pair3;
                }
                try {
                    visiblePack = this.filterWithVcs(dataPack, sortType, filters, commitCount);
                    scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getFILE_HISTORY_TYPE().getKey(), "history provider");
                    scope2.setAttribute("commitCount", String.valueOf(visiblePack.getVisibleGraph().getVisibleCommitCount()));
                    LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with history handler " + this.fileHistoryHandler.getClass().getName());
                    this.checkNotEmpty(dataPack, visiblePack, false);
                    pair = new Pair((Object)visiblePack, (Object)commitCount);
                }
                catch (VcsException e) {
                    Pair pair4 = new Pair((Object)new VisiblePack.ErrorVisiblePack(dataPack, filters, e), (Object)commitCount);
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    Pair pair5 = pair4;
                    $this$useWithoutActiveScope$iv$iv.end();
                    return pair5;
                    {
                        catch (Throwable throwable2) {
                            try {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                                    throw throwable3;
                                }
                            }
                            catch (CancellationException e$iv$iv) {
                                $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
                                throw e$iv$iv;
                            }
                            catch (ProcessCanceledException e$iv$iv) {
                                $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
                                throw e$iv$iv;
                            }
                            catch (Throwable e$iv$iv) {
                                $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
                                $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                                throw e$iv$iv;
                            }
                        }
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                Pair pair6 = pair;
                return pair6;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv.end();
            }
        }

        private final boolean checkNotEmpty(DataPack dataPack, VisiblePack visiblePack, boolean withIndex) {
            if (!dataPack.isFull()) {
                LOG.debug("Data pack is not full while computing file history for " + this.filePath + "\nFound " + visiblePack.getVisibleGraph().getVisibleCommitCount() + " commits");
                return true;
            }
            if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                LOG.warn("Empty file history from " + (withIndex ? "index" : "provider") + " for " + this.filePath);
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final VisiblePack filterWithVcs(DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters, CommitCountStage commitCount) throws VcsException {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            Pair pair;
            Object object;
            Object object2;
            boolean isFastStart;
            boolean bl = isFastStart = Intrinsics.areEqual((Object)commitCount, (Object)CommitCountStage.INITIAL) && this.fileHistoryHandler.isFastStartSupported();
            if (isFastStart) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                FileHistoryFilterer.this.cancelLastTask(false);
                Iterable iterable = this.fileHistoryHandler.getHistoryFast(this.root, this.filePath, this.hash, commitCount.getCount());
                FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                object2 = $this$mapTo$iv$iv2.iterator();
                while (object2.hasNext()) {
                    void it;
                    Object item$iv$iv = object2.next();
                    VcsFileRevisionEx vcsFileRevisionEx = (VcsFileRevisionEx)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    object.add(FileHistoryFiltererKt.access$createCommitMetadataWithPath(fileHistoryFilterer.getVcsLogObjectsFactory(), fileHistoryFilterer.storage, (VcsFileRevisionEx)it, this.root));
                }
                pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)false);
            } else {
                pair = FileHistoryFilterer.this.createFileHistoryTask(this.fileHistoryHandler, this.root, this.filePath, this.hash, Intrinsics.areEqual((Object)commitCount, (Object)CommitCountStage.FIRST_STEP)).waitForRevisions(100L);
            }
            Pair pair2 = pair;
            List revisions = (List)pair2.component1();
            boolean isDone = (Boolean)pair2.component2();
            if (revisions.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"EMPTY");
                return visiblePack;
            }
            if (dataPack.isFull() && !isFastStart) {
                void $this$associateTo$iv$iv2;
                Iterable $this$associate$iv2 = revisions;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                object2 = $this$associate$iv2;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                    Map map2 = destination$iv$iv;
                    CommitMetadataWithPath it = (CommitMetadataWithPath)element$iv$iv;
                    boolean bl3 = false;
                    Pair pair3 = new Pair((Object)it.commit, (Object)it.path);
                    map2.put(pair3.getFirst(), pair3.getSecond());
                }
                Map pathMap = destination$iv$iv;
                VisibleGraph visibleGraph = Companion.createVisibleGraph(dataPack, sortType, null, pathMap.keySet());
                VisiblePack $this$filterWithVcs_u24lambda_u243 = $i$f$associate = FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph, !isDone, filters), new FileHistory(pathMap, null, null, null, 14, null));
                boolean bl4 = false;
                $this$filterWithVcs_u24lambda_u243.putUserData(FileHistorySpeedSearch.Companion.getCOMMIT_METADATA$intellij_platform_vcs_log_impl(), this.toCommitMetadata(revisions));
                return $i$f$associate;
            }
            Iterable $this$map$iv = revisions;
            boolean $i$f$map = false;
            Iterable $this$filterWithVcs_u24lambda_u243 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommitMetadataWithPath element$iv$iv = (CommitMetadataWithPath)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                object.add(GraphCommitImpl.createCommit(it.commit, CollectionsKt.emptyList(), it.metadata.getTimestamp()));
            }
            List commits2 = (List)destination$iv$iv;
            Map<VirtualFile, CompressedRefs> refs = this.getFilteredRefs(dataPack);
            DataPack dataPack2 = DataPack.build(commits2, refs, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.root, FileHistoryFilterer.this.logProviders.get(this.root))), FileHistoryFilterer.this.storage, false);
            Intrinsics.checkNotNullExpressionValue((Object)dataPack2, (String)"build(...)");
            DataPack fakeDataPack = dataPack2;
            VisibleGraph visibleGraph = Companion.createVisibleGraph(fakeDataPack, sortType, null, null);
            destination$iv$iv = revisions;
            VisiblePack visiblePack = new VisiblePack(fakeDataPack, visibleGraph, !isDone, filters);
            object = FileHistoryPaths.INSTANCE;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void item$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv2;
                CommitMetadataWithPath it = (CommitMetadataWithPath)element$iv$iv;
                boolean bl6 = false;
                Pair pair4 = new Pair((Object)it.commit, (Object)it.path);
                map3.put(pair4.getFirst(), pair4.getSecond());
            }
            Map map4 = destination$iv$iv2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 14;
            MultiMap multiMap = null;
            Set set = null;
            Set set2 = null;
            Map map5 = map4;
            Object $this$filterWithVcs_u24lambda_u246 = object2 = ((FileHistoryPaths)object).withFileHistory(visiblePack, new FileHistory(map5, set2, set, multiMap, n, defaultConstructorMarker));
            boolean bl7 = false;
            ((VisiblePack)$this$filterWithVcs_u24lambda_u246).putUserData(VisiblePack.NO_GRAPH_INFORMATION, true);
            ((VisiblePack)$this$filterWithVcs_u24lambda_u246).putUserData(FileHistorySpeedSearch.Companion.getCOMMIT_METADATA$intellij_platform_vcs_log_impl(), this.toCommitMetadata(revisions));
            return object2;
        }

        private final Int2ObjectMap<VcsCommitMetadata> toCommitMetadata(List<CommitMetadataWithPath> revisions) {
            if (revisions.isEmpty()) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap(revisions.size());
            for (CommitMetadataWithPath revision : revisions) {
                result2.put(revision.commit, (Object)revision.metadata);
            }
            return (Int2ObjectMap)result2;
        }

        private final Map<VirtualFile, CompressedRefs> getFilteredRefs(DataPack dataPack) {
            CompressedRefs compressedRefs = dataPack.getRefsModel().getAllRefsByRoot().get(this.root);
            if (compressedRefs == null) {
                compressedRefs = new CompressedRefs(SetsKt.emptySet(), FileHistoryFilterer.this.storage);
            }
            CompressedRefs compressedRefs2 = compressedRefs;
            return MapsKt.mapOf((Pair)new Pair((Object)this.root, (Object)compressedRefs2));
        }

        private final VisiblePack filterWithIndex(IndexDataGetter indexDataGetter, DataPack dataPack, VisiblePack oldVisiblePack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters, boolean isInitial) {
            FileHistory oldFileHistory = FileHistoryPaths.INSTANCE.getFileHistory(oldVisiblePack);
            if (isInitial) {
                return this.filterWithIndex(indexDataGetter, dataPack, filters, sortType, oldFileHistory.getCommitToRename$intellij_platform_vcs_log_impl(), new FileHistory(MapsKt.emptyMap(), oldFileHistory.getProcessedAdditionsDeletions$intellij_platform_vcs_log_impl(), null, null, 12, null));
            }
            MultiMap<UnorderedPair<Integer>, Rename> renames2 = this.collectRenamesFromProvider(oldFileHistory);
            return this.filterWithIndex(indexDataGetter, dataPack, filters, sortType, (MultiMap<UnorderedPair<Integer>, Rename>)FileHistoryFiltererKt.access$union(renames2, oldFileHistory.getCommitToRename$intellij_platform_vcs_log_impl()), oldFileHistory);
        }

        private final VisiblePack filterWithIndex(IndexDataGetter indexDataGetter, DataPack dataPack, VcsLogFilterCollection filters, PermanentGraph.SortType sortType, MultiMap<UnorderedPair<Integer>, Rename> oldRenames, FileHistory oldFileHistory) {
            Integer n;
            VcsLogFiltererImpl vcsLogFiltererImpl = FileHistoryFilterer.this.vcsLogFilterer;
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
            Set<Integer> matchingHeads = vcsLogFiltererImpl.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)SetsKt.setOf((Object)this.root), filters);
            FileHistoryData data2 = indexDataGetter.createFileHistoryData(this.filePath).build$intellij_platform_vcs_log_impl(oldRenames);
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getPermanentGraph(...)");
            PermanentGraph<Integer> permanentGraph2 = permanentGraph;
            if (!(permanentGraph2 instanceof PermanentGraphImpl)) {
                VisibleGraph visibleGraph = Companion.createVisibleGraph(dataPack, sortType, matchingHeads, (Set)data2.getCommits());
                FileHistory fileHistory = new FileHistory(data2.buildPathsMap(), null, null, null, 14, null);
                return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph, false, filters), fileHistory);
            }
            if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || data2.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"EMPTY");
                return visiblePack;
            }
            Hash hash2 = this.hash;
            if (hash2 == null) {
                hash2 = this.getHead(dataPack);
            }
            if (hash2 != null) {
                Hash hash3 = hash2;
                FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
                Hash it = hash3;
                boolean bl = false;
                n = fileHistoryFilterer.storage.getCommitIndex(it, this.root);
            } else {
                n = null;
            }
            Integer commit2 = n;
            FileHistoryBuilder historyBuilder = new FileHistoryBuilder(commit2, this.filePath, data2, oldFileHistory, null, FileHistoryBuilder.Companion.isRemoveTrivialMerges$intellij_platform_vcs_log_impl(), FileHistoryBuilder.Companion.isRefine$intellij_platform_vcs_log_impl(), 16, null);
            VisibleGraph<Integer> visibleGraph = ((PermanentGraphImpl)permanentGraph2).createVisibleGraph(sortType, matchingHeads, (Set)data2.getCommits(), historyBuilder);
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"createVisibleGraph(...)");
            VisibleGraph<Integer> visibleGraph2 = visibleGraph;
            FileHistory fileHistory = historyBuilder.getFileHistory();
            return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph2, !((Collection)fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl()).isEmpty(), filters), fileHistory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final MultiMap<UnorderedPair<Integer>, Rename> collectRenamesFromProvider(FileHistory fileHistory) {
            void $this$use$iv;
            if (fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl().isEmpty()) {
                MultiMap multiMap = MultiMap.empty();
                Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
                return multiMap;
            }
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogHistory.CollectingRenames.getName());
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder spanBuilder2 = spanBuilder;
            FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
            boolean $i$f$use = false;
            Span span = $this$use$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan()");
            Span $this$useWithoutActiveScope$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                MultiMap multiMap;
                Span span$iv = $this$useWithoutActiveScope$iv$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Scope it$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    Span span2 = span$iv;
                    boolean bl3 = false;
                    Iterable $this$mapNotNull$iv = fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object = $this$forEach$iv$iv$iv.iterator();
                    while (object.hasNext()) {
                        VcsLogFileHistoryHandler.Rename it$iv$iv;
                        Hash childHash;
                        Hash parentHash;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = object.next();
                        boolean bl4 = false;
                        AdditionDeletion ad = (AdditionDeletion)element$iv$iv;
                        boolean bl5 = false;
                        CommitId commitId2 = fileHistoryFilterer.storage.getCommitId(ad.getParent());
                        Intrinsics.checkNotNull((Object)commitId2);
                        Intrinsics.checkNotNullExpressionValue((Object)commitId2.getHash(), (String)"getHash(...)");
                        CommitId commitId3 = fileHistoryFilterer.storage.getCommitId(ad.getChild());
                        Intrinsics.checkNotNull((Object)commitId3);
                        Intrinsics.checkNotNullExpressionValue((Object)commitId3.getHash(), (String)"getHash(...)");
                        if ((ad.isAddition() ? this.fileHistoryHandler.getRename(this.root, ad.getFilePath(), parentHash, childHash) : this.fileHistoryHandler.getRename(this.root, ad.getFilePath(), childHash, parentHash)) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void r;
                        object = (VcsLogFileHistoryHandler.Rename)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl7 = false;
                        collection.add(new Rename(r.getFilePath1(), r.getFilePath2(), fileHistoryFilterer.storage.getCommitIndex(r.getHash1(), this.root), fileHistoryFilterer.storage.getCommitIndex(r.getHash2(), this.root)));
                    }
                    List renames2 = (List)destination$iv$iv;
                    span2.setAttribute("renamesSize", (long)renames2.size());
                    span2.setAttribute("numberOfAdditionDeletions", (long)fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl().size());
                    span2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getVCS_NAME().getKey(), VcsLogRepoSizeCollector.getVcsKeySafe(this.vcsKey));
                    MultiMap result2 = new MultiMap();
                    Iterable $this$forEach$iv = renames2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Rename rename = (Rename)element$iv;
                        boolean bl8 = false;
                        result2.putValue(rename.getCommits(), (Object)rename);
                    }
                    multiMap = result2;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                            throw throwable3;
                        }
                    }
                    catch (CancellationException e$iv$iv) {
                        $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
                        throw e$iv$iv;
                    }
                    catch (ProcessCanceledException e$iv$iv) {
                        $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
                        throw e$iv$iv;
                    }
                    catch (Throwable e$iv$iv) {
                        $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
                        $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                        throw e$iv$iv;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                MultiMap multiMap2 = multiMap;
                return multiMap2;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv.end();
            }
        }

        private final Hash getHead(DataPack pack) {
            RefsModel refsModel = pack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
            VcsRef vcsRef = DataPackUtilKt.findBranch(refsModel, "HEAD", this.root);
            return vcsRef != null ? vcsRef.getCommitHash() : null;
        }
    }
}

