/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryEditorDiffPreview;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.history.FileHistorySpeedSearch;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.ComponentQuickActionProvider;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    @NonNls
    private static final String HELP_ID = "reference.versionControl.toolwindow.history";
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FileHistoryModel myFileHistoryModel;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final FileHistorySpeedSearch mySpeedSearch;
    @NotNull
    private final CommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final JBSplitter myDetailsSplitter;
    @NotNull
    private final FileHistoryEditorDiffPreview myEditorDiffPreview;
    @NotNull
    private final History myHistory;

    public FileHistoryPanel(final @NotNull AbstractVcsLogUi logUi2, @NotNull FileHistoryModel fileHistoryModel, @NotNull VcsLogData logData, @NotNull FilePath filePath, @NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager, @NotNull Disposable disposable) {
        if (logUi2 == null) {
            FileHistoryPanel.$$$reportNull$$$0(0);
        }
        if (fileHistoryModel == null) {
            FileHistoryPanel.$$$reportNull$$$0(1);
        }
        if (logData == null) {
            FileHistoryPanel.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            FileHistoryPanel.$$$reportNull$$$0(3);
        }
        if (root == null) {
            FileHistoryPanel.$$$reportNull$$$0(4);
        }
        if (colorManager == null) {
            FileHistoryPanel.$$$reportNull$$$0(5);
        }
        if (disposable == null) {
            FileHistoryPanel.$$$reportNull$$$0(6);
        }
        this.myProject = logData.getProject();
        this.myFilePath = filePath;
        this.myRoot = root;
        this.myFileHistoryModel = fileHistoryModel;
        this.myProperties = logUi2.getProperties();
        this.myGraphTable = new VcsLogGraphTable(logUi2.getId(), logData, logUi2.getProperties(), colorManager, () -> logUi2.requestMore(EmptyRunnable.INSTANCE), disposable){

            @Override
            protected void updateEmptyText() {
                VisiblePack visiblePack = this.getModel().getVisiblePack();
                if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                    this.setErrorEmptyText(((VisiblePack.ErrorVisiblePack)visiblePack).getError(), VcsLogBundle.message("file.history.error.status", new Object[0]));
                    this.appendActionToEmptyText(VcsLogBundle.message("vcs.log.refresh.status.action", new Object[0]), () -> logUi2.getRefresher().onRefresh());
                } else {
                    this.getEmptyText().setText(VcsLogBundle.message("file.history.empty.status", new Object[0]));
                }
            }
        };
        this.myGraphTable.setBorder(this.myGraphTable.createTopBottomBorder(1, 0));
        this.mySpeedSearch = new FileHistorySpeedSearch(this.myProject, logData.getIndex(), logData.getStorage(), this.myGraphTable);
        this.mySpeedSearch.setupListeners();
        this.myDetailsPanel = new CommitDetailsListPanel(this.myProject, this, (Function0<CommitDetailsPanel>)((Function0)() -> new CommitDetailsPanel((Function1<? super CommitId, Unit>)((Function1)commit2 -> {
            VcsLogContentUtil.runInMainLog(this.myProject, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> VcsLogNavigationUtil.jumpToCommit(ui2, commit2.getHash(), commit2.getRoot(), false, true)));
            return Unit.INSTANCE;
        }))));
        VcsLogCommitSelectionListenerForDetails.install(this.myGraphTable, this.myDetailsPanel, this, VcsLogColorManagerFactory.create(Collections.singleton(this.myRoot)));
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.history.details.splitter.proportion", 0.7f);
        JComponent tableWithProgress = VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 0), logData, logUi2.getId(), this);
        this.myDetailsSplitter.setFirstComponent(tableWithProgress);
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(this.myProperties.get(CommonUiProperties.SHOW_DETAILS) != false ? this.myDetailsPanel : null)));
        this.myEditorDiffPreview = new FileHistoryEditorDiffPreview(this.myProject, this);
        final JComponent actionsToolbar = this.createActionsToolbar();
        actionsToolbar.setBorder(IdeBorderFactory.createBorder((int)4));
        JBPanel tablePanel = new JBPanel(new BorderLayout()){

            public Dimension getMinimumSize() {
                return VcsLogUiUtil.expandToFitToolbar(super.getMinimumSize(), actionsToolbar);
            }
        };
        tablePanel.add((Component)this.myDetailsSplitter, (Object)"Center");
        tablePanel.add((Component)actionsToolbar, (Object)"West");
        this.setLayout(new BorderLayout());
        this.add((Component)new FrameDiffPreview<FileHistoryDiffProcessor>(this.createDiffPreview(false), this.myProperties, (JComponent)tablePanel, "vcs.history.diff.splitter.proportion", false, 0.7f){

            @Override
            public void updatePreview(boolean state) {
                ((FileHistoryDiffProcessor)this.getPreviewDiff()).updatePreview(state);
            }
        }.getMainComponent(), "Center");
        PopupHandler.installPopupMenu((JComponent)((Object)this.myGraphTable), (String)"Vcs.FileHistory.ContextMenu", (String)"Vcs.FileHistory.ContextMenu");
        this.invokeOnDoubleClick(ActionManager.getInstance().getAction("Diff.ShowDiff"), tableWithProgress);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(logUi2, this.myGraphTable);
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    private void invokeOnDoubleClick(@NotNull AnAction action2, @NotNull JComponent component2) {
        if (action2 == null) {
            FileHistoryPanel.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            FileHistoryPanel.$$$reportNull$$$0(8);
        }
        new AnActionWrapper(action2){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (e.getInputEvent() instanceof MouseEvent && FileHistoryPanel.this.myGraphTable.isResizingColumns()) {
                    return;
                }
                super.actionPerformed(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/history/FileHistoryPanel$4", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, component2);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        AnAction toolbarActions = CustomActionsSchema.getInstance().getCorrectedAction("Vcs.FileHistory.Toolbar");
        toolbarGroup.add(Objects.requireNonNull(toolbarActions));
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("Vcs.FileHistory.Toolbar", (ActionGroup)toolbarGroup, false);
        toolbar2.setTargetComponent((JComponent)((Object)this.myGraphTable));
        JComponent jComponent = toolbar2.getComponent();
        if (jComponent == null) {
            FileHistoryPanel.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            FileHistoryPanel.$$$reportNull$$$0(10);
        }
        return vcsLogGraphTable;
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permanentGraphChanged) {
        if (visiblePack == null) {
            FileHistoryPanel.$$$reportNull$$$0(11);
        }
        this.myGraphTable.updateDataPack(visiblePack, permanentGraphChanged);
        this.mySpeedSearch.setVisiblePack(visiblePack);
    }

    public void showDetails(boolean show2) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(show2 ? this.myDetailsPanel : null)));
    }

    @NotNull
    FileHistoryDiffProcessor createDiffPreview(boolean isInEditor) {
        FileHistoryDiffProcessor diffPreview = new FileHistoryDiffProcessor(this.myProject, (Function0<? extends Change>)((Function0)() -> this.getSelectedChange()), isInEditor, this);
        ListSelectionListener selectionListener = e -> {
            int[] selection = this.myGraphTable.getSelectedRows();
            ApplicationManager.getApplication().invokeLater(() -> diffPreview.updatePreview(diffPreview.getComponent().isShowing()), o -> !Arrays.equals(selection, this.myGraphTable.getSelectedRows()) || Disposer.isDisposed((Disposable)diffPreview));
        };
        this.myGraphTable.getSelectionModel().addListSelectionListener(selectionListener);
        Disposer.register((Disposable)diffPreview, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(selectionListener));
        TableModelListener modelListener = e -> {
            if (e.getColumn() < 0) {
                ApplicationManager.getApplication().invokeLater(() -> diffPreview.updatePreview(diffPreview.getComponent().isShowing()), o -> Disposer.isDisposed((Disposable)diffPreview));
            }
        };
        this.myGraphTable.getModel().addTableModelListener(modelListener);
        Disposer.register((Disposable)diffPreview, () -> this.myGraphTable.getModel().removeTableModelListener(modelListener));
        FileHistoryDiffProcessor fileHistoryDiffProcessor = diffPreview;
        if (fileHistoryDiffProcessor == null) {
            FileHistoryPanel.$$$reportNull$$$0(12);
        }
        return fileHistoryDiffProcessor;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FileHistoryPanel.$$$reportNull$$$0(13);
        }
        return ValueKey.match((String)dataId).ifEq(VcsDataKeys.CHANGES).or(VcsDataKeys.SELECTED_CHANGES).thenGet(() -> {
            Change change = this.getSelectedChange();
            if (change != null) {
                return new Change[]{change};
            }
            return null;
        }).ifEq(VcsLogInternalDataKeys.LOG_UI_PROPERTIES).then((Object)this.myProperties).ifEq(VcsDataKeys.FILE_PATH).then((Object)this.myFilePath).ifEq(VcsLogInternalDataKeys.VCS_LOG_VISIBLE_ROOTS).thenGet(() -> Collections.singleton(this.myRoot)).ifEq(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION).then((Object)false).ifEq(VcsLogInternalDataKeys.LOG_DIFF_HANDLER).thenGet(() -> this.myFileHistoryModel.getDiffHandler()).ifEq(EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW).thenGet(() -> this.myEditorDiffPreview).ifEq(VcsLogInternalDataKeys.FILE_HISTORY_MODEL).thenGet(() -> this.myFileHistoryModel.createSnapshot()).ifEq((ValueKey)QuickActionProvider.KEY).thenGet(() -> new ComponentQuickActionProvider(this)).ifEq((ValueKey)PlatformCoreDataKeys.BGT_DATA_PROVIDER).thenGet(() -> {
            List<VcsCommitMetadata> details = this.myGraphTable.getSelection().getCachedMetadata();
            FileHistoryModel modelSnapshot = this.myFileHistoryModel.createSnapshot();
            return slowId -> this.getSlowData(slowId, modelSnapshot, details);
        }).ifEq((ValueKey)PlatformCoreDataKeys.HELP_ID).then((Object)HELP_ID).ifEq((ValueKey)History.KEY).then((Object)this.myHistory).orNull();
    }

    @Nullable
    private Object getSlowData(@NotNull String dataId, @NotNull FileHistoryModel model2, @NotNull List<VcsCommitMetadata> details) {
        if (dataId == null) {
            FileHistoryPanel.$$$reportNull$$$0(14);
        }
        if (model2 == null) {
            FileHistoryPanel.$$$reportNull$$$0(15);
        }
        if (details == null) {
            FileHistoryPanel.$$$reportNull$$$0(16);
        }
        return ValueKey.match((String)dataId).ifEq(VcsDataKeys.VCS_FILE_REVISION).thenGet(() -> {
            if (details.isEmpty()) {
                return null;
            }
            return model2.createRevision((VcsCommitMetadata)ContainerUtil.getFirstItem((List)details));
        }).ifEq(VcsDataKeys.VCS_FILE_REVISIONS).thenGet(() -> {
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            return ContainerUtil.mapNotNull((Collection)details, model2::createRevision).toArray(new VcsFileRevision[0]);
        }).ifEq((ValueKey)CommonDataKeys.VIRTUAL_FILE).thenGet(() -> ((FilePath)this.myFilePath).getVirtualFile()).ifEq(VcsDataKeys.VCS_VIRTUAL_FILE).thenGet(() -> {
            if (details.isEmpty()) {
                return null;
            }
            VcsCommitMetadata detail2 = Objects.requireNonNull((VcsCommitMetadata)ContainerUtil.getFirstItem((List)details));
            return FileHistoryUtil.createVcsVirtualFile(model2.createRevision(detail2));
        }).orNull();
    }

    @Nullable
    Change getSelectedChange() {
        return this.myFileHistoryModel.getSelectedChange(this.myGraphTable.getSelectedRows());
    }

    @NotNull
    FilePath getFilePath() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            FileHistoryPanel.$$$reportNull$$$0(17);
        }
        return filePath;
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileHistoryModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffPreview";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnDoubleClick";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 10, 12, 17 -> new IllegalStateException(string2);
        };
    }
}

