/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.impl.VcsChangesMerger;
import com.intellij.vcs.log.visible.VisiblePack;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileHistoryUtil {
    @Nullable
    public static VirtualFile createVcsVirtualFile(@Nullable VcsFileRevision revision) {
        if (!VcsHistoryUtil.isEmpty(revision) && revision instanceof VcsFileRevisionEx) {
            FilePath path2 = ((VcsFileRevisionEx)revision).getPath();
            return path2.isDirectory() ? new VcsVirtualFolder(path2.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(path2.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    public static boolean affectsFile(@NotNull Change change, @NotNull FilePath file, boolean isDeleted) {
        ContentRevision revision;
        if (change == null) {
            FileHistoryUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileHistoryUtil.$$$reportNull$$$0(1);
        }
        ContentRevision contentRevision = revision = isDeleted ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null) {
            return false;
        }
        return file.equals(revision.getFile());
    }

    public static boolean affectsDirectory(@NotNull Change change, @NotNull FilePath directory) {
        if (change == null) {
            FileHistoryUtil.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            FileHistoryUtil.$$$reportNull$$$0(3);
        }
        return FileHistoryUtil.affectsDirectory(directory, change.getAfterRevision()) || FileHistoryUtil.affectsDirectory(directory, change.getBeforeRevision());
    }

    private static boolean affectsDirectory(@NotNull FilePath directory, @Nullable ContentRevision revision) {
        if (directory == null) {
            FileHistoryUtil.$$$reportNull$$$0(4);
        }
        if (revision == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((File)directory.getIOFile(), (File)revision.getFile().getIOFile(), (boolean)false);
    }

    @Nullable
    static Change createChangeToParents(int commitRow, @NotNull List<Integer> parentRows, @NotNull VisiblePack visiblePack, @NotNull VcsLogDiffHandler diffHandler, @NotNull VcsLogData logData) {
        List parentHashes;
        int commitIndex;
        FilePath path2;
        if (parentRows == null) {
            FileHistoryUtil.$$$reportNull$$$0(5);
        }
        if (visiblePack == null) {
            FileHistoryUtil.$$$reportNull$$$0(6);
        }
        if (diffHandler == null) {
            FileHistoryUtil.$$$reportNull$$$0(7);
        }
        if (logData == null) {
            FileHistoryUtil.$$$reportNull$$$0(8);
        }
        if ((path2 = FileHistoryPaths.filePath(visiblePack, commitIndex = visiblePack.getVisibleGraph().getRowInfo(commitRow).getCommit().intValue())) == null) {
            return null;
        }
        Hash commitHash = logData.getCommitId(commitIndex).getHash();
        ContentRevision afterRevision = FileHistoryUtil.createContentRevision(commitHash, commitIndex, visiblePack, diffHandler);
        if (parentRows.isEmpty()) {
            if (afterRevision == null) {
                return null;
            }
            return new Change(null, afterRevision);
        }
        List parentCommits = ContainerUtil.map(parentRows, r -> visiblePack.getVisibleGraph().getRowInfo((int)r).getCommit());
        List parentChanges = ContainerUtil.mapNotNull((Collection)ContainerUtil.toCollection((Iterable)ContainerUtil.zip((Iterable)parentCommits, (Iterable)(parentHashes = ContainerUtil.map((Collection)parentCommits, c -> logData.getCommitId((int)c).getHash())))), parent -> {
            ContentRevision beforeRevision = FileHistoryUtil.createContentRevision((Hash)parent.second, (Integer)parent.first, visiblePack, diffHandler);
            if (afterRevision == null && beforeRevision == null) {
                return null;
            }
            return new Change(beforeRevision, afterRevision);
        });
        if (parentChanges.size() <= 1) {
            return (Change)ContainerUtil.getFirstItem((List)parentChanges);
        }
        return new MyVcsChangesMerger(commitHash, parentHashes, diffHandler).mergedChange(path2, parentChanges);
    }

    @Nullable
    private static ContentRevision createContentRevision(@NotNull Hash commitHash, int commitIndex, @NotNull VcsLogDataPack visiblePack, @NotNull VcsLogDiffHandler diffHandler) {
        boolean isDeleted;
        if (commitHash == null) {
            FileHistoryUtil.$$$reportNull$$$0(9);
        }
        if (visiblePack == null) {
            FileHistoryUtil.$$$reportNull$$$0(10);
        }
        if (diffHandler == null) {
            FileHistoryUtil.$$$reportNull$$$0(11);
        }
        if (isDeleted = FileHistoryPaths.isDeletedInCommit(visiblePack, commitIndex)) {
            return null;
        }
        FilePath path2 = FileHistoryPaths.filePath(visiblePack, commitIndex);
        if (path2 == null) {
            return null;
        }
        return diffHandler.createContentRevision(path2, commitHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRows";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "affectsFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "affectsDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createChangeToParents";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createContentRevision";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyVcsChangesMerger
    extends VcsChangesMerger {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final Hash myFirstParent;
        @NotNull
        private final VcsLogDiffHandler myDiffHandler;

        private MyVcsChangesMerger(@NotNull Hash commit2, @NotNull List<Hash> parentCommits, @NotNull VcsLogDiffHandler diffHandler) {
            if (commit2 == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(0);
            }
            if (parentCommits == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(1);
            }
            if (diffHandler == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(2);
            }
            this.myCommit = commit2;
            this.myFirstParent = Objects.requireNonNull((Hash)ContainerUtil.getFirstItem(parentCommits));
            this.myDiffHandler = diffHandler;
        }

        @Override
        @NotNull
        protected Change createChange(@NotNull Change.Type type2, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            if (type2 == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(3);
            }
            ContentRevision beforeRevision = beforePath == null ? null : this.myDiffHandler.createContentRevision(beforePath, this.myFirstParent);
            ContentRevision afterRevision = afterPath == null ? null : this.myDiffHandler.createContentRevision(afterPath, this.myCommit);
            return new Change(beforeRevision, afterRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commit";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentCommits";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUtil$MyVcsChangesMerger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

