/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001;B?\b\u0000\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010'\u001a\u00020\u00112\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0014\u0010+\u001a\u00020\u00022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u0016\u0010,\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J\n\u00101\u001a\u0004\u0018\u00010\u0002H\u0014J\u001a\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107J\u0012\u00108\u001a\u0002032\b\u00109\u001a\u0004\u0018\u00010\u0002H\u0014J\u0012\u0010:\u001a\u0002032\b\u00109\u001a\u0004\u0018\u00010\u0002H\u0016R(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010$\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006<"}, d2={"Lcom/intellij/vcs/log/ui/filter/BranchFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel;", "Lcom/intellij/vcs/log/ui/filter/BranchFilters;", "dataPackProvider", "Ljava/util/function/Supplier;", "Lcom/intellij/vcs/log/VcsLogDataPack;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "properties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "(Ljava/util/function/Supplier;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Collection;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "branchFilter", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "getBranchFilter", "()Lcom/intellij/vcs/log/VcsLogBranchFilter;", "setBranchFilter", "(Lcom/intellij/vcs/log/VcsLogBranchFilter;)V", "dataPack", "getDataPack", "()Lcom/intellij/vcs/log/VcsLogDataPack;", "rangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "getRangeFilter", "()Lcom/intellij/vcs/log/VcsLogRangeFilter;", "setRangeFilter", "(Lcom/intellij/vcs/log/VcsLogRangeFilter;)V", "revisionFilter", "Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "getRevisionFilter", "()Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "<set-?>", "visibleRoots", "getVisibleRoots", "()Ljava/util/Collection;", "createBranchFilter", "values", "", "", "createFilterFromPresentation", "createRevisionFilter", "findCommitId", "Lcom/intellij/vcs/log/CommitId;", "hash", "Lcom/intellij/vcs/log/Hash;", "getFilterFromProperties", "onStructureFilterChanged", "", "rootFilter", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "structureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "saveFilterToProperties", "filter", "setFilter", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nBranchFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchFilterModel.kt\ncom/intellij/vcs/log/ui/filter/BranchFilterModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1#2:208\n1#2:222\n1620#3,3:209\n1603#3,9:212\n1855#3:221\n1856#3:223\n1612#3:224\n*S KotlinDebug\n*F\n+ 1 BranchFilterModel.kt\ncom/intellij/vcs/log/ui/filter/BranchFilterModel\n*L\n95#1:222\n90#1:209,3\n95#1:212,9\n95#1:221\n95#1:223\n95#1:224\n*E\n"})
public final class BranchFilterModel
extends FilterModel<BranchFilters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<? extends VcsLogDataPack> dataPackProvider;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Collection<VirtualFile> roots;
    @Nullable
    private Collection<? extends VirtualFile> visibleRoots;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String TWO_DOTS = "..";

    public BranchFilterModel(@NotNull Supplier<? extends VcsLogDataPack> dataPackProvider, @NotNull VcsLogStorage storage, @NotNull Collection<? extends VirtualFile> roots, @NotNull MainVcsLogUiProperties properties2, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter(dataPackProvider, (String)"dataPackProvider");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        super(properties2);
        this.dataPackProvider = dataPackProvider;
        this.storage = storage;
        this.roots = roots;
        if (filters != null) {
            this.saveFilterToProperties(new BranchFilters(filters.get(VcsLogFilterCollection.BRANCH_FILTER), filters.get(VcsLogFilterCollection.REVISION_FILTER), filters.get(VcsLogFilterCollection.RANGE_FILTER)));
        }
    }

    @Nullable
    public final Collection<VirtualFile> getVisibleRoots() {
        return this.visibleRoots;
    }

    @Override
    public void setFilter(@Nullable BranchFilters filter2) {
        BranchFilters newFilters = filter2;
        if (newFilters != null && newFilters.isEmpty()) {
            newFilters = null;
        }
        boolean anyFilterDiffers = false;
        BranchFilters branchFilters = newFilters;
        BranchFilters branchFilters2 = (BranchFilters)this._filter;
        if (!Intrinsics.areEqual((Object)(branchFilters != null ? branchFilters.getBranchFilter() : null), (Object)(branchFilters2 != null ? branchFilters2.getBranchFilter() : null))) {
            BranchFilters branchFilters3 = newFilters;
            if ((branchFilters3 != null ? branchFilters3.getBranchFilter() : null) != null) {
                VcsLogUsageTriggerCollector.triggerFilterSet(VcsLogFilterCollection.BRANCH_FILTER.getName());
            }
            anyFilterDiffers = true;
        }
        BranchFilters branchFilters4 = newFilters;
        BranchFilters branchFilters5 = (BranchFilters)this._filter;
        if (!Intrinsics.areEqual((Object)(branchFilters4 != null ? branchFilters4.getRevisionFilter() : null), (Object)(branchFilters5 != null ? branchFilters5.getRevisionFilter() : null))) {
            BranchFilters branchFilters6 = newFilters;
            if ((branchFilters6 != null ? branchFilters6.getRevisionFilter() : null) != null) {
                VcsLogUsageTriggerCollector.triggerFilterSet(VcsLogFilterCollection.REVISION_FILTER.getName());
            }
            anyFilterDiffers = true;
        }
        BranchFilters branchFilters7 = newFilters;
        BranchFilters branchFilters8 = (BranchFilters)this._filter;
        if (!Intrinsics.areEqual((Object)(branchFilters7 != null ? branchFilters7.getRangeFilter() : null), (Object)(branchFilters8 != null ? branchFilters8.getRangeFilter() : null))) {
            BranchFilters branchFilters9 = newFilters;
            if ((branchFilters9 != null ? branchFilters9.getRangeFilter() : null) != null) {
                VcsLogUsageTriggerCollector.triggerFilterSet(VcsLogFilterCollection.RANGE_FILTER.getName());
            }
            anyFilterDiffers = true;
        }
        if (anyFilterDiffers) {
            super.setFilter(newFilters);
        }
    }

    @Override
    protected void saveFilterToProperties(@Nullable BranchFilters filter2) {
        List list2;
        List list3;
        List list4;
        List list5;
        Object it;
        MainVcsLogUiProperties mainVcsLogUiProperties;
        String string2;
        MainVcsLogUiProperties mainVcsLogUiProperties2 = this.uiProperties;
        String string3 = VcsLogFilterCollection.BRANCH_FILTER.getName();
        Object object = filter2;
        if (object != null && (object = ((BranchFilters)object).getBranchFilter()) != null) {
            Object object2 = object;
            string2 = string3;
            mainVcsLogUiProperties = mainVcsLogUiProperties2;
            boolean bl = false;
            list5 = BranchFilterModel.Companion.getBranchFilterValues((VcsLogBranchFilter)it);
            mainVcsLogUiProperties2 = mainVcsLogUiProperties;
            string3 = string2;
            list4 = list5;
        } else {
            list4 = null;
        }
        mainVcsLogUiProperties2.saveFilterValues(string3, list4);
        MainVcsLogUiProperties mainVcsLogUiProperties3 = this.uiProperties;
        String string4 = VcsLogFilterCollection.REVISION_FILTER.getName();
        Object object3 = filter2;
        if (object3 != null && (object3 = ((BranchFilters)object3).getRevisionFilter()) != null) {
            it = object3;
            string2 = string4;
            mainVcsLogUiProperties = mainVcsLogUiProperties3;
            boolean bl = false;
            list5 = BranchFilterModel.Companion.getRevisionFilterValues((VcsLogRevisionFilter)it);
            mainVcsLogUiProperties3 = mainVcsLogUiProperties;
            string4 = string2;
            list3 = list5;
        } else {
            list3 = null;
        }
        mainVcsLogUiProperties3.saveFilterValues(string4, list3);
        MainVcsLogUiProperties mainVcsLogUiProperties4 = this.uiProperties;
        String string5 = VcsLogFilterCollection.RANGE_FILTER.getName();
        Object object4 = filter2;
        if (object4 != null && (object4 = ((BranchFilters)object4).getRangeFilter()) != null) {
            it = object4;
            string2 = string5;
            mainVcsLogUiProperties = mainVcsLogUiProperties4;
            boolean bl = false;
            list5 = BranchFilterModel.Companion.getRangeFilterValues((VcsLogRangeFilter)it);
            mainVcsLogUiProperties4 = mainVcsLogUiProperties;
            string5 = string2;
            list2 = list5;
        } else {
            list2 = null;
        }
        mainVcsLogUiProperties4.saveFilterValues(string5, list2);
    }

    @Override
    @Nullable
    protected BranchFilters getFilterFromProperties() {
        VcsLogRangeFilter rangeFilter;
        List<String> rangeFilterValues;
        VcsLogRevisionFilter vcsLogRevisionFilter;
        List<String> revisionFilterValues;
        VcsLogBranchFilter vcsLogBranchFilter;
        List<String> branchFilterValues;
        List<String> list2 = branchFilterValues = this.uiProperties.getFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName());
        if (list2 != null) {
            List<String> it = list2;
            boolean bl = false;
            vcsLogBranchFilter = this.createBranchFilter(it);
        } else {
            vcsLogBranchFilter = null;
        }
        VcsLogBranchFilter branchFilter = vcsLogBranchFilter;
        List<String> list3 = revisionFilterValues = this.uiProperties.getFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName());
        if (list3 != null) {
            List<String> it = list3;
            boolean bl = false;
            vcsLogRevisionFilter = this.createRevisionFilter(it);
        } else {
            vcsLogRevisionFilter = null;
        }
        VcsLogRevisionFilter revisionFilter = vcsLogRevisionFilter;
        List<String> list4 = rangeFilterValues = this.uiProperties.getFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName());
        if (list4 != null) {
            List<String> it = list4;
            boolean bl = false;
            v5 = BranchFilterModel.Companion.createRangeFilter(it);
        } else {
            v5 = rangeFilter = null;
        }
        if (branchFilter == null && revisionFilter == null && rangeFilter == null) {
            return null;
        }
        return new BranchFilters(branchFilter, revisionFilter, rangeFilter);
    }

    public final void onStructureFilterChanged(@Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        this.visibleRoots = rootFilter == null && structureFilter == null ? null : (Collection)VcsLogUtil.getAllVisibleRoots(this.roots, rootFilter, structureFilter);
    }

    @NotNull
    public final VcsLogDataPack getDataPack() {
        return this.dataPackProvider.get();
    }

    /*
     * WARNING - void declaration
     */
    private final VcsLogBranchFilter createBranchFilter(List<String> values2) {
        void $this$mapTo$iv;
        Collection collection = values2;
        Collection<VcsRef> collection2 = this.getDataPack().getRefs().getBranches();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getBranches(...)");
        Iterable iterable = collection2;
        Collection collection3 = new LinkedHashSet();
        Collection collection4 = collection;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            void destination$iv;
            VcsRef vcsRef = (VcsRef)item$iv;
            void var10_10 = destination$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            var10_10.add(string2);
        }
        return VcsLogFilterObject.fromBranchPatterns$default(collection4, (Set)collection3, false, 4, null);
    }

    /*
     * Unable to fully structure code
     */
    private final VcsLogRevisionFilter createRevisionFilter(List<String> values) {
        pattern = Pattern.compile("\\[(.*)\\](" + VcsLogUtil.HASH_REGEX.pattern() + ")");
        $this$mapNotNull$iv = values;
        $i$f$mapNotNull = false;
        var5_5 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var10_10 = $this$forEach$iv$iv$iv.iterator();
        while (var10_10.hasNext()) {
            block8: {
                block7: {
                    element$iv$iv = element$iv$iv$iv = var10_10.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    s = (String)element$iv$iv;
                    $i$a$-mapNotNull-BranchFilterModel$createRevisionFilter$1 = false;
                    matcher = pattern.matcher(s);
                    if (matcher.matches()) break block7;
                    if (!VcsLogUtil.isFullHash(s)) ** GOTO lbl-1000
                    v0 = HashImpl.build(s);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"build(...)");
                    commitId = this.findCommitId(v0);
                    if (commitId != null) {
                        v1 = commitId;
                    } else lbl-1000:
                    // 2 sources

                    {
                        BranchFilterModel.LOG.warn("Could not parse '" + s + "' while creating revision filter");
                        v1 = null;
                    }
                    break block8;
                }
                result = matcher.toMatchResult();
                root = LocalFileSystem.getInstance().findFileByPath(result.group(1));
                if (root == null) {
                    BranchFilterModel.LOG.warn("Root '" + result.group(1) + "' does not exist");
                    v1 = null;
                } else if (!this.roots.contains(root)) {
                    BranchFilterModel.LOG.warn("Root '" + result.group(1) + "' is not registered");
                    v1 = null;
                } else {
                    v1 = new CommitId(HashImpl.build(result.group(2)), root);
                }
            }
            if (v1 == null) continue;
            it$iv$iv = v1;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return VcsLogFilterObject.fromCommits((List)destination$iv$iv);
    }

    private final CommitId findCommitId(Hash hash2) {
        for (VirtualFile root : this.roots) {
            CommitId commitId2 = new CommitId(hash2, root);
            if (!this.storage.containsCommit(commitId2)) continue;
            return commitId2;
        }
        return null;
    }

    @NotNull
    public final BranchFilters createFilterFromPresentation(@NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        List hashes2 = new ArrayList();
        List branches = new ArrayList();
        List ranges = new ArrayList();
        for (String s : values2) {
            int twoDots = StringsKt.indexOf$default((CharSequence)s, (String)TWO_DOTS, (int)0, (boolean)false, (int)6, null);
            if (twoDots > 0 && twoDots == StringsKt.lastIndexOf$default((CharSequence)s, (String)TWO_DOTS, (int)0, (boolean)false, (int)6, null)) {
                ranges.add(s);
                continue;
            }
            if (VcsLogUtil.isFullHash(s)) {
                hashes2.add(s);
                continue;
            }
            branches.add(s);
        }
        VcsLogBranchFilter branchFilter = branches.isEmpty() ? null : this.createBranchFilter(branches);
        VcsLogRevisionFilter hashFilter = hashes2.isEmpty() ? null : this.createRevisionFilter(hashes2);
        VcsLogRangeFilter refDiffFilter = ranges.isEmpty() ? null : BranchFilterModel.Companion.createRangeFilter(ranges);
        return new BranchFilters(branchFilter, hashFilter, refDiffFilter);
    }

    @Nullable
    public final VcsLogBranchFilter getBranchFilter() {
        BranchFilters branchFilters = (BranchFilters)this.getFilter();
        return branchFilters != null ? branchFilters.getBranchFilter() : null;
    }

    public final void setBranchFilter(@Nullable VcsLogBranchFilter branchFilter) {
        this.setFilter(new BranchFilters(branchFilter, null, null));
    }

    @Nullable
    public final VcsLogRevisionFilter getRevisionFilter() {
        BranchFilters branchFilters = (BranchFilters)this.getFilter();
        return branchFilters != null ? branchFilters.getRevisionFilter() : null;
    }

    @Nullable
    public final VcsLogRangeFilter getRangeFilter() {
        BranchFilters branchFilters = (BranchFilters)this.getFilter();
        return branchFilters != null ? branchFilters.getRangeFilter() : null;
    }

    public final void setRangeFilter(@Nullable VcsLogRangeFilter rangeFilter) {
        this.setFilter(new BranchFilters(null, null, rangeFilter));
    }

    @JvmStatic
    @NotNull
    public static final List<String> getFilterPresentation(@NotNull BranchFilters filters) {
        return Companion.getFilterPresentation(filters);
    }

    static {
        Logger logger = Logger.getInstance(BranchFilterModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\r\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\r\u001a\u00020\u0015H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/filter/BranchFilterModel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TWO_DOTS", "", "createRangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "values", "", "getBranchFilterValues", "filter", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "getFilterPresentation", "filters", "Lcom/intellij/vcs/log/ui/filter/BranchFilters;", "getRangeFilterValues", "rangeFilter", "getRevisionFilter2Presentation", "Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "getRevisionFilterValues", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nBranchFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchFilterModel.kt\ncom/intellij/vcs/log/ui/filter/BranchFilterModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1603#2,9:208\n1855#2:217\n1856#2:219\n1612#2:220\n1549#2:221\n1620#2,3:222\n1549#2:225\n1620#2,3:226\n1#3:218\n1#3:229\n*S KotlinDebug\n*F\n+ 1 BranchFilterModel.kt\ncom/intellij/vcs/log/ui/filter/BranchFilterModel$Companion\n*L\n171#1:208,9\n171#1:217\n171#1:219\n171#1:220\n188#1:221\n188#1:222,3\n196#1:225\n196#1:226,3\n171#1:218\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final VcsLogRangeFilter createRangeFilter(List<String> values2) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = values2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VcsLogRangeFilter.RefRange refRange;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String value2 = (String)element$iv$iv;
                boolean bl2 = false;
                int twoDots = StringsKt.indexOf$default((CharSequence)value2, (String)BranchFilterModel.TWO_DOTS, (int)0, (boolean)false, (int)6, null);
                if (twoDots <= 0) {
                    LOG.error("Incorrect range filter value: " + values2);
                    refRange = null;
                } else {
                    String string2 = value2.substring(0, twoDots);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String string3 = value2.substring(twoDots + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    refRange = new VcsLogRangeFilter.RefRange(string2, string3);
                }
                if (refRange == null) continue;
                VcsLogRangeFilter.RefRange it$iv$iv = refRange;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List ranges = (List)destination$iv$iv;
            if (ranges.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRange(ranges);
        }

        private final List<String> getBranchFilterValues(VcsLogBranchFilter filter2) {
            Collection<String> collection = filter2.getTextPresentation();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getTextPresentation(...)");
            return new ArrayList(CollectionsKt.sorted((Iterable)collection));
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getRevisionFilterValues(VcsLogRevisionFilter filter2) {
            void $this$mapTo$iv$iv;
            Collection<CommitId> collection = filter2.getHeads();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getHeads(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void id;
                CommitId commitId2 = (CommitId)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add("[" + id.getRoot().getPath() + "]" + id.getHash().asString());
            }
            return (List)destination$iv$iv;
        }

        private final List<String> getRangeFilterValues(VcsLogRangeFilter rangeFilter) {
            return new ArrayList<String>(rangeFilter.getTextPresentation());
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getRevisionFilter2Presentation(VcsLogRevisionFilter filter2) {
            void $this$mapTo$iv$iv;
            Collection<CommitId> collection = filter2.getHeads();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getHeads(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void id;
                CommitId commitId2 = (CommitId)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(id.getHash().asString());
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<String> getFilterPresentation(@NotNull BranchFilters filters) {
            List<String> list2;
            List<String> revisionFilterValues;
            List<String> branchFilterValues;
            block11: {
                block10: {
                    block9: {
                        List<String> list3;
                        block8: {
                            block7: {
                                Object object;
                                block6: {
                                    Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
                                    object = filters.getBranchFilter();
                                    if (object == null) break block6;
                                    VcsLogBranchFilter it = object;
                                    boolean bl = false;
                                    List<String> list4 = Companion.getBranchFilterValues(it);
                                    object = list4;
                                    if (list4 != null) break block7;
                                }
                                object = branchFilterValues = CollectionsKt.emptyList();
                            }
                            if ((list3 = filters.getRevisionFilter()) == null) break block8;
                            VcsLogRevisionFilter it = list3;
                            boolean bl = false;
                            List<String> list5 = Companion.getRevisionFilter2Presentation(it);
                            list3 = list5;
                            if (list5 != null) break block9;
                        }
                        list3 = revisionFilterValues = CollectionsKt.emptyList();
                    }
                    if ((list2 = filters.getRangeFilter()) == null) break block10;
                    VcsLogRangeFilter it = list2;
                    boolean bl = false;
                    List<String> list6 = Companion.getRangeFilterValues(filters.getRangeFilter());
                    list2 = list6;
                    if (list6 != null) break block11;
                }
                list2 = CollectionsKt.emptyList();
            }
            List<String> rangeFilterValues = list2;
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)branchFilterValues, (Iterable)revisionFilterValues), (Iterable)rangeFilterValues);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

