/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewProvider;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\f\u0010\r*\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreviewProvider;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "owner", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "previewFile", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "getPreviewFile$delegate", "(Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;)Ljava/lang/Object;", "getPreviewFile", "()Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "previewFileDelegate", "Lkotlin/Lazy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "closePreview", "", "getCurrentToolWindowFocus", "Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview$ToolWindowFocus;", "getOwner", "getOwnerComponent", "Ljavax/swing/JComponent;", "openPreview", "", "requestFocus", "restoreToolWindowFocus", "oldToolWindowFocus", "MyEscapeHandler", "ToolWindowFocus", "intellij.platform.vcs.log.impl"})
public abstract class EditorDiffPreview
implements DiffPreviewProvider,
DiffPreview {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable owner;
    @NotNull
    private final Lazy<PreviewDiffVirtualFile> previewFileDelegate;

    public EditorDiffPreview(@NotNull Project project2, @NotNull Disposable owner) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.project = project2;
        this.owner = owner;
        this.previewFileDelegate = LazyKt.lazy((Function0)((Function0)new Function0<PreviewDiffVirtualFile>(this){
            final /* synthetic */ EditorDiffPreview this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PreviewDiffVirtualFile invoke() {
                return new PreviewDiffVirtualFile(this.this$0);
            }
        }));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    private final PreviewDiffVirtualFile getPreviewFile() {
        Lazy<PreviewDiffVirtualFile> lazy = this.previewFileDelegate;
        return (PreviewDiffVirtualFile)((Object)lazy.getValue());
    }

    private static Object getPreviewFile$delegate(EditorDiffPreview editorDiffPreview2) {
        return editorDiffPreview2.previewFileDelegate;
    }

    @Override
    public boolean openPreview(boolean requestFocus2) {
        ToolWindowFocus oldToolWindowFocus = this.getCurrentToolWindowFocus();
        EditorTabPreviewBase.Companion.registerEscapeHandler((VirtualFile)this.getPreviewFile(), new MyEscapeHandler(oldToolWindowFocus));
        EditorTabPreviewBase.Companion.openPreview(this.project, (VirtualFile)this.getPreviewFile(), requestFocus2);
        return true;
    }

    @Override
    public void closePreview() {
        if (this.previewFileDelegate.isInitialized()) {
            DiffPreview.Companion.closePreviewFile(this.project, (VirtualFile)this.getPreviewFile());
        }
    }

    @NotNull
    public Disposable getOwner() {
        return this.owner;
    }

    @NotNull
    public abstract JComponent getOwnerComponent();

    private final ToolWindowFocus getCurrentToolWindowFocus() {
        Component component2 = IdeFocusManager.getInstance((Project)this.project).getFocusOwner();
        if (component2 == null) {
            return null;
        }
        Component focusOwner = component2;
        Object object = InternalDecoratorImpl.Companion.findTopLevelDecorator(focusOwner);
        if (object == null || (object = object.getToolWindowId()) == null) {
            return null;
        }
        Object toolWindowId = object;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow((String)toolWindowId);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null || (contentManager = contentManager.getSelectedContent()) == null) {
            return null;
        }
        ContentManager selectedContent = contentManager;
        return new ToolWindowFocus(focusOwner, (String)toolWindowId, (Content)selectedContent);
    }

    private final void restoreToolWindowFocus(ToolWindowFocus oldToolWindowFocus) {
        if (oldToolWindowFocus == null) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(oldToolWindowFocus.getToolWindowId());
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null) {
            return;
        }
        ContentManager contentManager2 = contentManager;
        if (contentManager2.getIndexOfContent(oldToolWindowFocus.getContent()) < 0) {
            return;
        }
        contentManager2.setSelectedContent(oldToolWindowFocus.getContent());
        toolWindow2.activate(() -> EditorDiffPreview.restoreToolWindowFocus$lambda$0(this, oldToolWindowFocus), false);
    }

    private static final void restoreToolWindowFocus$lambda$0(EditorDiffPreview this$0, ToolWindowFocus $oldToolWindowFocus) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IdeFocusManager.getInstance((Project)this$0.project).requestFocus($oldToolWindowFocus.getComponent(), true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview$MyEscapeHandler;", "Ljava/lang/Runnable;", "oldToolWindowFocus", "Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview$ToolWindowFocus;", "(Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview$ToolWindowFocus;)V", "Ljava/lang/ref/WeakReference;", "getOldToolWindowFocus", "()Ljava/lang/ref/WeakReference;", "run", "", "intellij.platform.vcs.log.impl"})
    private final class MyEscapeHandler
    implements Runnable {
        @NotNull
        private final WeakReference<ToolWindowFocus> oldToolWindowFocus;

        public MyEscapeHandler(ToolWindowFocus oldToolWindowFocus) {
            this.oldToolWindowFocus = new WeakReference<ToolWindowFocus>(oldToolWindowFocus);
        }

        @NotNull
        public final WeakReference<ToolWindowFocus> getOldToolWindowFocus() {
            return this.oldToolWindowFocus;
        }

        @Override
        public void run() {
            EditorDiffPreview.this.closePreview();
            EditorDiffPreview.this.restoreToolWindowFocus((ToolWindowFocus)this.oldToolWindowFocus.get());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview$ToolWindowFocus;", "", "component", "Ljava/awt/Component;", "toolWindowId", "", "content", "Lcom/intellij/ui/content/Content;", "(Ljava/awt/Component;Ljava/lang/String;Lcom/intellij/ui/content/Content;)V", "getComponent", "()Ljava/awt/Component;", "getContent", "()Lcom/intellij/ui/content/Content;", "getToolWindowId", "()Ljava/lang/String;", "intellij.platform.vcs.log.impl"})
    private static final class ToolWindowFocus {
        @NotNull
        private final Component component;
        @NotNull
        private final String toolWindowId;
        @NotNull
        private final Content content;

        public ToolWindowFocus(@NotNull Component component2, @NotNull String toolWindowId, @NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.component = component2;
            this.toolWindowId = toolWindowId;
            this.content = content;
        }

        @NotNull
        public final Component getComponent() {
            return this.component;
        }

        @NotNull
        public final String getToolWindowId() {
            return this.toolWindowId;
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }
    }
}

