/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogChangeProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final VcsLogChangesBrowser myBrowser;
    private final boolean myIsInEditor;

    VcsLogChangeProcessor(@NotNull Project project2, @NotNull VcsLogChangesBrowser browser, boolean isInEditor, @NotNull Disposable disposable) {
        if (project2 == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(0);
        }
        if (browser == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(2);
        }
        super(project2, isInEditor ? "Default" : "VcsLogView");
        this.myIsInEditor = isInEditor;
        this.myBrowser = browser;
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myBrowser.addListener(() -> this.updatePreviewLater(), (Disposable)this);
        this.myBrowser.getViewer().addSelectionListener(this::updatePreviewLater, (Disposable)this);
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        if (toolbarComponents == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(3);
        }
        return !this.myIsInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
        return this.wrap(VcsTreeModelData.selected((JTree)((Object)this.myBrowser.getViewer())));
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
        return this.wrap(VcsTreeModelData.all((JTree)((Object)this.myBrowser.getViewer())));
    }

    @NotNull
    private Iterable<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull VcsTreeModelData modelData) {
        if (modelData == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(4);
        }
        return VcsLogChangeProcessor.wrap(this.myBrowser, modelData);
    }

    @NotNull
    static Iterable<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull VcsLogChangesBrowser browser, @NotNull VcsTreeModelData modelData) {
        if (browser == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(5);
        }
        if (modelData == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = modelData.iterateNodes().filter(ChangesBrowserChangeNode.class).map(n -> new MyChangeWrapper(browser, (Change)n.getUserObject(), browser.getTag((Change)n.getUserObject())));
        if (jBIterable == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        if (change == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(8);
        }
        this.myBrowser.selectChange(change.getUserObject(), change.getTag());
    }

    private void updatePreviewLater() {
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(this.myIsInEditor || this.getComponent().isShowing()));
    }

    public void updatePreview(boolean state) {
        this.updatePreview(state, false);
    }

    @NotNull
    public static VcsTreeModelData getSelectedOrAll(VcsLogChangesBrowser changesBrowser) {
        boolean hasSelection = changesBrowser.getViewer().getSelectionModel().getSelectionCount() != 0;
        VcsTreeModelData vcsTreeModelData = hasSelection ? VcsTreeModelData.selected((JTree)((Object)changesBrowser.getViewer())) : VcsTreeModelData.all((JTree)((Object)changesBrowser.getViewer()));
        if (vcsTreeModelData == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(9);
        }
        return vcsTreeModelData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarComponents";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelData";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedOrAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToolbarBottomBorder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectChange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 9 -> new IllegalStateException(string2);
        };
    }

    private static class MyChangeWrapper
    extends ChangeViewDiffRequestProcessor.ChangeWrapper {
        @NotNull
        private final VcsLogChangesBrowser myBrowser;

        MyChangeWrapper(@NotNull VcsLogChangesBrowser browser, @NotNull Change change, @Nullable ChangesBrowserNode.Tag tag) {
            if (browser == null) {
                MyChangeWrapper.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MyChangeWrapper.$$$reportNull$$$0(1);
            }
            super(change, tag);
            this.myBrowser = browser;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project2) {
            return this.myBrowser.getDiffRequestProducer(this.change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "browser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "change";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor$MyChangeWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

