/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.NewUiRootCellRenderer;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/table/column/Root;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "Lcom/intellij/openapi/vcs/FilePath;", "()V", "isResizable", "", "()Z", "createTableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "getStubValue", "model", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "getValue", "row", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogDefaultColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogDefaultColumn.kt\ncom/intellij/vcs/log/ui/table/column/Root\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public final class Root
extends VcsLogDefaultColumn<FilePath> {
    @NotNull
    public static final Root INSTANCE = new Root();
    private static final boolean isResizable;

    private Root() {
        super("Default.Root", "", false, null);
    }

    @Override
    public boolean isResizable() {
        return isResizable;
    }

    @Override
    @Nullable
    public FilePath getValue(@NotNull GraphTableModel model2, int row2) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        VisiblePack visiblePack = model2.getVisiblePack();
        Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"getVisiblePack(...)");
        VisiblePack visiblePack2 = visiblePack;
        if (FileHistoryPaths.hasPathsInformation(visiblePack2)) {
            VcsLogDataPack vcsLogDataPack = visiblePack2;
            Integer n = visiblePack2.getVisibleGraph().getRowInfo(row2).getCommit();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommit(...)");
            FilePath path2 = FileHistoryPaths.filePathOrDefault(vcsLogDataPack, ((Number)n).intValue());
            if (path2 != null) {
                return path2;
            }
        }
        VirtualFile virtualFile = visiblePack2.getRoot(row2);
        if (virtualFile != null) {
            VirtualFile p0 = virtualFile;
            boolean bl = false;
            filePath = VcsUtil.getFilePath(p0);
        } else {
            filePath = null;
        }
        return filePath;
    }

    @Override
    @NotNull
    public TableCellRenderer createTableCellRenderer(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        VcsLogDefaultColumnKt.access$doOnPropertyChange(table, new Function1<VcsLogUiProperties.VcsLogUiProperty<?>, Unit>(table){
            final /* synthetic */ VcsLogGraphTable $table;
            {
                this.$table = $table;
                super(1);
            }

            public final void invoke(@NotNull VcsLogUiProperties.VcsLogUiProperty<?> property2) {
                Intrinsics.checkNotNullParameter(property2, (String)"property");
                if (Intrinsics.areEqual(CommonUiProperties.SHOW_ROOT_NAMES, property2)) {
                    this.$table.rootColumnUpdated();
                }
            }
        });
        if (ExperimentalUI.Companion.isNewUI()) {
            VcsLogUiProperties vcsLogUiProperties = table.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperties, (String)"getProperties(...)");
            VcsLogColorManager vcsLogColorManager = table.getColorManager();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogColorManager, (String)"getColorManager(...)");
            return new NewUiRootCellRenderer(vcsLogUiProperties, vcsLogColorManager);
        }
        return new RootCellRenderer(table.getProperties(), table.getColorManager());
    }

    @Override
    @NotNull
    public FilePath getStubValue(@NotNull GraphTableModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Collection<VirtualFile> collection = model2.getLogData().getRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRoots(...)");
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)CollectionsKt.first((Iterable)collection));
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }
}

