/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.context.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.webSymbols.context.impl.ContextConfigInDir;
import com.intellij.webSymbols.context.impl.WebSymbolsContextDiscoveryInfo;
import com.intellij.webSymbols.context.impl.WebSymbolsContextDiscoveryKt;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0007J-\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00072\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\n\u0010\u001a\u001a\u00060\rj\u0002`\u0012\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u00072\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\n\u0010\u001a\u001a\u00060\rj\u0002`\u0012R/\u0010\u0005\u001a#\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RQ\u0010\u0010\u001aE\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u00121\u0012/\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\b\u0012\u00060\rj\u0002`\u00120\u0011\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t0\u000f\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextDiscoveryInfo;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/webSymbols/context/impl/ContextConfigInDir;", "previousContext", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/webSymbols/ContextKind;", "", "proximityCache", "Lkotlin/Pair;", "Lcom/intellij/webSymbols/ContextName;", "", "dispose", "", "getContextConfigInDir", "dir", "getProximityFromExtensions", "kind", "name", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "updateContext", "contextFile", "intellij.platform.webSymbols"})
final class WebSymbolsContextDiscoveryInfo
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, Map<VirtualFile, String>> previousContext;
    @NotNull
    private final ConcurrentMap<VirtualFile, Map<Pair<String, String>, CachedValue<Integer>>> proximityCache;
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedValue<ContextConfigInDir>> configCache;

    public WebSymbolsContextDiscoveryInfo(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.previousContext = new ConcurrentHashMap();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.proximityCache = concurrentMap;
        ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakMap(...)");
        this.configCache = concurrentMap2;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                previousContext.clear();
                proximityCache.clear();
                configCache.clear();
            }
        });
    }

    @Nullable
    public final Integer getProximityFromExtensions(@NotNull VirtualFile dir, @NotNull String kind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Integer)this.proximityCache.computeIfAbsent(dir, arg_0 -> WebSymbolsContextDiscoveryInfo.getProximityFromExtensions$lambda$0(getProximityFromExtensions.1.INSTANCE, arg_0)).computeIfAbsent(new Pair((Object)kind, (Object)name), arg_0 -> WebSymbolsContextDiscoveryInfo.getProximityFromExtensions$lambda$1((Function1)new Function1<Pair<? extends String, ? extends String>, CachedValue<Integer>>(this, kind, name, dir){
            final /* synthetic */ WebSymbolsContextDiscoveryInfo this$0;
            final /* synthetic */ String $kind;
            final /* synthetic */ String $name;
            final /* synthetic */ VirtualFile $dir;
            {
                this.this$0 = $receiver;
                this.$kind = $kind;
                this.$name = $name;
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final CachedValue<Integer> invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return CachedValuesManager.getManager((Project)WebSymbolsContextDiscoveryInfo.access$getProject$p(this.this$0)).createCachedValue(() -> getProximityFromExtensions.2.invoke$lambda$0(this.$kind, this.$name, this.this$0, this.$dir));
            }

            private static final CachedValueProvider.Result invoke$lambda$0(String $kind, String $name, WebSymbolsContextDiscoveryInfo this$0, VirtualFile $dir) {
                Intrinsics.checkNotNullParameter((Object)$kind, (String)"$kind");
                Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$dir, (String)"$dir");
                return WebSymbolsContextDiscoveryKt.access$webContextProximityFromProviders($kind, $name, WebSymbolsContextDiscoveryInfo.access$getProject$p(this$0), $dir);
            }
        }, arg_0)).getValue();
    }

    @Nullable
    public final String updateContext(@NotNull VirtualFile contextFile, @NotNull String kind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.previousContext.computeIfAbsent(kind, arg_0 -> WebSymbolsContextDiscoveryInfo.updateContext$lambda$2(updateContext.1.INSTANCE, arg_0)).put(contextFile, name);
    }

    @NotNull
    public final ContextConfigInDir getContextConfigInDir(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = this.configCache.computeIfAbsent(dir, arg_0 -> WebSymbolsContextDiscoveryInfo.getContextConfigInDir$lambda$3((Function1)new Function1<VirtualFile, CachedValue<ContextConfigInDir>>(this, dir){
            final /* synthetic */ WebSymbolsContextDiscoveryInfo this$0;
            final /* synthetic */ VirtualFile $dir;
            {
                this.this$0 = $receiver;
                this.$dir = $dir;
                super(1);
            }

            public final CachedValue<ContextConfigInDir> invoke(VirtualFile it) {
                return CachedValuesManager.getManager((Project)WebSymbolsContextDiscoveryInfo.access$getProject$p(this.this$0)).createCachedValue(() -> getContextConfigInDir.1.invoke$lambda$0(this.this$0, this.$dir));
            }

            private static final CachedValueProvider.Result invoke$lambda$0(WebSymbolsContextDiscoveryInfo this$0, VirtualFile $dir) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$dir, (String)"$dir");
                ContextConfigInDir result2 = WebSymbolsContextDiscoveryKt.access$loadContextConfiguration(WebSymbolsContextDiscoveryInfo.access$getProject$p(this$0), $dir);
                return CachedValueProvider.Result.create((Object)result2, (Collection)result2.getDependencies());
            }
        }, arg_0)).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ContextConfigInDir)object;
    }

    public void dispose() {
    }

    private static final Map getProximityFromExtensions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final CachedValue getProximityFromExtensions$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedValue)$tmp0.invoke(p0);
    }

    private static final Map updateContext$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final CachedValue getContextConfigInDir$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedValue)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(WebSymbolsContextDiscoveryInfo $this) {
        return $this.project;
    }
}

