/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaProvider {
    public static final ExtensionPointName<XmlSchemaProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.schemaProvider");

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @Nullable Module module, @NotNull PsiFile file) {
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            XmlSchemaProvider.$$$reportNull$$$0(1);
        }
        if (file.getProject().isDefault()) {
            return null;
        }
        boolean dumb = DumbService.getInstance((Project)file.getProject()).isDumb();
        for (XmlSchemaProvider provider2 : EP_NAME.getExtensionList()) {
            XmlFile schema;
            if (dumb && !DumbService.isDumbAware((Object)provider2) || file instanceof XmlFile && !provider2.isAvailable((XmlFile)file) || (schema = provider2.getSchema(namespace, module, file)) == null) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @NotNull PsiFile baseFile) {
        PsiDirectory directory;
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(2);
        }
        if (baseFile == null) {
            XmlSchemaProvider.$$$reportNull$$$0(3);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((directory = baseFile.getParent()) == null ? baseFile : directory));
        return XmlSchemaProvider.findSchema(namespace, module, baseFile);
    }

    @NotNull
    public static List<XmlSchemaProvider> getAvailableProviders(@NotNull XmlFile file) {
        if (file == null) {
            XmlSchemaProvider.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.findAll((Collection)EP_NAME.getExtensionList(), xmlSchemaProvider -> xmlSchemaProvider.isAvailable(file));
        if (list2 == null) {
            XmlSchemaProvider.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    public abstract XmlFile getSchema(@NotNull @NonNls String var1, @Nullable Module var2, @NotNull PsiFile var3);

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            XmlSchemaProvider.$$$reportNull$$$0(6);
        }
        return false;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            XmlSchemaProvider.$$$reportNull$$$0(7);
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            XmlSchemaProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            XmlSchemaProvider.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nullable
    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            XmlSchemaProvider.$$$reportNull$$$0(12);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/XmlSchemaProvider";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/XmlSchemaProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProviders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSchema";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableProviders";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableNamespaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrefix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocations";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 8 -> new IllegalStateException(string2);
        };
    }
}

