/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.ContentAwareJsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaByCommentProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorage;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogExclusion;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService,
ModificationTracker,
Disposable {
    private static final Logger LOG = Logger.getInstance(JsonSchemaServiceImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MyState myState;
    @NotNull
    private final ClearableLazyValue<Set<String>> myBuiltInSchemaIds;
    @NotNull
    private final Set<String> myRefs;
    private final AtomicLong myAnyChangeCount;
    @NotNull
    private final JsonSchemaCatalogManager myCatalogManager;
    @NotNull
    private final JsonSchemaVfsListener.JsonSchemaUpdater mySchemaUpdater;
    private final JsonSchemaProviderFactories myFactories;
    private final List<Runnable> myResetActions;

    public JsonSchemaServiceImpl(@NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(0);
        }
        this.myRefs = ConcurrentCollectionFactory.createConcurrentSet();
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myResetActions = ContainerUtil.createConcurrentList();
        this.myProject = project2;
        this.myFactories = new JsonSchemaProviderFactories();
        this.myState = new MyState(() -> this.myFactories.getProviders(), this.myProject);
        this.myBuiltInSchemaIds = new ClearableLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                Set set = ContainerUtil.map2SetNotNull(JsonSchemaServiceImpl.this.myState.getFiles(), f -> JsonCachedValues.getSchemaId(f, JsonSchemaServiceImpl.this.myProject));
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$1", "compute"));
            }
        };
        JsonSchemaProviderFactory.EP_NAME.addChangeListener(this::reset, (Disposable)this);
        JsonSchemaEnabler.EXTENSION_POINT_NAME.addChangeListener(this::reset, (Disposable)this);
        JsonSchemaCatalogExclusion.EP_NAME.addChangeListener(this::reset, (Disposable)this);
        this.myCatalogManager = new JsonSchemaCatalogManager(this.myProject);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)this);
        connection.subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        connection.subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> {
            this.myRefs.clear();
            this.myAnyChangeCount.incrementAndGet();
        });
        this.mySchemaUpdater = JsonSchemaVfsListener.startListening(project2, this, connection);
        this.myCatalogManager.startUpdates();
    }

    public long getModificationCount() {
        return this.myAnyChangeCount.get();
    }

    public void dispose() {
    }

    @NotNull
    protected List<JsonSchemaProviderFactory> getProviderFactories() {
        List list2 = JsonSchemaProviderFactory.EP_NAME.getExtensionList();
        if (list2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(2);
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(3);
        }
        return (file = this.resolveSchemaFile(schemaObject)) == null ? null : this.getSchemaProvider(file);
    }

    @Override
    public void reset() {
        this.myFactories.reset();
        this.resetWithCurrentFactories();
    }

    private void resetWithCurrentFactories() {
        this.myState.reset();
        this.myBuiltInSchemaIds.drop();
        this.myAnyChangeCount.incrementAndGet();
        for (Runnable action2 : this.myResetActions) {
            action2.run();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(4);
        }
        return project2;
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        VirtualFile file;
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(5);
        }
        if ((file = this.findBuiltInSchemaByReference(reference)) != null) {
            return file;
        }
        if (reference.startsWith("#")) {
            return referent;
        }
        return JsonFileResolver.resolveSchemaByReference(referent, JsonPointerUtil.normalizeId(reference));
    }

    @Nullable
    private VirtualFile findBuiltInSchemaByReference(@NotNull String reference) {
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(6);
        }
        String id = JsonPointerUtil.normalizeId(reference);
        if (!((Set)this.myBuiltInSchemaIds.getValue()).contains(id)) {
            return null;
        }
        for (VirtualFile file : this.myState.getFiles()) {
            if (!id.equals(JsonCachedValues.getSchemaId(file, this.myProject))) continue;
            return file;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(7);
        }
        Collection<VirtualFile> collection = this.getSchemasForFile(file, false, false);
        if (collection == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    @Nullable
    public VirtualFile getDynamicSchemaForFile(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(9);
        }
        return ContentAwareJsonSchemaFileProvider.EP_NAME.getExtensionList().stream().map(provider2 -> provider2.getSchemaFile(psiFile2)).filter(schemaFile -> schemaFile != null).findFirst().orElse(null);
    }

    private static boolean shouldIgnoreFile(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(11);
        }
        return JsonSchemaMappingsProjectConfiguration.getInstance(project2).isIgnoredFile(file);
    }

    @NotNull
    public Collection<VirtualFile> getSchemasForFile(@NotNull VirtualFile file, boolean single, boolean onlyUserSchemas) {
        VirtualFile schemaFromOtherSources;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(12);
        }
        if (JsonSchemaServiceImpl.shouldIgnoreFile(file, this.myProject)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(13);
            }
            return list2;
        }
        String schemaUrl = null;
        if (!onlyUserSchemas && JsonFileResolver.isSchemaUrl(schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject)) && (virtualFile2 = this.resolveFromSchemaProperty(schemaUrl, file)) != null) {
            List<VirtualFile> list3 = Collections.singletonList(virtualFile2);
            if (list3 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(14);
            }
            return list3;
        }
        List<JsonSchemaFileProvider> providers = this.getProvidersForFile(file);
        boolean checkSchemaProperty = true;
        if (!onlyUserSchemas && providers.stream().noneMatch(p -> p.getSchemaType() == SchemaType.userSchema)) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject);
            }
            if (schemaUrl == null) {
                schemaUrl = JsonSchemaByCommentProvider.getCommentSchema(file, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file)) != null) {
                List<VirtualFile> list4 = Collections.singletonList(virtualFile);
                if (list4 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(15);
                }
                return list4;
            }
            checkSchemaProperty = false;
        }
        if (!single) {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            for (JsonSchemaFileProvider provider3 : providers) {
                VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, provider3);
                if (schemaFile == null) continue;
                files2.add(schemaFile);
            }
            if (!files2.isEmpty()) {
                ArrayList<VirtualFile> arrayList = files2;
                if (arrayList == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(16);
                }
                return arrayList;
            }
        } else if (!providers.isEmpty()) {
            JsonSchemaFileProvider selected;
            if (providers.size() > 2) {
                List list5 = ContainerUtil.emptyList();
                if (list5 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(17);
                }
                return list5;
            }
            if (providers.size() > 1) {
                Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider2 -> SchemaType.userSchema.equals((Object)provider2.getSchemaType())).findFirst();
                if (userSchema.isEmpty()) {
                    List list6 = ContainerUtil.emptyList();
                    if (list6 == null) {
                        JsonSchemaServiceImpl.$$$reportNull$$$0(18);
                    }
                    return list6;
                }
                selected = userSchema.get();
            } else {
                selected = providers.get(0);
            }
            VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, selected);
            List list7 = ContainerUtil.createMaybeSingletonList((Object)schemaFile);
            if (list7 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(19);
            }
            return list7;
        }
        if (onlyUserSchemas) {
            List list8 = ContainerUtil.emptyList();
            if (list8 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(20);
            }
            return list8;
        }
        if (checkSchemaProperty) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file)) != null) {
                List<VirtualFile> list9 = Collections.singletonList(virtualFile);
                if (list9 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(21);
                }
                return list9;
            }
        }
        if ((schemaFromOtherSources = this.resolveSchemaFromOtherSources(file)) != null) {
            List list10 = ContainerUtil.createMaybeSingletonList((Object)schemaFromOtherSources);
            if (list10 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(22);
            }
            return list10;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile2 == null) {
            List<VirtualFile> list11 = Collections.emptyList();
            if (list11 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(23);
            }
            return list11;
        }
        List list12 = ContainerUtil.createMaybeSingletonList((Object)this.getDynamicSchemaForFile(psiFile2));
        if (list12 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(24);
        }
        return list12;
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProvidersForFile(@NotNull VirtualFile file) {
        Map map2;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(25);
        }
        if ((map2 = (Map)this.myState.myData.getValue()).isEmpty()) {
            List<JsonSchemaFileProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(26);
            }
            return list2;
        }
        List result2 = null;
        for (List providers : map2.values()) {
            for (JsonSchemaFileProvider provider2 : providers) {
                if (!JsonSchemaServiceImpl.isProviderAvailable(file, provider2)) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(provider2);
            }
        }
        List<JsonSchemaFileProvider> list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(27);
        }
        return list3;
    }

    @Nullable
    private VirtualFile resolveFromSchemaProperty(@Nullable String schemaUrl, @NotNull VirtualFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(28);
        }
        if (schemaUrl != null && (virtualFile = this.findSchemaFileByReference(schemaUrl, file)) != null) {
            return virtualFile;
        }
        return null;
    }

    @Override
    public List<JsonSchemaInfo> getAllUserVisibleSchemas() {
        List<JsonSchemaCatalogEntry> schemas = this.myCatalogManager.getAllCatalogEntries();
        Map map2 = (Map)this.myState.myData.getValue();
        ArrayList<JsonSchemaInfo> results = new ArrayList<JsonSchemaInfo>(schemas.size() + map2.size());
        HashMap processedRemotes = new HashMap();
        this.myState.processProviders(provider2 -> {
            if (provider2.isUserVisible()) {
                String remoteSource = provider2.getRemoteSource();
                if (remoteSource != null) {
                    if (!processedRemotes.containsKey(remoteSource)) {
                        JsonSchemaInfo info = new JsonSchemaInfo((JsonSchemaFileProvider)provider2);
                        processedRemotes.put(remoteSource, info);
                        results.add(info);
                    }
                } else {
                    results.add(new JsonSchemaInfo((JsonSchemaFileProvider)provider2));
                }
            }
        });
        for (JsonSchemaCatalogEntry schema : schemas) {
            JsonSchemaInfo info;
            String url = schema.getUrl();
            if (!processedRemotes.containsKey(url)) {
                info = new JsonSchemaInfo(url);
                if (schema.getDescription() != null) {
                    info.setDocumentation(schema.getDescription());
                }
                if (schema.getName() != null) {
                    info.setName(schema.getName());
                }
                results.add(info);
                continue;
            }
            info = (JsonSchemaInfo)processedRemotes.get(url);
            if (info.getDocumentation() == null) {
                info.setDocumentation(schema.getDescription());
            }
            if (info.getName() != null) continue;
            info.setName(schema.getName());
        }
        return results;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file) {
        Collection<VirtualFile> schemas;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(29);
        }
        if ((schemas = this.getSchemasForFile(file, true, false)).size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        VirtualFile schemaFile = schemas.iterator().next();
        return JsonCachedValues.getSchemaObject(this.replaceHttpFileWithBuiltinIfNeeded(schemaFile), this.myProject);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull PsiFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(30);
        }
        return JsonCachedValues.computeSchemaForFile(file, this);
    }

    public VirtualFile replaceHttpFileWithBuiltinIfNeeded(VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile && (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas() || JsonFileResolver.isSchemaUrl(schemaFile.getUrl()))) {
            String url = schemaFile.getUrl();
            VirtualFile first1 = this.getLocalSchemaByUrl(url);
            return first1 != null ? first1 : schemaFile;
        }
        return schemaFile;
    }

    @Nullable
    public VirtualFile getLocalSchemaByUrl(String url) {
        return this.myState.getFiles().stream().filter(f -> {
            JsonSchemaFileProvider prov = this.getSchemaProvider((VirtualFile)f);
            return prov != null && !(prov.getSchemaFile() instanceof HttpVirtualFile) && (url.equals(prov.getRemoteSource()) || JsonFileResolver.replaceUnsafeSchemaStoreUrls(url).equals(prov.getRemoteSource()) || url.equals(JsonFileResolver.replaceUnsafeSchemaStoreUrls(prov.getRemoteSource())));
        }).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(31);
        }
        return JsonCachedValues.getSchemaObject(schemaFile, this.myProject);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(32);
        }
        return !file.isDirectory() && (this.isMappedSchema(file) || this.isSchemaByProvider(file) || this.hasSchemaSchema(file));
    }

    @Override
    public boolean isSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(33);
        }
        return (file = this.resolveSchemaFile(schemaObject)) != null && this.isSchemaFile(file);
    }

    private boolean isMappedSchema(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(34);
        }
        return this.isMappedSchema(file, true);
    }

    public boolean isMappedSchema(@NotNull VirtualFile file, boolean canRecompute) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(35);
        }
        return (canRecompute || this.myState.isComputed()) && this.myState.getFiles().contains(file);
    }

    private boolean isSchemaByProvider(@NotNull VirtualFile file) {
        JsonSchemaFileProvider provider2;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(36);
        }
        if ((provider2 = this.myState.getProvider(file)) != null) {
            return JsonSchemaServiceImpl.isSchemaProvider(provider2);
        }
        Map map2 = (Map)this.myState.myData.getValue();
        for (List providers : map2.values()) {
            for (JsonSchemaFileProvider p : providers) {
                if (!JsonSchemaServiceImpl.isSchemaProvider(p) || !p.isAvailable(file)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSchemaProvider(JsonSchemaFileProvider provider2) {
        return JsonFileResolver.isSchemaUrl(provider2.getRemoteSource());
    }

    @Override
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile file) {
        JsonSchemaFileProvider provider2;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(37);
        }
        if (this.isMappedSchema(file) && (provider2 = this.myState.getProvider(file)) != null) {
            return provider2.getSchemaVersion();
        }
        return this.getSchemaVersionFromSchemaUrl(file);
    }

    @Nullable
    private JsonSchemaVersion getSchemaVersionFromSchemaUrl(@NotNull VirtualFile file) {
        JsonSchemaObject schemaRootOrNull;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(38);
        }
        if (Registry.is((String)"json.schema.object.v2") && (schemaRootOrNull = JsonSchemaObjectStorage.getInstance(this.myProject).getOrComputeSchemaRootObject(file)) != null) {
            String schemaPropertyValue = schemaRootOrNull.getSchema();
            return schemaPropertyValue == null ? null : JsonSchemaVersion.byId(schemaPropertyValue);
        }
        Ref res = Ref.create(null);
        ApplicationManager.getApplication().runReadAction(() -> res.set((Object)JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject)));
        String schemaPropertyValue = (String)res.get();
        return schemaPropertyValue == null ? null : JsonSchemaVersion.byId(schemaPropertyValue);
    }

    private boolean hasSchemaSchema(VirtualFile file) {
        return this.getSchemaVersionFromSchemaUrl(file) != null;
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file, @NotNull JsonSchemaFileProvider provider2) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(39);
        }
        if (provider2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(40);
        }
        return provider2.isAvailable(file);
    }

    @Nullable
    private VirtualFile resolveSchemaFromOtherSources(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(41);
        }
        return this.myCatalogManager.getSchemaFileForFile(file);
    }

    @Override
    public void registerRemoteUpdateCallback(@NotNull Runnable callback2) {
        if (callback2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(42);
        }
        this.myCatalogManager.registerCatalogUpdateCallback(callback2);
    }

    @Override
    public void unregisterRemoteUpdateCallback(@NotNull Runnable callback2) {
        if (callback2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(43);
        }
        this.myCatalogManager.unregisterCatalogUpdateCallback(callback2);
    }

    @Override
    public void registerResetAction(Runnable action2) {
        this.myResetActions.add(action2);
    }

    @Override
    public void unregisterResetAction(Runnable action2) {
        this.myResetActions.remove(action2);
    }

    @Override
    public void registerReference(String ref) {
        int index = StringUtil.lastIndexOfAny((CharSequence)ref, (String)"\\/");
        if (index >= 0) {
            ref = ref.substring(index + 1);
        }
        this.myRefs.add(ref);
    }

    @Override
    public boolean possiblyHasReference(String ref) {
        return this.myRefs.contains(ref);
    }

    @Override
    public void triggerUpdateRemote() {
        this.myCatalogManager.triggerUpdateCatalog(this.myProject);
    }

    @Override
    public boolean isApplicableToFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        for (JsonSchemaEnabler e : JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!e.isEnabledForFile(file, this.myProject)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JsonSchemaCatalogManager getCatalogManager() {
        JsonSchemaCatalogManager jsonSchemaCatalogManager = this.myCatalogManager;
        if (jsonSchemaCatalogManager == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(44);
        }
        return jsonSchemaCatalogManager;
    }

    @Nullable
    private static VirtualFile getSchemaForProvider(@NotNull Project project2, @NotNull JsonSchemaFileProvider provider2) {
        String source2;
        if (project2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(45);
        }
        if (provider2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(46);
        }
        if (JsonSchemaCatalogProjectConfiguration.getInstance(project2).isPreferRemoteSchemas() && (source2 = provider2.getRemoteSource()) != null && !source2.endsWith("!") && !JsonFileResolver.isSchemaUrl(source2)) {
            return VirtualFileManager.getInstance().findFileByUrl(source2);
        }
        return provider2.getSchemaFile();
    }

    @Override
    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile rawFile;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(47);
        }
        if ((rawFile = schemaObject.getRawFile()) != null) {
            return rawFile;
        }
        String fileUrl = schemaObject.getFileUrl();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(fileUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 2: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 3: 
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFactories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFilesForFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasForFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForFile";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalogManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 44: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaFileByReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltInSchemaByReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFilesForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicSchemaForFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSchemasForFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromSchemaProperty";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObjectForSchemaFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isMappedSchema";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaByProvider";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersion";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersionFromSchemaUrl";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isProviderAvailable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFromOtherSources";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerRemoteUpdateCallback";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "unregisterRemoteUpdateCallback";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaForProvider";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 8, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 44 -> new IllegalStateException(string2);
        };
    }

    private final class JsonSchemaProviderFactories {
        private volatile List<JsonSchemaFileProvider> myProviders;

        private JsonSchemaProviderFactories() {
        }

        @NotNull
        public List<JsonSchemaFileProvider> getProviders() {
            List<JsonSchemaFileProvider> providers = this.myProviders;
            if (providers == null) {
                this.myProviders = providers = this.getDumbAwareProvidersAndUpdateRestWhenSmart();
            }
            List<JsonSchemaFileProvider> list2 = providers;
            if (list2 == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void reset() {
            this.myProviders = null;
        }

        @NotNull
        private List<JsonSchemaFileProvider> getDumbAwareProvidersAndUpdateRestWhenSmart() {
            ArrayList<JsonSchemaProviderFactory> readyFactories = new ArrayList<JsonSchemaProviderFactory>();
            ArrayList<JsonSchemaProviderFactory> notReadyFactories = new ArrayList<JsonSchemaProviderFactory>();
            boolean dumb = DumbService.getInstance((Project)JsonSchemaServiceImpl.this.myProject).isDumb();
            for (JsonSchemaProviderFactory factory : JsonSchemaServiceImpl.this.getProviderFactories()) {
                if (!dumb || DumbService.isDumbAware((Object)factory)) {
                    readyFactories.add(factory);
                    continue;
                }
                notReadyFactories.add(factory);
            }
            List<JsonSchemaFileProvider> providers = this.getProvidersFromFactories(readyFactories);
            this.myProviders = providers;
            if (!notReadyFactories.isEmpty() && !LightEdit.owns((Project)JsonSchemaServiceImpl.this.myProject)) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (JsonSchemaServiceImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    DumbService.getInstance((Project)JsonSchemaServiceImpl.this.myProject).runReadActionInSmartMode(() -> {
                        List<JsonSchemaFileProvider> newProviders;
                        if (this.myProviders == providers && !(newProviders = this.getProvidersFromFactories(notReadyFactories)).isEmpty()) {
                            List<JsonSchemaFileProvider> oldProviders = this.myProviders;
                            this.myProviders = ContainerUtil.concat(oldProviders, newProviders);
                            JsonSchemaServiceImpl.this.resetWithCurrentFactories();
                        }
                    });
                });
            }
            List<JsonSchemaFileProvider> list2 = providers;
            if (list2 == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        private List<JsonSchemaFileProvider> getProvidersFromFactories(@NotNull List<JsonSchemaProviderFactory> factories) {
            if (factories == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(2);
            }
            ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
            for (JsonSchemaProviderFactory factory : factories) {
                try {
                    providers.addAll(factory.getProviders(JsonSchemaServiceImpl.this.myProject));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    PluginException.logPluginError((Logger)Logger.getInstance(JsonSchemaService.class), (String)e.toString(), (Throwable)e, factory.getClass());
                }
            }
            ArrayList<JsonSchemaFileProvider> arrayList = providers;
            if (arrayList == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$JsonSchemaProviderFactories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProviders";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDumbAwareProvidersAndUpdateRestWhenSmart";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$JsonSchemaProviderFactories";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProvidersFromFactories";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvidersFromFactories";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    private static final class MyState {
        @NotNull
        private final Supplier<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final Project myProject;
        @NotNull
        private final SynchronizedClearableLazy<Map<VirtualFile, List<JsonSchemaFileProvider>>> myData;

        private MyState(@NotNull Supplier<List<JsonSchemaFileProvider>> factory, @NotNull Project project2) {
            if (factory == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                MyState.$$$reportNull$$$0(1);
            }
            this.myFactory = factory;
            this.myProject = project2;
            this.myData = new SynchronizedClearableLazy(() -> MyState.createFileProviderMap(this.myFactory.get(), this.myProject));
        }

        public void reset() {
            this.myData.drop();
        }

        public void processProviders(@NotNull Consumer<JsonSchemaFileProvider> consumer) {
            Map map2;
            if (consumer == null) {
                MyState.$$$reportNull$$$0(2);
            }
            if ((map2 = (Map)this.myData.getValue()).isEmpty()) {
                return;
            }
            for (List providers : map2.values()) {
                providers.forEach(consumer);
            }
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set<VirtualFile> set = ((Map)this.myData.getValue()).keySet();
            if (set == null) {
                MyState.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file) {
            List providers;
            if (file == null) {
                MyState.$$$reportNull$$$0(4);
            }
            if ((providers = (List)((Map)this.myData.getValue()).get(file)) == null || providers.isEmpty()) {
                return null;
            }
            for (JsonSchemaFileProvider p : providers) {
                if (p.getSchemaType() != SchemaType.userSchema) continue;
                return p;
            }
            return (JsonSchemaFileProvider)providers.get(0);
        }

        public boolean isComputed() {
            return this.myData.isInitialized();
        }

        @NotNull
        private static Map<VirtualFile, List<JsonSchemaFileProvider>> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2, @NotNull Project project2) {
            if (list2 == null) {
                MyState.$$$reportNull$$$0(5);
            }
            if (project2 == null) {
                MyState.$$$reportNull$$$0(6);
            }
            HashMap<VirtualFile, List<JsonSchemaFileProvider>> map2 = new HashMap<VirtualFile, List<JsonSchemaFileProvider>>();
            for (JsonSchemaFileProvider provider2 : list2) {
                VirtualFile schemaFile;
                try {
                    schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(project2, provider2);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (schemaFile == null) continue;
                map2.computeIfAbsent(schemaFile, __ -> new SmartList()).add(provider2);
            }
            HashMap<VirtualFile, List<JsonSchemaFileProvider>> hashMap = map2;
            if (hashMap == null) {
                MyState.$$$reportNull$$$0(7);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFileProviderMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processProviders";
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileProviderMap";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 7 -> new IllegalStateException(string2);
            };
        }
    }
}

