/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.nodes;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.URLUtil;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.light.RawJsonSchemaNodeAccessor;
import com.jetbrains.jsonSchema.impl.light.nodes.JacksonSchemaNodeAccessor;
import com.jetbrains.jsonSchema.impl.light.nodes.SchemaParsingUtilsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J)\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013J1\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J+\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001eJ=\u0010\u001f\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020 \u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017JC\u0010!\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0 \u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017J1\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017J+\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010&J+\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010(J+\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010(J1\u0010*\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0005H\u0016J+\u0010.\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/nodes/JacksonSchemaNodeAccessor;", "Lcom/jetbrains/jsonSchema/impl/light/RawJsonSchemaNodeAccessor;", "Lcom/fasterxml/jackson/databind/JsonNode;", "()V", "adaptJsonPointerToJacksonImplementation", "", "oldPointer", "asDoubleQuotedTextOrNull", "jsonNode", "escapeAndCompileJsonPointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "unescapedPointer", "fastCheckIfCorrectPointer", "", "maybeIncorrectPointer", "getChild", "node", "relativePath", "", "(Lcom/fasterxml/jackson/databind/JsonNode;[Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;", "getChildArrayItems", "Lkotlin/sequences/Sequence;", "name", "(Lcom/fasterxml/jackson/databind/JsonNode;[Ljava/lang/String;)Lkotlin/sequences/Sequence;", "hasChildNode", "relativeChildPath", "(Lcom/fasterxml/jackson/databind/JsonNode;[Ljava/lang/String;)Z", "readAnything", "", "readBooleanNodeValue", "(Lcom/fasterxml/jackson/databind/JsonNode;[Ljava/lang/String;)Ljava/lang/Boolean;", "readNodeAsMapEntries", "Lkotlin/Pair;", "readNodeAsMultiMapEntries", "", "readNodeKeys", "readNumberNodeValue", "", "(Lcom/fasterxml/jackson/databind/JsonNode;[Ljava/lang/String;)Ljava/lang/Number;", "readTextNodeValue", "(Lcom/fasterxml/jackson/databind/JsonNode;[Ljava/lang/String;)Ljava/lang/String;", "readUntypedNodeValueAsText", "readUntypedNodesCollection", "resolveNode", "rootNode", "absoluteNodeJsonPointer", "resolveRelativeNode", "intellij.json"})
@SourceDebugExtension(value={"SMAP\nschemaParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 schemaParsingUtils.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JacksonSchemaNodeAccessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n1#2:172\n1284#3,3:173\n12720#4,3:176\n14#5:179\n37#6,2:180\n9#7:182\n*S KotlinDebug\n*F\n+ 1 schemaParsingUtils.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JacksonSchemaNodeAccessor\n*L\n23#1:173,3\n104#1:176,3\n113#1:179\n127#1:180,2\n144#1:182\n*E\n"})
public final class JacksonSchemaNodeAccessor
implements RawJsonSchemaNodeAccessor<JsonNode> {
    @NotNull
    public static final JacksonSchemaNodeAccessor INSTANCE = new JacksonSchemaNodeAccessor();

    private JacksonSchemaNodeAccessor() {
    }

    @Override
    @Nullable
    public JsonNode resolveNode(@NotNull JsonNode rootNode, @NotNull String absoluteNodeJsonPointer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)absoluteNodeJsonPointer, (String)"absoluteNodeJsonPointer");
        JsonPointer jsonPointer = this.escapeAndCompileJsonPointer(absoluteNodeJsonPointer);
        if (jsonPointer == null) {
            return null;
        }
        JsonPointer compiledPointer = jsonPointer;
        JsonNode jsonNode = rootNode.at(compiledPointer);
        if (jsonNode != null) {
            JsonNode jsonNode2;
            JsonNode it = jsonNode2 = jsonNode;
            boolean bl = false;
            object = !(it instanceof MissingNode) ? jsonNode2 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JsonNode resolveRelativeNode(@NotNull JsonNode node, String ... relativeChildPath) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        Sequence $this$fold$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])relativeChildPath), (Function1)resolveRelativeNode.1.INSTANCE);
        boolean $i$f$fold = false;
        JsonNode accumulator$iv = node;
        for (Object element$iv : $this$fold$iv) {
            void childName;
            String string2 = (String)element$iv;
            JsonNode currentNode = accumulator$iv;
            boolean bl = false;
            JsonNode childByName = currentNode.get((String)childName);
            JsonNode jsonNode2 = childByName;
            if (jsonNode2 == null) {
                Integer n = StringsKt.toIntOrNull((String)childName);
                if (n == null) {
                    MissingNode missingNode = MissingNode.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)missingNode, (String)"getInstance(...)");
                    jsonNode2 = (JsonNode)missingNode;
                } else {
                    int maybeIndex = n;
                    return currentNode.get(maybeIndex);
                }
            }
            accumulator$iv = jsonNode2;
        }
        JsonNode it = jsonNode = accumulator$iv;
        boolean bl = false;
        return !(it instanceof MissingNode) ? jsonNode : null;
    }

    @Override
    public boolean hasChildNode(@NotNull JsonNode node, String ... relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        if (!node.isObject()) {
            return false;
        }
        return !this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length)).isMissingNode();
    }

    @Override
    @Nullable
    public String readUntypedNodeValueAsText(@NotNull JsonNode node, String ... relativeChildPath) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        if (!node.isObject()) {
            return null;
        }
        JsonNode it = jsonNode = this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        boolean bl = false;
        JsonNode jsonNode2 = !(it instanceof MissingNode) ? jsonNode : null;
        return jsonNode2 != null ? jsonNode2.asText() : null;
    }

    @Override
    @Nullable
    public String readTextNodeValue(@NotNull JsonNode node, String ... relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        if (!node.isObject()) {
            return null;
        }
        JsonNode maybeString = this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        return maybeString.isTextual() ? maybeString.asText() : null;
    }

    @Override
    @Nullable
    public Boolean readBooleanNodeValue(@NotNull JsonNode node, String ... relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        if (!node.isObject()) {
            return null;
        }
        JsonNode maybeBoolean = this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        return maybeBoolean.isBoolean() ? Boolean.valueOf(maybeBoolean.asBoolean()) : null;
    }

    @Override
    @Nullable
    public Number readNumberNodeValue(@NotNull JsonNode node, String ... relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        if (!node.isObject()) {
            return null;
        }
        JsonNode maybeNumber = this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        return maybeNumber.isInt() ? (Number)maybeNumber.asInt() : (Number)(maybeNumber.isDouble() ? (Number)maybeNumber.asDouble() : (Number)(maybeNumber.isLong() ? (Number)maybeNumber.asLong() : null));
    }

    @Override
    @Nullable
    public Sequence<Object> readUntypedNodesCollection(@NotNull JsonNode node, String ... relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        Sequence<JsonNode> sequence = this.getChildArrayItems(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        return sequence != null ? SequencesKt.mapNotNull(sequence, (Function1)((Function1)new Function1<JsonNode, Object>((Object)INSTANCE){

            @Nullable
            public final Object invoke(@NotNull JsonNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JacksonSchemaNodeAccessor.access$readAnything((JacksonSchemaNodeAccessor)this.receiver, p0);
            }
        })) : null;
    }

    @Override
    @Nullable
    public Sequence<Pair<String, JsonNode>> readNodeAsMapEntries(@NotNull JsonNode node, String ... relativeChildPath) {
        Sequence sequence;
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        if (!node.isObject()) {
            return null;
        }
        JsonNode it = object = this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        boolean bl = false;
        JsonNode jsonNode = it.isObject() ? object : null;
        return jsonNode != null && (object = jsonNode.fields()) != null && (sequence = SequencesKt.asSequence((Iterator)object)) != null ? SequencesKt.map((Sequence)sequence, (Function1)readNodeAsMapEntries.2.INSTANCE) : null;
    }

    @Override
    @Nullable
    public Sequence<Pair<String, List<String>>> readNodeAsMultiMapEntries(@NotNull JsonNode node, String ... relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        Sequence<Pair<String, JsonNode>> sequence = this.readNodeAsMapEntries(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        return sequence != null ? SequencesKt.mapNotNull(sequence, (Function1)readNodeAsMultiMapEntries.1.INSTANCE) : null;
    }

    @Override
    @Nullable
    public Sequence<String> readNodeKeys(@NotNull JsonNode node, String ... relativeChildPath) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        JsonNode expandedNode = relativeChildPath.length == 0 ? node : this.getChild(node, Arrays.copyOf(relativeChildPath, relativeChildPath.length));
        Iterator p0 = iterator = expandedNode.fieldNames();
        boolean bl = false;
        Iterator iterator2 = p0.hasNext() ? iterator : null;
        return iterator2 != null ? SequencesKt.asSequence((Iterator)iterator2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode getChild(JsonNode node, String ... relativePath) {
        String[] $this$fold$iv = relativePath;
        boolean $i$f$fold = false;
        JsonNode accumulator$iv = node;
        int n = $this$fold$iv.length;
        for (int i = 0; i < n; ++i) {
            void childName;
            JsonNode jsonNode;
            String element$iv;
            String string2 = element$iv = $this$fold$iv[i];
            JsonNode parentNode = accumulator$iv;
            boolean bl = false;
            JsonNode jsonNode2 = jsonNode = parentNode.get((String)childName);
            if (jsonNode2 == null) {
                MissingNode missingNode = MissingNode.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)missingNode, (String)"getInstance(...)");
                return (JsonNode)missingNode;
            }
            Intrinsics.checkNotNull((Object)jsonNode2);
            accumulator$iv = jsonNode;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Sequence<JsonNode> getChildArrayItems(JsonNode node, String ... name) {
        void $this$asSafely$iv;
        JsonNode jsonNode;
        if (!node.isObject()) {
            return null;
        }
        JsonNode it = jsonNode = this.getChild(node, Arrays.copyOf(name, name.length));
        boolean bl = false;
        if (!it.isArray()) return null;
        JsonNode jsonNode2 = jsonNode;
        JsonNode jsonNode3 = jsonNode2;
        if (jsonNode3 == null) return null;
        it = jsonNode3;
        boolean $i$f$asSafely = false;
        Object v1 = $this$asSafely$iv;
        if (!(v1 instanceof ArrayNode)) {
            v1 = null;
        }
        if ((jsonNode = (ArrayNode)v1) == null) return null;
        Iterator iterator = jsonNode.elements();
        if (iterator == null) return null;
        Sequence sequence = SequencesKt.asSequence((Iterator)iterator);
        return sequence;
    }

    private final Object readAnything(JsonNode node) {
        Object object;
        if (node.isTextual()) {
            object = this.asDoubleQuotedTextOrNull(node);
        } else if (node.isNull()) {
            object = node.asText();
        } else if (node.isInt()) {
            object = node.asInt();
        } else if (node.isLong()) {
            object = node.asLong();
        } else if (node.isDouble()) {
            object = node.asDouble();
        } else if (node.isBoolean()) {
            object = node.asBoolean();
        } else if (node.isObject()) {
            Iterator iterator = node.fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
            object = new EnumObjectValueWrapper(MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)readAnything.1.INSTANCE)));
        } else if (node.isArray()) {
            Iterator iterator = node.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<JsonNode, Object>((Object)INSTANCE){

                @Nullable
                public final Object invoke(@NotNull JsonNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return JacksonSchemaNodeAccessor.access$readAnything((JacksonSchemaNodeAccessor)this.receiver, p0);
                }
            })));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EnumArrayValueWrapper enumArrayValueWrapper = new EnumArrayValueWrapper(thisCollection$iv.toArray(new Object[0]));
            object = enumArrayValueWrapper;
        } else {
            object = null;
        }
        return object;
    }

    private final String asDoubleQuotedTextOrNull(JsonNode jsonNode) {
        if (!jsonNode.isTextual()) {
            return null;
        }
        String string2 = jsonNode.asText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
        return SchemaParsingUtilsKt.asDoubleQuotedString(string2);
    }

    private final JsonPointer escapeAndCompileJsonPointer(String unescapedPointer) {
        JsonPointer jsonPointer;
        if (!this.fastCheckIfCorrectPointer(unescapedPointer)) {
            return null;
        }
        try {
            jsonPointer = JsonPointer.compile((String)this.adaptJsonPointerToJacksonImplementation(unescapedPointer));
        }
        catch (IllegalArgumentException exception) {
            JacksonSchemaNodeAccessor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JacksonSchemaNodeAccessor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to compile json pointer. Resolve aborted.", (Throwable)exception);
            jsonPointer = null;
        }
        return jsonPointer;
    }

    private final boolean fastCheckIfCorrectPointer(String maybeIncorrectPointer) {
        return StringsKt.startsWith$default((String)maybeIncorrectPointer, (String)"/", (boolean)false, (int)2, null);
    }

    private final String adaptJsonPointerToJacksonImplementation(String oldPointer) {
        String string2;
        if (Intrinsics.areEqual((Object)oldPointer, (Object)"/")) {
            string2 = "";
        } else {
            String string3 = URLUtil.unescapePercentSequences((String)oldPointer);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"unescapePercentSequences(...)");
        }
        return string2;
    }

    public static final /* synthetic */ Object access$readAnything(JacksonSchemaNodeAccessor $this, JsonNode node) {
        return $this.readAnything(node);
    }
}

