/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ArrayValidation
implements JsonSchemaValidation {
    public static final ArrayValidation INSTANCE = new ArrayValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        ArrayValidation.checkArray(propValue, schema, consumer, options);
    }

    private static void checkArray(JsonValueAdapter value2, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        JsonArrayValueAdapter asArray = value2.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        ArrayValidation.checkArrayItems(value2, elements, schema, consumer, options);
    }

    private static void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        if (array == null) {
            ArrayValidation.$$$reportNull$$$0(0);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(1);
        }
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(array.getDelegate(), schema);
            assert (walker != null);
            for (JsonValueAdapter adapter : list2) {
                valueTexts.putValue((Object)walker.getNodeTextForValidation(adapter.getDelegate()), (Object)adapter);
            }
            for (Map.Entry entry2 : valueTexts.entrySet()) {
                if (((Collection)entry2.getValue()).size() <= 1) continue;
                for (JsonValueAdapter item2 : (Collection)entry2.getValue()) {
                    if (!item2.shouldCheckAsValue()) continue;
                    consumer.error(JsonBundle.message("schema.validation.not.unique", new Object[0]), item2.getDelegate(), JsonErrorPriority.TYPE_MISMATCH);
                }
            }
        }
        if (schema.getContainsSchema() != null) {
            boolean match2 = false;
            for (JsonValueAdapter item3 : list2) {
                JsonValidationHost checker = consumer.checkByMatchResult(item3, consumer.resolve(schema.getContainsSchema()), options);
                if (checker != null && !checker.isValid()) continue;
                match2 = true;
                break;
            }
            if (!match2) {
                consumer.error(JsonBundle.message("schema.validation.array.not.contains", new Object[0]), array.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
        }
        if (schema.getItemsSchema() != null) {
            for (JsonValueAdapter item4 : list2) {
                consumer.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), item4);
            }
        } else if (schema.getItemsSchemaList() != null) {
            Iterator<? extends JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator.hasNext()) {
                    consumer.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                    consumer.error(JsonBundle.message("schema.validation.array.no.extra", new Object[0]), arrayValue.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    continue;
                }
                if (schema.getAdditionalItemsSchema() == null) continue;
                consumer.checkObjectBySchemaRecordErrors(schema.getAdditionalItemsSchema(), arrayValue);
            }
        }
        if (schema.getMinItems() != null && list2.size() < schema.getMinItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema.getMinItems()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxItems() != null && list2.size() > schema.getMaxItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema.getMaxItems()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMinLength() != null && list2.size() < schema.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema.getMinLength()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxLength() != null && list2.size() > schema.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema.getMaxLength()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "array";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/validations/ArrayValidation";
        objectArray[2] = "checkArrayItems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

