/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlIconProviderKt;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a(\u0010\f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"githubActionsFilePattern", "Lkotlin/text/Regex;", "githubWorkflowsFilePattern", "isGithubActionFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "isGithubActionsFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isGithubSchemaAssigned", "schemaNames", "", "", "isGithubWorkflowFile", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\ngithubYamlFileDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 githubYamlFileDetection.kt\norg/jetbrains/plugins/github/extensions/GithubYamlFileDetectionKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n31#2,2:62\n1747#3,3:64\n*S KotlinDebug\n*F\n+ 1 githubYamlFileDetection.kt\norg/jetbrains/plugins/github/extensions/GithubYamlFileDetectionKt\n*L\n35#1:62,2\n36#1:64,3\n*E\n"})
public final class GithubYamlFileDetectionKt {
    @NotNull
    private static final Regex githubActionsFilePattern = new Regex(((Object)StringUtil.newBombedCharSequence((CharSequence)"^.*/\\.github/.*/action\\.ya?ml$", (long)1000L)).toString());
    @NotNull
    private static final Regex githubWorkflowsFilePattern = new Regex(((Object)StringUtil.newBombedCharSequence((CharSequence)"^.*/\\.github/workflows/.*\\.(ya?ml)$", (long)1000L)).toString());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGithubActionsFile(@NotNull VirtualFile virtualFile, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (project == null) {
            return false;
        }
        boolean isYamlFile = FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)YAMLFileType.YML);
        if (!isYamlFile) return false;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return false;
        }
        if (!GithubYamlFileDetectionKt.isGithubActionsFile(psiFile)) return false;
        return true;
    }

    public static final boolean isGithubActionsFile(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), () -> GithubYamlFileDetectionKt.isGithubActionsFile$lambda$0(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final boolean isGithubSchemaAssigned(Project project, VirtualFile virtualFile, Set<String> schemaNames) {
        boolean bl;
        block5: {
            if (project == null) {
                return false;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JsonSchemaService> serviceClass$iv = JsonSchemaService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Collection collection = ((JsonSchemaService)object).getSchemaFilesForFile(virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSchemaFilesForFile(...)");
            Collection schemaFiles = collection;
            Iterable $this$any$iv = schemaFiles;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!schemaNames.contains(it.getNameWithoutExtension())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean schemaAssigned = bl;
        return schemaAssigned;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGithubActionFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiFile psiFile2 = psiFile.getOriginalFile();
        if (psiFile2 == null) return false;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            return false;
        }
        boolean schemaAssigned = GithubYamlFileDetectionKt.isGithubSchemaAssigned(psiFile.getProject(), virtualFile2, GithubYamlIconProviderKt.getGITHUB_ACTION_SCHEMA_NAMES());
        if (psiFile.getLanguage().is((Language)YAMLLanguage.INSTANCE)) {
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (githubActionsFilePattern.matches((CharSequence)string)) return true;
        }
        if (!schemaAssigned) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGithubWorkflowFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiFile psiFile2 = psiFile.getOriginalFile();
        if (psiFile2 == null) return false;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            return false;
        }
        boolean schemaAssigned = GithubYamlFileDetectionKt.isGithubSchemaAssigned(psiFile.getProject(), virtualFile2, GithubYamlIconProviderKt.getGITHUB_WORKFLOW_SCHEMA_NAMES());
        if (psiFile.getLanguage().is((Language)YAMLLanguage.INSTANCE)) {
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (githubWorkflowsFilePattern.matches((CharSequence)string)) return true;
        }
        if (!schemaAssigned) return false;
        return true;
    }

    private static final CachedValueProvider.Result isGithubActionsFile$lambda$0(PsiFile $psiFile) {
        Object[] objectArray = new Object[]{$psiFile.getManager().getModificationTracker().forLanguage((Language)YAMLLanguage.INSTANCE)};
        return CachedValueProvider.Result.create((Object)(GithubYamlFileDetectionKt.isGithubActionFile($psiFile) || GithubYamlFileDetectionKt.isGithubWorkflowFile($psiFile) ? 1 : 0), (Object[])objectArray);
    }
}

