/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.review;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProviderKt;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRReviewBranchStateSharedViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.review.GHPRBranchWidgetViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model.GHPRToolWindowProjectViewModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0016R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/review/GHPRBranchWidgetViewModelImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/review/GHPRBranchWidgetViewModel;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "settings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "projectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowProjectViewModel;", "sharedBranchVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRReviewBranchStateSharedViewModel;", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowProjectViewModel;Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRReviewBranchStateSharedViewModel;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "cs", "dataLoadingState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/collaboration/util/ComputedResult;", "", "getDataLoadingState", "()Lkotlinx/coroutines/flow/StateFlow;", "editorReviewEnabled", "", "getEditorReviewEnabled", "getId", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "updateErrors", "Lkotlinx/coroutines/flow/SharedFlow;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getUpdateErrors", "()Lkotlinx/coroutines/flow/SharedFlow;", "updateRequired", "getUpdateRequired", "showPullRequest", "", "toggleEditorReview", "updateBranch", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRBranchWidgetViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRBranchWidgetViewModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/review/GHPRBranchWidgetViewModelImpl\n+ 2 CoroutineUtil.kt\ncom/intellij/collaboration/async/CoroutineUtilKt\n*L\n1#1,62:1\n24#2:63\n*S KotlinDebug\n*F\n+ 1 GHPRBranchWidgetViewModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/review/GHPRBranchWidgetViewModelImpl\n*L\n41#1:63\n*E\n"})
public final class GHPRBranchWidgetViewModelImpl
implements GHPRBranchWidgetViewModel {
    @NotNull
    private final GithubPullRequestsProjectUISettings settings;
    @NotNull
    private final GHPRToolWindowProjectViewModel projectVm;
    @NotNull
    private final GHPRReviewBranchStateSharedViewModel sharedBranchVm;
    @NotNull
    private final GHPRIdentifier id;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final StateFlow<Boolean> updateRequired;
    @NotNull
    private final StateFlow<ComputedResult<Object>> dataLoadingState;
    @NotNull
    private final StateFlow<Boolean> editorReviewEnabled;
    @NotNull
    private final SharedFlow<Exception> updateErrors;

    public GHPRBranchWidgetViewModelImpl(@NotNull CoroutineScope parentCs, @NotNull GithubPullRequestsProjectUISettings settings, @NotNull GHPRDataProvider dataProvider, @NotNull GHPRToolWindowProjectViewModel projectVm2, @NotNull GHPRReviewBranchStateSharedViewModel sharedBranchVm, @NotNull GHPRIdentifier id) {
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)projectVm2, (String)"projectVm");
        Intrinsics.checkNotNullParameter((Object)sharedBranchVm, (String)"sharedBranchVm");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.settings = settings;
        this.projectVm = projectVm2;
        this.sharedBranchVm = sharedBranchVm;
        this.id = id;
        GHPRBranchWidgetViewModelImpl $this$classAsCoroutineName$iv = this;
        boolean $i$f$classAsCoroutineName = false;
        String string = GHPRBranchWidgetViewModelImpl.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (CoroutineContext)((CoroutineContext)new CoroutineName(string)), (boolean)false, (int)2, null);
        this.updateRequired = this.sharedBranchVm.getUpdateRequired();
        this.dataLoadingState = CoroutineUtilKt.stateInNow((Flow)CoroutineUtilKt.computationState(GHPRChangesDataProviderKt.changesRequestFlow(dataProvider.getChangesData())), (CoroutineScope)this.cs, (Object)ComputedResult.box-impl((Result)ComputedResult.Companion.loading-uUe189E()));
        this.editorReviewEnabled = this.settings.getEditorReviewEnabledState();
        this.updateErrors = this.sharedBranchVm.getUpdateErrors();
    }

    @Override
    @NotNull
    public GHPRIdentifier getId() {
        return this.id;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getUpdateRequired() {
        return this.updateRequired;
    }

    @Override
    @NotNull
    public StateFlow<ComputedResult<Object>> getDataLoadingState() {
        return this.dataLoadingState;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getEditorReviewEnabled() {
        return this.editorReviewEnabled;
    }

    @Override
    @NotNull
    public SharedFlow<Exception> getUpdateErrors() {
        return this.updateErrors;
    }

    @Override
    public void showPullRequest() {
        GHPRToolWindowProjectViewModel.viewPullRequest$default(this.projectVm, this.getId(), false, 2, null);
    }

    @Override
    public void updateBranch() {
        this.sharedBranchVm.updateBranch();
    }

    @Override
    public void toggleEditorReview() {
        this.settings.setEditorReviewEnabled(!this.settings.getEditorReviewEnabled());
    }
}

