/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManagerKt;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponentBase;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogLoginPanel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponentBase;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/ModalityState;)V", "createAccountMenuLoginActions", "", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Action;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "createLoginAction", "createLoginPanel", "Ljavax/swing/JComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "cancelHandler", "Lkotlin/Function0;", "", "createLoginWithTokenAction", "getLoginPanel", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogLoginPanel;", "isAccountHandled", "", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHCloneDialogExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHCloneDialogExtension.kt\norg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,145:1\n43#2,3:146\n*S KotlinDebug\n*F\n+ 1 GHCloneDialogExtension.kt\norg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent\n*L\n47#1:146,3\n*E\n"})
final class GHCloneDialogExtensionComponent
extends GHCloneDialogExtensionComponentBase {
    public GHCloneDialogExtensionComponent(@NotNull Project project, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        super(project, modalityState, (GHAccountManager)((Object)object));
    }

    @Override
    protected boolean isAccountHandled(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        return GHAccountManagerKt.isGHAccount(account);
    }

    @Override
    @NotNull
    protected JComponent createLoginPanel(@NotNull CoroutineScope cs, @Nullable GithubAccount account, @NotNull Function0<Unit> cancelHandler) {
        GHCloneDialogLoginPanel gHCloneDialogLoginPanel;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter(cancelHandler, (String)"cancelHandler");
        GHCloneDialogLoginPanel $this$createLoginPanel_u24lambda_u240 = gHCloneDialogLoginPanel = new GHCloneDialogLoginPanel(cs, account);
        boolean bl = false;
        Function0<Unit> chooseLoginUiHandler2 = new Function0<Unit>($this$createLoginPanel_u24lambda_u240){
            final /* synthetic */ GHCloneDialogLoginPanel $this_apply;
            {
                this.$this_apply = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$this_apply.setChooseLoginUi();
            }
        };
        $this$createLoginPanel_u24lambda_u240.getLoginPanel().setCancelHandler(this.getAccounts().isEmpty() ? chooseLoginUiHandler2 : cancelHandler);
        GHCloneDialogLoginPanel it = gHCloneDialogLoginPanel;
        boolean bl2 = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)it);
        return (JComponent)((Object)gHCloneDialogLoginPanel);
    }

    @Override
    @NotNull
    protected Collection<AccountMenuItem.Action> createAccountMenuLoginActions(@Nullable GithubAccount account) {
        Object[] objectArray = new AccountMenuItem.Action[]{this.createLoginAction(account), this.createLoginWithTokenAction(account)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final AccountMenuItem.Action createLoginAction(GithubAccount account) {
        boolean isExistingAccount = account != null;
        String string = GithubBundle.message("login.via.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new AccountMenuItem.Action(string, (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                super(0);
            }

            public final void invoke() {
                block0: {
                    this.this$0.switchToLogin(this.$account);
                    GHCloneDialogLoginPanel gHCloneDialogLoginPanel = GHCloneDialogExtensionComponent.access$getLoginPanel(this.this$0);
                    if (gHCloneDialogLoginPanel == null) break block0;
                    gHCloneDialogLoginPanel.setOAuthLoginUi();
                }
            }
        }, null, !isExistingAccount, 4, null);
    }

    private final AccountMenuItem.Action createLoginWithTokenAction(GithubAccount account) {
        String string = CollaborationToolsBundle.message((String)"clone.dialog.login.with.token.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new AccountMenuItem.Action(string, (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                super(0);
            }

            public final void invoke() {
                block0: {
                    this.this$0.switchToLogin(this.$account);
                    GHCloneDialogLoginPanel gHCloneDialogLoginPanel = GHCloneDialogExtensionComponent.access$getLoginPanel(this.this$0);
                    if (gHCloneDialogLoginPanel == null) break block0;
                    gHCloneDialogLoginPanel.setTokenUi();
                }
            }
        }, null, false, 12, null);
    }

    private final GHCloneDialogLoginPanel getLoginPanel() {
        JComponent jComponent = this.getContent();
        return jComponent instanceof GHCloneDialogLoginPanel ? (GHCloneDialogLoginPanel)((Object)jComponent) : null;
    }

    public static final /* synthetic */ GHCloneDialogLoginPanel access$getLoginPanel(GHCloneDialogExtensionComponent $this) {
        return $this.getLoginPanel();
    }
}

