/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModChooseAction;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ActionHint {
    @NotNull
    private final String myExpectedText;
    private final boolean myShouldPresent;
    private final ProblemHighlightType myHighlightType;
    private final boolean myExactMatch;
    private final boolean myCheckPreview;

    private ActionHint(@NotNull String expectedText, boolean shouldPresent, ProblemHighlightType severity, boolean exactMatch, boolean preview) {
        if (expectedText == null) {
            ActionHint.$$$reportNull$$$0(0);
        }
        this.myExpectedText = expectedText;
        this.myShouldPresent = shouldPresent;
        this.myHighlightType = severity;
        this.myExactMatch = exactMatch;
        this.myCheckPreview = preview;
    }

    @NotNull
    public String getExpectedText() {
        String string = this.myExpectedText;
        if (string == null) {
            ActionHint.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean shouldPresent() {
        return this.myShouldPresent;
    }

    public boolean shouldCheckPreview() {
        return this.myCheckPreview;
    }

    @Nullable
    public IntentionAction findAndCheck(@NotNull Collection<? extends IntentionAction> actions, @NotNull Supplier<String> infoSupplier) {
        if (actions == null) {
            ActionHint.$$$reportNull$$$0(2);
        }
        if (infoSupplier == null) {
            ActionHint.$$$reportNull$$$0(3);
        }
        return this.findAndCheck(actions, null, infoSupplier);
    }

    @Nullable
    public IntentionAction findAndCheck(@NotNull Collection<? extends IntentionAction> actions, @Nullable ActionContext context2, @NotNull Supplier<String> infoSupplier) {
        if (actions == null) {
            ActionHint.$$$reportNull$$$0(4);
        }
        if (infoSupplier == null) {
            ActionHint.$$$reportNull$$$0(5);
        }
        String[] steps = this.myExpectedText.split("\\|->");
        CommonIntentionAction found2 = null;
        List commonActions = actions;
        for (int i2 = 0; i2 < steps.length; ++i2) {
            ModCommand command;
            ModCommandAction action;
            String curStep = steps[i2];
            found2 = (CommonIntentionAction)ContainerUtil.find(commonActions, t -> {
                String text = ActionHint.getActionText(context2, t);
                return this.myExactMatch ? text.equals(curStep) : text.startsWith(curStep);
            });
            if (i2 == steps.length - 1) break;
            if (context2 == null) {
                Assert.fail((String)"Action context is not supplied");
            }
            if (found2 == null) {
                Assert.fail((String)(this.exceptionHeader(curStep) + " not found\nAvailable actions: " + commonActions.stream().map(act -> ActionHint.getActionText(context2, act)).collect(Collectors.joining(", ", "[", "]\n")) + infoSupplier.get()));
            }
            if ((action = found2.asModCommandAction()) == null) {
                Assert.fail((String)(this.exceptionHeader(curStep) + " is not ModCommandAction"));
            }
            if (!((command = action.perform(context2)) instanceof ModChooseAction)) {
                Assert.fail((String)(this.exceptionHeader(curStep) + " does not produce a chooser"));
                return null;
            }
            ModChooseAction chooseAction = (ModChooseAction)command;
            commonActions = chooseAction.actions();
        }
        IntentionAction result2 = found2 == null ? null : found2.asIntention();
        String lastStep = steps[steps.length - 1];
        if (this.myShouldPresent) {
            if (result2 == null) {
                Assert.fail((String)(this.exceptionHeader(lastStep) + " not found\nAvailable actions: " + actions.stream().map(IntentionAction::getText).collect(Collectors.joining(", ", "[", "]\n")) + infoSupplier.get()));
            } else if (this.myHighlightType != null) {
                ProblemHighlightType actualType = QuickFixWrapper.getHighlightType((IntentionAction)(result2 = IntentionActionDelegate.unwrap((IntentionAction)result2)));
                if (actualType == null) {
                    Assert.fail((String)(this.exceptionHeader(lastStep) + " is not a LocalQuickFix, but " + result2.getClass().getName() + "\nExpected LocalQuickFix with ProblemHighlightType=" + this.myHighlightType + "\n" + infoSupplier.get()));
                }
                if (actualType != this.myHighlightType) {
                    Assert.fail((String)(this.exceptionHeader(lastStep) + " has wrong ProblemHighlightType.\nExpected: " + this.myHighlightType + "\nActual: " + actualType + "\n" + infoSupplier.get()));
                }
            }
        } else if (result2 != null) {
            Assert.fail((String)(this.exceptionHeader(lastStep) + " is present, but should not\n" + infoSupplier.get()));
        }
        return result2;
    }

    @NotNull
    private static String getActionText(@Nullable ActionContext context2, CommonIntentionAction t) {
        Presentation presentation;
        if (t instanceof IntentionAction) {
            IntentionAction intention = (IntentionAction)t;
            String string = intention.getText();
            if (string == null) {
                ActionHint.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (!(t instanceof ModCommandAction)) {
            throw new AssertionError((Object)("Action is not ModCommandAction: " + t));
        }
        ModCommandAction action = (ModCommandAction)t;
        if (context2 == null) {
            Assert.fail((String)"Context is not specified for ModCommandAction");
        }
        Object object = (presentation = action.getPresentation(context2)) == null ? "(unavailable) " + action.getFamilyName() : presentation.name();
        if (object == null) {
            ActionHint.$$$reportNull$$$0(7);
        }
        return object;
    }

    @NotNull
    private String exceptionHeader(String text) {
        String string = "Action with " + (this.myExactMatch ? "text" : "prefix") + " '" + text + "'";
        if (string == null) {
            ActionHint.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents) {
        if (file2 == null) {
            ActionHint.$$$reportNull$$$0(9);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(10);
        }
        return ActionHint.parse(file2, contents, true);
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents, boolean exactMatch) {
        PsiFile hostFile;
        Commenter commenter;
        String comment;
        if (file2 == null) {
            ActionHint.$$$reportNull$$$0(11);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(12);
        }
        if ((comment = (commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((hostFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2)).getLanguage())).getLineCommentPrefix()) == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        return ActionHint.parse(file2, contents, Pattern.quote(comment), exactMatch);
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents, @NotNull String commentPrefix, boolean exactMatch) {
        if (file2 == null) {
            ActionHint.$$$reportNull$$$0(13);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(14);
        }
        if (commentPrefix == null) {
            ActionHint.$$$reportNull$$$0(15);
        }
        Pattern pattern = Pattern.compile("^" + commentPrefix + " \"([^\n]*)\" \"(\\w+)(?:-(\\w+))?\".*", 32);
        Matcher matcher = pattern.matcher(contents);
        TestCase.assertTrue((String)("No comment found in " + file2.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        String state = matcher.group(2);
        String previewState = matcher.group(3);
        boolean checkPreview = "preview".equals(previewState);
        if (state.equals("true") || state.equals("false")) {
            return new ActionHint(text, Boolean.parseBoolean(state), null, exactMatch, checkPreview);
        }
        return new ActionHint(text, true, ProblemHighlightType.valueOf((String)state), exactMatch, checkPreview);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/ActionHint";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoSupplier";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/ActionHint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "exceptionHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAndCheck";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

