/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerTestUtil;
import com.intellij.compiler.server.BuildManager;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.LogSetup;
import org.junit.Assert;

public final class CompilerTester {
    private static final Logger LOG = Logger.getInstance(CompilerTester.class);
    private final Project myProject;
    private List<? extends Module> myModules;
    private TempDirTestFixture myMainOutput;

    public CompilerTester(@NotNull Module module2) throws Exception {
        if (module2 == null) {
            CompilerTester.$$$reportNull$$$0(0);
        }
        this(module2.getProject(), Collections.singletonList(module2), null);
    }

    public CompilerTester(@NotNull IdeaProjectTestFixture fixture, @NotNull List<? extends Module> modules) throws Exception {
        if (fixture == null) {
            CompilerTester.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            CompilerTester.$$$reportNull$$$0(2);
        }
        this(fixture.getProject(), modules, fixture.getTestRootDisposable());
    }

    public CompilerTester(@NotNull Project project2, @NotNull List<? extends Module> modules, @Nullable Disposable disposable) throws Exception {
        if (project2 == null) {
            CompilerTester.$$$reportNull$$$0(3);
        }
        if (modules == null) {
            CompilerTester.$$$reportNull$$$0(4);
        }
        this(project2, modules, disposable, true);
    }

    public CompilerTester(@NotNull Project project2, @NotNull List<? extends Module> modules, @Nullable Disposable disposable, boolean overrideJdkAndOutput) throws Exception {
        if (project2 == null) {
            CompilerTester.$$$reportNull$$$0(5);
        }
        if (modules == null) {
            CompilerTester.$$$reportNull$$$0(6);
        }
        this.myProject = project2;
        this.myModules = modules;
        this.myMainOutput = new TempDirTestFixtureImpl();
        this.myMainOutput.setUp();
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    CompilerTester.this.tearDown();
                }
            });
        }
        CompilerTestUtil.enableExternalCompiler();
        if (overrideJdkAndOutput) {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                Objects.requireNonNull(CompilerProjectExtension.getInstance((Project)this.getProject())).setCompilerOutputUrl(this.myMainOutput.findOrCreateDir("out").getUrl());
                if (!this.myModules.isEmpty()) {
                    JavaAwareProjectJdkTableImpl projectJdkTable = JavaAwareProjectJdkTableImpl.getInstanceEx();
                    if (project2.getBasePath() != null && WslPath.getDistributionByWindowsUncPath((String)project2.getBasePath()) == null) {
                        for (Module module2 : this.myModules) {
                            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)projectJdkTable.getInternalJdk());
                        }
                    }
                }
            });
            IndexingTestUtil.waitUntilIndexesAreReady(project2);
        }
    }

    public void tearDown() {
        try {
            RunAll.runAll(() -> this.myMainOutput.tearDown(), () -> CompilerTestUtil.disableExternalCompiler(this.getProject()));
        }
        finally {
            this.myMainOutput = null;
            this.myModules = null;
        }
    }

    private Project getProject() {
        return this.myProject;
    }

    public void deleteClassFile(@NotNull String className) throws IOException {
        if (className == null) {
            CompilerTester.$$$reportNull$$$0(7);
        }
        WriteAction.runAndWait(() -> this.touch(JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject())).getContainingFile().getVirtualFile()));
    }

    @Nullable
    public File findClassFile(String className, Module module2) {
        VirtualFile out = ((CompilerModuleExtension)ModuleRootManager.getInstance((Module)module2).getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
        assert (out != null);
        File cls = new File(out.getPath(), className.replace('.', '/') + ".class");
        return cls.exists() ? cls : null;
    }

    public void touch(VirtualFile file2) throws IOException {
        WriteAction.runAndWait(() -> {
            file2.setBinaryContent(file2.contentsToByteArray(), -1L, file2.getTimeStamp() + 1L);
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            assert (ioFile.setLastModified(ioFile.lastModified() - 100000L));
            file2.refresh(false, false);
        });
    }

    public void setFileText(PsiFile file2, String text) throws IOException {
        WriteAction.runAndWait(() -> {
            VirtualFile virtualFile = file2.getVirtualFile();
            VfsUtil.saveText((VirtualFile)Objects.requireNonNull(virtualFile), (String)text);
        });
        this.touch(file2.getVirtualFile());
    }

    public void setFileName(PsiFile file2, String name) {
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> file2.setName(name));
    }

    public List<CompilerMessage> make() {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).make(callback)));
    }

    public List<CompilerMessage> rebuild() {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).rebuild(callback)));
    }

    public List<CompilerMessage> compileModule(Module module2) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).compile(module2, callback)));
    }

    public List<CompilerMessage> make(CompileScope scope) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).make(scope, callback)));
    }

    public List<CompilerMessage> compileFiles(VirtualFile ... files) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).compile(files, callback)));
    }

    @NotNull
    public List<CompilerMessage> runCompiler(@NotNull Consumer<? super CompileStatusNotification> runnable2) {
        if (runnable2 == null) {
            CompilerTester.$$$reportNull$$$0(8);
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        ErrorReportingCallback callback = new ErrorReportingCallback(semaphore);
        PlatformTestUtil.saveProject(this.getProject(), false);
        CompilerTestUtil.saveApplicationSettings();
        EdtTestUtil.runInEdtAndWait(() -> {
            PathMacros pathMacroManager;
            Map map;
            if (!ProjectKt.isDirectoryBased((Project)this.myProject)) {
                for (Module module2 : this.myModules) {
                    Path ioFile = module2.getModuleNioFile();
                    assert (Files.exists(ioFile, new LinkOption[0])) : "File does not exist: " + ioFile;
                }
            }
            if (!(map = (pathMacroManager = PathMacros.getInstance()).getUserMacros()).isEmpty()) {
                Path macroFilePath = StoreUtilKt.getPersistentStateComponentStorageLocation(pathMacroManager.getClass());
                Assert.assertNotNull((Object)macroFilePath);
                if (!Files.exists(macroFilePath, new LinkOption[0])) {
                    String message = "File " + macroFilePath + " doesn't exist, but user macros defined: " + map;
                    LOG.warn(message);
                    String fakeMacroName = "__remove_me__";
                    IComponentStore appStore = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
                    pathMacroManager.setMacro(fakeMacroName, fakeMacroName);
                    appStore.saveComponent((PersistentStateComponent)pathMacroManager);
                    pathMacroManager.setMacro(fakeMacroName, null);
                    appStore.saveComponent((PersistentStateComponent)pathMacroManager);
                    if (!Files.exists(macroFilePath, new LinkOption[0])) {
                        throw new AssertionError((Object)message);
                    }
                }
            }
            CompilerTester.enableDebugLogging();
            runnable2.consume((Object)callback);
        });
        while (!semaphore.waitFor(100L)) {
            if (!SwingUtilities.isEventDispatchThread()) continue;
            UIUtil.dispatchAllInvocationEvents();
        }
        CompilerTester.printBuildLog();
        callback.throwException();
        if (!((CompilerManagerImpl)CompilerManager.getInstance((Project)this.getProject())).waitForExternalJavacToTerminate(1L, TimeUnit.MINUTES)) {
            throw new RuntimeException("External javac thread is still running. Thread dump:" + ThreadDumper.dumpThreadsToString());
        }
        this.checkVfsNotLoadedForOutput();
        List<CompilerMessage> list = callback.getMessages();
        if (list == null) {
            CompilerTester.$$$reportNull$$$0(9);
        }
        return list;
    }

    private void checkVfsNotLoadedForOutput() {
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module2);
            if (extension == null) continue;
            for (String url : extension.getOutputRootUrls(true)) {
                VirtualFile root = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
                if (root == null) continue;
                UsefulTestCase.assertEmpty("VFS should not be loaded for output: that increases the number of VFS events and reindexing costs", ((NewVirtualFile)root).getCachedChildren());
            }
        }
    }

    public static void printBuildLog() {
        File logDirectory = BuildManager.getBuildLogDirectory();
        File[] files = logDirectory.listFiles(file2 -> file2.getName().endsWith(".log"));
        if (files == null || files.length == 0) {
            LOG.debug("No *.log files in " + logDirectory + " after build");
            return;
        }
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file3 : files) {
            LOG.debug(file3.getName() + ":");
            try {
                List lines2 = FileUtil.loadLines((File)file3);
                for (String line : lines2) {
                    LOG.debug(line);
                }
            }
            catch (IOException e) {
                LOG.debug("Failed to load contents: " + e.getMessage());
            }
        }
    }

    public static void enableDebugLogging() {
        Path logDirectory = BuildManager.getBuildLogDirectory().toPath();
        try {
            NioFiles.deleteRecursively((Path)logDirectory);
            Files.createDirectories(logDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties properties = new Properties();
        try {
            try (InputStream config = LogSetup.readDefaultLogConfig();){
                properties.load(config);
            }
            properties.setProperty("log4j.rootLogger", "debug, file");
            Path logFile = logDirectory.resolve("build-log-jul.properties");
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(logFile, new OpenOption[0]));){
                properties.store(output, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/CompilerTester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/CompilerTester";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runCompiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteClassFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runCompiler";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static final class ErrorReportingCallback
    implements CompileStatusNotification {
        private final Semaphore mySemaphore;
        private Throwable myError;
        private final List<CompilerMessage> myMessages;

        ErrorReportingCallback(@NotNull Semaphore semaphore) {
            if (semaphore == null) {
                ErrorReportingCallback.$$$reportNull$$$0(0);
            }
            this.myMessages = new ArrayList<CompilerMessage>();
            this.mySemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(boolean aborted2, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (compileContext == null) {
                ErrorReportingCallback.$$$reportNull$$$0(1);
            }
            try {
                for (CompilerMessageCategory category : CompilerMessageCategory.values()) {
                    CompilerMessage[] messages;
                    for (CompilerMessage message : messages = compileContext.getMessages(category)) {
                        String text = message.getMessage();
                        if (category == CompilerMessageCategory.INFORMATION && ErrorReportingCallback.isSpamMessage(text)) continue;
                        this.myMessages.add(message);
                    }
                }
                Assert.assertFalse((String)"Code did not compile!", (boolean)aborted2);
            }
            catch (Throwable t) {
                this.myError = t;
            }
            finally {
                this.mySemaphore.up();
            }
        }

        private static boolean isSpamMessage(String text) {
            return text.contains("Build completed successfully in ") || text.contains("used to compile") || text.contains("illegal reflective") || text.contains("Picked up") || text.contains("consider reporting this to the maintainers") || text.contains("Errors occurred while compiling module") || text.startsWith("Using Groovy-Eclipse");
        }

        void throwException() {
            if (this.myError != null) {
                ExceptionUtil.rethrow((Throwable)this.myError);
            }
        }

        @NotNull
        public List<CompilerMessage> getMessages() {
            List<CompilerMessage> list = this.myMessages;
            if (list == null) {
                ErrorReportingCallback.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semaphore";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compileContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/CompilerTester$ErrorReportingCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/CompilerTester$ErrorReportingCallback";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "finished";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

