/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.testFramework.diagnostic.MetricsPublisher;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProfilerForTests;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.coroutines.CoroutineContext;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceTestInfo {
    private final ThrowableComputable<Integer, ?> test;
    private final int expectedInputSize;
    private ThrowableRunnable<?> setup;
    private int maxMeasurementAttempts;
    private final String launchName;
    private int warmupIterations;
    @NotNull
    private final IJTracer tracer;
    private static final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob(null).plus((CoroutineContext)Dispatchers.getIO()));

    private static void initOpenTelemetry() {
        System.setProperty("idea.diagnostic.opentelemetry.file", PathManager.getLogDir().resolve("opentelemetry.json").toAbsolutePath().toString());
        try {
            TelemetryManager.Companion.resetGlobalSdk();
            Class<?> telemetryClazz = Class.forName("com.intellij.platform.diagnostic.telemetry.impl.TelemetryManagerImpl");
            Object instance2 = Arrays.stream(telemetryClazz.getDeclaredConstructors()).filter(it -> it.getParameterCount() > 0).findFirst().get().newInstance(coroutineScope, true);
            TelemetryManager.Companion.forceSetTelemetryManager((TelemetryManager)instance2);
        }
        catch (Throwable e) {
            System.err.println("Couldn't setup TelemetryManager without TestApplication. Either test should use TestApplication or somewhere is a bug");
            e.printStackTrace();
        }
    }

    PerformanceTestInfo(@NotNull ThrowableComputable<Integer, ?> test, int expectedInputSize, @NotNull String launchName) {
        if (test == null) {
            PerformanceTestInfo.$$$reportNull$$$0(0);
        }
        if (launchName == null) {
            PerformanceTestInfo.$$$reportNull$$$0(1);
        }
        this.maxMeasurementAttempts = 3;
        this.warmupIterations = 1;
        PerformanceTestInfo.initOpenTelemetry();
        this.test = test;
        this.expectedInputSize = expectedInputSize;
        assert (expectedInputSize > 0) : "Expected input size must be > 0. Was: " + expectedInputSize;
        this.launchName = launchName;
        this.tracer = TelemetryManager.getInstance().getTracer(new Scope("performanceUnitTests", null));
    }

    @Contract(pure=true)
    public PerformanceTestInfo setup(@NotNull ThrowableRunnable<?> setup) {
        if (setup == null) {
            PerformanceTestInfo.$$$reportNull$$$0(2);
        }
        assert (this.setup == null);
        this.setup = setup;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo attempts(int attempts) {
        this.maxMeasurementAttempts = attempts;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo warmupIterations(int iterations) {
        this.warmupIterations = iterations;
        return this;
    }

    private static Method filterMethodFromStackTrace(Function<Method, Boolean> methodFilter) {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement element2 : stackTraceElements = Thread.currentThread().getStackTrace()) {
            try {
                Method foundMethod = (Method)ContainerUtil.find((Object[])Class.forName(element2.getClassName()).getDeclaredMethods(), method -> method.getName().equals(element2.getMethodName()) && (Boolean)methodFilter.apply((Method)method) != false);
                if (foundMethod == null) continue;
                return foundMethod;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method tryToFindCallingTestMethodByJUnitAnnotation() {
        return PerformanceTestInfo.filterMethodFromStackTrace(method -> ContainerUtil.exists((Object[])method.getDeclaredAnnotations(), annotation -> annotation.annotationType().getName().contains("junit")));
    }

    private static Method tryToFindCallingTestMethodByNamePattern() {
        return PerformanceTestInfo.filterMethodFromStackTrace(method -> method.getName().toLowerCase(Locale.ROOT).startsWith("test"));
    }

    private static Method getCallingTestMethod() {
        Method callingTestMethod = PerformanceTestInfo.tryToFindCallingTestMethodByJUnitAnnotation();
        if (callingTestMethod == null && (callingTestMethod = PerformanceTestInfo.tryToFindCallingTestMethodByNamePattern()) == null) {
            throw new AssertionError((Object)"Couldn't manage to detect the calling test method. Please use one of the overloads of com.intellij.testFramework.PerformanceTestInfo.start");
        }
        return callingTestMethod;
    }

    public void start() {
        this.start(PerformanceTestInfo.getCallingTestMethod());
    }

    public void start(@NotNull Method javaTestMethod) {
        if (javaTestMethod == null) {
            PerformanceTestInfo.$$$reportNull$$$0(3);
        }
        this.start(javaTestMethod, "");
    }

    public void start(@NotNull Method javaTestMethod, String subTestName) {
        if (javaTestMethod == null) {
            PerformanceTestInfo.$$$reportNull$$$0(4);
        }
        Object fullTestName = String.format("%s.%s", javaTestMethod.getDeclaringClass().getName(), javaTestMethod.getName());
        if (subTestName != null && !subTestName.isEmpty()) {
            fullTestName = (String)fullTestName + " - " + subTestName;
        }
        this.start((String)fullTestName);
    }

    public void start(@NotNull KFunction<?> kotlinTestMethod) {
        if (kotlinTestMethod == null) {
            PerformanceTestInfo.$$$reportNull$$$0(5);
        }
        this.start(String.format("%s.%s", kotlinTestMethod.getClass().getName(), kotlinTestMethod.getName()));
    }

    public void startAsSubtest() {
        this.startAsSubtest(this.launchName);
    }

    public void startAsSubtest(@Nullable String subTestName) {
        this.start(PerformanceTestInfo.getCallingTestMethod(), subTestName);
    }

    public void start(String fullQualifiedTestMethodName) {
        this.start(IterationMode.WARMUP, fullQualifiedTestMethodName);
        this.start(IterationMode.MEASURE, fullQualifiedTestMethodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(IterationMode iterationType, String fullQualifiedTestMethodName) {
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        System.out.printf("Starting performance test \"%s\" in mode: %s%n", new Object[]{fullQualifiedTestMethodName, iterationType});
        int maxIterationsNumber = iterationType.equals((Object)IterationMode.WARMUP) ? this.warmupIterations : this.maxMeasurementAttempts;
        if (maxIterationsNumber == 1) {
            System.gc();
        }
        try {
            TraceKt.computeWithSpanAttribute((IJTracer)this.tracer, (String)this.launchName, (String)"warmup", st -> String.valueOf(iterationType.equals((Object)IterationMode.WARMUP)), () -> {
                try {
                    PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                    for (int attempt = 1; attempt <= maxIterationsNumber; ++attempt) {
                        if (this.setup != null) {
                            this.setup.run();
                        }
                        AtomicInteger actualInputSize = new AtomicInteger(this.expectedInputSize);
                        Supplier<Object> perfTestWorkload = this.getPerfTestWorkloadSupplier(iterationType, attempt, actualInputSize);
                        TraceKt.computeWithSpanAttribute((IJTracer)this.tracer, (String)("Attempt: " + attempt), (String)"warmup", st -> String.valueOf(iterationType.equals((Object)IterationMode.WARMUP)), () -> perfTestWorkload.get());
                        if (!UsefulTestCase.IS_UNDER_TEAMCITY) {
                            // empty if block
                        }
                        System.gc();
                        StorageLockContext.forceDirectMemoryCache();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                    throw new RuntimeException(throwable);
                }
                return null;
            });
        }
        finally {
            try {
                if (iterationType.equals((Object)IterationMode.MEASURE)) {
                    MetricsPublisher.Companion.getInstance().publishSync(fullQualifiedTestMethodName, this.launchName);
                }
            }
            catch (Throwable t) {
                System.err.println("Something unexpected happened during publishing performance metrics");
                throw t;
            }
        }
    }

    @NotNull
    private Supplier<Object> getPerfTestWorkloadSupplier(IterationMode iterationType, int attempt, AtomicInteger actualInputSize) {
        Supplier<Object> supplier = () -> {
            try {
                Profiler.startProfiling(iterationType.name() + attempt);
                actualInputSize.set((Integer)this.test.compute());
            }
            catch (Throwable e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                Profiler.stopProfiling();
            }
            return null;
        };
        if (supplier == null) {
            PerformanceTestInfo.$$$reportNull$$$0(6);
        }
        return supplier;
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaTestMethod";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTestMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PerformanceTestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PerformanceTestInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerfTestWorkloadSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static enum IterationMode {
        WARMUP,
        MEASURE;

    }

    private static final class Profiler {
        private static final ProfilerForTests profiler = Profiler.getProfilerInstance();

        private Profiler() {
        }

        private static ProfilerForTests getProfilerInstance() {
            ServiceLoader<ProfilerForTests> loader = ServiceLoader.load(ProfilerForTests.class);
            for (ProfilerForTests service : loader) {
                if (service == null) continue;
                return service;
            }
            System.out.println("No service com.intellij.testFramework.Profiler is found in class path");
            return null;
        }

        public static void stopProfiling() {
            if (profiler != null) {
                try {
                    profiler.stopProfiling();
                }
                catch (IOException e) {
                    System.out.println("Can't stop profiling");
                }
            }
        }

        public static void startProfiling(String fileName) {
            Path logDir = PathManager.getLogDir();
            if (profiler != null) {
                try {
                    profiler.startProfiling(logDir, fileName);
                }
                catch (IOException e) {
                    System.out.println("Can't start profiling");
                }
            }
        }
    }
}

