/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.io.NettyUtil;

@TestOnly
@ApiStatus.Internal
public final class ThreadLeakTracker {
    private static final MethodHandle getThreads = ThreadLeakTracker.getThreadsMethodHandle();
    private static final Set<String> wellKnownOffenders;

    private ThreadLeakTracker() {
    }

    @NotNull
    public static Map<String, Thread> getThreads() {
        Thread[] threads;
        try {
            threads = getThreads.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (threads.length == 0) {
            Map<String, Thread> map = Collections.emptyMap();
            if (map == null) {
                ThreadLeakTracker.$$$reportNull$$$0(0);
            }
            return map;
        }
        HashMap<String, Thread> map = new HashMap<String, Thread>(threads.length);
        for (Thread thread : threads) {
            map.put(thread.getName(), thread);
        }
        HashMap<String, Thread> hashMap = map;
        if (hashMap == null) {
            ThreadLeakTracker.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    public static void longRunningThreadCreated(@NotNull Disposable parentDisposable, String ... threadNamePrefixes) {
        if (parentDisposable == null) {
            ThreadLeakTracker.$$$reportNull$$$0(2);
        }
        if (threadNamePrefixes == null) {
            ThreadLeakTracker.$$$reportNull$$$0(3);
        }
        ContainerUtil.addAll(wellKnownOffenders, (Object[])threadNamePrefixes);
        Disposer.register((Disposable)parentDisposable, () -> ContainerUtil.removeAll(wellKnownOffenders, (Object[])threadNamePrefixes));
    }

    public static void awaitQuiescence() {
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor((long)100L, (TimeUnit)TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
    }

    public static void checkLeak(@NotNull Map<String, Thread> threadsBefore) throws AssertionError {
        if (threadsBefore == null) {
            ThreadLeakTracker.$$$reportNull$$$0(4);
        }
        Map<String, Thread> all = ThreadLeakTracker.getThreads();
        HashMap<String, Thread> after2 = new HashMap<String, Thread>(all);
        after2.keySet().removeAll(threadsBefore.keySet());
        Map stackTraces = ContainerUtil.map2Map(after2.values(), thread -> new Pair(thread, (Object)thread.getStackTrace()));
        for (Thread thread2 : after2.values()) {
            ThreadLeakTracker.waitForThread(thread2, stackTraces, all, after2);
        }
    }

    private static void waitForThread(@NotNull Thread thread, @NotNull Map<Thread, StackTraceElement[]> stackTraces, @NotNull Map<String, Thread> all, @NotNull Map<String, Thread> after2) {
        if (thread == null) {
            ThreadLeakTracker.$$$reportNull$$$0(5);
        }
        if (stackTraces == null) {
            ThreadLeakTracker.$$$reportNull$$$0(6);
        }
        if (all == null) {
            ThreadLeakTracker.$$$reportNull$$$0(7);
        }
        if (after2 == null) {
            ThreadLeakTracker.$$$reportNull$$$0(8);
        }
        if (!ThreadLeakTracker.shouldWaitForThread(thread)) {
            return;
        }
        long start = System.currentTimeMillis();
        StackTraceElement[] traceBeforeWait = thread.getStackTrace();
        if (ThreadLeakTracker.shouldIgnore(thread, traceBeforeWait)) {
            return;
        }
        int WAIT_SEC = 10;
        long deadlineMs = start + TimeUnit.SECONDS.toMillis(WAIT_SEC);
        StackTraceElement[] stackTrace = traceBeforeWait;
        while (System.currentTimeMillis() < deadlineMs) {
            if (EDT.isCurrentThreadEdt()) {
                UIUtil.dispatchAllInvocationEvents();
            } else {
                UIUtil.pump();
            }
            if (!ThreadLeakTracker.shouldIgnore(thread, stackTrace = thread.getStackTrace())) continue;
        }
        stackTraces.put(thread, stackTrace);
        if (ThreadLeakTracker.shouldIgnore(thread, stackTrace)) {
            return;
        }
        all.keySet().removeAll(after2.keySet());
        Map otherStackTraces = ContainerUtil.map2Map(all.values(), t -> Pair.create((Object)t, (Object)t.getStackTrace()));
        String trace = PerformanceWatcher.printStacktrace((String)"", (Thread)thread, (StackTraceElement[])stackTrace);
        String traceBefore = PerformanceWatcher.printStacktrace((String)"", (Thread)thread, (StackTraceElement[])traceBeforeWait);
        String internalDiagnostic = ThreadLeakTracker.internalDiagnostic(stackTrace);
        throw new AssertionError((Object)("Thread leaked: " + traceBefore + (String)(trace.equals(traceBefore) ? "" : "(its trace after " + WAIT_SEC + " seconds wait:) " + trace) + internalDiagnostic + "\n\nLeaking threads dump:\n" + ThreadLeakTracker.dumpThreadsToString(after2, stackTraces) + "\n----\nAll other threads dump:\n" + ThreadLeakTracker.dumpThreadsToString(all, otherStackTraces)));
    }

    private static boolean shouldWaitForThread(@NotNull Thread thread) {
        if (thread == null) {
            ThreadLeakTracker.$$$reportNull$$$0(9);
        }
        if (thread == Thread.currentThread()) {
            return false;
        }
        ThreadGroup group = thread.getThreadGroup();
        return (group == null || !"system".equals(group.getName())) && thread.isAlive();
    }

    private static boolean shouldIgnore(@NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (thread == null) {
            ThreadLeakTracker.$$$reportNull$$$0(10);
        }
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(11);
        }
        if (!thread.isAlive()) {
            return true;
        }
        if (stackTrace.length == 0) {
            return true;
        }
        if (ThreadLeakTracker.isWellKnownOffender(thread.getName())) {
            return true;
        }
        return ThreadLeakTracker.isIdleApplicationPoolThread(stackTrace) || ThreadLeakTracker.isIdleCommonPoolThread(thread, stackTrace) || ThreadLeakTracker.isFutureTaskAboutToFinish(stackTrace) || ThreadLeakTracker.isIdleDefaultCoroutineExecutorThread(thread, stackTrace) || ThreadLeakTracker.isCoroutineSchedulerPoolThread(thread, stackTrace) || ThreadLeakTracker.isKotlinCIOSelector(stackTrace) || ThreadLeakTracker.isStarterTestFramework(stackTrace) || ThreadLeakTracker.isJMXRemoteCall(stackTrace);
    }

    private static boolean isWellKnownOffender(@NotNull String threadName) {
        if (threadName == null) {
            ThreadLeakTracker.$$$reportNull$$$0(12);
        }
        for (String t : wellKnownOffenders) {
            if (!threadName.contains(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIdleApplicationPoolThread(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(13);
        }
        return ContainerUtil.exists((Object[])stackTrace, element2 -> element2.getMethodName().equals("getTask") && element2.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
    }

    private static boolean isKotlinCIOSelector(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(14);
        }
        return ContainerUtil.exists((Object[])stackTrace, element2 -> element2.getMethodName().equals("select") && element2.getClassName().equals("io.ktor.network.selector.ActorSelectorManager"));
    }

    private static boolean isIdleCommonPoolThread(@NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (thread == null) {
            ThreadLeakTracker.$$$reportNull$$$0(15);
        }
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(16);
        }
        if (!ForkJoinWorkerThread.class.isAssignableFrom(thread.getClass())) {
            return false;
        }
        boolean insideAwaitWork = ContainerUtil.exists((Object[])stackTrace, element2 -> element2.getMethodName().equals("awaitWork") && element2.getClassName().equals("java.util.concurrent.ForkJoinPool"));
        if (insideAwaitWork) {
            return true;
        }
        return stackTrace.length > 2 && stackTrace[0].getClassName().endsWith(".Unsafe") && stackTrace[0].getMethodName().equals("park") && stackTrace[1].getClassName().equals("java.util.concurrent.locks.LockSupport") && stackTrace[1].getMethodName().equals("park") && stackTrace[2].getClassName().equals("java.util.concurrent.ForkJoinPool") && stackTrace[2].getMethodName().equals("runWorker");
    }

    private static boolean isFutureTaskAboutToFinish(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(17);
        }
        if (stackTrace.length < 5) {
            return false;
        }
        return stackTrace[0].getClassName().equals("sun.misc.Unsafe") && stackTrace[0].getMethodName().equals("unpark") && stackTrace[2].getClassName().equals("java.util.concurrent.FutureTask") && stackTrace[2].getMethodName().equals("finishCompletion");
    }

    private static boolean isIdleDefaultCoroutineExecutorThread(@NotNull Thread thread, @NotNull @NotNull StackTraceElement @NotNull [] stackTrace) {
        if (thread == null) {
            ThreadLeakTracker.$$$reportNull$$$0(18);
        }
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(19);
        }
        if (stackTrace.length != 4) {
            return false;
        }
        return "kotlinx.coroutines.DefaultExecutor".equals(thread.getName()) && (stackTrace[0].getClassName().equals("sun.misc.Unsafe") || stackTrace[0].getClassName().equals("jdk.internal.misc.Unsafe")) && stackTrace[0].getMethodName().equals("park") && stackTrace[2].getClassName().equals("kotlinx.coroutines.DefaultExecutor") && stackTrace[2].getMethodName().equals("run");
    }

    private static boolean isCoroutineSchedulerPoolThread(@NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (thread == null) {
            ThreadLeakTracker.$$$reportNull$$$0(20);
        }
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(21);
        }
        if (!"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker".equals(thread.getClass().getName())) {
            return false;
        }
        boolean insideCpuWorkerIdle = ContainerUtil.exists((Object[])stackTrace, element2 -> element2.getMethodName().equals("park") && element2.getClassName().equals("kotlinx.coroutines.scheduling.CoroutineScheduler$Worker"));
        return insideCpuWorkerIdle;
    }

    private static boolean isStarterTestFramework(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(22);
        }
        return ContainerUtil.exists((Object[])stackTrace, element2 -> element2.getClassName().contains("com.intellij.ide.starter"));
    }

    private static boolean isJMXRemoteCall(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(23);
        }
        return ContainerUtil.exists((Object[])stackTrace, element2 -> element2.getClassName().contains("com.sun.jmx.remote"));
    }

    @NotNull
    private static CharSequence dumpThreadsToString(@NotNull Map<String, Thread> after2, @NotNull Map<Thread, StackTraceElement[]> stackTraces) {
        if (after2 == null) {
            ThreadLeakTracker.$$$reportNull$$$0(24);
        }
        if (stackTraces == null) {
            ThreadLeakTracker.$$$reportNull$$$0(25);
        }
        StringBuilder f = new StringBuilder();
        after2.forEach((name, thread) -> {
            f.append("\"").append((String)name).append("\" (").append(thread.isAlive() ? "alive" : "dead").append(") ").append((Object)thread.getState());
            f.append("\n");
            for (StackTraceElement element2 : (StackTraceElement[])stackTraces.get(thread)) {
                f.append("\tat ").append(element2).append("\n");
            }
            f.append("\n");
        });
        StringBuilder stringBuilder = f;
        if (stringBuilder == null) {
            ThreadLeakTracker.$$$reportNull$$$0(26);
        }
        return stringBuilder;
    }

    @NotNull
    private static String internalDiagnostic(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace == null) {
            ThreadLeakTracker.$$$reportNull$$$0(27);
        }
        String string = stackTrace.length < 5 ? "stackTrace.length: " + stackTrace.length : "(diagnostic: 0: " + stackTrace[0].getClassName() + " : " + stackTrace[0].getClassName().equals("sun.misc.Unsafe") + " . " + stackTrace[0].getMethodName() + " : " + stackTrace[0].getMethodName().equals("unpark") + " 2: " + stackTrace[2].getClassName() + " : " + stackTrace[2].getClassName().equals("java.util.concurrent.FutureTask") + " . " + stackTrace[2].getMethodName() + " : " + stackTrace[2].getMethodName().equals("finishCompletion") + ")";
        if (string == null) {
            ThreadLeakTracker.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static MethodHandle getThreadsMethodHandle() {
        MethodHandle methodHandle;
        try {
            methodHandle = MethodHandles.privateLookupIn(Thread.class, MethodHandles.lookup()).findStatic(Thread.class, "getThreads", MethodType.methodType(Thread[].class));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to access the Thread#getThreads method", e);
        }
        if (methodHandle == null) {
            ThreadLeakTracker.$$$reportNull$$$0(29);
        }
        return methodHandle;
    }

    private static void validateWhitelistedThreads(@NotNull List<String> offenders) {
        if (offenders == null) {
            ThreadLeakTracker.$$$reportNull$$$0(30);
        }
        ArrayList<String> sorted = new ArrayList<String>(offenders);
        sorted.sort(String::compareToIgnoreCase);
        if (offenders.equals(sorted)) {
            return;
        }
        String proper = String.join((CharSequence)",\n", ContainerUtil.map(sorted, s -> "\"" + s + "\"")).replaceAll("\"Flushing Daemon\"", "FlushingDaemon.NAME").replaceAll("\"I/O pool \"", "ProcessIOExecutorService.POOLED_THREAD_PREFIX");
        throw new AssertionError((Object)("Thread names must be sorted (for ease of maintenance). Something like this will do:\n" + proper));
    }

    static {
        List<String> offenders = List.of("ApplicationImpl pooled thread ", "AWT-EventQueue-", "AWT-Shutdown", "AWT-Windows", "BatchSpanProcessor_WorkerThread", "Batik CleanerThread", "BC Entropy Daemon", "Cidr Symbol Building Thread", "Cleaner-0", "CompilerThread0", "Coroutines Debugger Cleaner", "dockerjava-netty", "External compiler", "FilePageCache housekeeper", "Finalizer", "Flushing Daemon", "HttpClient-", "I/O pool ", "IDEA Test Case Thread", "Image Fetcher ", "InnocuousThreadGroup", "Java2D Disposer", "JNA Cleaner", "JobScheduler FJ pool ", "JPS thread pool", "Keep-Alive-SocketCleaner", "Keep-Alive-Timer", "main", "Monitor Ctrl-Break", "Netty ", "ObjectCleanerThread", "OkHttp ConnectionPool", "Okio Watchdog", "Periodic tasks thread", "process reaper", "rd throttler", "Reference Handler", "RMI GC Daemon", "RMI TCP ", "Save classpath indexes for file loader", "Signal Dispatcher", "tc-okhttp-stream", "timer-int", "timer-sys", "TimerQueue", "UserActivityMonitor thread", "VM Periodic Task Thread", "VM Thread", "YJPAgent-Telemetry");
        ThreadLeakTracker.validateWhitelistedThreads(offenders);
        wellKnownOffenders = new HashSet<String>(offenders);
        try {
            Preferences.userRoot().flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/common/ThreadLeakTracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadNamePrefixes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadsBefore";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraces";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offenders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/common/ThreadLeakTracker";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsToString";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "internalDiagnostic";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadsMethodHandle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "longRunningThreadCreated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForThread";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldWaitForThread";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnore";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWellKnownOffender";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIdleApplicationPoolThread";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isKotlinCIOSelector";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isIdleCommonPoolThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFutureTaskAboutToFinish";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isIdleDefaultCoroutineExecutorThread";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCoroutineSchedulerPoolThread";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isStarterTestFramework";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isJMXRemoteCall";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadsToString";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "internalDiagnostic";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "validateWhitelistedThreads";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 30 -> new IllegalArgumentException(string);
        };
    }
}

