/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ae.database.core.dbs;

import com.intellij.ae.database.core.IdService;
import com.intellij.ae.database.core.dbs.SqliteDatabaseMetadataKt;
import com.intellij.ae.database.core.dbs.migrations.MigrationsKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.ObjectBinder1;
import org.jetbrains.sqlite.ObjectBinder2;
import org.jetbrains.sqlite.ObjectBinder3;
import org.jetbrains.sqlite.ObjectBinderFactory;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteException;
import org.jetbrains.sqlite.SqlitePreparedStatement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ae/database/core/dbs/SqliteDatabaseMetadata;", "", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "isNewFile", "", "(Lorg/jetbrains/sqlite/SqliteConnection;Z)V", "ideId", "", "getIdeId", "()I", "executeMigrations", "", "fromVersion", "getVersion", "initIdeId", "intellij.ae.database.core"})
@SourceDebugExtension(value={"SMAP\nSqliteDatabaseMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteDatabaseMetadata.kt\ncom/intellij/ae/database/core/dbs/SqliteDatabaseMetadata\n+ 2 ObjectBinder.kt\norg/jetbrains/sqlite/ObjectBinderFactory\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n179#2,4:88\n185#2,4:93\n191#2,4:97\n1#3:92\n*S KotlinDebug\n*F\n+ 1 SqliteDatabaseMetadata.kt\ncom/intellij/ae/database/core/dbs/SqliteDatabaseMetadata\n*L\n66#1:88,4\n76#1:93,4\n82#1:97,4\n*E\n"})
public final class SqliteDatabaseMetadata {
    @NotNull
    private final SqliteConnection connection;
    private final int ideId;

    public SqliteDatabaseMetadata(@NotNull SqliteConnection connection, boolean isNewFile) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        ThreadingAssertions.assertBackgroundThread();
        if (isNewFile) {
            SqliteDatabaseMetadataKt.access$getLogger$p().info("New database, executing migration");
            this.executeMigrations(0);
        } else {
            int n;
            try {
                n = this.getVersion();
            }
            catch (SqliteException t) {
                if (!Intrinsics.areEqual((Object)t.getMessage(), (Object)"[SQLITE_ERROR] SQL error or missing database (no such table: meta)")) {
                    throw t;
                }
                SqliteDatabaseMetadataKt.access$getLogger$p().info("File exists, but database seem to be uninitialized");
                n = 0;
            }
            int version = n;
            this.executeMigrations(version);
        }
        this.ideId = this.initIdeId();
    }

    public final int getIdeId() {
        return this.ideId;
    }

    private final void executeMigrations(int fromVersion) {
        List<String> migrations = MigrationsKt.getMIGRATIONS().subList(Math.max(fromVersion, 0), MigrationsKt.getLAST_DB_VERSION());
        if (migrations.isEmpty()) {
            return;
        }
        SqlitePreparedStatement sqlitePreparedStatement = migrations.iterator();
        while (sqlitePreparedStatement.hasNext()) {
            String migration = sqlitePreparedStatement.next();
            this.connection.execute(migration);
        }
        ObjectBinderFactory $this$iv = ObjectBinderFactory.INSTANCE;
        int batchCountHint$iv = 1;
        boolean $i$f$create1 = false;
        Class[] classArray = new Class[]{Integer.class};
        $this$iv.verifyTypes(classArray);
        SqlitePreparedStatement $this$executeMigrations_u24lambda_u240 = sqlitePreparedStatement = this.connection.prepareStatement("UPDATE meta SET version = (?) WHERE true;", (Binder)new ObjectBinder1(batchCountHint$iv));
        boolean bl = false;
        ((ObjectBinder1)$this$executeMigrations_u24lambda_u240.getBinder()).bind((Object)MigrationsKt.getLAST_DB_VERSION());
        sqlitePreparedStatement.executeUpdate();
    }

    private final int getVersion() {
        Integer n = SqliteConnection.selectInt$default((SqliteConnection)this.connection, (String)"SELECT version FROM meta LIMIT 1", null, (int)2, null);
        return n != null ? n : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int initIdeId() {
        int n;
        Object $this$iv = ObjectBinderFactory.INSTANCE;
        int batchCountHint$iv22 = 1;
        boolean $i$f$create2 = false;
        Class[] classArray = new Class[]{String.class, String.class};
        $this$iv.verifyTypes(classArray);
        $this$iv = (AutoCloseable)this.connection.prepareStatement("SELECT id FROM ide WHERE ide_id = (?) AND machine_id = (?) LIMIT 1", (Binder)new ObjectBinder2(batchCountHint$iv22));
        Throwable batchCountHint$iv22 = null;
        try {
            Object statement = (SqlitePreparedStatement)$this$iv;
            boolean bl = false;
            ((ObjectBinder2)statement.getBinder()).bind((Object)IdService.Companion.getInstance().getId(), (Object)IdService.Companion.getInstance().getMachineId());
            statement = statement.selectInt();
        }
        catch (Throwable statement) {
            batchCountHint$iv22 = statement;
            throw statement;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$this$iv, (Throwable)batchCountHint$iv22);
        }
        Object potentialResult = statement;
        if (potentialResult != null) {
            return (Integer)potentialResult;
        }
        $this$iv = ObjectBinderFactory.INSTANCE;
        int batchCountHint$iv = 1;
        boolean $i$f$create3 = false;
        Class[] bl = new Class[]{String.class, String.class, String.class};
        $this$iv.verifyTypes(bl);
        AutoCloseable autoCloseable = (AutoCloseable)this.connection.prepareStatement("insert into ide(ide_id, machine_id, family) values (?, ?, ?) RETURNING id;", (Binder)new ObjectBinder3(batchCountHint$iv));
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl2 = false;
            ObjectBinder3 objectBinder3 = (ObjectBinder3)statement.getBinder();
            String string = IdService.Companion.getInstance().getId();
            String string2 = IdService.Companion.getInstance().getMachineId();
            String string3 = IdService.Companion.getInstance().getIdeCode();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ideCode>(...)");
            objectBinder3.bind((Object)string, (Object)string2, (Object)string3);
            Integer n2 = statement.selectInt();
            if (n2 == null) {
                throw new IllegalStateException("Null was returned when not expected".toString());
            }
            n = n2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n;
    }
}

