/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ae.database.core.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ae/database/core/utils/InstantUtils;", "", "()V", "Now", "Ljava/time/Instant;", "getNow", "()Ljava/time/Instant;", "NowButABitLater", "getNowButABitLater", "SomeTimeAgo", "getSomeTimeAgo", "StartOfDay", "getStartOfDay", "WeekAgo", "getWeekAgo", "WeekAgoStartOfDay", "getWeekAgoStartOfDay", "formatForDatabase", "", "instant", "fromString", "str", "intellij.ae.database.core"})
public final class InstantUtils {
    @NotNull
    public static final InstantUtils INSTANCE = new InstantUtils();
    @NotNull
    private static final Instant SomeTimeAgo;

    private InstantUtils() {
    }

    @NotNull
    public final Instant getSomeTimeAgo() {
        return SomeTimeAgo;
    }

    @NotNull
    public final Instant getNow() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return instant;
    }

    @NotNull
    public final Instant getNowButABitLater() {
        Instant instant = this.getNow().plusSeconds(1200L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusSeconds(...)");
        return instant;
    }

    @NotNull
    public final Instant getStartOfDay() {
        Instant instant = this.getNow().truncatedTo(ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"truncatedTo(...)");
        return instant;
    }

    @NotNull
    public final Instant getWeekAgo() {
        Instant instant = this.getNow().minus(7L, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
        return instant;
    }

    @NotNull
    public final Instant getWeekAgoStartOfDay() {
        Instant instant = this.getWeekAgo().truncatedTo(ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"truncatedTo(...)");
        return instant;
    }

    @NotNull
    public final String formatForDatabase(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        String string = instant.truncatedTo(ChronoUnit.SECONDS).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Instant fromString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Instant instant = Instant.parse(str);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(...)");
        return instant;
    }

    static {
        Instant instant = Instant.ofEpochSecond(0L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        SomeTimeAgo = instant;
    }
}

