/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.indexing.shared.download.DownloadTaskContext;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecision;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecisionKey;
import com.intellij.indexing.shared.download.IndexDownloadConsentService;
import com.intellij.indexing.shared.download.SharedIndexAuthKt;
import com.intellij.indexing.shared.download.SharedIndexAuthLifetimeHolder;
import com.intellij.indexing.shared.download.SharedIndexConsentStoreKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutor;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutorKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadHistoryStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadInfo;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadNotifications;
import com.intellij.indexing.shared.download.SharedIndexDownloadServiceKt;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupResultKt;
import com.intellij.indexing.shared.download.SharedIndexPerProjectTaskExpiration;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.SharedIndexSuggestionService;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.DownloadIndexResult;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J0\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u00170\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012JB\u0010\u001d\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u00170\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0002J(\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\"\u001a\u00020#H\u0007J\r\u0010$\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b%J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\b\u0012\u0004\u0012\u00020\u00150'H\u0002J$\u0010(\u001a\u00020\u0010*\u00020)2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R4\u0010\u0007\u001a(\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n \f*\u0012\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\u000b\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService;", "", "()V", "executor", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "getExecutor", "()Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "pendingSharedIndexes", "", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "rescanningCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "applySuggestions", "", "project", "Lcom/intellij/openapi/project/Project;", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "collectRequests", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "collectSuggestionsSuitableForDownload", "rescanNow", "resolveAndDownloadAndInstallIndexes", "requests", "makeIndicatorVisible", "Lkotlin/Function0;", "suggestIndexes", "enableConsent", "", "waitRescanningCalmDown", "waitRescanningCalmDown$intellij_indexing_shared", "mergeSameSuggestions", "", "processSuggestions", "Lcom/intellij/indexing/shared/download/DownloadTaskContext;", "LookupChunkDescriptor", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadService.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n+ 7 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,315:1\n43#2,3:316\n43#2,3:322\n43#2,3:331\n43#2,3:402\n43#2,3:430\n43#2,3:445\n766#3:319\n857#3,2:320\n1194#3,2:325\n1222#3,4:327\n1477#3:336\n1502#3,3:337\n1505#3,3:347\n1490#3:388\n1520#3,3:389\n1523#3,3:399\n1549#3:433\n1620#3,3:434\n31#4,2:334\n372#5,7:340\n372#5,7:392\n55#6,3:350\n28#6:353\n13#6,4:354\n29#6,14:358\n58#6,2:372\n44#6,5:374\n19#6,2:379\n49#6:381\n60#6,2:382\n13#6,4:384\n28#6:405\n13#6,4:406\n29#6,14:410\n44#6,5:437\n19#6,2:442\n49#6:444\n19#6,2:448\n17#7,6:424\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadService.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadService\n*L\n56#1:316,3\n169#1:322,3\n192#1:331,3\n260#1:402,3\n285#1:430,3\n299#1:445,3\n145#1:319\n145#1:320,2\n188#1:325,2\n188#1:327,4\n198#1:336\n198#1:337,3\n198#1:347,3\n258#1:388\n258#1:389,3\n258#1:399,3\n286#1:433\n286#1:434,3\n196#1:334,2\n198#1:340,7\n258#1:392,7\n234#1:350,3\n234#1:353\n234#1:354,4\n234#1:358,14\n234#1:372,2\n234#1:374,5\n234#1:379,2\n234#1:381\n234#1:382,2\n253#1:384,4\n263#1:405\n263#1:406,4\n263#1:410,14\n263#1:437,5\n263#1:442,2\n263#1:444\n253#1:448,2\n276#1:424,6\n*E\n"})
public final class SharedIndexDownloadService {
    @NotNull
    private final AtomicInteger rescanningCounter = new AtomicInteger();
    @NotNull
    private final Set<SharedIndexId> pendingSharedIndexes;

    public SharedIndexDownloadService() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.pendingSharedIndexes = set;
    }

    private final SharedIndexDownloadExecutor getExecutor() {
        boolean $i$f$service = false;
        Class<SharedIndexDownloadExecutor> serviceClass$iv = SharedIndexDownloadExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (SharedIndexDownloadExecutor)object;
    }

    public final void waitRescanningCalmDown$intellij_indexing_shared() {
        int checkFrequencyInSec = SystemProperties.getIntProperty((String)"shared.index.check.frequency", (int)-1);
        int waitLimitInSec = SystemProperties.getIntProperty((String)"shared.index.wait.limit", (int)-1);
        int lastRescanningCount = -1;
        if (waitLimitInSec == -1 || checkFrequencyInSec == -1) {
            return;
        }
        long globalStart = System.nanoTime();
        do {
            int currentRescanningCount;
            if (lastRescanningCount == (currentRescanningCount = this.rescanningCounter.get())) {
                return;
            }
            lastRescanningCount = currentRescanningCount;
            long start = System.nanoTime();
            ProgressIndicatorUtils.awaitWithCheckCanceled(() -> SharedIndexDownloadService.waitRescanningCalmDown$lambda$0(start, checkFrequencyInSec));
        } while (System.nanoTime() - globalStart <= TimeUnit.SECONDS.toNanos(waitLimitInSec));
        throw new Error("Rescanning calm down waiting limit (" + waitLimitInSec + " secs) exceeded");
    }

    public final void rescanNow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!SharedIndexDownloadServiceKt.access$isEnabled()) {
            return;
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Rescan");
        this.rescanningCounter.incrementAndGet();
        SharedIndexPerProjectTaskExpiration.Token expiration = SharedIndexPerProjectTaskExpiration.Companion.registerNewTask(project);
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(expiration, this, project){
            final /* synthetic */ SharedIndexPerProjectTaskExpiration.Token $expiration;
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ Project $project;
            {
                this.$expiration = $expiration;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                Class serviceClass$iv;
                boolean $i$f$service;
                List list;
                SharedIndexDownloadService sharedIndexDownloadService;
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
                if (this.$expiration.isExpired()) {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Expired");
                    return;
                }
                SharedIndexDownloadService sharedIndexDownloadService2 = this.this$0;
                try {
                    sharedIndexDownloadService = sharedIndexDownloadService2;
                    list = SharedIndexDownloadService.access$collectSuggestionsSuitableForDownload(this.this$0, this.$project);
                }
                catch (Throwable throwable) {
                    void t;
                    SharedIndexDownloadService sharedIndexDownloadService3 = sharedIndexDownloadService2;
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to collect suggested shared indexes. " + t.getMessage(), (Throwable)t);
                    return;
                }
                List suggestions = SharedIndexDownloadService.access$mergeSameSuggestions(sharedIndexDownloadService, list);
                SharedIndexDownloadLoggerKt.getDownloadLogger().trace("All project suggestions: [" + suggestions + "]");
                if (suggestions.isEmpty()) {
                    return;
                }
                if (!ProjectUtil.isNotificationSilentMode((Project)this.$project)) {
                    ComponentManager $this$service$iv = (ComponentManager)this.$project;
                    $i$f$service = false;
                    serviceClass$iv = IndexDownloadConsentService.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, (Class)serviceClass$iv);
                    }
                    ((IndexDownloadConsentService)object).askForMoreDownloads(suggestions, this.$project);
                }
                $i$f$service = false;
                serviceClass$iv = SharedIndexDownloadConsentStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                List<SharedIndexSuggestion> allowedSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(suggestions, this.$project);
                if (allowedSuggestions.isEmpty()) {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().debug("All suggestions are not allowed");
                    return;
                }
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Allowed suggestion: [" + suggestions + "]");
                $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$project, allowedSuggestions){
                    final /* synthetic */ SharedIndexDownloadService this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<SharedIndexSuggestion> $allowedSuggestions;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$allowedSuggestions = $allowedSuggestions;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.applySuggestions(this.$project, this.$allowedSuggestions);
                    }
                }));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void applySuggestions(@Nullable Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (!SharedIndexDownloadServiceKt.access$isEnabled() || suggestions.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = suggestions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            if (!this.pendingSharedIndexes.add(it.getSharedIndexId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List onlyNewSuggestions = (List)destination$iv$iv;
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this, project, (List<? extends SharedIndexSuggestion>)onlyNewSuggestions){
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List<SharedIndexSuggestion> $onlyNewSuggestions;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$onlyNewSuggestions = $onlyNewSuggestions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
                try {
                    SharedIndexDownloadService.access$processSuggestions(this.this$0, $this$submitPreProgressSync, this.$project, this.$onlyNewSuggestions);
                }
                catch (Throwable throwable) {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Iterable $i$f$map = this.$onlyNewSuggestions;
                    Set set = SharedIndexDownloadService.access$getPendingSharedIndexes$p(this.this$0);
                    boolean $i$f$map2 = false;
                    void destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        SharedIndexSuggestion sharedIndexSuggestion2 = (SharedIndexSuggestion)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean $i$a$-map-SharedIndexDownloadService$applySuggestions$1$2 = false;
                        collection.add(it.getSharedIndexId());
                    }
                    set.removeAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
                    throw throwable;
                }
                Iterable iterable = this.$onlyNewSuggestions;
                Set set = SharedIndexDownloadService.access$getPendingSharedIndexes$p(this.this$0);
                boolean $i$f$map = false;
                void var4_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean sharedIndexSuggestion2 = false;
                    collection.add(it.getSharedIndexId());
                }
                set.removeAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            }
        }));
    }

    @JvmOverloads
    public final void suggestIndexes(@NotNull Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions, boolean enableConsent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (suggestions.isEmpty()) {
            return;
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().info("Got suggestion to download shared indexes " + CollectionsKt.joinToString$default((Iterable)suggestions, null, null, null, (int)0, null, null, (int)63, null) + ".");
        if (enableConsent) {
            boolean $i$f$service = false;
            Class<SharedIndexDownloadConsentStore> clazz = SharedIndexDownloadConsentStore.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            SharedIndexDownloadConsentStore consentStore = (SharedIndexDownloadConsentStore)((Object)object);
            for (SharedIndexSuggestion sharedIndexSuggestion : suggestions) {
                IndexDownloadConsentDecisionKey key = SharedIndexConsentStoreKt.toKey(sharedIndexSuggestion);
                if (consentStore.decisionFor(key, project) == IndexDownloadConsentDecision.DENIED) continue;
                consentStore.setDecisionFor(key, IndexDownloadConsentDecision.ALLOWED);
            }
        }
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(suggestions, project, this){
            final /* synthetic */ List<SharedIndexSuggestion> $suggestions;
            final /* synthetic */ Project $project;
            final /* synthetic */ SharedIndexDownloadService this$0;
            {
                this.$suggestions = $suggestions;
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
                $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this.$suggestions, this.$project, this.this$0){
                    final /* synthetic */ List<SharedIndexSuggestion> $suggestions;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ SharedIndexDownloadService this$0;
                    {
                        this.$suggestions = $suggestions;
                        this.$project = $project;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        boolean $i$f$service = false;
                        Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                        }
                        List<SharedIndexSuggestion> actualSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(this.$suggestions, this.$project);
                        this.this$0.applySuggestions(this.$project, actualSuggestions);
                    }
                }));
            }
        }));
    }

    public static /* synthetic */ void suggestIndexes$default(SharedIndexDownloadService sharedIndexDownloadService, Project project, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        sharedIndexDownloadService.suggestIndexes(project, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> mergeSameSuggestions(Collection<? extends SharedIndexSuggestion> $this$mergeSameSuggestions) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = $this$mergeSameSuggestions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSharedIndexId(), element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> collectSuggestionsSuitableForDownload(Project project) {
        List list;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$service$iv;
        boolean $i$f$service = false;
        ComponentManager serviceClass$iv = SharedIndexDownloadHistoryStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        SharedIndexDownloadHistoryStore history = (SharedIndexDownloadHistoryStore)((Object)object);
        serviceClass$iv = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<SharedIndexSuggestionService> serviceClass$iv2 = SharedIndexSuggestionService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
        }
        $this$service$iv = ((SharedIndexSuggestionService)object2).resolveSuggestions();
        boolean $i$f$groupBy = false;
        serviceClass$iv2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = SharedIndexDownloadHistoryStore.isDownloadMakeSenseFor$default(history, it.getSharedIndexId(), false, 2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map allSuggestions = destination$iv$iv;
        List list2 = (List)allSuggestions.get(false);
        if (list2 != null) {
            List it = list2;
            boolean bl = false;
            String message = "There is no need to download shared indexes for " + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null) + ". Similar compatible shared indexes are available locally.";
            if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug(message);
            } else {
                SharedIndexDownloadLoggerKt.getDownloadLogger().info(StringUtil.first((String)message, (int)300, (boolean)true));
            }
        }
        if ((list = (List)allSuggestions.get(true)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void processSuggestions(DownloadTaskContext $this$processSuggestions, Project project, List<? extends SharedIndexSuggestion> suggestions) {
        List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> requests = this.collectRequests($this$processSuggestions.getIndicator(), suggestions);
        if (requests.isEmpty()) {
            return;
        }
        SharedIndexAuthKt.initiateAuthIfNeeded(requests, $this$processSuggestions.getIndicator(), SharedIndexAuthLifetimeHolder.Companion.getNextDisposable(project), (Function1<? super List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>>, Unit>)((Function1)new Function1<List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>>, Unit>($this$processSuggestions, this, project){
            final /* synthetic */ DownloadTaskContext $this_processSuggestions;
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ Project $project;
            {
                this.$this_processSuggestions = $receiver;
                this.this$0 = $receiver2;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> authRequests) {
                Intrinsics.checkNotNullParameter(authRequests, (String)"authRequests");
                this.$this_processSuggestions.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$project, authRequests){
                    final /* synthetic */ SharedIndexDownloadService this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> $authRequests;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$authRequests = $authRequests;
                        super(0);
                    }

                    public final void invoke() {
                        SharedIndexDownloadService.access$getExecutor(this.this$0).submitPreProgressSync(this.$project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this.$project, this.this$0, this.$authRequests){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ SharedIndexDownloadService this$0;
                            final /* synthetic */ List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> $authRequests;
                            {
                                this.$project = $project;
                                this.this$0 = $receiver;
                                this.$authRequests = $authRequests;
                                super(1);
                            }

                            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
                                SharedIndexDownloadExecutorKt.suspendIndexingIfNeededWhileDownloading(this.$project, (Function0)new Function0<Unit>(this.this$0, this.$project, $this$submitPreProgressSync, this.$authRequests){
                                    final /* synthetic */ SharedIndexDownloadService this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ DownloadTaskContext $this_submitPreProgressSync;
                                    final /* synthetic */ List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> $authRequests;
                                    {
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$this_submitPreProgressSync = $this_submitPreProgressSync;
                                        this.$authRequests = $authRequests;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        SharedIndexDownloadService.access$resolveAndDownloadAndInstallIndexes(this.this$0, this.$project, this.$this_submitPreProgressSync.getIndicator(), this.$authRequests, (Function0)new Function0<Unit>((Object)this.$this_submitPreProgressSync){

                                            public final void invoke() {
                                                ((DownloadTaskContext)this.receiver).ensureBackgroundableProgressShown();
                                            }
                                        });
                                    }
                                });
                            }
                        }));
                    }
                }));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> collectRequests(ProgressIndicator indicator, List<? extends SharedIndexSuggestion> suggestions) {
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.requests", new Object[0]));
        Collection $this$mapWithProgress$iv = suggestions;
        boolean $i$f$mapWithProgress = false;
        indicator.checkCanceled();
        List result$iv = new ArrayList();
        Collection $this$forEachWithProgress$iv$iv = $this$mapWithProgress$iv;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv$iv = $this$withPushPop$iv$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv$iv = $this$forEachWithProgress$iv$iv.size();
            Iterator iterator = $this$forEachWithProgress$iv$iv.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Pair pair;
                Collection collection;
                String prevText2$iv$iv;
                String prevText$iv$iv;
                block8: {
                    Pair pair2;
                    void it;
                    void it$iv;
                    int i$iv$iv = n++;
                    Object y$iv$iv = iterator.next();
                    indicator.checkCanceled();
                    double lowerBound$iv$iv = (double)i$iv$iv / size$iv$iv;
                    double upperBound$iv$iv = (double)(i$iv$iv + 1) / size$iv$iv;
                    indicator.setFraction(lowerBound$iv$iv);
                    prevText$iv$iv = indicator.getText();
                    prevText2$iv$iv = indicator.getText2();
                    ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv$iv, (double)upperBound$iv$iv);
                    Object y$iv = y$iv$iv;
                    boolean bl2 = false;
                    void var27_25 = it$iv;
                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)y$iv;
                    collection = result$iv;
                    boolean bl3 = false;
                    try {
                        void subIndicator;
                        SharedIndexLookupRequest request = it.resolveRequest((ProgressIndicator)subIndicator);
                        if (request == null) {
                            pair = null;
                            break block8;
                        }
                        pair2 = TuplesKt.to((Object)it, (Object)request);
                    }
                    catch (Throwable e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to create for shared index request for " + (SharedIndexSuggestion)it + ". " + e.getMessage(), e);
                        pair2 = null;
                    }
                    pair = pair2;
                }
                collection.add(pair);
                indicator.setText(prevText$iv$iv);
                indicator.setText2(prevText2$iv$iv);
            }
            indicator.setFraction(1.0);
        }
        finally {
            $this$withPushPop$iv$iv$iv.setIndeterminate(wasIndeterminate$iv$iv$iv);
            $this$withPushPop$iv$iv$iv.popState();
        }
        indicator.checkCanceled();
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)result$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void resolveAndDownloadAndInstallIndexes(Project project, ProgressIndicator indicator, List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests, Function0<Unit> makeIndicatorVisible) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            boolean bl = false;
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sharedIndexInfrastructureVersion), (String)"getIdeVersion(...)");
            SharedIndexInfrastructureVersion ideVersion = sharedIndexInfrastructureVersion;
            Iterable iterable = requests;
            boolean $i$f$groupBy = false;
            void var12_13 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-SharedIndexDownloadService$resolveAndDownloadAndInstallIndexes$1$uniqueRequests$32 = false;
                SharedIndexLookupRequest key$iv$iv = (SharedIndexLookupRequest)it2.getSecond();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                Pair $i$a$-groupBy-SharedIndexDownloadService$resolveAndDownloadAndInstallIndexes$1$uniqueRequests$32 = (Pair)element$iv$iv;
                List list = list$iv$iv;
                boolean bl3 = false;
                list.add((SharedIndexSuggestion)it.getFirst());
            }
            Set uniqueRequests = destination$iv$iv.entrySet();
            boolean $i$f$service = false;
            Class<SharedIndexLookup> serviceClass$iv = SharedIndexLookup.class;
            destination$iv$iv = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (destination$iv$iv == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            SharedIndexLookup indexLookup = (SharedIndexLookup)destination$iv$iv;
            List infos = new ArrayList();
            Collection $this$forEachWithProgress$iv = uniqueRequests;
            boolean $i$f$forEachWithProgress = false;
            ProgressIndicator $this$withPushPop$iv$iv = indicator;
            boolean $i$f$withPushPop2 = false;
            boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
            $this$withPushPop$iv$iv.pushState();
            try {
                boolean bl4 = false;
                indicator.setIndeterminate(false);
                indicator.checkCanceled();
                double size$iv = $this$forEachWithProgress$iv.size();
                Iterator iterator = $this$forEachWithProgress$iv.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String prevText2$iv;
                    String prevText$iv;
                    block21: {
                        SharedIndexLookupResult sharedIndexLookupResult;
                        void subIndicator;
                        int i$iv = n++;
                        Object y$iv = iterator.next();
                        indicator.checkCanceled();
                        double lowerBound$iv = (double)i$iv / size$iv;
                        double upperBound$iv = (double)(i$iv + 1) / size$iv;
                        indicator.setFraction(lowerBound$iv);
                        prevText$iv = indicator.getText();
                        prevText2$iv = indicator.getText2();
                        ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                        Map.Entry entry = (Map.Entry)y$iv;
                        boolean bl5 = false;
                        SharedIndexLookupRequest lookupRequest = (SharedIndexLookupRequest)entry.getKey();
                        List suggestions = (List)entry.getValue();
                        try {
                            if (indexLookup.lookupSharedIndex(lookupRequest, ideVersion, (ProgressIndicator)subIndicator) == null) break block21;
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) {
                                throw e;
                            }
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to lookup for shared index " + lookupRequest + " (" + suggestions + "). " + e.getMessage(), e);
                            break block21;
                        }
                        SharedIndexLookupResult lookupResult = sharedIndexLookupResult;
                        makeIndicatorVisible.invoke();
                        try {
                            DownloadIndexResult hadDownloadedSomething;
                            boolean $i$f$measureTimeMillis = false;
                            long start$iv = System.currentTimeMillis();
                            boolean bl6 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)SharedIndexChunkConfiguration.getInstance().downloadChunk(new LookupChunkDescriptor(lookupResult), project, (ProgressIndicator)subIndicator)), (String)"downloadChunk(...)");
                            if (hadDownloadedSomething == DownloadIndexResult.JUST_DOWNLOADED) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                long downloadTime = System.currentTimeMillis() - start$iv;
                                boolean $i$f$service22 = false;
                                Class<SharedIndexDownloadHistoryStore> serviceClass$iv2 = SharedIndexDownloadHistoryStore.class;
                                Object object = ApplicationManager.getApplication().getService(serviceClass$iv2);
                                if (object == null) {
                                    throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                                }
                                Iterable $i$f$service22 = suggestions;
                                SharedIndexDownloadHistoryStore sharedIndexDownloadHistoryStore = (SharedIndexDownloadHistoryStore)((Object)object);
                                boolean $i$f$map = false;
                                object = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                                    Collection collection = destination$iv$iv2;
                                    boolean bl7 = false;
                                    collection.add(it.getSharedIndexId());
                                }
                                sharedIndexDownloadHistoryStore.updateLastDownload((List)destination$iv$iv2, lookupResult.getChunkUniqueId(), lookupResult.getSize());
                                ((Collection)infos).add(new SharedIndexDownloadInfo(suggestions, lookupResult.getSize(), downloadTime));
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) {
                                throw e;
                            }
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to download shared index " + lookupResult + " (" + suggestions + "). " + e.getMessage(), e);
                        }
                    }
                    indicator.setText(prevText$iv);
                    indicator.setText2(prevText2$iv);
                }
                indicator.setFraction(1.0);
            }
            finally {
                $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
                $this$withPushPop$iv$iv.popState();
            }
            boolean $i$f$service2 = false;
            Class<SharedIndexDownloadNotifications> serviceClass$iv3 = SharedIndexDownloadNotifications.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv3);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv3.getName() + " (classloader=" + serviceClass$iv3.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            ((SharedIndexDownloadNotifications)object).notifySharedIndexInstalled(project, infos);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    @JvmOverloads
    public final void suggestIndexes(@NotNull Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        SharedIndexDownloadService.suggestIndexes$default(this, project, suggestions, false, 4, null);
    }

    private static final Boolean waitRescanningCalmDown$lambda$0(long $start, int $checkFrequencyInSec) {
        return System.nanoTime() - $start > TimeUnit.SECONDS.toNanos($checkFrequencyInSec);
    }

    public static final /* synthetic */ List access$mergeSameSuggestions(SharedIndexDownloadService $this, Collection $receiver) {
        return $this.mergeSameSuggestions($receiver);
    }

    public static final /* synthetic */ List access$collectSuggestionsSuitableForDownload(SharedIndexDownloadService $this, Project project) {
        return $this.collectSuggestionsSuitableForDownload(project);
    }

    public static final /* synthetic */ void access$processSuggestions(SharedIndexDownloadService $this, DownloadTaskContext $receiver, Project project, List suggestions) {
        $this.processSuggestions($receiver, project, suggestions);
    }

    public static final /* synthetic */ Set access$getPendingSharedIndexes$p(SharedIndexDownloadService $this) {
        return $this.pendingSharedIndexes;
    }

    public static final /* synthetic */ SharedIndexDownloadExecutor access$getExecutor(SharedIndexDownloadService $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ void access$resolveAndDownloadAndInstallIndexes(SharedIndexDownloadService $this, Project project, ProgressIndicator indicator, List requests, Function0 makeIndicatorVisible) {
        $this.resolveAndDownloadAndInstallIndexes(project, indicator, requests, (Function0<Unit>)makeIndicatorVisible);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService$LookupChunkDescriptor;", "Lcom/intellij/indexing/shared/platform/api/ChunkDescriptor;", "lookupResult", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "chunkStorageOption", "Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "getChunkStorageOption", "()Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "chunkUniqueId", "", "getChunkUniqueId", "()Ljava/lang/String;", "kind", "getKind", "downloadChunk", "", "targetFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.indexing.shared"})
    private static final class LookupChunkDescriptor
    implements ChunkDescriptor {
        @NotNull
        private final SharedIndexLookupResult lookupResult;
        @NotNull
        private final String chunkUniqueId;
        @NotNull
        private final String kind;
        @NotNull
        private final ChunkStorageOption chunkStorageOption;

        public LookupChunkDescriptor(@NotNull SharedIndexLookupResult lookupResult) {
            Intrinsics.checkNotNullParameter((Object)lookupResult, (String)"lookupResult");
            this.lookupResult = lookupResult;
            this.chunkUniqueId = this.lookupResult.getChunkUniqueId();
            this.kind = this.lookupResult.getRequest().getKind();
            this.chunkStorageOption = ChunkStorageOption.APPENDABLE;
        }

        @Override
        @NotNull
        public String getChunkUniqueId() {
            return this.chunkUniqueId;
        }

        @Override
        @NotNull
        public String getKind() {
            return this.kind;
        }

        @Override
        public boolean downloadChunk(@NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            return SharedIndexLookupResultKt.downloadChunk(this.lookupResult, targetFile, project, indicator);
        }

        @Override
        @NotNull
        public ChunkStorageOption getChunkStorageOption() {
            return this.chunkStorageOption;
        }

        @NotNull
        public String toString() {
            return this.getChunkUniqueId();
        }
    }
}

