/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics.file;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.CompileStatisticsData;
import org.jetbrains.kotlin.build.report.statistics.FormattingUtilsKt;
import org.jetbrains.kotlin.build.report.statistics.file.FileReportService;
import org.jetbrains.kotlin.build.report.statistics.file.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.build.report.statistics.file.Printer;
import org.jetbrains.kotlin.build.report.statistics.file.TextTable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 :*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0001:B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!H\u0002J\u001e\u0010\"\u001a\u00020\u00192\u0014\u0010#\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0$H\u0002J8\u0010&\u001a\u00020\u00192\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(0!2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!H\u0002J\u001e\u0010)\u001a\u00020\u00192\u0014\u0010*\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0$H\u0002J\u001c\u0010+\u001a\u00020\u00192\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(H\u0016J4\u0010,\u001a\u00020\u00192\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%\u0018\u00010$H\u0002J|\u0010\n\u001a\u00020\u00192\u0014\u0010/\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0$2\u0014\u00100\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0$2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0016\b\u0002\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0016\b\u0002\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%\u0018\u00010$2\b\b\u0002\u00102\u001a\u00020\u000bH\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020%H\u0002J\u001c\u00106\u001a\u00020\u00192\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(H\u0002J\"\u00107\u001a\u00020\u00192\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(0\u001bH\u0002J\"\u00108\u001a\u00020\u00192\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(0!H\u0002J8\u00109\u001a\u00020\u00192\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(0!2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/file/FileReportService;", "B", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "P", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "Ljava/io/Serializable;", "buildReportDir", "Ljava/io/File;", "projectName", "", "printMetrics", "", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Ljava/io/File;Ljava/lang/String;ZLorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)V", "outputFile", "p", "Lorg/jetbrains/kotlin/build/report/statistics/file/Printer;", "getP", "()Lorg/jetbrains/kotlin/build/report/statistics/file/Printer;", "setP", "(Lorg/jetbrains/kotlin/build/report/statistics/file/Printer;)V", "ts", "kotlin.jvm.PlatformType", "printBuildAttributes", "", "buildAttributes", "", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "printBuildInfo", "startParameters", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "failureMessages", "", "printBuildPerformanceMetrics", "buildMetrics", "", "", "printBuildReport", "statisticsData", "Lorg/jetbrains/kotlin/build/report/statistics/CompileStatisticsData;", "printBuildTimes", "buildTimes", "printCustomTaskMetrics", "printGcMetrics", "gcTimeMetrics", "gcCountMetrics", "buildTimesMetrics", "performanceMetrics", "nonIncrementalAttributes", "aggregatedMetric", "printSizeMetric", "sizeMetric", "value", "printTaskLog", "printTaskOverview", "printTasksLog", "process", "Companion", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nFileReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileReportService.kt\norg/jetbrains/kotlin/build/report/statistics/file/FileReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Printer.kt\norg/jetbrains/kotlin/build/report/statistics/file/Printer\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,292:1\n1547#2:293\n1618#2,3:294\n2659#2,5:297\n1269#2,2:302\n1283#2,4:304\n2665#2:308\n1547#2:309\n1618#2,3:310\n2659#2,5:313\n1269#2,2:318\n1283#2,4:320\n2665#2:324\n1547#2:325\n1618#2,3:326\n2659#2,7:329\n1534#2:388\n1475#2:396\n1500#2,3:397\n1503#2,3:407\n1177#2,2:410\n1251#2,4:412\n1853#2,2:435\n1853#2,2:447\n1853#2,2:451\n60#3,10:336\n60#3,7:347\n59#3,11:354\n68#3,2:365\n59#3,11:367\n60#3,10:378\n60#3,7:389\n68#3,2:416\n60#3,10:418\n60#3,7:428\n68#3,2:437\n59#3,8:439\n68#3,2:449\n1#4:346\n372#5,7:400\n*S KotlinDebug\n*F\n+ 1 FileReportService.kt\norg/jetbrains/kotlin/build/report/statistics/file/FileReportService\n*L\n70#1:293\n70#1:294,3\n70#1:297,5\n71#1:302,2\n71#1:304,4\n70#1:308\n73#1:309\n73#1:310,3\n73#1:313,5\n74#1:318,2\n74#1:320,4\n73#1:324\n76#1:325\n76#1:326,3\n76#1:329,7\n211#1:388\n213#1:396\n213#1:397,3\n213#1:407,3\n215#1:410,2\n215#1:412,4\n280#1:435,2\n158#1:447,2\n162#1:451,2\n86#1:336,10\n134#1:347,7\n137#1:354,11\n134#1:365,2\n149#1:367,11\n177#1:378,10\n212#1:389,7\n212#1:416,2\n273#1:418,10\n279#1:428,7\n279#1:437,2\n157#1:439,8\n157#1:449,2\n213#1:400,7\n*E\n"})
public class FileReportService<B extends BuildTime, P extends BuildPerformanceMetric>
implements Serializable {
    @NotNull
    public static final Companion Companion;
    private final boolean printMetrics;
    @NotNull
    private final KotlinLogger logger;
    private final String ts;
    @NotNull
    private final File outputFile;
    protected Printer p;
    @NotNull
    private static final SimpleDateFormat formatter;

    public FileReportService(@NotNull File buildReportDir, @NotNull String projectName, boolean printMetrics, @NotNull KotlinLogger logger) {
        Intrinsics.checkNotNullParameter((Object)buildReportDir, (String)"buildReportDir");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.printMetrics = printMetrics;
        this.logger = logger;
        this.ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
        this.outputFile = FilesKt.resolve((File)buildReportDir, (String)(projectName + "-build-" + this.ts + ".txt"));
    }

    @NotNull
    protected final Printer getP() {
        Printer printer = this.p;
        if (printer != null) {
            return printer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        return null;
    }

    protected final void setP(@NotNull Printer printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"<set-?>");
        this.p = printer;
    }

    public void printCustomTaskMetrics(@NotNull CompileStatisticsData<B, P> statisticsData) {
        Intrinsics.checkNotNullParameter(statisticsData, (String)"statisticsData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull List<? extends CompileStatisticsData<B, P>> statisticsData, @NotNull BuildStartParameters startParameters, @NotNull List<String> failureMessages) {
        Intrinsics.checkNotNullParameter(statisticsData, (String)"statisticsData");
        Intrinsics.checkNotNullParameter((Object)startParameters, (String)"startParameters");
        Intrinsics.checkNotNullParameter(failureMessages, (String)"failureMessages");
        String string = this.outputFile.toPath().toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String buildReportPath = string;
        try {
            this.outputFile.getParentFile().mkdirs();
            if (!this.outputFile.getParentFile().exists() || !this.outputFile.getParentFile().isDirectory()) {
                KotlinLogger.error$default(this.logger, "Kotlin build report cannot be created: '" + this.outputFile + ".parentFile' is a file or do not have permissions to create", null, 2, null);
                return;
            }
            Object object = this.outputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                this.setP(new Printer(writer, null, null, 6, null));
                this.printBuildReport(statisticsData, startParameters, failureMessages);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            this.logger.lifecycle("Kotlin build report is written to " + buildReportPath);
        }
        catch (Exception e) {
            this.logger.error("Could not write Kotlin build report to " + buildReportPath, e);
        }
    }

    public static /* synthetic */ void process$default(FileReportService fileReportService, List list, BuildStartParameters buildStartParameters, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: process");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        fileReportService.process(list, buildStartParameters, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void printBuildReport(List<? extends CompileStatisticsData<B, P>> statisticsData, BuildStartParameters startParameters, List<String> failureMessages) {
        this.printBuildInfo(startParameters, failureMessages);
        if (this.printMetrics && !((Collection)statisticsData).isEmpty()) {
            Object object;
            Object object2;
            Long l;
            BuildPerformanceMetric it;
            Map map;
            Object t;
            Object element$iv$iv;
            Iterator iterator2;
            boolean $i$f$associateWithTo;
            Object $this$associateWithTo$iv$iv;
            LinkedHashMap result$iv;
            boolean $i$f$associateWith;
            Object $this$associateWith$iv;
            Sequence agg;
            Iterable $this$reduce$iv;
            void it2;
            Object object3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = statisticsData;
            FileReportService fileReportService = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CompileStatisticsData compileStatisticsData = (CompileStatisticsData)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object3.add(it2.getBuildTimesMetrics());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value2;
                Map $i$f$mapTo2 = (Map)iterator$iv.next();
                agg = (Map)accumulator$iv;
                boolean bl = false;
                $this$associateWith$iv = SetsKt.plus(agg.keySet(), (Iterable)value2.keySet());
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                iterator2 = $this$associateWithTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    BuildTime buildTime = (BuildTime)element$iv$iv;
                    t = element$iv$iv;
                    map = result$iv;
                    boolean bl2 = false;
                    Long l2 = (Long)agg.get(it);
                    Long l3 = (Long)value2.get(it);
                    l = (l2 != null ? l2 : 0L) + (l3 != null ? l3 : 0L);
                    map.put(t, l);
                }
                accumulator$iv = result$iv;
            }
            $this$reduce$iv = statisticsData;
            object3 = (Map)accumulator$iv;
            $i$f$map = false;
            iterator$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $this$associateWith$iv = (CompileStatisticsData)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(it2.getPerformanceMetrics());
            }
            object2 = (List)destination$iv$iv;
            $this$map$iv = (Iterable)object2;
            $i$f$reduce = false;
            iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value3;
                Map $i$f$mapTo3 = (Map)iterator$iv.next();
                agg = (Map)accumulator$iv;
                boolean bl = false;
                $this$associateWith$iv = SetsKt.plus(agg.keySet(), (Iterable)value3.keySet());
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                iterator2 = $this$associateWithTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    it = (BuildPerformanceMetric)element$iv$iv;
                    t = element$iv$iv;
                    map = result$iv;
                    boolean bl3 = false;
                    Long l4 = (Long)agg.get(it);
                    Long l5 = (Long)value3.get(it);
                    l = (l4 != null ? l4 : 0L) + (l5 != null ? l5 : 0L);
                    map.put(t, l);
                }
                accumulator$iv = result$iv;
            }
            object2 = accumulator$iv;
            $this$reduce$iv = statisticsData;
            object2 = (Map)object2;
            $i$f$map = false;
            iterator$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $this$associateWith$iv = (CompileStatisticsData)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(CollectionsKt.asSequence((Iterable)it2.getNonIncrementalAttributes()));
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Iterable)object;
            $i$f$reduce = false;
            iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value4;
                Sequence $i$f$mapTo4 = (Sequence)iterator$iv.next();
                agg = (Sequence)accumulator$iv;
                boolean bl = false;
                accumulator$iv = SequencesKt.plus((Sequence)agg, (Sequence)value4);
            }
            object = accumulator$iv;
            FileReportService.printMetrics$default(fileReportService, (Map)object3, (Map)object2, SequencesKt.toList((Sequence)((Sequence)object)), null, null, true, 24, null);
            this.getP().println(new String[0]);
        }
        this.printTaskOverview((Collection)statisticsData);
        this.printTasksLog(statisticsData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildStartParameters startParameters, List<String> failureMessages) {
        void this_$iv;
        String[] stringArray = this.getP();
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        String[] stringArray2 = new String[]{headLine$iv};
        this_$iv.println(stringArray2);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            BuildStartParameters it = startParameters;
            boolean bl2 = false;
            String[] stringArray3 = new String[]{"tasks = " + it.getTasks()};
            this.getP().println(stringArray3);
            stringArray3 = new String[]{"excluded tasks = " + it.getExcludedTasks()};
            this.getP().println(stringArray3);
            stringArray3 = new String[]{"current dir = " + it.getCurrentDir()};
            this.getP().println(stringArray3);
            stringArray3 = new String[]{"project properties args = " + it.getProjectProperties()};
            this.getP().println(stringArray3);
            stringArray3 = new String[]{"system properties args = " + it.getSystemProperties()};
            this.getP().println(stringArray3);
            stringArray2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        this.getP().println(new String[0]);
        if (!((Collection)failureMessages).isEmpty()) {
            stringArray = new String[]{"Build failed: " + failureMessages};
            this.getP().println(stringArray);
            this.getP().println(new String[0]);
        }
    }

    private final void printMetrics(Map<? extends BuildTime, Long> buildTimesMetrics, Map<? extends BuildPerformanceMetric, Long> performanceMetrics, Collection<? extends BuildAttribute> nonIncrementalAttributes, Map<String, Long> gcTimeMetrics, Map<String, Long> gcCountMetrics, boolean aggregatedMetric) {
        this.printBuildTimes(buildTimesMetrics);
        if (aggregatedMetric) {
            this.getP().println(new String[0]);
        }
        this.printBuildPerformanceMetrics(performanceMetrics);
        if (aggregatedMetric) {
            this.getP().println(new String[0]);
        }
        this.printBuildAttributes(nonIncrementalAttributes);
        if (!aggregatedMetric) {
            this.printGcMetrics(gcTimeMetrics, gcCountMetrics);
        }
    }

    static /* synthetic */ void printMetrics$default(FileReportService fileReportService, Map map, Map map2, Collection collection, Map map3, Map map4, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printMetrics");
        }
        if ((n & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            map4 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        fileReportService.printMetrics(map, map2, collection, map3, map4, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printGcMetrics(Map<String, Long> gcTimeMetrics, Map<String, Long> gcCountMetrics) {
        void this_$iv;
        Object object;
        Map<String, Long> it;
        Map<String, Long> map;
        HashSet keys = new HashSet();
        Map<String, Long> map2 = gcCountMetrics;
        if (map2 != null && (map2 = map2.keySet()) != null) {
            it = map = map2;
            boolean bl = false;
            keys.addAll((Collection)((Object)it));
        }
        if ((object = gcTimeMetrics) != null && (object = object.keySet()) != null) {
            it = map = object;
            boolean bl = false;
            keys.addAll((Collection)((Object)it));
        }
        if (keys.isEmpty()) {
            return;
        }
        Printer printer = this.getP();
        String headLine$iv = "GC metrics:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            for (String key : keys) {
                String[] stringArray2 = new String[]{key + ':'};
                this.getP().println(stringArray2);
                Printer $this$iv = this.getP();
                Object headLine$iv2 = null;
                boolean $i$f$withIndent2 = false;
                $this$iv.pushIndent();
                try {
                    Map<String, Long> map3;
                    Object object2;
                    String[] stringArray3;
                    long it2;
                    Map<String, Long> map4;
                    boolean bl2 = false;
                    Map<String, Long> map5 = gcCountMetrics;
                    if (map5 != null && (map5 = map5.get(key)) != null) {
                        map4 = map5;
                        it2 = ((Number)((Object)map4)).longValue();
                        boolean bl3 = false;
                        stringArray3 = new String[]{"GC count: " + it2};
                        this.getP().println(stringArray3);
                    }
                    if ((object2 = gcTimeMetrics) != null && (object2 = object2.get(key)) != null) {
                        map4 = object2;
                        it2 = ((Number)((Object)map4)).longValue();
                        boolean bl4 = false;
                        stringArray3 = new String[]{"GC time: " + FormattingUtilsKt.formatTime(it2)};
                        this.getP().println(stringArray3);
                        map3 = map4;
                    } else {
                        map3 = null;
                    }
                    Map<String, Long> map6 = map3;
                }
                finally {
                    $this$iv.popIndent();
                }
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printBuildTimes(Map<? extends BuildTime, Long> buildTimes) {
        if (buildTimes.isEmpty()) {
            return;
        }
        String[] stringArray = new String[]{"Time metrics:"};
        this.getP().println(stringArray);
        Printer $this$iv = this.getP();
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        $this$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet<BuildTime> visitedBuildTimes = new HashSet<BuildTime>();
            for (BuildTime buildTime : ((BuildTime)CollectionsKt.first((Iterable)buildTimes.keySet())).getAllMetrics()) {
                if (buildTime.getParent() != null) continue;
                FileReportService.printBuildTimes$lambda$20$printBuildTime(visitedBuildTimes, buildTimes, this, buildTime);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$iv.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildPerformanceMetrics(Map<? extends BuildPerformanceMetric, Long> buildMetrics) {
        void this_$iv;
        if (buildMetrics.isEmpty()) {
            return;
        }
        Printer printer = this.getP();
        String headLine$iv = "Size metrics:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            for (BuildPerformanceMetric metric : ((BuildPerformanceMetric)CollectionsKt.first((Iterable)buildMetrics.keySet())).getAllMetrics()) {
                Long l = buildMetrics.get(metric);
                if (l == null) continue;
                long it = ((Number)l).longValue();
                boolean bl2 = false;
                this.printSizeMetric(metric, it);
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    private final void printSizeMetric(BuildPerformanceMetric sizeMetric, long value2) {
        int it;
        int indentLevel = FileReportService.printSizeMetric$numberOfAncestors(sizeMetric);
        int n = 0;
        while (n < indentLevel) {
            it = n++;
            boolean bl = false;
            this.getP().pushIndent();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[sizeMetric.getType().ordinal()]) {
            case 1: {
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + FormattingUtilsKt.formatSize(value2)};
                this.getP().println(bl);
                break;
            }
            case 2: {
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + value2};
                this.getP().println(bl);
                break;
            }
            case 3: {
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + value2};
                this.getP().println(bl);
                break;
            }
            case 4: {
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + FormattingUtilsKt.formatTime(value2)};
                this.getP().println(bl);
                break;
            }
            case 5: {
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + formatter.format(value2)};
                this.getP().println(bl);
            }
        }
        n = 0;
        while (n < indentLevel) {
            it = n++;
            boolean bl = false;
            this.getP().popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(Collection<? extends BuildAttribute> buildAttributes) {
        void this_$iv;
        if (buildAttributes.isEmpty()) {
            return;
        }
        Object $this$groupingBy$iv = buildAttributes;
        boolean $i$f$groupingBy = false;
        Map buildAttributesMap = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<BuildAttribute, BuildAttribute>((Iterable)$this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<BuildAttribute> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                BuildAttribute it = (BuildAttribute)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        $this$groupingBy$iv = this.getP();
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            List list$iv$iv;
            void $this$groupByTo$iv$iv;
            boolean bl = false;
            Iterable $this$groupBy$iv = buildAttributesMap.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap((Map)destination$iv$iv);
            for (Map.Entry entry : ((Map)attributesByKind).entrySet()) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                BuildAttributeKind kind = (BuildAttributeKind)entry.getKey();
                List attributesCounts = (List)entry.getValue();
                Printer printer = this.getP();
                String string = kind.name();
                Intrinsics.checkNotNull((Object)attributesCounts);
                Iterable $i$f$groupByTo2 = attributesCounts;
                String string2 = string;
                Printer printer2 = printer;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                list$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv2;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    boolean bl4 = false;
                    BuildAttribute k = (BuildAttribute)entry2.getKey();
                    int v = ((Number)entry2.getValue()).intValue();
                    entry2 = TuplesKt.to((Object)k.getReadableString(), (Object)v);
                    map.put(entry2.getFirst(), entry2.getSecond());
                }
                Map map = destination$iv$iv2;
                PlainTextBuildReportWriterKt.printMap(printer2, string2, map);
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    private final void printTaskOverview(Collection<? extends CompileStatisticsData<B, P>> statisticsData) {
        long allTasksTimeMs = 0L;
        long kotlinTotalTimeMs = 0L;
        ArrayList<CompileStatisticsData<B, P>> kotlinTasks = new ArrayList<CompileStatisticsData<B, P>>();
        for (CompileStatisticsData<B, P> compileStatisticsData : statisticsData) {
            long taskTimeMs = compileStatisticsData.getDurationMs();
            allTasksTimeMs += taskTimeMs;
            if (!Intrinsics.areEqual((Object)compileStatisticsData.getFromKotlinPlugin(), (Object)true)) continue;
            kotlinTotalTimeMs += taskTimeMs;
            kotlinTasks.add(compileStatisticsData);
        }
        if (kotlinTasks.isEmpty()) {
            String[] stringArray = new String[]{"No Kotlin task was run"};
            this.getP().println(stringArray);
            return;
        }
        String ktTaskPercent = FormattingUtilsKt.asString((double)kotlinTotalTimeMs / (double)allTasksTimeMs * (double)100, 1);
        String[] stringArray = new String[]{"Total time for Kotlin tasks: " + FormattingUtilsKt.formatTime(kotlinTotalTimeMs) + " (" + ktTaskPercent + " % of all tasks time)"};
        this.getP().println(stringArray);
        String[] stringArray2 = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable textTable = new TextTable(stringArray2);
        Function1[] function1Array = new Function1[]{printTaskOverview.1.INSTANCE, printTaskOverview.2.INSTANCE};
        for (CompileStatisticsData task3 : CollectionsKt.sortedWith((Iterable)kotlinTasks, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))) {
            long timeMs = task3.getDurationMs();
            String percent = FormattingUtilsKt.asString((double)timeMs / (double)kotlinTotalTimeMs * (double)100, 1);
            String[] stringArray3 = new String[]{FormattingUtilsKt.formatTime(timeMs), percent + " %", task3.getTaskName()};
            textTable.addRow(stringArray3);
        }
        textTable.printTo(this.getP());
        this.getP().println(new String[0]);
    }

    private final void printTasksLog(List<? extends CompileStatisticsData<B, P>> statisticsData) {
        Function1[] function1Array = new Function1[]{printTasksLog.1.INSTANCE, printTasksLog.2.INSTANCE};
        for (CompileStatisticsData task : CollectionsKt.sortedWith((Iterable)statisticsData, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))) {
            this.printTaskLog(task);
            this.getP().println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(CompileStatisticsData<B, P> statisticsData) {
        Object object;
        String skipMessage = statisticsData.getSkipMessage();
        if (skipMessage != null) {
            object = new String[]{"Task '" + statisticsData.getTaskName() + "' was skipped: " + skipMessage};
            this.getP().println((String)object);
        } else {
            object = new String[]{"Task '" + statisticsData.getTaskName() + "' finished in " + FormattingUtilsKt.formatTime(statisticsData.getDurationMs())};
            this.getP().println((String)object);
        }
        String string = statisticsData.getKotlinLanguageVersion();
        if (string != null) {
            void this_$iv;
            String string2;
            String it = string2 = string;
            boolean bl = false;
            Printer printer = this.getP();
            String headLine$iv = "Task info:";
            boolean $i$f$withIndent = false;
            Object object2 = new String[]{headLine$iv};
            this_$iv.println((String[])object2);
            this_$iv.pushIndent();
            try {
                boolean bl2 = false;
                String[] stringArray = new String[]{"Kotlin language version: " + it};
                this.getP().println(stringArray);
                object2 = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        if (!((Collection)statisticsData.getIcLogLines()).isEmpty()) {
            void this_$iv;
            object = this.getP();
            String headLine$iv = "Compilation log for task '" + statisticsData.getTaskName() + "':";
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                String[] stringArray = new String[]{headLine$iv};
                this_$iv.println(stringArray);
            }
            this_$iv.pushIndent();
            try {
                boolean bl = false;
                Iterable $this$forEach$iv = statisticsData.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    String[] stringArray = new String[]{it};
                    this.getP().println(stringArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        if (this.printMetrics) {
            FileReportService.printMetrics$default(this, statisticsData.getBuildTimesMetrics(), statisticsData.getPerformanceMetrics(), statisticsData.getNonIncrementalAttributes(), statisticsData.getGcTimeMetrics(), statisticsData.getGcCountMetrics(), false, 32, null);
            this.printCustomTaskMetrics(statisticsData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <B extends BuildTime, P extends BuildPerformanceMetric> void printBuildTimes$lambda$20$printBuildTime(HashSet<BuildTime> visitedBuildTimes, Map<? extends BuildTime, Long> $buildTimes, FileReportService<B, P> this$0, BuildTime buildTime) {
        block9: {
            if (!visitedBuildTimes.add(buildTime)) {
                return;
            }
            Long timeMs = $buildTimes.get(buildTime);
            if (timeMs != null) {
                String[] stringArray = new String[]{buildTime.getReadableString() + ": " + FormattingUtilsKt.formatTime(timeMs)};
                this$0.getP().println(stringArray);
                Printer $this$iv = this$0.getP();
                Object headLine$iv = null;
                boolean $i$f$withIndent = false;
                $this$iv.pushIndent();
                try {
                    Unit unit;
                    boolean bl = false;
                    List<BuildTime> list = buildTime.children();
                    if (list != null) {
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BuildTime it = (BuildTime)element$iv;
                            boolean bl2 = false;
                            FileReportService.printBuildTimes$lambda$20$printBuildTime(visitedBuildTimes, $buildTimes, this$0, it);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    $this$iv.popIndent();
                }
            }
            List<BuildTime> list = buildTime.children();
            if (list == null) break block9;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BuildTime it = (BuildTime)element$iv;
                boolean bl = false;
                FileReportService.printBuildTimes$lambda$20$printBuildTime(visitedBuildTimes, $buildTimes, this$0, it);
            }
        }
    }

    private static final int printSizeMetric$numberOfAncestors(BuildPerformanceMetric $this$printSizeMetric_u24numberOfAncestors) {
        int count = 0;
        for (BuildPerformanceMetric parent = $this$printSizeMetric_u24numberOfAncestors.getParent(); parent != null; parent = parent.getParent()) {
            ++count;
        }
        return count;
    }

    static {
        SimpleDateFormat simpleDateFormat;
        Companion = new Companion(null);
        SimpleDateFormat it = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        boolean bl = false;
        it.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter = simpleDateFormat;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/file/FileReportService$Companion;", "", "()V", "formatter", "Ljava/text/SimpleDateFormat;", "kotlin-build-statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NANOSECONDS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

