/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/StringTemplateExpressionManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", "", "psi"})
public final class StringTemplateExpressionManipulator
extends AbstractElementManipulator<KtStringTemplateExpression> {
    @Nullable
    public KtStringTemplateExpression handleContentChange(@NotNull KtStringTemplateExpression element, @NotNull TextRange range, @NotNull String newContent) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        ASTNode node = aSTNode;
        String string = node.getFirstChildNode().getTextLength() == 1 ? StringUtil.escapeStringCharacters((String)newContent) : newContent;
        Intrinsics.checkNotNull((Object)string);
        String content2 = string;
        String string2 = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String oldText = string2;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = oldText.substring(0, range.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(content2);
        String string4 = oldText.substring(range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String newText = stringBuilder2.append(string4).toString();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression expression = new KtPsiFactory(project, false, 2, null).createExpression(newText);
        node.replaceAllChildrenToChildrenOf(expression.getNode());
        return (KtStringTemplateExpression)node.getPsi(KtStringTemplateExpression.class);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KtPsiUtilKt.getContentRange(element);
    }
}

