/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmOverridesBackwardCompatibilityHelper;", "Lorg/jetbrains/kotlin/resolve/OverridesBackwardCompatibilityHelper;", "()V", "isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden", "", "overriddenDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "visitedDescriptors", "", "isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden", "overrideCanBeOmitted", "overridingDescriptor", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmOverridesBackwardCompatibilityHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOverridesBackwardCompatibilityHelper.kt\norg/jetbrains/kotlin/resolve/jvm/JvmOverridesBackwardCompatibilityHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1724#2,3:83\n1724#2,3:86\n*S KotlinDebug\n*F\n+ 1 JvmOverridesBackwardCompatibilityHelper.kt\norg/jetbrains/kotlin/resolve/jvm/JvmOverridesBackwardCompatibilityHelper\n*L\n31#1:83,3\n78#1:86,3\n*E\n"})
public final class JvmOverridesBackwardCompatibilityHelper
implements OverridesBackwardCompatibilityHelper {
    @NotNull
    public static final JvmOverridesBackwardCompatibilityHelper INSTANCE = new JvmOverridesBackwardCompatibilityHelper();

    private JvmOverridesBackwardCompatibilityHelper() {
    }

    public boolean overrideCanBeOmitted(@NotNull CallableMemberDescriptor overridingDescriptor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)overridingDescriptor, (String)"overridingDescriptor");
            HashSet visitedDescriptors = new HashSet();
            Collection collection = overridingDescriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (INSTANCE.isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden(it, visitedDescriptors)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden(CallableMemberDescriptor overriddenDescriptor, Set<CallableMemberDescriptor> visitedDescriptors) {
        if (overriddenDescriptor.getModality() == Modality.FINAL) {
            return false;
        }
        if (visitedDescriptors.contains(overriddenDescriptor.getOriginal())) {
            return true;
        }
        CallableMemberDescriptor callableMemberDescriptor = overriddenDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"getOriginal(...)");
        visitedDescriptors.add(callableMemberDescriptor);
        switch (WhenMappings.$EnumSwitchMapping$0[overriddenDescriptor.getKind().ordinal()]) {
            case 1: 
            case 2: {
                return this.isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden(overriddenDescriptor, visitedDescriptors);
            }
            case 3: {
                if (overriddenDescriptor.getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME())) {
                    return true;
                }
                if (overriddenDescriptor instanceof JavaMethodDescriptor) {
                    ClassDescriptor classDescriptor = DescriptorUtils.getContainingClass((DeclarationDescriptor)((DeclarationDescriptor)overriddenDescriptor));
                    if (classDescriptor == null) {
                        return false;
                    }
                    ClassDescriptor containingClass = classDescriptor;
                    if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)containingClass))) != null) {
                        return true;
                    }
                    if (((JavaMethodDescriptor)overriddenDescriptor).getOverriddenDescriptors().isEmpty()) {
                        return false;
                    }
                    return this.isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden(overriddenDescriptor, visitedDescriptors);
                }
                return false;
            }
        }
        return false;
    }

    private final boolean isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden(CallableMemberDescriptor overriddenDescriptor, Set<CallableMemberDescriptor> visitedDescriptors) {
        boolean bl;
        block3: {
            Collection collection = overriddenDescriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (INSTANCE.isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden(it, visitedDescriptors)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

