/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nUpperBoundViolatedInTypealiasConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpperBoundViolatedInTypealiasConstructorChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n142#2:54\n1177#3,2:55\n1251#3,4:57\n1547#3:61\n1618#3,3:62\n*S KotlinDebug\n*F\n+ 1 UpperBoundViolatedInTypealiasConstructorChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker\n*L\n25#1:54\n31#1:55,2\n31#1:57,4\n37#1:61\n37#1:62,3\n*E\n"})
public final class UpperBoundViolatedInTypealiasConstructorChecker
implements CallChecker {
    @NotNull
    public static final UpperBoundViolatedInTypealiasConstructorChecker INSTANCE = new UpperBoundViolatedInTypealiasConstructorChecker();

    private UpperBoundViolatedInTypealiasConstructorChecker() {
    }

    /*
     * WARNING - void declaration
     */
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        void $this$mapTo$iv$iv;
        IndexedValue it;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = callableDescriptor instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)callableDescriptor : null;
        if (typeAliasConstructorDescriptor == null) {
            return;
        }
        TypeAliasConstructorDescriptor resultingDescriptor = typeAliasConstructorDescriptor;
        PsiElement $this$getStrictParentOfType$iv = reportOn;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        KotlinType kotlinType = resultingDescriptor.getUnderlyingConstructorDescriptor().getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getReturnType(...)");
        KotlinType underlyingConstructedType = kotlinType;
        List underlyingTypeArguments = underlyingConstructedType.getArguments();
        List list = resultingDescriptor.getUnderlyingConstructorDescriptor().getReturnType().getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        List underlyingTypeParameters = list;
        ClassicTypeCheckerState state = new ClassicTypeCheckerState(false, false, null, null, null, 30, null);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)underlyingTypeParameters);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object object = destination$iv$iv;
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = new Pair((Object)((TypeParameterDescriptor)it.getValue()).getTypeConstructor(), (Object)((TypeProjection)underlyingTypeArguments.get(it.getIndex())).getType().unwrap());
            object.put(it.getFirst(), it.getSecond());
        }
        Map map = destination$iv$iv;
        NewTypeSubstitutorByConstructorMap substitutor = new NewTypeSubstitutorByConstructorMap(map);
        List list2 = resolvedCall.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
        List aliasTypeParameters = list2;
        Iterable $this$map$iv = resultingDescriptor.getTypeAliasDescriptor().getUnderlyingType().getArguments();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getType());
        }
        List originalTypes = (List)destination$iv$iv2;
        Iterator iterator2 = ((Iterable)CollectionsKt.zip((Iterable)underlyingTypeArguments, (Iterable)underlyingTypeParameters)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Pair argumentAndParameter = (Pair)iterator2.next();
            TypeProjection argument2 = (TypeProjection)argumentAndParameter.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)argumentAndParameter.component2();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.getOrNull((List)aliasTypeParameters, (int)index);
            if (Intrinsics.areEqual((Object)(typeParameterDescriptor != null ? typeParameterDescriptor.getDefaultType() : null), (Object)CollectionsKt.getOrNull((List)originalTypes, (int)index))) continue;
            for (KotlinType upperBound : parameter.getUpperBounds()) {
                TypeCheckerState typeCheckerState2 = (TypeCheckerState)state;
                KotlinType kotlinType2 = argument2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)kotlinType2, (KotlinTypeMarker)substitutor.safeSubstitute(upperBound.unwrap()), false, 8, null)) continue;
                List<KtTypeProjection> list3 = callExpression.getTypeArguments();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeArguments(...)");
                KtModifierListOwnerStub ktModifierListOwnerStub = (KtTypeProjection)CollectionsKt.getOrNull(list3, (int)index);
                if (ktModifierListOwnerStub == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) continue;
                KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
                context.getTrace().report((Diagnostic)Errors.UPPER_BOUND_VIOLATED_WARNING.on((PsiElement)typeReference, (Object)upperBound, (Object)argument2.getType()));
            }
        }
    }
}

