/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ssh.AgentProxyConnectorFactory;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.NamedPipeAgentConnector;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.ShellChannelConfig;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.ssh.impl.channels.FailSafeSftpChannel;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.messages.Topic;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 C2\u00020\u0001:\u0002CDB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020(J \u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0-H\u0007J\b\u0010.\u001a\u00020\u0006H\u0002J\u0018\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u000202H\u0002J\u001e\u00103\u001a\u00020!2\b\b\u0001\u00100\u001a\u00020\u00062\n\b\u0001\u00104\u001a\u0004\u0018\u00010\u0006H\u0002J3\u00105\u001a\u0002H6\"\b\b\u0000\u00106*\u0002072\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002H609H\u0002\u00a2\u0006\u0002\u0010;J\u0012\u0010<\u001a\u00020!2\b\u0010=\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010>\u001a\u00020!H\u0007J\u0016\u0010?\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020(J\u0016\u0010@\u001a\u00020A2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020BR\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0006\u00a2\u0006\u0002\b\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/ssh/SshConnectionService;", "Lcom/intellij/openapi/Disposable;", "()V", "agentProxyConnector", "Lkotlin/Pair;", "Lcom/jcraft/jsch/agentproxy/Connector;", "", "agentProxyConnectorFactory", "Lcom/intellij/ssh/AgentProxyConnectorFactory;", "getAgentProxyConnectorFactory", "()Lcom/intellij/ssh/AgentProxyConnectorFactory;", "overridenSshAuthSock", "pageantName", "Lcom/intellij/openapi/util/NlsSafe;", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ssh/SshSessionKey;", "Lcom/intellij/ssh/impl/SshConnection;", "sshAgentName", "sshAgentProxyLock", "", "sshConnectionsGroup", "Lcom/intellij/notification/NotificationGroup;", "checkCanAuthenticate", "", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "addToPool", "connect", "Lcom/intellij/ssh/SshSession;", "createSshAgentConnector", "customUnixSocketPath", "dispose", "", "exec", "Lcom/intellij/ssh/channels/ExecChannel;", "channelConfig", "Lcom/intellij/ssh/ExecChannelConfig;", "failSafeSftp", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/SftpChannelConfig;", "getAgentProxyConnector", "path", "getOrCreateSshConnection", "getSessions", "", "getSshAuthSock", "logAgentProxyException", "authAgentName", "e", "Lcom/jcraft/jsch/agentproxy/AgentProxyException;", "notifyAgentProxyCreationFailure", "errorMessage", "openChannel", "R", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lkotlin/Function1;", "Lcom/intellij/ssh/SshSessionChannelFactory;", "(Lcom/intellij/ssh/SessionConfig;Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "overrideSshAuthSock", "value", "reset", "sftp", "shell", "Lcom/intellij/ssh/channels/ShellChannel;", "Lcom/intellij/ssh/ShellChannelConfig;", "Companion", "Listener", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,299:1\n1#2:300\n76#3:301\n96#3,5:302\n*S KotlinDebug\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService\n*L\n253#1:301\n253#1:302,5\n*E\n"})
public final class SshConnectionService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationGroup sshConnectionsGroup = NotificationGroup.Companion.balloonGroup("SSH Connections", SshBundle.message("ssh.connections.notifications.group.title", new Object[0]));
    @NotNull
    private final String pageantName;
    @NotNull
    private final String sshAgentName;
    @Nullable
    private Pair<? extends Connector, String> agentProxyConnector;
    @NotNull
    private final ConcurrentHashMap<SshSessionKey, SshConnection> pool = new ConcurrentHashMap();
    @NotNull
    private final Object sshAgentProxyLock = new Object();
    @NotNull
    private final AgentProxyConnectorFactory agentProxyConnectorFactory;
    @Nullable
    private volatile String overridenSshAuthSock;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SSH_AUTH_SOCK = "SSH_AUTH_SOCK";
    @NotNull
    private static final Topic<Listener> TOPIC;

    public SshConnectionService() {
        this.pageantName = "Pageant";
        this.sshAgentName = "ssh-agent";
        SshConnectionService sshConnectionService = this;
        SshConnectionService sshConnectionService2 = this;
        boolean bl = false;
        sshConnectionService2.agentProxyConnectorFactory = new AgentProxyConnectorFactory(this, sshConnectionService){
            final /* synthetic */ SshConnectionService this$0;
            final /* synthetic */ SshConnectionService $sshConnectionService;
            {
                this.this$0 = $receiver;
                this.$sshConnectionService = $sshConnectionService;
            }

            @Nullable
            public Pair<Connector, String> get(@Nullable String path) {
                return SshConnectionService.access$getAgentProxyConnector(this.this$0, path);
            }

            @NotNull
            public String toString() {
                return "<AgentProxyConnectionFactory of " + this.$sshConnectionService + "}>";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.sshAgentProxyLock;
        synchronized (object) {
            boolean $i$a$-synchronized-SshConnectionService$dispose$22 = false;
            this.agentProxyConnector = null;
            Unit $i$a$-synchronized-SshConnectionService$dispose$22 = Unit.INSTANCE;
        }
        LOG.debug("Disconnecting SSH connections on " + SshConnectionService.class + " dispose");
        Iterator iterator = ((Map)this.pool).entrySet().iterator();
        while (iterator.hasNext()) {
            SshConnection value = (SshConnection)iterator.next().getValue();
            value.dispose();
        }
        this.pool.clear();
    }

    @TestOnly
    public final void reset() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Connector, String> getAgentProxyConnector(String path) {
        Object object = this.sshAgentProxyLock;
        synchronized (object) {
            block5: {
                boolean bl = false;
                String string = path;
                if (string == null) break block5;
                String it = string;
                boolean bl2 = false;
                Pair<Connector, String> pair = this.createSshAgentConnector(it);
                return pair;
            }
            Pair<? extends Connector, String> pair = this.agentProxyConnector;
            if (pair == null) {
                Pair<Connector, String> pair2;
                Pair<Connector, String> it = pair2 = this.createSshAgentConnector(null);
                boolean bl = false;
                this.agentProxyConnector = it;
                pair = pair2;
            }
            Pair<? extends Connector, String> pair3 = pair;
            return pair3;
        }
    }

    @NotNull
    public final AgentProxyConnectorFactory getAgentProxyConnectorFactory() {
        return this.agentProxyConnectorFactory;
    }

    private final Pair<Connector, String> createSshAgentConnector(String customUnixSocketPath) {
        LOG.debug("Creating authentication agent connector");
        if (SystemInfo.isWindows) {
            NamedPipeAgentConnector namedPipeAgentConnector;
            if (Registry.is((String)"openssh.agent.windows") && (namedPipeAgentConnector = NamedPipeAgentConnector.Companion.getInstance()).isAvailable()) {
                return TuplesKt.to((Object)namedPipeAgentConnector, (Object)namedPipeAgentConnector.getName());
            }
            try {
                return TuplesKt.to((Object)new PageantConnector(), (Object)"pageant");
            }
            catch (AgentProxyException e) {
                this.logAgentProxyException("Pageant", e);
                this.notifyAgentProxyCreationFailure(this.pageantName, e.getMessage());
            }
        } else {
            String pathToAuthSock = null;
            if (customUnixSocketPath != null) {
                if (!Files.exists(Paths.get(customUnixSocketPath, new String[0]), new LinkOption[0]) || ((CharSequence)customUnixSocketPath).length() == 0) {
                    LOG.info("Path " + customUnixSocketPath + " to SSH agent socket is incorrect");
                    Object[] objectArray = new Object[]{customUnixSocketPath};
                    this.notifyAgentProxyCreationFailure(this.sshAgentName, SshBundle.message("ssh.connection.service.0.path.to.auth.socket.is.incorrect", objectArray));
                    return null;
                }
                pathToAuthSock = customUnixSocketPath;
                LOG.debug("UNIX-domain socket by path " + customUnixSocketPath + " will be used to connect to authentication agent");
            } else {
                pathToAuthSock = this.getSshAuthSock();
                if (((CharSequence)pathToAuthSock).length() == 0) {
                    LOG.info("SSH_AUTH_SOCK environment variable is not defined");
                    Object[] objectArray = new Object[]{SSH_AUTH_SOCK};
                    this.notifyAgentProxyCreationFailure(this.sshAgentName, SshBundle.message("ssh.connection.service.0.environment.variable.is.not.defined", objectArray));
                    return null;
                }
                LOG.debug("UNIX-domain socket " + pathToAuthSock + " defined in environment variable SSH_AUTH_SOCK will be used to connect to authentication agent");
            }
            try {
                return TuplesKt.to((Object)new SSHAgentConnector((USocketFactory)new JNAUSocketFactory(), pathToAuthSock), (Object)("ssh-agent[" + pathToAuthSock + "]"));
            }
            catch (AgentProxyException e) {
                this.logAgentProxyException("ssh-agent", e);
                this.notifyAgentProxyCreationFailure(this.sshAgentName, e.getMessage());
            }
        }
        return null;
    }

    private final void logAgentProxyException(String authAgentName, AgentProxyException e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed to create " + authAgentName + " proxy", (Throwable)e);
        } else {
            LOG.info("Failed to create " + authAgentName + " proxy: " + e);
        }
    }

    private final void notifyAgentProxyCreationFailure(@NlsSafe String authAgentName, @Nls(capitalization=Nls.Capitalization.Sentence) String errorMessage) {
        Object[] objectArray = new Object[]{authAgentName, errorMessage};
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(SshBundle.message("ssh.connection.service.unable.to.connect.to.0.1", objectArray)).br().append("\n\n");
        objectArray = new Object[]{authAgentName};
        String string = htmlBuilder.append(SshBundle.message("ssh.connection.service.using.0.during.ssh.key.based.authentication.process.disabled", objectArray)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String content = string;
        objectArray = new Object[]{authAgentName};
        String string2 = SshBundle.message("ssh.connection.service.notification.title.authentication.using", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.sshConnectionsGroup.createNotification(string2, content, NotificationType.WARNING).notify(null);
    }

    private final SshConnection getOrCreateSshConnection(SessionConfig sessionConfig) {
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection = this.pool.computeIfAbsent(sessionKey, arg_0 -> SshConnectionService.getOrCreateSshConnection$lambda$5((Function1)new Function1<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;
            {
                this.$sessionKey = $sessionKey;
                super(1);
            }

            @NotNull
            public final SshConnection invoke(@NotNull SshSessionKey it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sshConnection, (String)"computeIfAbsent(...)");
        return sshConnection;
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.getOrCreateSshConnection(sessionConfig).getSshSession(sessionConfig);
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig, boolean addToPool) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.getOrCreateSshConnection(sessionConfig).checkCanAuthenticate(sessionConfig, addToPool);
    }

    public static /* synthetic */ boolean checkCanAuthenticate$default(SshConnectionService sshConnectionService, SessionConfig sessionConfig, boolean bl, int n, Object object) throws SshException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sshConnectionService.checkCanAuthenticate(sessionConfig, bl);
    }

    @NotNull
    public final ExecChannel exec(@NotNull SessionConfig sessionConfig, @NotNull ExecChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return (ExecChannel)this.getOrCreateSshConnection(sessionConfig).openChannel(sessionConfig, (Function1)new Function1<SshSessionChannelFactory, ExecChannel>(channelConfig){
            final /* synthetic */ ExecChannelConfig $channelConfig;
            {
                this.$channelConfig = $channelConfig;
                super(1);
            }

            @NotNull
            public final ExecChannel invoke(@NotNull SshSessionChannelFactory session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                SshConnectionService.access$getLOG$cp().debug("Executing SSH command: " + this.$channelConfig.getCommand() + " within " + session);
                return session.execChannel(this.$channelConfig);
            }
        });
    }

    @NotNull
    public final SftpChannel sftp(@NotNull SessionConfig sessionConfig, @NotNull SftpChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return (SftpChannel)this.getOrCreateSshConnection(sessionConfig).openChannel(sessionConfig, (Function1)new Function1<SshSessionChannelFactory, SftpChannel>(channelConfig){
            final /* synthetic */ SftpChannelConfig $channelConfig;
            {
                this.$channelConfig = $channelConfig;
                super(1);
            }

            @NotNull
            public final SftpChannel invoke(@NotNull SshSessionChannelFactory session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                SshConnectionService.access$getLOG$cp().debug("Creating sftp channel within " + session);
                return session.sftpChannel(this.$channelConfig);
            }
        });
    }

    @NotNull
    public final SftpChannel failSafeSftp(@NotNull SessionConfig sessionConfig, @NotNull SftpChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return new FailSafeSftpChannel((Function0<? extends SftpChannel>)((Function0)new Function0<SftpChannel>(this, sessionConfig, channelConfig){
            final /* synthetic */ SshConnectionService this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            final /* synthetic */ SftpChannelConfig $channelConfig;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                this.$channelConfig = $channelConfig;
                super(0);
            }

            @NotNull
            public final SftpChannel invoke() {
                return this.this$0.sftp(this.$sessionConfig, this.$channelConfig);
            }
        }));
    }

    @NotNull
    public final ShellChannel shell(@NotNull SessionConfig sessionConfig, @NotNull ShellChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return (ShellChannel)this.openChannel(sessionConfig, (Function1)new Function1<SshSessionChannelFactory, ShellChannel>(channelConfig){
            final /* synthetic */ ShellChannelConfig $channelConfig;
            {
                this.$channelConfig = $channelConfig;
                super(1);
            }

            @NotNull
            public final ShellChannel invoke(@NotNull SshSessionChannelFactory session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                SshConnectionService.access$getLOG$cp().debug("Creating shell channel within " + session);
                return session.shellChannel(this.$channelConfig);
            }
        });
    }

    private final <R extends SshChannel> R openChannel(SessionConfig sessionConfig, Function1<? super SshSessionChannelFactory, ? extends R> channelCreator) throws SshException {
        return this.getOrCreateSshConnection(sessionConfig).openChannel(sessionConfig, channelCreator);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final List<SshSession> getSessions() {
        void $this$flatMapTo$iv$iv;
        Map $this$flatMap$iv = this.pool;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = ((SshConnection)it.getValue()).getSessions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getSshAuthSock() {
        String sockFromNewShellProc = (String)EnvironmentUtil.getEnvironmentMap().get(SSH_AUTH_SOCK);
        String string = this.overridenSshAuthSock;
        if (string == null && (string = sockFromNewShellProc) == null) {
            string = "";
        }
        return string;
    }

    @TestOnly
    public final void overrideSshAuthSock(@Nullable String value) {
        this.overridenSshAuthSock = value;
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return SshConnectionService.checkCanAuthenticate$default(this, sessionConfig, false, 2, null);
    }

    private static final SshConnection getOrCreateSshConnection$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SshConnection)$tmp0.invoke(p0);
    }

    @NotNull
    public static final SshConnectionService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Pair access$getAgentProxyConnector(SshConnectionService $this, String path) {
        return $this.getAgentProxyConnector(path);
    }

    static {
        Logger logger = Logger.getInstance(SshConnectionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Topic topic = Topic.create((String)"SshConnectionService", Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ssh/SshConnectionService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SSH_AUTH_SOCK", "", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/ssh/SshConnectionService$Listener;", "kotlin.jvm.PlatformType", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "instance", "Lcom/intellij/ssh/SshConnectionService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/ssh/SshConnectionService;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,299:1\n43#2,3:300\n*S KotlinDebug\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService$Companion\n*L\n290#1:300,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SshConnectionService getInstance() {
            boolean $i$f$service = false;
            Class<SshConnectionService> serviceClass$iv = SshConnectionService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (SshConnectionService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ssh/SshConnectionService$Listener;", "", "sessionOrChannelRequested", "", "userName", "", "host", "port", "", "intellij.platform.ssh"})
    public static interface Listener {
        public void sessionOrChannelRequested(@NotNull String var1, @NotNull String var2, int var3);
    }
}

