/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConfigsMasterComponent;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigComboBox
extends ComboboxWithBrowseButton
implements SshConfigManager.Listener {
    private static final Logger LOG = Logger.getInstance(SshConfigComboBox.class);
    @Nullable
    private Project myProject;
    @NotNull
    private final SshConfigVisibility myDefaultVisibility;
    private Runnable myChangesListener;
    private SshConfigManager.ConfigsData myData;

    public SshConfigComboBox(@Nullable Project project2, @NotNull Disposable parent, @NotNull SshConfigVisibility defaultVisibility) {
        if (parent == null) {
            SshConfigComboBox.$$$reportNull$$$0(0);
        }
        if (defaultVisibility == null) {
            SshConfigComboBox.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(project2 != null && !project2.isDefault() || defaultVisibility == SshConfigVisibility.App, (Object)"Form without project can't create project-level ssh configurations");
        this.myDefaultVisibility = defaultVisibility;
        this.myProject = project2;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.getMyComboBox().setPrototypeDisplayValue(new NothingSelectedDataWrapper(true));
        this.getMyComboBox().setRenderer((ListCellRenderer<DataWrapper>)new ColoredListCellRenderer<DataWrapper>(){

            protected void customizeCellRenderer(@NotNull JList<? extends DataWrapper> list2, DataWrapper item, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.clear();
                if (item == null) {
                    return;
                }
                SshUiData data = item.getData();
                if (data != null) {
                    SshConfigsMasterComponent.renderData(data, (SimpleColoredComponent)this);
                } else {
                    SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (!item.isConfigured()) {
                        attributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
                    }
                    if (item instanceof NothingSelectedDataWrapper) {
                        attributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    }
                    this.append(item.getPresentableName(), attributes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ssh/ui/unified/SshConfigComboBox$1", "customizeCellRenderer"));
            }
        });
        this.getMyComboBox().setModel((ComboBoxModel<DataWrapper>)new MutableCollectionComboBoxModel());
        this.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 && e.getStateChange() != 2) {
                    return;
                }
                SshConfigComboBox.this.runChangeListener();
            }
        });
        this.myData = SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData();
        MessageBus bus = project2 == null || project2.isDefault() ? ApplicationManager.getApplication().getMessageBus() : project2.getMessageBus();
        bus.connect(parent).subscribe(SshConfigManager.SSH_CONFIGS, (Object)this);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshConfigComboBox.this.edit(false);
            }
        });
    }

    public void edit(final boolean clone) {
        final DataWrapper wrapper = this.getSelectedWrapper();
        final SshUiData selected = wrapper == null ? null : wrapper.getData();
        final SshConfigConfigurable.ComboBoxConfigurable configurable = new SshConfigConfigurable.ComboBoxConfigurable(this.myProject, selected, this.myData, this.myDefaultVisibility);
        String dimensionKey = ShowSettingsUtilImpl.createDimensionKey((Configurable)configurable);
        DialogWrapper editor = SettingsDialogFactory.getInstance().create(this.myProject, dimensionKey, (Configurable)configurable, true, false);
        UiNotifyConnector.Once.installOn((Component)editor.getContentPane(), (Activatable)new Activatable(){

            public void showNotify() {
                SshConfigManager.ConfigsData currentData = SshConfigComboBox.this.myData;
                SshUiData selectedData = selected;
                if (wrapper != null && !wrapper.isConfigured()) {
                    SshUiData data;
                    selectedData = data = SshUiData.createData(wrapper.getName(), wrapper.getId(), wrapper.getVisibility());
                    currentData = currentData.createMerged(new SshConfigManager.ConfigsData(Collections.emptyList(), Collections.singletonList(data)));
                }
                configurable.resetFromData(currentData);
                if (clone && selectedData != null) {
                    SshUiData cloned = selectedData.clone();
                    SshConfig config = cloned.getConfig();
                    config.setId(UUID.randomUUID().toString());
                    Set names = ContainerUtil.map2Set(currentData.getCurrentData(), c -> c.getName());
                    String name = UniqueNameGenerator.generateUniqueName((String)config.getName(), (Collection)names);
                    config.setCustomName(name);
                    configurable.add(cloned);
                } else {
                    configurable.select(selectedData);
                }
            }
        });
        boolean ok = editor.showAndGet();
        if (!ok) {
            return;
        }
        SshUiData data = configurable.getLastSelectedData();
        if (data == null) {
            this.reload();
        } else {
            this.reload(data.getConfig().createPresentableId(), data.getConfig().getVisibility());
        }
    }

    private void runChangeListener() {
        if (this.myChangesListener != null) {
            this.myChangesListener.run();
        }
    }

    public void setDataListener(@NotNull Runnable listener) {
        if (listener == null) {
            SshConfigComboBox.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.myChangesListener == null, (Object)"Only one listener is supported so far");
        this.myChangesListener = listener;
    }

    @NotNull
    private JComboBox<DataWrapper> getMyComboBox() {
        JComboBox jComboBox = (JComboBox)this.getChildComponent();
        if (jComboBox == null) {
            SshConfigComboBox.$$$reportNull$$$0(3);
        }
        return jComboBox;
    }

    @Nullable
    public PresentableId getSelectedPresentableId() {
        DataWrapper item = this.getSelectedWrapper();
        if (item == null) {
            return null;
        }
        if (item.getData() == null) {
            return PresentableId.createId(null, (String)item.getName());
        }
        return item.getData().getConfig().createPresentableId();
    }

    @Nullable
    public @Nullable Pair<@Nullable SshUiData, @NotNull String> getSelectedUiDataAndName() {
        DataWrapper item = this.getSelectedWrapper();
        return item == null ? null : new Pair((Object)item.getData(), (Object)item.getName());
    }

    @Nullable
    public @Nullable Pair<@Nullable SshUiData, PresentableId> getSelectedUiDataAndPresentableId() {
        DataWrapper item = this.getSelectedWrapper();
        return item == null ? null : new Pair((Object)item.getData(), (Object)PresentableId.createId((String)item.getId(), (String)item.getName()));
    }

    @Nullable
    public SshConfig getSelectedSshConfig() {
        DataWrapper item = this.getSelectedWrapper();
        if (item == null) {
            return null;
        }
        SshUiData data = item.getData();
        if (data == null) {
            return null;
        }
        return data.getConfig().clone();
    }

    @Nullable
    private DataWrapper getSelectedWrapper() {
        Object item = this.getMyComboBox().getSelectedItem();
        return item instanceof DataWrapper && !(item instanceof NothingSelectedDataWrapper) ? (DataWrapper)item : null;
    }

    public void select(@Nullable SshConfig sshConfigToSelect) {
        DataWrapper itemToSelect = null;
        MutableCollectionComboBoxModel<DataWrapper> model = this.getComboBoxModel();
        List items = model.getItems();
        if (sshConfigToSelect == null) {
            for (DataWrapper item : items) {
                if (!(item instanceof NothingSelectedDataWrapper)) continue;
                itemToSelect = item;
                break;
            }
            if (itemToSelect == null) {
                itemToSelect = new NothingSelectedDataWrapper(items.isEmpty());
                model.add((Object)itemToSelect);
            }
        } else {
            for (DataWrapper item : items) {
                if (!sshConfigToSelect.getId().equals(item.getId())) continue;
                itemToSelect = item;
                break;
            }
            if (itemToSelect == null) {
                itemToSelect = SshConfigComboBox.wrap(sshConfigToSelect);
                model.add((Object)itemToSelect);
            }
        }
        this.getComboBox().setSelectedItem(itemToSelect);
    }

    public void reload() {
        this.changeData(this.myData.getCurrentData(), null, null, SshConfigVisibility.Project);
    }

    public void reload(@Nullable PresentableId configToSelect, SshConfigVisibility configVisibility) {
        List<SshUiData> currentData = this.myData.getCurrentData();
        SshUiData dataToSelect = SshConfigManager.findData(configToSelect, currentData);
        this.changeData(currentData, dataToSelect, configToSelect, configVisibility);
    }

    private void changeData(@NotNull List<SshUiData> currentData, @Nullable SshUiData dataToSelect, @Nullable PresentableId nonExistingNameToSelect, SshConfigVisibility configVisibility) {
        if (currentData == null) {
            SshConfigComboBox.$$$reportNull$$$0(4);
        }
        ArrayList<DataWrapper> wrappers = new ArrayList<DataWrapper>(currentData.size());
        DataWrapper selection = null;
        for (SshUiData datum : currentData) {
            DataWrapper wrap = SshConfigComboBox.wrap(datum);
            wrappers.add(wrap);
            if (datum != dataToSelect) continue;
            selection = wrap;
        }
        if (selection == null) {
            if (nonExistingNameToSelect != null && nonExistingNameToSelect.getName() != null) {
                selection = SshConfigComboBox.wrap(nonExistingNameToSelect.getName(), nonExistingNameToSelect.getId(), configVisibility);
                wrappers.add(selection);
            } else {
                selection = new NothingSelectedDataWrapper(wrappers.isEmpty());
            }
        }
        MutableCollectionComboBoxModel<DataWrapper> model = this.getComboBoxModel();
        model.update(wrappers);
        model.setSelectedItem((Object)selection);
        if (wrappers.size() > 1 || wrappers.size() == 1 && !(wrappers.get(0) instanceof NothingSelectedDataWrapper)) {
            this.getMyComboBox().setPrototypeDisplayValue(null);
        }
        this.runChangeListener();
    }

    private MutableCollectionComboBoxModel<DataWrapper> getComboBoxModel() {
        return (MutableCollectionComboBoxModel)this.getMyComboBox().getModel();
    }

    public boolean isSelected(@Nullable String nameToSelect) {
        DataWrapper wrapper = this.getSelectedWrapper();
        if (nameToSelect == null) {
            return wrapper == null;
        }
        if (wrapper == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)nameToSelect, (CharSequence)wrapper.getName());
    }

    public void dispose() {
        super.dispose();
        this.myChangesListener = null;
        this.myProject = null;
    }

    @Override
    public void sshConfigsChanged() {
        this.myData = SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData();
        List<SshUiData> currentData = this.myData.getCurrentData();
        DataWrapper initiallySelectedWrapper = this.getSelectedWrapper();
        SshUiData newSelectedData = null;
        if (initiallySelectedWrapper != null) {
            SshUiData selectedData = initiallySelectedWrapper.getData();
            if (selectedData != null) {
                newSelectedData = SshUiData.findById(currentData, selectedData.getConfig().getId());
            }
            if (newSelectedData == null) {
                newSelectedData = SshUiData.findByName(currentData, initiallySelectedWrapper.getName());
            }
        }
        PresentableId nonExistentNameToSelect = null;
        SshConfigVisibility visibility = SshConfigVisibility.Project;
        if (initiallySelectedWrapper != null && newSelectedData == null) {
            nonExistentNameToSelect = PresentableId.createId((String)initiallySelectedWrapper.getId(), (String)initiallySelectedWrapper.getName());
            visibility = initiallySelectedWrapper.getVisibility();
        }
        this.changeData(currentData, newSelectedData, nonExistentNameToSelect, visibility);
    }

    private static DataWrapper wrap(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigComboBox.$$$reportNull$$$0(5);
        }
        return new DataWrapperImpl(data);
    }

    private static DataWrapper wrap(@NotNull String name, @Nullable String id, @NotNull SshConfigVisibility visibility) {
        if (name == null) {
            SshConfigComboBox.$$$reportNull$$$0(6);
        }
        if (visibility == null) {
            SshConfigComboBox.$$$reportNull$$$0(7);
        }
        return new PartialDataWrapper(name, id, visibility);
    }

    private static DataWrapper wrap(@NotNull SshConfig config) {
        if (config == null) {
            SshConfigComboBox.$$$reportNull$$$0(8);
        }
        return new PartialDataWrapper(config.getName(), config.getId(), config.isProjectLevel() ? SshConfigVisibility.Project : SshConfigVisibility.App);
    }

    @NotNull
    public List<String> getElements() {
        ArrayList<String> result2 = new ArrayList<String>();
        JComboBox<DataWrapper> comboBox = this.getMyComboBox();
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataWrapper wrapper = comboBox.getItemAt(i);
            result2.add(wrapper.getName());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SshConfigComboBox.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDataListener";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "changeData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }

    private static final class NothingSelectedDataWrapper
    implements DataWrapper {
        private final boolean isEmpty;

        private NothingSelectedDataWrapper(boolean empty) {
            this.isEmpty = empty;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.isEmpty ? SshBundle.message("ssh.combo.create.configuration", new Object[0]) : SshBundle.message("ssh.combo.select.configuration", new Object[0]);
            if (string == null) {
                NothingSelectedDataWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getPresentableName() {
            String string = this.isEmpty ? SshBundle.message("ssh.combo.create.configuration", new Object[0]) : SshBundle.message("ssh.combo.select.configuration", new Object[0]);
            if (string == null) {
                NothingSelectedDataWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public SshUiData getData() {
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            return null;
        }

        @Override
        @NotNull
        public SshConfigVisibility getVisibility() {
            SshConfigVisibility sshConfigVisibility = SshConfigVisibility.Project;
            if (sshConfigVisibility == null) {
                NothingSelectedDataWrapper.$$$reportNull$$$0(2);
            }
            return sshConfigVisibility;
        }

        @Override
        @NotNull
        public DataWrapper clone() {
            DataWrapper dataWrapper;
            try {
                dataWrapper = (DataWrapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
            if (dataWrapper == null) {
                NothingSelectedDataWrapper.$$$reportNull$$$0(3);
            }
            return dataWrapper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox$NothingSelectedDataWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibility";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clone";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static interface DataWrapper
    extends Cloneable {
        public boolean isConfigured();

        @NonNls
        @NotNull
        public String getName();

        @Nls
        @NotNull
        public String getPresentableName();

        @Nullable
        public String getId();

        @NotNull
        public SshConfigVisibility getVisibility();

        @Nullable
        public SshUiData getData();

        @NotNull
        public DataWrapper clone();
    }

    private static final class DataWrapperImpl
    implements DataWrapper {
        @NotNull
        private SshUiData myData;

        private DataWrapperImpl(@NotNull SshUiData data) {
            if (data == null) {
                DataWrapperImpl.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.myData.getName();
            if (string == null) {
                DataWrapperImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getPresentableName() {
            String string = this.myData.getConfig().getPresentableFullName();
            if (string == null) {
                DataWrapperImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public SshUiData getData() {
            SshUiData sshUiData = this.myData;
            if (sshUiData == null) {
                DataWrapperImpl.$$$reportNull$$$0(3);
            }
            return sshUiData;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myData.getConfig().getId();
            if (string == null) {
                DataWrapperImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public SshConfigVisibility getVisibility() {
            SshConfigVisibility sshConfigVisibility = this.myData.getConfig().isProjectLevel() ? SshConfigVisibility.Project : SshConfigVisibility.App;
            if (sshConfigVisibility == null) {
                DataWrapperImpl.$$$reportNull$$$0(5);
            }
            return sshConfigVisibility;
        }

        @Override
        @NotNull
        public DataWrapper clone() {
            DataWrapperImpl dataWrapperImpl;
            try {
                DataWrapperImpl clone = (DataWrapperImpl)super.clone();
                clone.myData = clone.myData.clone();
                dataWrapperImpl = clone;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
            if (dataWrapperImpl == null) {
                DataWrapperImpl.$$$reportNull$$$0(6);
            }
            return dataWrapperImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox$DataWrapperImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigComboBox$DataWrapperImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibility";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PartialDataWrapper
    implements DataWrapper {
        @NotNull
        @NlsSafe
        private final String myName;
        @Nullable
        private final String myId;
        private final SshConfigVisibility myVisibility;

        private PartialDataWrapper(@NotNull String name, @Nullable String id, @NotNull SshConfigVisibility visibility) {
            if (name == null) {
                PartialDataWrapper.$$$reportNull$$$0(0);
            }
            if (visibility == null) {
                PartialDataWrapper.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myId = id;
            this.myVisibility = visibility;
        }

        @Override
        public boolean isConfigured() {
            return false;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.myName;
            if (string == null) {
                PartialDataWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getPresentableName() {
            String string = this.myName;
            if (string == null) {
                PartialDataWrapper.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public SshUiData getData() {
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            return this.myId;
        }

        @Override
        @NotNull
        public SshConfigVisibility getVisibility() {
            SshConfigVisibility sshConfigVisibility = this.myVisibility;
            if (sshConfigVisibility == null) {
                PartialDataWrapper.$$$reportNull$$$0(4);
            }
            return sshConfigVisibility;
        }

        @Override
        @NotNull
        public DataWrapper clone() {
            DataWrapper dataWrapper;
            try {
                dataWrapper = (DataWrapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
            if (dataWrapper == null) {
                PartialDataWrapper.$$$reportNull$$$0(5);
            }
            return dataWrapper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibility";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox$PartialDataWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigComboBox$PartialDataWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibility";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

