/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFieldName;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0016\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J)\u0010\u001a\u001a\u00020\u00002\b\b\u0003\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/internal/statistic/eventLog/events/BoundedLongEventField;", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "name", "", "bounds", "", "description", "(Ljava/lang/String;[JLjava/lang/String;)V", "getBounds", "()[J", "getDescription", "()Ljava/lang/String;", "getName", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nBaseEventFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseEventFields.kt\ncom/intellij/internal/statistic/eventLog/events/BoundedLongEventField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,553:1\n1747#2,3:554\n*S KotlinDebug\n*F\n+ 1 BaseEventFields.kt\ncom/intellij/internal/statistic/eventLog/events/BoundedLongEventField\n*L\n205#1:554,3\n*E\n"})
public final class BoundedLongEventField
extends PrimitiveEventField<Long> {
    @NotNull
    private final String name;
    @NotNull
    private final long[] bounds;
    @Nullable
    private final String description;

    public BoundedLongEventField(@EventFieldName @NonNls @NotNull String name, @NotNull long[] bounds, @NonNls @Nullable String description) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            super(null, 1, null);
            this.name = name;
            this.bounds = bounds;
            this.description = description;
            if (this.bounds.length == 0) {
                throw new InvalidParameterException("Bounds array should not be empty");
            }
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)1, (int)this.bounds.length);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.bounds[it] <= this.bounds[it - 1])) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new InvalidParameterException("Bounds array should be sorted in ascending order and all values should be unique");
        }
    }

    public /* synthetic */ BoundedLongEventField(String string, long[] lArray, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, lArray, string2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final long[] getBounds() {
        return this.bounds;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        return CollectionsKt.listOf((Object)"{regexp#integer}");
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, long value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        fuData.addData(this.getName(), StatisticsUtil.roundToUpperBoundInternal$intellij_platform_statistics(value, this.bounds));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final long[] component2() {
        return this.bounds;
    }

    @Nullable
    public final String component3() {
        return this.description;
    }

    @NotNull
    public final BoundedLongEventField copy(@EventFieldName @NonNls @NotNull String name, @NotNull long[] bounds, @NonNls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return new BoundedLongEventField(name, bounds, description);
    }

    public static /* synthetic */ BoundedLongEventField copy$default(BoundedLongEventField boundedLongEventField, String string, long[] lArray, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = boundedLongEventField.name;
        }
        if ((n & 2) != 0) {
            lArray = boundedLongEventField.bounds;
        }
        if ((n & 4) != 0) {
            string2 = boundedLongEventField.description;
        }
        return boundedLongEventField.copy(string, lArray, string2);
    }

    @NotNull
    public String toString() {
        return "BoundedLongEventField(name=" + this.name + ", bounds=" + Arrays.toString(this.bounds) + ", description=" + this.description + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Arrays.hashCode(this.bounds);
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BoundedLongEventField)) {
            return false;
        }
        BoundedLongEventField boundedLongEventField = (BoundedLongEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)boundedLongEventField.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bounds, (Object)boundedLongEventField.bounds)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.description, (Object)boundedLongEventField.description);
    }
}

