/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Not;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Not$BooleanNegation;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "BooleanNegation", "backend.jvm.codegen"})
public final class Not
extends IntrinsicMethod {
    @NotNull
    public static final Not INSTANCE = new Not();

    private Not() {
    }

    @Override
    @NotNull
    public BooleanNegation invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression irExpression = expression2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        return new BooleanNegation(expression2, PromisedValueKt.coerceToBoolean((PromisedValue)irExpression.accept((IrElementVisitor)codegen2, (Object)data)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Not$BooleanNegation;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "value", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;)V", "getExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getValue", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "discard", "", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm.codegen"})
    public static final class BooleanNegation
    extends BooleanValue {
        @NotNull
        private final IrFunctionAccessExpression expression;
        @NotNull
        private final BooleanValue value;

        public BooleanNegation(@NotNull IrFunctionAccessExpression expression2, @NotNull BooleanValue value2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(value2.getCodegen());
            this.expression = expression2;
            this.value = value2;
        }

        @NotNull
        public final IrFunctionAccessExpression getExpression() {
            return this.expression;
        }

        @NotNull
        public final BooleanValue getValue() {
            return this.value;
        }

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.markLineNumber((IrExpression)this.expression);
            this.value.jumpIfTrue(target);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.markLineNumber((IrExpression)this.expression);
            this.value.jumpIfFalse(target);
        }

        @Override
        public void discard() {
            this.markLineNumber((IrExpression)this.expression);
            this.value.discard();
        }
    }
}

