/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "state", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EntriesMappingState", "backend.jvm.lower"})
public final class EnumExternalEntriesLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @Nullable
    private EntriesMappingState state;

    public EnumExternalEntriesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        boolean shouldBeLowered;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction owner = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrDeclarationParent irDeclarationParent = owner.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return super.visitCall(expression2);
        }
        IrClass parentClass = irClass;
        boolean bl = shouldBeLowered = Intrinsics.areEqual((Object)owner.getName(), (Object)SpecialNames.ENUM_GET_ENTRIES) && JvmIrUtilsKt.isEnumClassWhichRequiresExternalEntries(parentClass);
        if (!shouldBeLowered) {
            return super.visitCall(expression2);
        }
        EntriesMappingState entriesMappingState = this.state;
        Intrinsics.checkNotNull((Object)entriesMappingState);
        IrField field = entriesMappingState.getEntriesFieldForEnum(parentClass);
        return (IrExpression)new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), field.getSymbol(), field.getType(), null, null, 48, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        EntriesMappingState mappingState;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        EntriesMappingState oldState = this.state;
        this.state = mappingState = new EntriesMappingState();
        super.visitClassNew(declaration);
        for (Map.Entry<IrClass, IrField> irClass : mappingState.getMappings().entrySet()) {
            void $this$visitClassNew_u24lambda_u241_u24lambda_u240;
            void $this$visitClassNew_u24lambda_u241;
            IrCall irCall;
            IrClass irClass2 = irClass.getKey();
            IrField field = irClass.getValue();
            IrSimpleFunction enumValues = JvmIrUtilsKt.findEnumValuesFunction(irClass2, this.context);
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)field.getSymbol()), (int)0, (int)0, (int)6, null);
            IrField irField = field;
            boolean bl = false;
            IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitClassNew_u24lambda_u241), (IrSimpleFunctionSymbol)this.context.getIr().getSymbols().getCreateEnumEntries());
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitClassNew_u24lambda_u241;
            boolean bl2 = false;
            $this$visitClassNew_u24lambda_u241_u24lambda_u240.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitClassNew_u24lambda_u241), (IrFunction)((IrFunction)enumValues)));
            irField.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
        }
        if (!mappingState.getMappings().isEmpty()) {
            IrClass irClass;
            Collection collection = declaration.getDeclarations();
            IrClass $this$visitClassNew_u24lambda_u242 = irClass = mappingState.getMappingsClass();
            boolean bl = false;
            $this$visitClassNew_u24lambda_u242.setParent((IrDeclarationParent)declaration);
            IrClass irClass2 = irClass;
            collection.add(irClass2);
        }
        this.state = oldState;
        return (IrStatement)declaration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState;", "", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering;)V", "mappings", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getMappings", "()Ljava/util/Map;", "mappingsClass", "getMappingsClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "mappingsClass$delegate", "Lkotlin/Lazy;", "getEntriesFieldForEnum", "enumClass", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nEnumExternalEntriesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumExternalEntriesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,138:1\n372#2,3:139\n375#2,4:153\n80#3:142\n74#3,10:143\n*S KotlinDebug\n*F\n+ 1 EnumExternalEntriesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState\n*L\n90#1:139,3\n90#1:153,4\n91#1:142\n91#1:143,10\n*E\n"})
    private final class EntriesMappingState {
        @NotNull
        private final Map<IrClass, IrField> mappings = new LinkedHashMap();
        @NotNull
        private final Lazy mappingsClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrClass>(EnumExternalEntriesLowering.this){
            final /* synthetic */ EnumExternalEntriesLowering this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrClass invoke() {
                IrClass irClass;
                IrFactory $this$buildClass$iv = EnumExternalEntriesLowering.access$getContext$p(this.this$0).getIrFactory();
                boolean $i$f$buildClass = false;
                IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
                boolean bl = false;
                IrClassBuilder $this$invoke_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
                boolean bl2 = false;
                Name name2 = Name.identifier((String)"EntriesMappings");
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                $this$invoke_u24lambda_u240.setName(name2);
                $this$invoke_u24lambda_u240.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getENUM_MAPPINGS_FOR_ENTRIES());
                IrClass $this$invoke_u24lambda_u241 = irClass = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
                boolean bl3 = false;
                IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$invoke_u24lambda_u241);
                return irClass;
            }
        }));

        @NotNull
        public final Map<IrClass, IrField> getMappings() {
            return this.mappings;
        }

        @NotNull
        public final IrClass getMappingsClass() {
            Lazy lazy = this.mappingsClass$delegate;
            return (IrClass)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrField getEntriesFieldForEnum(@NotNull IrClass enumClass2) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)enumClass2, (String)"enumClass");
            Map<IrClass, IrField> map = this.mappings;
            EnumExternalEntriesLowering enumExternalEntriesLowering = EnumExternalEntriesLowering.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(enumClass2);
            if (value$iv == null) {
                IrField irField;
                boolean bl = false;
                IrClass $this$addField$iv = this.getMappingsClass();
                boolean $i$f$addField = false;
                IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
                boolean bl2 = false;
                IrFieldBuilder $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240 = $this$buildField_u24lambda_u244$iv$iv;
                boolean bl3 = false;
                Name name2 = Name.identifier((String)("entries$" + this.mappings.size()));
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setName(name2);
                IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType((IrClass)enumClass2)};
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)enumExternalEntriesLowering.context.getIr().getSymbols().getEnumEntries()), (IrType[])irTypeArray));
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getENUM_MAPPINGS_FOR_ENTRIES());
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setFinal(true);
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setStatic(true);
                IrField field$iv = irField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv$iv);
                boolean bl4 = false;
                field$iv.setParent((IrDeclarationParent)$this$addField$iv);
                $this$addField$iv.getDeclarations().add(field$iv);
                IrField answer$iv = irField;
                $this$getOrPut$iv.put(enumClass2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrField)object;
        }
    }
}

