/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.JsCodeCallsLowering;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00060\bR\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "jsRelatedSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getJsRelatedSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFunction", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getJsCode", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nJsCodeCallsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,118:1\n1745#2,3:119\n1547#2:122\n1618#2,3:123\n1862#2,3:137\n1862#2,3:140\n416#3,10:126\n72#4:136\n73#4:143\n*S KotlinDebug\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n*L\n63#1:119,3\n74#1:122\n74#1:123,3\n77#1:137,3\n80#1:140,3\n75#1:126,10\n75#1:136\n75#1:143\n*E\n"})
public final class JsCodeCallsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public JsCodeCallsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final WasmSymbols.JsRelatedSymbols getJsRelatedSymbols() {
        return this.context.getWasmSymbols().getJsRelatedSymbols();
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.context.isWasmJsTarget()) {
            return;
        }
        TransformKt.transformDeclarationsFlat((IrDeclarationContainer)((IrDeclarationContainer)irFile), (Function1)((Function1)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
            final /* synthetic */ JsCodeCallsLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<IrDeclaration> invoke(IrDeclaration declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrDeclaration irDeclaration2 = declaration;
                return irDeclaration2 instanceof IrSimpleFunction ? JsCodeCallsLowering.access$transformFunction(this.this$0, (IrSimpleFunction)declaration) : (irDeclaration2 instanceof IrProperty ? JsCodeCallsLowering.access$transformProperty(this.this$0, (IrProperty)declaration) : null);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformFunction(IrSimpleFunction function2) {
        void it;
        IrConstructorCall irConstructorCall;
        boolean bl;
        String jsFunCode2;
        block20: {
            StringBuilder stringBuilder2;
            IrBody irBody = function2.getBody();
            if (irBody == null) {
                return null;
            }
            IrBody body2 = irBody;
            if (!(body2 instanceof IrBlockBody)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            IrStatement irStatement = (IrStatement)CollectionsKt.singleOrNull((List)((IrBlockBody)body2).getStatements());
            if (irStatement == null) {
                return null;
            }
            IrStatement statement2 = irStatement;
            boolean isSingleExpressionJsCode = false;
            String jsCode = null;
            IrStatement irStatement2 = statement2;
            if (irStatement2 instanceof IrReturn) {
                String string3 = this.getJsCode(((IrReturn)statement2).getValue());
                if (string3 == null) {
                    return null;
                }
                jsCode = string3;
                isSingleExpressionJsCode = true;
            } else if (irStatement2 instanceof IrCall) {
                String string4 = this.getJsCode((IrExpression)statement2);
                if (string4 == null) {
                    return null;
                }
                jsCode = string4;
                isSingleExpressionJsCode = false;
            } else {
                return null;
            }
            List valueParameters2 = function2.getValueParameters();
            StringBuilder $this$transformFunction_u24lambda_u240 = stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            $this$transformFunction_u24lambda_u240.append('(');
            $this$transformFunction_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)valueParameters2, null, null, null, (int)0, null, (Function1)transformFunction.jsFunCode.1.1.INSTANCE, (int)31, null));
            $this$transformFunction_u24lambda_u240.append(") => ");
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u240.append("{ ");
            }
            $this$transformFunction_u24lambda_u240.append(jsCode);
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u240.append(" }");
            }
            String string5 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            jsFunCode2 = string5;
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it2 = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!(it2.getDefaultValue() != null)) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        if (bl) {
            IrTypeParameter parameter;
            int index2;
            int n;
            void $this$transformFunction_u24lambda_u245;
            void this_$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv;
            IrSimpleFunction externalFun = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, function2.getName(), "_js_code", function2.getReturnType(), jsFunCode2);
            IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)externalFun), (IrTypeParametersContainer)((IrTypeParametersContainer)function2), null, null, (int)6, null);
            Iterable $i$f$any = function2.getValueParameters();
            IrSimpleFunction irSimpleFunction = externalFun;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it3;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it3, (IrFunction)((IrFunction)externalFun), null, (int)0, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)7678, null));
            }
            irSimpleFunction.setValueParameters((List)destination$iv$iv);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)function2.getSymbol()), (int)0, (int)0, (int)6, null);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $i$f$mapTo22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            item$iv$iv2 = this_$iv$iv;
            irSimpleFunction = function2;
            boolean bl5 = false;
            IrCall call2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$transformFunction_u24lambda_u245), (IrSimpleFunctionSymbol)externalFun.getSymbol());
            Iterable $this$forEachIndexed$iv = function2.getValueParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                index2 = n;
                boolean bl6 = false;
                call2.putValueArgument(index2, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$transformFunction_u24lambda_u245), (IrValueDeclaration)((IrValueDeclaration)parameter)));
            }
            $this$forEachIndexed$iv = function2.getTypeParameters();
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void typeParameter;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                parameter = (IrTypeParameter)item$iv;
                index2 = n;
                boolean bl7 = false;
                call2.putTypeArgument(index2, (IrType)IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
            }
            $this$transformFunction_u24lambda_u245.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$transformFunction_u24lambda_u245), (IrExpression)((IrExpression)call2)));
            irSimpleFunction.setBody((IrBody)this_$iv$iv.doBuild());
            Object[] objectArray = new IrSimpleFunction[]{function2, externalFun};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)function2.getSymbol()), (int)0, (int)0, (int)6, null);
        IrConstructorCall startOffset$iv = irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrConstructorSymbol)this.getJsRelatedSymbols().getJsFunConstructor(), (List)CollectionsKt.emptyList());
        Collection collection = function2.getAnnotations();
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl8 = false;
        it.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)builder2), (String)jsFunCode2));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCall));
        function2.setBody(null);
        return null;
    }

    private final List<IrDeclaration> transformProperty(IrProperty property) {
        IrField irField = property.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField field = irField;
        IrExpressionBody irExpressionBody = field.getInitializer();
        if (irExpressionBody == null) {
            return null;
        }
        IrExpressionBody initializer = irExpressionBody;
        String string2 = this.getJsCode(initializer.getExpression());
        if (string2 == null) {
            return null;
        }
        String jsCode = string2;
        IrSimpleFunction externalFun = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, property.getName(), "_js_code", field.getType(), "() => (" + jsCode + ')');
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)field.getSymbol()), (int)0, (int)0, (int)6, null);
        initializer.setExpression((IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrFunction)((IrFunction)externalFun)));
        Object[] objectArray = new IrDeclaration[]{property, externalFun};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String getJsCode(IrExpression $this$getJsCode) {
        IrCall irCall = $this$getJsCode instanceof IrCall ? (IrCall)$this$getJsCode : null;
        if (irCall == null) {
            return null;
        }
        IrCall call2 = irCall;
        if (!Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.getJsRelatedSymbols().getJsCode())) {
            return null;
        }
        IrExpression irExpression = call2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<kotlin.String>");
        return (String)((IrConst)irExpression).getValue();
    }

    public static final /* synthetic */ List access$transformFunction(JsCodeCallsLowering $this, IrSimpleFunction function2) {
        return $this.transformFunction(function2);
    }

    public static final /* synthetic */ List access$transformProperty(JsCodeCallsLowering $this, IrProperty property) {
        return $this.transformProperty(property);
    }
}

