/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u000f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J-\u0010\u000f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001f\u0010\u001c\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u00102\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u001f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "index", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "enableSearchInCtSym", "", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;Lcom/intellij/psi/search/GlobalSearchScope;Z)V", "findBinaryClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "fileName", "", "findBinaryOrSigClass", "Lorg/jetbrains/annotations/Nullable;", "simpleName", "rootType", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findClass", "findMetadata", "findMetadataTopLevelClassesInPackage", "findSigFileIfEnabled", "dir", "findSourceClass", "findSourceOrBinaryVirtualFile", "findVirtualFileWithHeader", "hasMetadataPackage", "fqName", "cli-base"})
@SourceDebugExtension(value={"SMAP\nCliVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliVirtualFileFinder.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class CliVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    private final JvmDependenciesIndex index;
    @NotNull
    private final GlobalSearchScope scope;
    private final boolean enableSearchInCtSym;

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index2, @NotNull GlobalSearchScope scope, boolean enableSearchInCtSym) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.index = index2;
        this.scope = scope;
        this.enableSearchInCtSym = enableSearchInCtSym;
    }

    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findBinaryOrSigClass(classId);
    }

    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        VirtualFile virtualFile = this.findBinaryOrSigClass(classId);
        if (virtualFile == null) {
            virtualFile = this.findSourceClass(classId, classId.getRelativeClassName().asString() + ".java");
        }
        return virtualFile;
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean bl2 = bl = !classId.isNestedClass();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Nested classes are not supported here: " + classId;
            throw new AssertionError((Object)string2);
        }
        VirtualFile virtualFile = this.findBinaryClass(classId, classId.getShortClassName().asString() + ".kotlin_metadata");
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    @NotNull
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        ObjectOpenHashSet result2 = new ObjectOpenHashSet();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, packageFqName, null, (Function2)new Function2<VirtualFile, JavaRoot.RootType, Boolean>((ObjectOpenHashSet<String>)result2){
            final /* synthetic */ ObjectOpenHashSet<String> $result;
            {
                this.$result = $result;
                super(2);
            }

            public final Boolean invoke(VirtualFile dir2, JavaRoot.RootType rootType) {
                Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<anonymous parameter 1>");
                VirtualFile[] virtualFileArray = dir2.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                for (VirtualFile child : virtualFileArray) {
                    if (!Intrinsics.areEqual((Object)child.getExtension(), (Object)"kotlin_metadata")) continue;
                    this.$result.add((Object)child.getNameWithoutExtension());
                }
                return true;
            }
        }, 2, null);
        return (Set)result2;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Ref.BooleanRef found = new Ref.BooleanRef();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, fqName2, null, (Function2)new Function2<VirtualFile, JavaRoot.RootType, Boolean>(found){
            final /* synthetic */ Ref.BooleanRef $found;
            {
                this.$found = $found;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(VirtualFile dir2, JavaRoot.RootType rootType) {
                boolean bl;
                boolean bl2;
                block1: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<anonymous parameter 1>");
                    boolean bl3 = this.$found.element;
                    VirtualFile[] virtualFileArray = dir2.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    Object[] objectArray = virtualFileArray;
                    bl2 = bl3;
                    Ref.BooleanRef booleanRef = this.$found;
                    boolean $i$f$any = false;
                    for (void element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"kotlin_metadata")) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean bl5 = bl;
                booleanRef.element = bl2 | bl5;
                return !this.$found.element;
            }
        }, 2, null);
        return found.element;
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Name name2 = Name.special((String)"<builtins-metadata>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        ClassId classId = new ClassId(packageFqName, name2);
        VirtualFile virtualFile = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    private final VirtualFile findClass(ClassId classId, String fileName, Set<? extends JavaRoot.RootType> rootType) {
        Object object;
        VirtualFile virtualFile = (VirtualFile)this.index.findClass(classId, rootType, (Function2)new Function2<VirtualFile, JavaRoot.RootType, VirtualFile>(fileName){
            final /* synthetic */ String $fileName;
            {
                this.$fileName = $fileName;
                super(2);
            }

            public final VirtualFile invoke(VirtualFile dir2, JavaRoot.RootType rootType) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<anonymous parameter 1>");
                VirtualFile virtualFile = dir2.findChild(this.$fileName);
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile p0 = virtualFile2 = virtualFile;
                    boolean bl = false;
                    object = p0.isValid() ? virtualFile2 : null;
                } else {
                    object = null;
                }
                return object;
            }
        });
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = this.scope.contains(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final VirtualFile findSigFileIfEnabled(VirtualFile dir2, String simpleName) {
        return this.enableSearchInCtSym ? dir2.findChild(simpleName + ".sig") : null;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId, String simpleName, Set<? extends JavaRoot.RootType> rootType) {
        Object object;
        VirtualFile virtualFile = (VirtualFile)this.index.findClass(classId, rootType, (Function2)new Function2<VirtualFile, JavaRoot.RootType, VirtualFile>(simpleName, this){
            final /* synthetic */ String $simpleName;
            final /* synthetic */ CliVirtualFileFinder this$0;
            {
                this.$simpleName = $simpleName;
                this.this$0 = $receiver;
                super(2);
            }

            public final VirtualFile invoke(VirtualFile dir2, JavaRoot.RootType rootType) {
                VirtualFile file2;
                Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<anonymous parameter 1>");
                VirtualFile virtualFile = dir2.findChild(this.$simpleName + ".class");
                if (virtualFile == null) {
                    virtualFile = CliVirtualFileFinder.access$findSigFileIfEnabled(this.this$0, dir2, this.$simpleName);
                }
                return (file2 = virtualFile) != null && file2.isValid() ? file2 : null;
            }
        });
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = this.scope.contains(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId) {
        String string2 = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.findBinaryOrSigClass(classId, StringsKt.replace$default((String)string2, (char)'.', (char)'$', (boolean)false, (int)4, null), JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findSourceClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlySource());
    }

    public static final /* synthetic */ VirtualFile access$findSigFileIfEnabled(CliVirtualFileFinder $this, VirtualFile dir2, String simpleName) {
        return $this.findSigFileIfEnabled(dir2, simpleName);
    }
}

