/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.CityHashKt;
import org.jetbrains.kotlin.backend.common.serialization.FingerprintHash;
import org.jetbrains.kotlin.backend.common.serialization.Hash128Bits;
import org.jetbrains.kotlin.ir.backend.js.ic.HashCalculatorForICKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.ICUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.IdSignatureSerialization;
import org.jetbrains.kotlin.ir.backend.js.ic.IncrementalCacheArtifact;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinLibraryFile;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinLibraryHeader;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFile;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMap;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadata;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadataNotExist;
import org.jetbrains.kotlin.ir.backend.js.ic.SourceFileCacheArtifact;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.utils.CollectionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 @2\u00020\u0001:\u0004?@ABB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010(\u001a\u00020)2\u001e\u0010*\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020+0\u00130\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013J\u0006\u0010.\u001a\u00020/JB\u00100\u001a\u0002012\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00132\u001e\u0010*\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020+0\u00130\u0013H\u0002J$\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00142\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020+0\u0013H\u0002J\u001a\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013H\u0002J\u000e\u00107\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u0014J\u0018\u00108\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u0011H\u0002J\u0016\u0010:\u001a\u0002012\u0006\u00105\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u001eJ\u0014\u0010<\u001a\u00020\u0005*\u00020\u00142\u0006\u0010=\u001a\u00020>H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e0\u001dj\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010 \u001a\u0004\u0018\u00010!8FX\u0086\u0084\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache;", "", "library", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryHeader;", "cacheDir", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryHeader;Ljava/io/File;)V", "getCacheDir", "()Ljava/io/File;", "cacheHeaderFile", "cacheHeaderFromDisk", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader;", "getCacheHeaderFromDisk", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader;", "cacheHeaderFromDisk$delegate", "Lkotlin/Lazy;", "cacheHeaderShouldBeUpdated", "", "filesWithStubbedSignatures", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getFilesWithStubbedSignatures", "()Ljava/util/Map;", "filesWithStubbedSignatures$delegate", "idSignatureSerialization", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IdSignatureSerialization;", "kotlinLibrarySourceFileMetadata", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMetadata;", "Lkotlin/collections/HashMap;", "libraryFileFromHeader", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryFile;", "getLibraryFileFromHeader-y7ymc5g", "()Ljava/lang/String;", "libraryFileFromHeader$delegate", "modifiedSrcFiles", "removedSrcFiles", "stubbedSymbolsFile", "buildAndCommitCacheArtifact", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheArtifact;", "signatureToIndexMapping", "", "stubbedSignatures", "collectFilesWithStubbedSignatures", "collectModifiedFiles", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$ModifiedFiles;", "commitFilesWithStubbedSignatures", "", "updatedFilesWithStubbedSignatures", "commitSourceFileMetadata", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SourceFileCacheArtifact;", "srcFile", "fetchFilesWithStubbedSymbols", "fetchSourceFileFullMetadata", "fetchSourceFileMetadata", "loadSignatures", "updateSourceFileMetadata", "sourceFileMetadata", "getCacheFile", "suffix", "", "CacheHeader", "Companion", "KotlinSourceFileMetadataFromDisk", "ModifiedFiles", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIncrementalCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalCache.kt\norg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache\n+ 2 ICUtils.kt\norg/jetbrains/kotlin/ir/backend/js/ic/ICUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,336:1\n32#2,2:337\n25#2,10:339\n19#2:361\n17#2,5:362\n66#2:367\n62#2:369\n23#2:371\n32#2,2:372\n25#2,10:374\n19#2:387\n17#2,7:388\n25#2,5:399\n66#2:404\n66#2:406\n1547#3:349\n1618#3,2:350\n855#3,2:352\n1620#3:354\n1269#3,2:355\n1283#3,4:357\n1#4:368\n1#4:370\n1#4:405\n1#4:407\n372#5,3:384\n375#5,4:395\n*S KotlinDebug\n*F\n+ 1 IncrementalCache.kt\norg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache\n*L\n101#1:337,2\n101#1:339,10\n182#1:361\n182#1:362,5\n183#1:367\n191#1:369\n182#1:371\n213#1:372,2\n213#1:374,10\n274#1:387\n274#1:388,7\n327#1:399,5\n241#1:404\n243#1:406\n114#1:349\n114#1:350,2\n119#1:352,2\n114#1:354\n158#1:355,2\n158#1:357,4\n183#1:368\n191#1:370\n241#1:405\n243#1:407\n238#1:384,3\n238#1:395,4\n*E\n"})
public final class IncrementalCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinLibraryHeader library;
    @NotNull
    private final File cacheDir;
    @NotNull
    private final File cacheHeaderFile;
    @NotNull
    private final File stubbedSymbolsFile;
    private boolean cacheHeaderShouldBeUpdated;
    @NotNull
    private Set<KotlinSourceFile> removedSrcFiles;
    @NotNull
    private Set<KotlinSourceFile> modifiedSrcFiles;
    @NotNull
    private final HashMap<KotlinSourceFile, KotlinSourceFileMetadata> kotlinLibrarySourceFileMetadata;
    @NotNull
    private final IdSignatureSerialization idSignatureSerialization;
    @NotNull
    private final Lazy cacheHeaderFromDisk$delegate;
    @NotNull
    private final Lazy filesWithStubbedSignatures$delegate;
    @NotNull
    private final Lazy libraryFileFromHeader$delegate;
    @NotNull
    private static final String CACHE_HEADER = "ic.header.bin";
    @NotNull
    private static final String STUBBED_SYMBOLS = "ic.stubbed-symbols.bin";
    @NotNull
    private static final String BINARY_AST_SUFFIX = "ast.bin";
    @NotNull
    private static final String METADATA_SUFFIX = "metadata.bin";

    public IncrementalCache(@NotNull KotlinLibraryHeader library, @NotNull File cacheDir) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.library = library;
        this.cacheDir = cacheDir;
        this.cacheHeaderFile = new File(this.cacheDir, CACHE_HEADER);
        this.stubbedSymbolsFile = new File(this.cacheDir, STUBBED_SYMBOLS);
        this.removedSrcFiles = SetsKt.emptySet();
        this.modifiedSrcFiles = SetsKt.emptySet();
        this.kotlinLibrarySourceFileMetadata = new HashMap();
        this.idSignatureSerialization = new IdSignatureSerialization(this.library);
        this.cacheHeaderFromDisk$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<CacheHeader>(this){
            final /* synthetic */ IncrementalCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final CacheHeader invoke() {
                CacheHeader cacheHeader;
                File $this$useCodedInputIfExists$iv = IncrementalCache.access$getCacheHeaderFile$p(this.this$0);
                boolean $i$f$useCodedInputIfExists = false;
                File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
                boolean $i$f$ifExists = false;
                if ($this$ifExists$iv$iv.exists()) {
                    File $this$useCodedInputIfExists_u24lambda_u241$iv = $this$ifExists$iv$iv;
                    boolean bl = false;
                    Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u241$iv);
                    Throwable throwable = null;
                    try {
                        FileInputStream it$iv = (FileInputStream)closeable;
                        boolean bl2 = false;
                        CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)it$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(...)");
                        CodedInputStream $this$invoke_u24lambda_u240 = codedInputStream;
                        boolean bl3 = false;
                        CacheHeader cacheHeader2 = CacheHeader.Companion.fromProtoStream($this$invoke_u24lambda_u240);
                        cacheHeader = cacheHeader2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    cacheHeader = null;
                }
                return cacheHeader;
            }
        }));
        this.filesWithStubbedSignatures$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<KotlinSourceFile, ? extends Set<? extends IdSignature>>>(this){
            final /* synthetic */ IncrementalCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<KotlinSourceFile, Set<IdSignature>> invoke() {
                return IncrementalCache.access$fetchFilesWithStubbedSymbols(this.this$0);
            }
        }));
        this.libraryFileFromHeader$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<KotlinLibraryFile>(this){
            final /* synthetic */ IncrementalCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke-y7ymc5g() {
                CacheHeader cacheHeader = IncrementalCache.access$getCacheHeaderFromDisk(this.this$0);
                return cacheHeader != null ? cacheHeader.getLibraryFile-dAnkW_k() : null;
            }
        }));
    }

    @NotNull
    public final File getCacheDir() {
        return this.cacheDir;
    }

    private final CacheHeader getCacheHeaderFromDisk() {
        Lazy lazy = this.cacheHeaderFromDisk$delegate;
        return (CacheHeader)lazy.getValue();
    }

    private final Map<KotlinSourceFile, Set<IdSignature>> getFilesWithStubbedSignatures() {
        Lazy lazy = this.filesWithStubbedSignatures$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String getLibraryFileFromHeader-y7ymc5g() {
        Lazy lazy = this.libraryFileFromHeader$delegate;
        KotlinLibraryFile kotlinLibraryFile = (KotlinLibraryFile)lazy.getValue();
        return kotlinLibraryFile != null ? kotlinLibraryFile.unbox-impl() : null;
    }

    private final File getCacheFile(KotlinSourceFile $this$getCacheFile, String suffix) {
        String pathHash = CityHashKt.cityHash64String((String)$this$getCacheFile.getPath());
        return new File(this.cacheDir, new File($this$getCacheFile.getPath()).getName() + '.' + $this$getCacheFile.getId() + '.' + pathHash + '.' + suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final IncrementalCacheArtifact buildAndCommitCacheArtifact(@NotNull Map<KotlinSourceFile, ? extends Map<IdSignature, Integer>> signatureToIndexMapping, @NotNull Set<? extends IdSignature> stubbedSignatures) {
        void $this$mapTo$iv$iv;
        Object object;
        Object out$iv$iv;
        Intrinsics.checkNotNullParameter(signatureToIndexMapping, (String)"signatureToIndexMapping");
        Intrinsics.checkNotNullParameter(stubbedSignatures, (String)"stubbedSignatures");
        if (this.cacheHeaderShouldBeUpdated) {
            void $this$useCodedOutput$iv$iv;
            CacheHeader newCacheHeader = new CacheHeader(this.library);
            File $this$useCodedOutput$iv = this.cacheHeaderFile;
            boolean $i$f$useCodedOutput = false;
            File file2 = $this$useCodedOutput$iv.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            OutputStream outputStream2 = new FileOutputStream($this$useCodedOutput$iv);
            boolean $i$f$useCodedOutput2 = false;
            Closeable closeable = (Closeable)$this$useCodedOutput$iv$iv;
            Throwable throwable = null;
            try {
                OutputStream it$iv$iv = (OutputStream)closeable;
                boolean bl = false;
                out$iv$iv = CodedOutputStream.newInstance((OutputStream)it$iv$iv);
                Intrinsics.checkNotNull((Object)out$iv$iv);
                CodedOutputStream $this$buildAndCommitCacheArtifact_u24lambda_u240 = out$iv$iv;
                boolean bl2 = false;
                newCacheHeader.toProtoStream($this$buildAndCommitCacheArtifact_u24lambda_u240);
                out$iv$iv.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = newCacheHeader.getSourceFileFingerprints().keySet();
        } else {
            object = this.getCacheHeaderFromDisk();
            if (object == null || (object = ((CacheHeader)object).getSourceFileFingerprints()) == null || (object = object.keySet()) == null) {
                ICUtilsKt.notFoundIcError-5vrbIOY$default("source file fingerprints", this.library.getLibraryFile-dAnkW_k(), null, 4, null);
                throw null;
            }
        }
        Set klibSrcFiles = object;
        for (KotlinSourceFile removedFile : this.removedSrcFiles) {
            this.getCacheFile(removedFile, BINARY_AST_SUFFIX).delete();
            this.getCacheFile(removedFile, METADATA_SUFFIX).delete();
        }
        HashMap updatedFilesWithStubbedSignatures = new HashMap();
        Iterable $this$map$iv = klibSrcFiles;
        boolean $i$f$map = false;
        Iterable $i$f$useCodedOutput2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Set fileStubbedSignatures;
            Set set;
            Map signatureMapping;
            SourceFileCacheArtifact artifact;
            void srcFile;
            out$iv$iv = (KotlinSourceFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map = signatureToIndexMapping.get(srcFile);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            if ((artifact = this.commitSourceFileMetadata((KotlinSourceFile)srcFile, signatureMapping = map)) instanceof SourceFileCacheArtifact.CommitMetadata) {
                void destination$iv;
                void $this$filterTo$iv;
                Iterable iterable = signatureMapping.keySet();
                Collection collection2 = new HashSet();
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    IdSignature it = (IdSignature)element$iv;
                    boolean bl3 = false;
                    if (!stubbedSignatures.contains(it)) continue;
                    destination$iv.add(element$iv);
                }
                set = (Set)destination$iv;
            } else {
                set = this.getFilesWithStubbedSignatures().get(srcFile);
                if (set == null) {
                    set = fileStubbedSignatures = SetsKt.emptySet();
                }
            }
            if (!((Collection)fileStubbedSignatures).isEmpty()) {
                ((Map)updatedFilesWithStubbedSignatures).put(srcFile, fileStubbedSignatures);
            }
            collection.add(artifact);
        }
        List fileArtifacts = (List)destination$iv$iv;
        this.commitFilesWithStubbedSignatures(updatedFilesWithStubbedSignatures, signatureToIndexMapping);
        return new IncrementalCacheArtifact(this.cacheDir, !((Collection)this.removedSrcFiles).isEmpty(), fileArtifacts, this.library.getJsOutputName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ModifiedFiles collectModifiedFiles() {
        boolean bl;
        Object object = this.getCacheHeaderFromDisk();
        if (object == null || (object = ((CacheHeader)object).getSourceFileFingerprints()) == null) {
            object = MapsKt.emptyMap();
        }
        Object cachedFingerprints = object;
        CacheHeader cacheHeader = this.getCacheHeaderFromDisk();
        Hash128Bits hash128Bits = cacheHeader != null ? cacheHeader.getLibraryFingerprint-jverJr4() : null;
        Hash128Bits hash128Bits2 = this.library.getLibraryFingerprint-jverJr4();
        if (hash128Bits == null) {
            bl = hash128Bits2 == null;
        } else {
            Hash128Bits hash128Bits3 = hash128Bits2;
            bl = hash128Bits3 == null ? false : FingerprintHash.equals-impl0((Hash128Bits)hash128Bits, (Hash128Bits)hash128Bits3);
        }
        if (bl) {
            return new ModifiedFiles(kotlin.collections.CollectionsKt.emptyList(), MapsKt.emptyMap(), MapsKt.emptyMap(), cachedFingerprints.keySet());
        }
        List addedFiles = new ArrayList();
        HashMap modifiedFiles = new HashMap();
        List nonModifiedFiles = new ArrayList();
        for (Map.Entry<KotlinSourceFile, FingerprintHash> entry : this.library.getSourceFileFingerprints().entrySet()) {
            Hash128Bits hash128Bits4;
            KotlinSourceFile file2 = entry.getKey();
            Hash128Bits fileNewFingerprint = entry.getValue().unbox-impl();
            FingerprintHash fingerprintHash = (FingerprintHash)cachedFingerprints.get(file2);
            Hash128Bits hash128Bits5 = hash128Bits4 = fingerprintHash != null ? fingerprintHash.unbox-impl() : null;
            if (hash128Bits5 == null ? false : FingerprintHash.equals-impl0((Hash128Bits)hash128Bits5, (Hash128Bits)fileNewFingerprint)) {
                nonModifiedFiles.add(file2);
                continue;
            }
            if (hash128Bits4 == null) {
                addedFiles.add(file2);
                continue;
            }
            ((Map)modifiedFiles).put(file2, this.fetchSourceFileMetadata(file2, false));
        }
        Iterable $this$associateWith$iv = SetsKt.minus(cachedFingerprints.keySet(), (Iterable)this.library.getSourceFileFingerprints().keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            KotlinSourceFile kotlinSourceFile = (KotlinSourceFile)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl2 = false;
            KotlinSourceFileMetadata kotlinSourceFileMetadata = this.fetchSourceFileMetadata((KotlinSourceFile)it, false);
            map.put(t, kotlinSourceFileMetadata);
        }
        Map removedFiles = result$iv;
        this.removedSrcFiles = removedFiles.keySet();
        Set set = modifiedFiles.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        this.modifiedSrcFiles = set;
        this.cacheHeaderShouldBeUpdated = true;
        return new ModifiedFiles(addedFiles, removedFiles, modifiedFiles, nonModifiedFiles);
    }

    @NotNull
    public final KotlinSourceFileMetadata fetchSourceFileFullMetadata(@NotNull KotlinSourceFile srcFile) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        return this.fetchSourceFileMetadata(srcFile, true);
    }

    public final void updateSourceFileMetadata(@NotNull KotlinSourceFile srcFile, @NotNull KotlinSourceFileMetadata sourceFileMetadata) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)sourceFileMetadata, (String)"sourceFileMetadata");
        ((Map)this.kotlinLibrarySourceFileMetadata).put(srcFile, sourceFileMetadata);
    }

    @NotNull
    public final Map<KotlinSourceFile, Set<IdSignature>> collectFilesWithStubbedSignatures() {
        return this.getFilesWithStubbedSignatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<KotlinSourceFile, Set<IdSignature>> fetchFilesWithStubbedSymbols() {
        Map map;
        File $this$useCodedInputIfExists$iv = this.stubbedSymbolsFile;
        boolean $i$f$useCodedInputIfExists = false;
        File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
        boolean $i$f$ifExists = false;
        if ($this$ifExists$iv$iv.exists()) {
            File $this$useCodedInputIfExists_u24lambda_u241$iv = $this$ifExists$iv$iv;
            boolean bl = false;
            Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u241$iv);
            Throwable throwable = null;
            try {
                HashMap hashMap;
                FileInputStream it$iv = (FileInputStream)closeable;
                boolean bl2 = false;
                CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)it$iv);
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(...)");
                CodedInputStream $this$fetchFilesWithStubbedSymbols_u24lambda_u247 = codedInputStream;
                boolean bl3 = false;
                int to$iv = $this$fetchFilesWithStubbedSymbols_u24lambda_u247.readInt32();
                boolean $i$f$buildMapUntil = false;
                HashMap $this$buildMapUntil_u24lambda_u246$iv = hashMap = CollectionsKt.newHashMapWithExpectedSize((int)to$iv);
                boolean bl4 = false;
                for (int i = 0; i < to$iv; ++i) {
                    HashSet hashSet;
                    int it$iv2 = i;
                    boolean bl5 = false;
                    int n = it$iv2;
                    Map $this$fetchFilesWithStubbedSymbols_u24lambda_u247_u24lambda_u246 = $this$buildMapUntil_u24lambda_u246$iv;
                    boolean bl6 = false;
                    KotlinSourceFile srcFile = KotlinSourceFile.Companion.fromProtoStream($this$fetchFilesWithStubbedSymbols_u24lambda_u247);
                    IdSignatureSerialization.IdSignatureICDeserializer signatureDeserializer = this.idSignatureSerialization.getIdSignatureDeserializer(srcFile);
                    if (this.modifiedSrcFiles.contains(srcFile) || this.removedSrcFiles.contains(srcFile)) {
                        int n2 = $this$fetchFilesWithStubbedSymbols_u24lambda_u247.readInt32();
                        int n3 = 0;
                        while (n3 < n2) {
                            int it = n3++;
                            boolean bl7 = false;
                            signatureDeserializer.skipIdSignature($this$fetchFilesWithStubbedSymbols_u24lambda_u247);
                        }
                        continue;
                    }
                    int to$iv2 = $this$fetchFilesWithStubbedSymbols_u24lambda_u247.readInt32();
                    boolean $i$f$buildSetUntil = false;
                    HashSet $this$buildSetUntil_u24lambda_u244$iv = hashSet = CollectionsKt.newHashSetWithExpectedSize((int)to$iv2);
                    boolean bl8 = false;
                    int n4 = 0;
                    while (n4 < to$iv2) {
                        int it$iv3 = n4++;
                        boolean bl9 = false;
                        int n5 = it$iv3;
                        Set $this$fetchFilesWithStubbedSymbols_u24lambda_u247_u24lambda_u246_u24lambda_u245 = $this$buildSetUntil_u24lambda_u244$iv;
                        boolean bl10 = false;
                        $this$fetchFilesWithStubbedSymbols_u24lambda_u247_u24lambda_u246_u24lambda_u245.add(signatureDeserializer.deserializeIdSignature($this$fetchFilesWithStubbedSymbols_u24lambda_u247));
                    }
                    Set unboundSignatures = hashSet;
                    $this$fetchFilesWithStubbedSymbols_u24lambda_u247_u24lambda_u246.put(srcFile, unboundSignatures);
                }
                Map map2 = hashMap;
                map = map2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        map = null;
        Map map3 = map;
        if (map == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void commitFilesWithStubbedSignatures(Map<KotlinSourceFile, ? extends Set<? extends IdSignature>> updatedFilesWithStubbedSignatures, Map<KotlinSourceFile, ? extends Map<IdSignature, Integer>> signatureToIndexMapping) {
        void $this$useCodedOutput$iv$iv;
        if (updatedFilesWithStubbedSignatures.isEmpty()) {
            this.stubbedSymbolsFile.delete();
            return;
        }
        if (Intrinsics.areEqual(updatedFilesWithStubbedSignatures, this.getFilesWithStubbedSignatures())) {
            return;
        }
        File $this$useCodedOutput$iv = this.stubbedSymbolsFile;
        boolean $i$f$useCodedOutput = false;
        File file2 = $this$useCodedOutput$iv.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        OutputStream outputStream2 = new FileOutputStream($this$useCodedOutput$iv);
        boolean $i$f$useCodedOutput2 = false;
        Closeable closeable = (Closeable)$this$useCodedOutput$iv$iv;
        Throwable throwable = null;
        try {
            OutputStream it$iv$iv = (OutputStream)closeable;
            boolean bl = false;
            CodedOutputStream out$iv$iv = CodedOutputStream.newInstance((OutputStream)it$iv$iv);
            Intrinsics.checkNotNull((Object)out$iv$iv);
            CodedOutputStream $this$commitFilesWithStubbedSignatures_u24lambda_u248 = out$iv$iv;
            boolean bl2 = false;
            $this$commitFilesWithStubbedSignatures_u24lambda_u248.writeInt32NoTag(updatedFilesWithStubbedSignatures.size());
            for (Map.Entry<KotlinSourceFile, ? extends Set<? extends IdSignature>> entry : updatedFilesWithStubbedSignatures.entrySet()) {
                KotlinSourceFile srcFile = entry.getKey();
                Set<? extends IdSignature> stubbedSignatures = entry.getValue();
                Map map = signatureToIndexMapping.get(srcFile);
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                IdSignatureSerialization.IdSignatureICSerializer serializer2 = this.idSignatureSerialization.getIdSignatureSerializer(srcFile, map);
                srcFile.toProtoStream($this$commitFilesWithStubbedSignatures_u24lambda_u248);
                $this$commitFilesWithStubbedSignatures_u24lambda_u248.writeInt32NoTag(stubbedSignatures.size());
                for (IdSignature idSignature : stubbedSignatures) {
                    serializer2.serializeIdSignature($this$commitFilesWithStubbedSignatures_u24lambda_u248, idSignature);
                }
            }
            out$iv$iv.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KotlinSourceFileMetadata fetchSourceFileMetadata(KotlinSourceFile srcFile, boolean loadSignatures) {
        Object object;
        Map $this$getOrPut$iv = this.kotlinLibrarySourceFileMetadata;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(srcFile);
        if (value$iv == null) {
            KotlinSourceFileMetadataFromDisk kotlinSourceFileMetadataFromDisk;
            boolean bl = false;
            IdSignatureSerialization.IdSignatureICDeserializer deserializer2 = this.idSignatureSerialization.getIdSignatureDeserializer(srcFile);
            File $this$useCodedInputIfExists$iv = this.getCacheFile(srcFile, METADATA_SUFFIX);
            boolean $i$f$useCodedInputIfExists = false;
            File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
            boolean $i$f$ifExists = false;
            if ($this$ifExists$iv$iv.exists()) {
                File $this$useCodedInputIfExists_u24lambda_u241$iv = $this$ifExists$iv$iv;
                boolean bl2 = false;
                Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u241$iv);
                Throwable throwable = null;
                try {
                    FileInputStream it$iv = (FileInputStream)closeable;
                    boolean bl3 = false;
                    CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)it$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(...)");
                    CodedInputStream $this$fetchSourceFileMetadata_u24lambda_u2412_u24lambda_u2411 = codedInputStream;
                    boolean bl4 = false;
                    KotlinSourceFileMap<Map<IdSignature, ICHash>> directDependencies = new KotlinSourceFileMap<Map<IdSignature, ICHash>>(IncrementalCache.fetchSourceFileMetadata$lambda$12$readDirectDependencies($this$fetchSourceFileMetadata_u24lambda_u2412_u24lambda_u2411, loadSignatures, deserializer2));
                    KotlinSourceFileMap<Set<IdSignature>> reverseDependencies = new KotlinSourceFileMap<Set<IdSignature>>(IncrementalCache.fetchSourceFileMetadata$lambda$12$readInverseDependencies($this$fetchSourceFileMetadata_u24lambda_u2412_u24lambda_u2411, loadSignatures, deserializer2));
                    KotlinSourceFileMetadataFromDisk kotlinSourceFileMetadataFromDisk2 = new KotlinSourceFileMetadataFromDisk(reverseDependencies, directDependencies);
                    kotlinSourceFileMetadataFromDisk = kotlinSourceFileMetadataFromDisk2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                kotlinSourceFileMetadataFromDisk = null;
            }
            KotlinSourceFileMetadata answer$iv = kotlinSourceFileMetadataFromDisk != null ? (KotlinSourceFileMetadata)kotlinSourceFileMetadataFromDisk : (KotlinSourceFileMetadata)KotlinSourceFileMetadataNotExist.INSTANCE;
            $this$getOrPut$iv.put(srcFile, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (KotlinSourceFileMetadata)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SourceFileCacheArtifact commitSourceFileMetadata(KotlinSourceFile srcFile, Map<IdSignature, Integer> signatureToIndexMapping) {
        ByteArrayOutputStream byteArrayOutputStream;
        File binaryAstFile = this.getCacheFile(srcFile, BINARY_AST_SUFFIX);
        KotlinSourceFileMetadata kotlinSourceFileMetadata = this.kotlinLibrarySourceFileMetadata.get(srcFile);
        if (kotlinSourceFileMetadata == null) {
            return new SourceFileCacheArtifact.DoNotChangeMetadata(srcFile, binaryAstFile);
        }
        KotlinSourceFileMetadata sourceFileMetadata = kotlinSourceFileMetadata;
        File headerCacheFile = this.getCacheFile(srcFile, METADATA_SUFFIX);
        if (sourceFileMetadata.isEmpty()) {
            return new SourceFileCacheArtifact.RemoveMetadata(srcFile, binaryAstFile, headerCacheFile);
        }
        if (sourceFileMetadata instanceof KotlinSourceFileMetadataFromDisk) {
            return new SourceFileCacheArtifact.DoNotChangeMetadata(srcFile, binaryAstFile);
        }
        IdSignatureSerialization.IdSignatureICSerializer serializer2 = this.idSignatureSerialization.getIdSignatureSerializer(srcFile, signatureToIndexMapping);
        ByteArrayOutputStream $this$commitSourceFileMetadata_u24lambda_u2414 = byteArrayOutputStream = new ByteArrayOutputStream(4096);
        boolean bl = false;
        OutputStream $this$useCodedOutput$iv = $this$commitSourceFileMetadata_u24lambda_u2414;
        boolean $i$f$useCodedOutput = false;
        Closeable closeable = $this$useCodedOutput$iv;
        Throwable throwable = null;
        try {
            OutputStream it$iv = (OutputStream)closeable;
            boolean bl2 = false;
            CodedOutputStream out$iv = CodedOutputStream.newInstance((OutputStream)it$iv);
            Intrinsics.checkNotNull((Object)out$iv);
            CodedOutputStream $this$commitSourceFileMetadata_u24lambda_u2414_u24lambda_u2413 = out$iv;
            boolean bl3 = false;
            IncrementalCache.commitSourceFileMetadata$writeDirectDependencies($this$commitSourceFileMetadata_u24lambda_u2414_u24lambda_u2413, serializer2, sourceFileMetadata.getDirectDependencies());
            IncrementalCache.commitSourceFileMetadata$writeInverseDependencies($this$commitSourceFileMetadata_u24lambda_u2414_u24lambda_u2413, serializer2, sourceFileMetadata.getInverseDependencies());
            out$iv.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] encodedMetadata = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNull((Object)encodedMetadata);
        return new SourceFileCacheArtifact.CommitMetadata(srcFile, binaryAstFile, headerCacheFile, encodedMetadata);
    }

    private static final <T> Map<KotlinLibraryFile, Map<KotlinSourceFile, T>> fetchSourceFileMetadata$lambda$12$readDependencies(CodedInputStream $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies, Function0<? extends T> signaturesReader) {
        HashMap hashMap;
        int to$iv = $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies.readInt32();
        boolean $i$f$buildMapUntil = false;
        HashMap $this$buildMapUntil_u24lambda_u246$iv = hashMap = CollectionsKt.newHashMapWithExpectedSize((int)to$iv);
        boolean bl = false;
        for (int i = 0; i < to$iv; ++i) {
            HashMap hashMap2;
            int it$iv = i;
            boolean bl2 = false;
            int n = it$iv;
            Map $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies_u24lambda_u2410 = $this$buildMapUntil_u24lambda_u246$iv;
            boolean bl3 = false;
            String libFile = KotlinLibraryFile.Companion.fromProtoStream-BZAKev0($this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies);
            int to$iv2 = $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies.readInt32();
            boolean $i$f$buildMapUntil2 = false;
            HashMap $this$buildMapUntil_u24lambda_u246$iv2 = hashMap2 = CollectionsKt.newHashMapWithExpectedSize((int)to$iv2);
            $i$a$-apply-ICUtilsKt$buildMapUntil$1$iv = false;
            int n2 = 0;
            while (n2 < to$iv2) {
                int it$iv2 = n2++;
                $i$a$-repeat-ICUtilsKt$buildMapUntil$1$1$iv = false;
                int n3 = it$iv2;
                Map $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies_u24lambda_u2410_u24lambda_u249 = $this$buildMapUntil_u24lambda_u246$iv2;
                boolean bl4 = false;
                KotlinSourceFile dependencySrcFile = KotlinSourceFile.Companion.fromProtoStream($this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies);
                $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies_u24lambda_u2410_u24lambda_u249.put(dependencySrcFile, signaturesReader.invoke());
            }
            Map depends2 = hashMap2;
            $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDependencies_u24lambda_u2410.put(KotlinLibraryFile.box-impl(libFile), depends2);
        }
        return hashMap;
    }

    private static final Map<KotlinLibraryFile, Map<KotlinSourceFile, Map<IdSignature, ICHash>>> fetchSourceFileMetadata$lambda$12$readDirectDependencies(CodedInputStream $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDirectDependencies, boolean $loadSignatures, IdSignatureSerialization.IdSignatureICDeserializer deserializer2) {
        return IncrementalCache.fetchSourceFileMetadata$lambda$12$readDependencies($this$fetchSourceFileMetadata_u24lambda_u2412_u24readDirectDependencies, (Function0)new Function0<Map<IdSignature, ? extends ICHash>>($loadSignatures, $this$fetchSourceFileMetadata_u24lambda_u2412_u24readDirectDependencies, deserializer2){
            final /* synthetic */ boolean $loadSignatures;
            final /* synthetic */ CodedInputStream $this_readDirectDependencies;
            final /* synthetic */ IdSignatureSerialization.IdSignatureICDeserializer $deserializer;
            {
                this.$loadSignatures = $loadSignatures;
                this.$this_readDirectDependencies = $receiver;
                this.$deserializer = $deserializer;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Map<IdSignature, ICHash> invoke() {
                Map map;
                if (this.$loadSignatures) {
                    void to$iv;
                    HashMap hashMap;
                    int n = this.$this_readDirectDependencies.readInt32();
                    IdSignatureSerialization.IdSignatureICDeserializer idSignatureICDeserializer = this.$deserializer;
                    CodedInputStream codedInputStream = this.$this_readDirectDependencies;
                    boolean $i$f$buildMapUntil = false;
                    HashMap $this$buildMapUntil_u24lambda_u246$iv = hashMap = CollectionsKt.newHashMapWithExpectedSize((int)to$iv);
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < to$iv) {
                        int it$iv = n2++;
                        boolean bl2 = false;
                        int n3 = it$iv;
                        Map $this$invoke_u24lambda_u240 = $this$buildMapUntil_u24lambda_u246$iv;
                        boolean bl3 = false;
                        IdSignature signature2 = idSignatureICDeserializer.deserializeIdSignature(codedInputStream);
                        $this$invoke_u24lambda_u240.put(signature2, ICHash.box-impl(ICHash.Companion.fromProtoStream-TVZkk9w(codedInputStream)));
                    }
                    map = hashMap;
                } else {
                    int n = this.$this_readDirectDependencies.readInt32();
                    IdSignatureSerialization.IdSignatureICDeserializer idSignatureICDeserializer = this.$deserializer;
                    CodedInputStream codedInputStream = this.$this_readDirectDependencies;
                    int n4 = 0;
                    while (n4 < n) {
                        int it = n4++;
                        boolean bl = false;
                        idSignatureICDeserializer.skipIdSignature(codedInputStream);
                        ICHash.Companion.fromProtoStream-TVZkk9w(codedInputStream);
                    }
                    map = MapsKt.emptyMap();
                }
                return map;
            }
        });
    }

    private static final Map<KotlinLibraryFile, Map<KotlinSourceFile, Set<IdSignature>>> fetchSourceFileMetadata$lambda$12$readInverseDependencies(CodedInputStream $this$fetchSourceFileMetadata_u24lambda_u2412_u24readInverseDependencies, boolean $loadSignatures, IdSignatureSerialization.IdSignatureICDeserializer deserializer2) {
        return IncrementalCache.fetchSourceFileMetadata$lambda$12$readDependencies($this$fetchSourceFileMetadata_u24lambda_u2412_u24readInverseDependencies, (Function0)new Function0<Set<? extends IdSignature>>($loadSignatures, $this$fetchSourceFileMetadata_u24lambda_u2412_u24readInverseDependencies, deserializer2){
            final /* synthetic */ boolean $loadSignatures;
            final /* synthetic */ CodedInputStream $this_readInverseDependencies;
            final /* synthetic */ IdSignatureSerialization.IdSignatureICDeserializer $deserializer;
            {
                this.$loadSignatures = $loadSignatures;
                this.$this_readInverseDependencies = $receiver;
                this.$deserializer = $deserializer;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Set<IdSignature> invoke() {
                Set set;
                if (this.$loadSignatures) {
                    void to$iv;
                    HashSet hashSet;
                    int n = this.$this_readInverseDependencies.readInt32();
                    IdSignatureSerialization.IdSignatureICDeserializer idSignatureICDeserializer = this.$deserializer;
                    CodedInputStream codedInputStream = this.$this_readInverseDependencies;
                    boolean $i$f$buildSetUntil = false;
                    HashSet $this$buildSetUntil_u24lambda_u244$iv = hashSet = CollectionsKt.newHashSetWithExpectedSize((int)to$iv);
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < to$iv) {
                        int it$iv = n2++;
                        boolean bl2 = false;
                        int n3 = it$iv;
                        Set $this$invoke_u24lambda_u240 = $this$buildSetUntil_u24lambda_u244$iv;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u240.add(idSignatureICDeserializer.deserializeIdSignature(codedInputStream));
                    }
                    set = hashSet;
                } else {
                    int n = this.$this_readInverseDependencies.readInt32();
                    IdSignatureSerialization.IdSignatureICDeserializer idSignatureICDeserializer = this.$deserializer;
                    CodedInputStream codedInputStream = this.$this_readInverseDependencies;
                    int n4 = 0;
                    while (n4 < n) {
                        int it = n4++;
                        boolean bl = false;
                        idSignatureICDeserializer.skipIdSignature(codedInputStream);
                    }
                    set = SetsKt.emptySet();
                }
                return set;
            }
        });
    }

    private static final <T> void commitSourceFileMetadata$writeDependencies(CodedOutputStream $this$commitSourceFileMetadata_u24writeDependencies, KotlinSourceFileMap<? extends T> depends2, Function1<? super T, Unit> signaturesWriter) {
        $this$commitSourceFileMetadata_u24writeDependencies.writeInt32NoTag(depends2.size());
        for (Map.Entry entry : ((Map)depends2).entrySet()) {
            String dependencyLibFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
            Map dependencySrcFiles = (Map)entry.getValue();
            KotlinLibraryFile.toProtoStream-impl(dependencyLibFile, $this$commitSourceFileMetadata_u24writeDependencies);
            $this$commitSourceFileMetadata_u24writeDependencies.writeInt32NoTag(dependencySrcFiles.size());
            for (Map.Entry entry2 : dependencySrcFiles.entrySet()) {
                KotlinSourceFile dependencySrcFile = (KotlinSourceFile)entry2.getKey();
                Object signatures2 = entry2.getValue();
                dependencySrcFile.toProtoStream($this$commitSourceFileMetadata_u24writeDependencies);
                signaturesWriter.invoke(signatures2);
            }
        }
    }

    private static final void commitSourceFileMetadata$writeDirectDependencies(CodedOutputStream $this$commitSourceFileMetadata_u24writeDirectDependencies, IdSignatureSerialization.IdSignatureICSerializer serializer2, KotlinSourceFileMap<? extends Map<IdSignature, ICHash>> depends2) {
        IncrementalCache.commitSourceFileMetadata$writeDependencies($this$commitSourceFileMetadata_u24writeDirectDependencies, depends2, (Function1)new Function1<Map<IdSignature, ? extends ICHash>, Unit>($this$commitSourceFileMetadata_u24writeDirectDependencies, serializer2){
            final /* synthetic */ CodedOutputStream $this_writeDirectDependencies;
            final /* synthetic */ IdSignatureSerialization.IdSignatureICSerializer $serializer;
            {
                this.$this_writeDirectDependencies = $receiver;
                this.$serializer = $serializer;
                super(1);
            }

            public final void invoke(Map<IdSignature, ICHash> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$this_writeDirectDependencies.writeInt32NoTag(it.size());
                for (Map.Entry<IdSignature, ICHash> entry : it.entrySet()) {
                    IdSignature signature2 = entry.getKey();
                    Hash128Bits hash = entry.getValue().unbox-impl();
                    this.$serializer.serializeIdSignature(this.$this_writeDirectDependencies, signature2);
                    ICHash.toProtoStream-impl(hash, this.$this_writeDirectDependencies);
                }
            }
        });
    }

    private static final void commitSourceFileMetadata$writeInverseDependencies(CodedOutputStream $this$commitSourceFileMetadata_u24writeInverseDependencies, IdSignatureSerialization.IdSignatureICSerializer serializer2, KotlinSourceFileMap<? extends Set<? extends IdSignature>> depends2) {
        IncrementalCache.commitSourceFileMetadata$writeDependencies($this$commitSourceFileMetadata_u24writeInverseDependencies, depends2, (Function1)new Function1<Set<? extends IdSignature>, Unit>($this$commitSourceFileMetadata_u24writeInverseDependencies, serializer2){
            final /* synthetic */ CodedOutputStream $this_writeInverseDependencies;
            final /* synthetic */ IdSignatureSerialization.IdSignatureICSerializer $serializer;
            {
                this.$this_writeInverseDependencies = $receiver;
                this.$serializer = $serializer;
                super(1);
            }

            public final void invoke(Set<? extends IdSignature> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$this_writeInverseDependencies.writeInt32NoTag(it.size());
                for (IdSignature idSignature : it) {
                    this.$serializer.serializeIdSignature(this.$this_writeInverseDependencies, idSignature);
                }
            }
        });
    }

    public static final /* synthetic */ File access$getCacheHeaderFile$p(IncrementalCache $this) {
        return $this.cacheHeaderFile;
    }

    public static final /* synthetic */ Map access$fetchFilesWithStubbedSymbols(IncrementalCache $this) {
        return $this.fetchFilesWithStubbedSymbols();
    }

    public static final /* synthetic */ CacheHeader access$getCacheHeaderFromDisk(IncrementalCache $this) {
        return $this.getCacheHeaderFromDisk();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader;", "", "library", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryHeader;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryHeader;)V", "libraryFile", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryFile;", "libraryFingerprint", "Lorg/jetbrains/kotlin/backend/common/serialization/FingerprintHash;", "sourceFileFingerprints", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;Ljava/util/Map;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getLibraryFile-dAnkW_k", "()Ljava/lang/String;", "Ljava/lang/String;", "getLibraryFingerprint-jverJr4", "()Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;", "Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;", "getSourceFileFingerprints", "()Ljava/util/Map;", "toProtoStream", "", "out", "Lorg/jetbrains/kotlin/protobuf/CodedOutputStream;", "Companion", "backend.js"})
    private static final class CacheHeader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String libraryFile;
        @Nullable
        private final Hash128Bits libraryFingerprint;
        @NotNull
        private final Map<KotlinSourceFile, FingerprintHash> sourceFileFingerprints;

        private CacheHeader(String libraryFile, Hash128Bits libraryFingerprint2, Map<KotlinSourceFile, FingerprintHash> sourceFileFingerprints2) {
            Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
            Intrinsics.checkNotNullParameter(sourceFileFingerprints2, (String)"sourceFileFingerprints");
            this.libraryFile = libraryFile;
            this.libraryFingerprint = libraryFingerprint2;
            this.sourceFileFingerprints = sourceFileFingerprints2;
        }

        @NotNull
        public final String getLibraryFile-dAnkW_k() {
            return this.libraryFile;
        }

        @Nullable
        public final Hash128Bits getLibraryFingerprint-jverJr4() {
            return this.libraryFingerprint;
        }

        @NotNull
        public final Map<KotlinSourceFile, FingerprintHash> getSourceFileFingerprints() {
            return this.sourceFileFingerprints;
        }

        public CacheHeader(@NotNull KotlinLibraryHeader library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            this(library.getLibraryFile-dAnkW_k(), library.getLibraryFingerprint-jverJr4(), library.getSourceFileFingerprints(), null);
        }

        public final void toProtoStream(@NotNull CodedOutputStream out) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            KotlinLibraryFile.toProtoStream-impl(this.libraryFile, out);
            Hash128Bits hash128Bits = this.libraryFingerprint;
            if (hash128Bits != null) {
                HashCalculatorForICKt.toProtoStream(hash128Bits, out);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                ICUtilsKt.notFoundIcError-5vrbIOY$default("library fingerprint", this.libraryFile, null, 4, null);
                throw null;
            }
            out.writeInt32NoTag(this.sourceFileFingerprints.size());
            for (Map.Entry<KotlinSourceFile, FingerprintHash> entry : this.sourceFileFingerprints.entrySet()) {
                KotlinSourceFile srcFile = entry.getKey();
                Hash128Bits fingerprint = entry.getValue().unbox-impl();
                srcFile.toProtoStream(out);
                HashCalculatorForICKt.toProtoStream(fingerprint, out);
            }
        }

        public /* synthetic */ CacheHeader(String libraryFile, Hash128Bits libraryFingerprint2, Map sourceFileFingerprints2, DefaultConstructorMarker $constructor_marker) {
            this(libraryFile, libraryFingerprint2, sourceFileFingerprints2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader$Companion;", "", "()V", "fromProtoStream", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader;", "input", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "backend.js"})
        @SourceDebugExtension(value={"SMAP\nIncrementalCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalCache.kt\norg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader$Companion\n+ 2 ICUtils.kt\norg/jetbrains/kotlin/ir/backend/js/ic/ICUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,336:1\n66#2:337\n1#3:338\n*S KotlinDebug\n*F\n+ 1 IncrementalCache.kt\norg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheHeader$Companion\n*L\n76#1:337\n76#1:338\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CacheHeader fromProtoStream(@NotNull CodedInputStream input) {
                HashMap hashMap;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                String libraryFile = KotlinLibraryFile.Companion.fromProtoStream-BZAKev0(input);
                Hash128Bits oldLibraryFingerprint = FingerprintHash.constructor-impl((Hash128Bits)HashCalculatorForICKt.readHash128BitsFromProtoStream(input));
                int to$iv = input.readInt32();
                boolean $i$f$buildMapUntil = false;
                HashMap $this$buildMapUntil_u24lambda_u246$iv = hashMap = CollectionsKt.newHashMapWithExpectedSize((int)to$iv);
                boolean bl = false;
                int n = 0;
                while (n < to$iv) {
                    int it$iv = n++;
                    boolean bl2 = false;
                    int n2 = it$iv;
                    Map $this$fromProtoStream_u24lambda_u240 = $this$buildMapUntil_u24lambda_u246$iv;
                    boolean bl3 = false;
                    KotlinSourceFile file2 = KotlinSourceFile.Companion.fromProtoStream(input);
                    $this$fromProtoStream_u24lambda_u240.put(file2, FingerprintHash.box-impl((Hash128Bits)FingerprintHash.constructor-impl((Hash128Bits)HashCalculatorForICKt.readHash128BitsFromProtoStream(input))));
                }
                Map sourceFileFingerprints2 = hashMap;
                return new CacheHeader(libraryFile, oldLibraryFingerprint, sourceFileFingerprints2, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$Companion;", "", "()V", "BINARY_AST_SUFFIX", "", "CACHE_HEADER", "METADATA_SUFFIX", "STUBBED_SYMBOLS", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00070\u0003\u00a2\u0006\u0002\u0010\tR&\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00070\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$KotlinSourceFileMetadataFromDisk;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMetadata;", "inverseDependencies", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "directDependencies", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;)V", "getDirectDependencies", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;", "getInverseDependencies", "backend.js"})
    private static final class KotlinSourceFileMetadataFromDisk
    extends KotlinSourceFileMetadata {
        @NotNull
        private final KotlinSourceFileMap<Set<IdSignature>> inverseDependencies;
        @NotNull
        private final KotlinSourceFileMap<Map<IdSignature, ICHash>> directDependencies;

        public KotlinSourceFileMetadataFromDisk(@NotNull KotlinSourceFileMap<? extends Set<? extends IdSignature>> inverseDependencies, @NotNull KotlinSourceFileMap<? extends Map<IdSignature, ICHash>> directDependencies) {
            Intrinsics.checkNotNullParameter(inverseDependencies, (String)"inverseDependencies");
            Intrinsics.checkNotNullParameter(directDependencies, (String)"directDependencies");
            this.inverseDependencies = inverseDependencies;
            this.directDependencies = directDependencies;
        }

        @Override
        @NotNull
        public KotlinSourceFileMap<Set<IdSignature>> getInverseDependencies() {
            return this.inverseDependencies;
        }

        @Override
        @NotNull
        public KotlinSourceFileMap<Map<IdSignature, ICHash>> getDirectDependencies() {
            return this.directDependencies;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003JU\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$ModifiedFiles;", "", "addedFiles", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "removedFiles", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMetadata;", "modifiedFiles", "nonModifiedFiles", "(Ljava/util/Collection;Ljava/util/Map;Ljava/util/Map;Ljava/util/Collection;)V", "getAddedFiles", "()Ljava/util/Collection;", "getModifiedFiles", "()Ljava/util/Map;", "getNonModifiedFiles", "getRemovedFiles", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ModifiedFiles {
        @NotNull
        private final Collection<KotlinSourceFile> addedFiles;
        @NotNull
        private final Map<KotlinSourceFile, KotlinSourceFileMetadata> removedFiles;
        @NotNull
        private final Map<KotlinSourceFile, KotlinSourceFileMetadata> modifiedFiles;
        @NotNull
        private final Collection<KotlinSourceFile> nonModifiedFiles;

        public ModifiedFiles(@NotNull Collection<KotlinSourceFile> addedFiles, @NotNull Map<KotlinSourceFile, ? extends KotlinSourceFileMetadata> removedFiles, @NotNull Map<KotlinSourceFile, ? extends KotlinSourceFileMetadata> modifiedFiles, @NotNull Collection<KotlinSourceFile> nonModifiedFiles) {
            Intrinsics.checkNotNullParameter(addedFiles, (String)"addedFiles");
            Intrinsics.checkNotNullParameter(removedFiles, (String)"removedFiles");
            Intrinsics.checkNotNullParameter(modifiedFiles, (String)"modifiedFiles");
            Intrinsics.checkNotNullParameter(nonModifiedFiles, (String)"nonModifiedFiles");
            this.addedFiles = addedFiles;
            this.removedFiles = removedFiles;
            this.modifiedFiles = modifiedFiles;
            this.nonModifiedFiles = nonModifiedFiles;
        }

        public /* synthetic */ ModifiedFiles(Collection collection, Map map, Map map2, Collection collection2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                collection = kotlin.collections.CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 8) != 0) {
                collection2 = kotlin.collections.CollectionsKt.emptyList();
            }
            this(collection, map, map2, collection2);
        }

        @NotNull
        public final Collection<KotlinSourceFile> getAddedFiles() {
            return this.addedFiles;
        }

        @NotNull
        public final Map<KotlinSourceFile, KotlinSourceFileMetadata> getRemovedFiles() {
            return this.removedFiles;
        }

        @NotNull
        public final Map<KotlinSourceFile, KotlinSourceFileMetadata> getModifiedFiles() {
            return this.modifiedFiles;
        }

        @NotNull
        public final Collection<KotlinSourceFile> getNonModifiedFiles() {
            return this.nonModifiedFiles;
        }

        @NotNull
        public final Collection<KotlinSourceFile> component1() {
            return this.addedFiles;
        }

        @NotNull
        public final Map<KotlinSourceFile, KotlinSourceFileMetadata> component2() {
            return this.removedFiles;
        }

        @NotNull
        public final Map<KotlinSourceFile, KotlinSourceFileMetadata> component3() {
            return this.modifiedFiles;
        }

        @NotNull
        public final Collection<KotlinSourceFile> component4() {
            return this.nonModifiedFiles;
        }

        @NotNull
        public final ModifiedFiles copy(@NotNull Collection<KotlinSourceFile> addedFiles, @NotNull Map<KotlinSourceFile, ? extends KotlinSourceFileMetadata> removedFiles, @NotNull Map<KotlinSourceFile, ? extends KotlinSourceFileMetadata> modifiedFiles, @NotNull Collection<KotlinSourceFile> nonModifiedFiles) {
            Intrinsics.checkNotNullParameter(addedFiles, (String)"addedFiles");
            Intrinsics.checkNotNullParameter(removedFiles, (String)"removedFiles");
            Intrinsics.checkNotNullParameter(modifiedFiles, (String)"modifiedFiles");
            Intrinsics.checkNotNullParameter(nonModifiedFiles, (String)"nonModifiedFiles");
            return new ModifiedFiles(addedFiles, removedFiles, modifiedFiles, nonModifiedFiles);
        }

        public static /* synthetic */ ModifiedFiles copy$default(ModifiedFiles modifiedFiles, Collection collection, Map map, Map map2, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = modifiedFiles.addedFiles;
            }
            if ((n & 2) != 0) {
                map = modifiedFiles.removedFiles;
            }
            if ((n & 4) != 0) {
                map2 = modifiedFiles.modifiedFiles;
            }
            if ((n & 8) != 0) {
                collection2 = modifiedFiles.nonModifiedFiles;
            }
            return modifiedFiles.copy(collection, map, map2, collection2);
        }

        @NotNull
        public String toString() {
            return "ModifiedFiles(addedFiles=" + this.addedFiles + ", removedFiles=" + this.removedFiles + ", modifiedFiles=" + this.modifiedFiles + ", nonModifiedFiles=" + this.nonModifiedFiles + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.addedFiles).hashCode();
            result2 = result2 * 31 + ((Object)this.removedFiles).hashCode();
            result2 = result2 * 31 + ((Object)this.modifiedFiles).hashCode();
            result2 = result2 * 31 + ((Object)this.nonModifiedFiles).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModifiedFiles)) {
                return false;
            }
            ModifiedFiles modifiedFiles = (ModifiedFiles)other;
            if (!Intrinsics.areEqual(this.addedFiles, modifiedFiles.addedFiles)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.removedFiles, modifiedFiles.removedFiles)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.modifiedFiles, modifiedFiles.modifiedFiles)) {
                return false;
            }
            return Intrinsics.areEqual(this.nonModifiedFiles, modifiedFiles.nonModifiedFiles);
        }

        public ModifiedFiles() {
            this(null, null, null, null, 15, null);
        }
    }
}

