/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.PropertyReference2;
import kotlin.jvm.internal.PropertyReference2Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MutableReference;
import org.jetbrains.kotlin.ir.backend.js.utils.ReferenceKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\f\u0010\u0018\u001a\u00020\u0006*\u00020\u0007H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0007H\u0002J\f\u0010\u001b\u001a\u00020\u0006*\u00020\u0007H\u0002J\f\u0010\u001c\u001a\u00020\u0006*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR?\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r*\u00020\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "needsOfBoxParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getNeedsOfBoxParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Boolean;", "needsOfBoxParameter$delegate", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "<set-?>", "Lorg/jetbrains/kotlin/ir/backend/js/utils/MutableReference;", "possibilityToOptimizeForEsClass", "getPossibilityToOptimizeForEsClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/backend/js/utils/MutableReference;", "setPossibilityToOptimizeForEsClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/backend/js/utils/MutableReference;)V", "possibilityToOptimizeForEsClass$delegate", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "canBeOptimized", "checkIfCanBeOptimized", "", "hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary", "isSubclassOfExternalClassWithRequiredBoxParameter", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6PrimaryConstructorOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering\n+ 2 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n32#2,2:265\n9#2,6:267\n1853#3,2:273\n*S KotlinDebug\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering\n*L\n240#1:265,2\n240#1:267,6\n241#1:273,2\n*E\n"})
public final class ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering
implements DeclarationTransformer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Mapping.Delegate needsOfBoxParameter$delegate;
    @NotNull
    private final Mapping.Delegate possibilityToOptimizeForEsClass$delegate;

    public ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.needsOfBoxParameter$delegate = this.context.getMapping().getEsClassWhichNeedBoxParameters();
        this.possibilityToOptimizeForEsClass$delegate = this.context.getMapping().getEsClassToPossibilityForOptimization();
    }

    private final Boolean getNeedsOfBoxParameter(IrClass $this$needsOfBoxParameter) {
        return (Boolean)this.needsOfBoxParameter$delegate.getValue((IrDeclaration)$this$needsOfBoxParameter, $$delegatedProperties[0]);
    }

    private final MutableReference<Boolean> getPossibilityToOptimizeForEsClass(IrClass $this$possibilityToOptimizeForEsClass) {
        return (MutableReference)this.possibilityToOptimizeForEsClass$delegate.getValue((IrDeclaration)$this$possibilityToOptimizeForEsClass, $$delegatedProperties[1]);
    }

    private final void setPossibilityToOptimizeForEsClass(IrClass $this$possibilityToOptimizeForEsClass, MutableReference<Boolean> mutableReference) {
        this.possibilityToOptimizeForEsClass$delegate.setValue((IrDeclaration)$this$possibilityToOptimizeForEsClass, $$delegatedProperties[1], mutableReference);
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.context.getEs6mode() && declaration instanceof IrClass && !((IrClass)declaration).isExternal() && !this.context.getInlineClassesUtils().isClassInlineLike((IrClass)declaration) && this.getPossibilityToOptimizeForEsClass((IrClass)declaration) == null) {
            this.checkIfCanBeOptimized((IrClass)declaration);
        }
        return null;
    }

    private final void checkIfCanBeOptimized(IrClass $this$checkIfCanBeOptimized) {
        IrClass currentClass = $this$checkIfCanBeOptimized;
        MutableReference<Boolean> nearestOptimizationDecision = null;
        while (currentClass != null && !currentClass.isExternal()) {
            MutableReference<Boolean> currentClassOptimizationDecision = this.getPossibilityToOptimizeForEsClass(currentClass);
            if (currentClassOptimizationDecision != null) {
                nearestOptimizationDecision = currentClassOptimizationDecision;
                break;
            }
            currentClass = IrUtilsKt.getSuperClass((IrClass)currentClass);
        }
        if (nearestOptimizationDecision == null) {
            nearestOptimizationDecision = ReferenceKt.mutableReferenceOf(true);
        }
        currentClass = $this$checkIfCanBeOptimized;
        while (currentClass != null && !currentClass.isExternal() && this.getPossibilityToOptimizeForEsClass(currentClass) == null) {
            this.setPossibilityToOptimizeForEsClass(currentClass, nearestOptimizationDecision);
            if (nearestOptimizationDecision.getValue().booleanValue() && !this.canBeOptimized(currentClass)) {
                nearestOptimizationDecision.setValue(false);
            }
            currentClass = IrUtilsKt.getSuperClass((IrClass)currentClass);
        }
    }

    private final boolean canBeOptimized(IrClass $this$canBeOptimized) {
        IrClass irClass = IrUtilsKt.getSuperClass((IrClass)$this$canBeOptimized);
        return !Intrinsics.areEqual((Object)(irClass != null ? irClass.getSymbol() : null), (Object)this.context.getThrowableClass()) && !this.isSubclassOfExternalClassWithRequiredBoxParameter($this$canBeOptimized) && !this.hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary($this$canBeOptimized);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary(IrClass $this$hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary) {
        List list2;
        Collection $this$filterIsInstanceAnd$iv = $this$hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = (Collection)new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrFunction)) continue;
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!ES6ConstructorLoweringKt.isEs6ConstructorReplacement((IrDeclaration)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            Ref.BooleanRef meetUnoptimizedDelegation = new Ref.BooleanRef();
            IrBody irBody = it.getBody();
            if (irBody != null) {
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)new IrElementTransformerVoid(it, meetUnoptimizedDelegation){
                    final /* synthetic */ IrFunction $it;
                    final /* synthetic */ Ref.BooleanRef $meetUnoptimizedDelegation;
                    {
                        this.$it = $it;
                        this.$meetUnoptimizedDelegation = $meetUnoptimizedDelegation;
                    }

                    public IrExpression visitCall(IrCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2) && !Intrinsics.areEqual((Object)((IrSimpleFunction)expression2.getSymbol().getOwner()).getOrigin(), (Object)this.$it.getOrigin())) {
                            this.$meetUnoptimizedDelegation.element = true;
                        }
                        return super.visitCall(expression2);
                    }
                });
            }
            if (!meetUnoptimizedDelegation.element) continue;
            return true;
        }
        return false;
    }

    private final boolean isSubclassOfExternalClassWithRequiredBoxParameter(IrClass $this$isSubclassOfExternalClassWithRequiredBoxParameter) {
        IrClass irClass = IrUtilsKt.getSuperClass((IrClass)$this$isSubclassOfExternalClassWithRequiredBoxParameter);
        return (irClass != null ? irClass.isExternal() : false) && Intrinsics.areEqual((Object)this.getNeedsOfBoxParameter($this$isSubclassOfExternalClassWithRequiredBoxParameter), (Object)true);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property2((PropertyReference2)((PropertyReference2)new PropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering.class), "needsOfBoxParameter", "getNeedsOfBoxParameter(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Boolean;"))), Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering.class), "possibilityToOptimizeForEsClass", "getPossibilityToOptimizeForEsClass(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/backend/js/utils/MutableReference;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

